/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupStepV3d0<S, K, V, R>
extends ReducingBarrierStep<S, Map<K, R>>
implements TraversalParent,
ByModulating {
    private char state = (char)107;
    private Traversal.Admin<S, K> keyTraversal = null;
    private Traversal.Admin<S, V> valueTraversal = null;
    private Traversal.Admin<Collection<V>, R> reduceTraversal = null;

    public GroupStepV3d0(Traversal.Admin traversal) {
        super(traversal);
        this.setSeedSupplier(HashMapSupplier.instance());
        this.setReducingBiOperator(GroupBiOperatorV3d0.instance());
    }

    @Override
    public Map<K, R> projectTraverser(Traverser.Admin<S> traverser) {
        K key = TraversalUtil.applyNullable(traverser, this.keyTraversal);
        BulkSet values = new BulkSet();
        V value = TraversalUtil.applyNullable(traverser, this.valueTraversal);
        TraversalHelper.addToCollectionUnrollIterator(values, value, traverser.bulk());
        return Collections.singletonMap(key, values);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.keyTraversal, this.valueTraversal, this.reduceTraversal);
    }

    @Override
    public Map<K, R> generateFinalResult(Map<K, R> valueMap) {
        HashMap<K, R> reducedMap = new HashMap<K, R>();
        for (K key : valueMap.keySet()) {
            R r = TraversalUtil.applyNullable(valueMap.get(key), this.reduceTraversal);
            reducedMap.put(key, r);
        }
        return reducedMap;
    }

    public <A, B> List<Traversal.Admin<A, B>> getLocalChildren() {
        ArrayList<Traversal.Admin<A, B>> children = new ArrayList<Traversal.Admin<A, B>>(3);
        if (null != this.keyTraversal) {
            children.add(this.keyTraversal);
        }
        if (null != this.valueTraversal) {
            children.add(this.valueTraversal);
        }
        if (null != this.reduceTraversal) {
            children.add(this.reduceTraversal);
        }
        return children;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> kvrTraversal) {
        if ('k' == this.state) {
            this.keyTraversal = this.integrateChild(kvrTraversal);
            this.state = (char)118;
        } else if ('v' == this.state) {
            this.valueTraversal = this.integrateChild(kvrTraversal);
            this.state = (char)114;
        } else if ('r' == this.state) {
            this.reduceTraversal = this.integrateChild(kvrTraversal);
            this.state = (char)120;
        } else {
            throw new IllegalStateException("The key, value, and reduce functions for group()-step have already been set");
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.SIDE_EFFECTS, TraverserRequirement.BULK);
    }

    @Override
    public GroupStepV3d0<S, K, V, R> clone() {
        GroupStepV3d0 clone = (GroupStepV3d0)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        if (null != this.valueTraversal) {
            clone.valueTraversal = this.valueTraversal.clone();
        }
        if (null != this.reduceTraversal) {
            clone.reduceTraversal = this.reduceTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
        this.integrateChild(this.valueTraversal);
        this.integrateChild(this.reduceTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        if (this.valueTraversal != null) {
            result ^= this.valueTraversal.hashCode();
        }
        if (this.reduceTraversal != null) {
            result ^= this.reduceTraversal.hashCode();
        }
        return result;
    }

    @Deprecated
    public static class GroupBiOperatorV3d0<K, V>
    implements BinaryOperator<Map<K, V>>,
    Serializable {
        private static final GroupBiOperatorV3d0 INSTANCE = new GroupBiOperatorV3d0();

        @Override
        public Map<K, V> apply(Map<K, V> mutatingSeed, Map<K, V> map) {
            for (K key : map.keySet()) {
                BulkSet values = (BulkSet)map.get(key);
                BulkSet seedValues = (BulkSet)mutatingSeed.get(key);
                if (null == seedValues) {
                    seedValues = new BulkSet();
                    mutatingSeed.put(key, seedValues);
                }
                seedValues.addAll(values);
            }
            return mutatingSeed;
        }

        public static final <K, V> GroupBiOperatorV3d0<K, V> instance() {
            return INSTANCE;
        }
    }
}

