/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.function;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.ProjectedTraverser;

public final class MultiComparator<C>
implements Comparator<C>,
Serializable {
    private List<Comparator> comparators;
    private boolean isShuffle;
    int startIndex = 0;

    private MultiComparator() {
    }

    public MultiComparator(List<Comparator<C>> comparators) {
        this.comparators = comparators;
        this.isShuffle = !this.comparators.isEmpty() && Order.shuffle == this.comparators.get(this.comparators.size() - 1);
        for (int i = 0; i < this.comparators.size(); ++i) {
            if (this.comparators.get(i) != Order.shuffle) continue;
            this.startIndex = i + 1;
        }
    }

    @Override
    public int compare(C objectA, C objectB) {
        if (this.comparators.isEmpty()) {
            return Order.incr.compare(objectA, objectB);
        }
        for (int i = this.startIndex; i < this.comparators.size(); ++i) {
            int comparison = this.comparators.get(i).compare(this.getObject(objectA, i), this.getObject(objectB, i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public boolean isShuffle() {
        return this.isShuffle;
    }

    private final Object getObject(C object, int index) {
        if (object instanceof ProjectedTraverser) {
            return ((ProjectedTraverser)object).getProjections().get(index);
        }
        return object;
    }
}

