/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.Host;

public interface Attachable<V> {
    public V get();

    default public V attach(Function<Attachable<V>, V> method) throws IllegalStateException {
        return method.apply(this);
    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static IllegalStateException canNotGetAttachableFromHostVertex(Attachable<?> attachable, Vertex hostVertex) {
            return new IllegalStateException("Can not get the attachable from the host vertex: " + attachable + "-/->" + hostVertex);
        }

        public static IllegalStateException canNotGetAttachableFromHostGraph(Attachable<?> attachable, Graph hostGraph) {
            return new IllegalStateException("Can not get the attachable from the host vertex: " + attachable + "-/->" + hostGraph);
        }

        public static IllegalArgumentException providedAttachableMustContainAGraphObject(Attachable<?> attachable) {
            return new IllegalArgumentException("The provided attachable must contain a graph object: " + attachable);
        }
    }

    public static class Method {
        public static <V> Function<Attachable<V>, V> get(Host hostVertexOrGraph) {
            return attachable -> {
                Object base = attachable.get();
                if (base instanceof Vertex) {
                    Optional<Vertex> optional = hostVertexOrGraph instanceof Graph ? Method.getVertex((Attachable<Vertex>)attachable, (Graph)hostVertexOrGraph) : Method.getVertex((Attachable<Vertex>)attachable, (Vertex)hostVertexOrGraph);
                    return optional.orElseThrow(() -> hostVertexOrGraph instanceof Graph ? Exceptions.canNotGetAttachableFromHostGraph(attachable, (Graph)hostVertexOrGraph) : Exceptions.canNotGetAttachableFromHostVertex(attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof Edge) {
                    Optional<Edge> optional = hostVertexOrGraph instanceof Graph ? Method.getEdge((Attachable<Edge>)attachable, (Graph)hostVertexOrGraph) : Method.getEdge((Attachable<Edge>)attachable, (Vertex)hostVertexOrGraph);
                    return optional.orElseThrow(() -> hostVertexOrGraph instanceof Graph ? Exceptions.canNotGetAttachableFromHostGraph(attachable, (Graph)hostVertexOrGraph) : Exceptions.canNotGetAttachableFromHostVertex(attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof VertexProperty) {
                    Optional<VertexProperty> optional = hostVertexOrGraph instanceof Graph ? Method.getVertexProperty((Attachable<VertexProperty>)attachable, (Graph)hostVertexOrGraph) : Method.getVertexProperty((Attachable<VertexProperty>)attachable, (Vertex)hostVertexOrGraph);
                    return optional.orElseThrow(() -> hostVertexOrGraph instanceof Graph ? Exceptions.canNotGetAttachableFromHostGraph(attachable, (Graph)hostVertexOrGraph) : Exceptions.canNotGetAttachableFromHostVertex(attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof Property) {
                    Optional<Property> optional = hostVertexOrGraph instanceof Graph ? Method.getProperty((Attachable<Property>)attachable, (Graph)hostVertexOrGraph) : Method.getProperty((Attachable<Property>)attachable, (Vertex)hostVertexOrGraph);
                    return optional.orElseThrow(() -> hostVertexOrGraph instanceof Graph ? Exceptions.canNotGetAttachableFromHostGraph(attachable, (Graph)hostVertexOrGraph) : Exceptions.canNotGetAttachableFromHostVertex(attachable, (Vertex)hostVertexOrGraph));
                }
                throw Exceptions.providedAttachableMustContainAGraphObject(attachable);
            };
        }

        public static <V> Function<Attachable<V>, V> getOrCreate(Host hostVertexOrGraph) {
            return attachable -> {
                Object base = attachable.get();
                if (base instanceof Vertex) {
                    return (hostVertexOrGraph instanceof Graph ? Method.getVertex((Attachable<Vertex>)attachable, (Graph)hostVertexOrGraph) : Method.getVertex((Attachable<Vertex>)attachable, (Vertex)hostVertexOrGraph)).orElseGet(() -> hostVertexOrGraph instanceof Graph ? Method.createVertex((Attachable<Vertex>)attachable, (Graph)hostVertexOrGraph) : Method.createVertex((Attachable<Vertex>)attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof Edge) {
                    return (hostVertexOrGraph instanceof Graph ? Method.getEdge((Attachable<Edge>)attachable, (Graph)hostVertexOrGraph) : Method.getEdge((Attachable<Edge>)attachable, (Vertex)hostVertexOrGraph)).orElseGet(() -> hostVertexOrGraph instanceof Graph ? Method.createEdge((Attachable<Edge>)attachable, (Graph)hostVertexOrGraph) : Method.createEdge((Attachable<Edge>)attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof VertexProperty) {
                    return (hostVertexOrGraph instanceof Graph ? Method.getVertexProperty((Attachable<VertexProperty>)attachable, (Graph)hostVertexOrGraph) : Method.getVertexProperty((Attachable<VertexProperty>)attachable, (Vertex)hostVertexOrGraph)).orElseGet(() -> hostVertexOrGraph instanceof Graph ? Method.createVertexProperty((Attachable<VertexProperty>)attachable, (Graph)hostVertexOrGraph) : Method.createVertexProperty((Attachable<VertexProperty>)attachable, (Vertex)hostVertexOrGraph));
                }
                if (base instanceof Property) {
                    return (hostVertexOrGraph instanceof Graph ? Method.getProperty((Attachable<Property>)attachable, (Graph)hostVertexOrGraph) : Method.getProperty((Attachable<Property>)attachable, (Vertex)hostVertexOrGraph)).orElseGet(() -> hostVertexOrGraph instanceof Graph ? Method.createProperty((Attachable<Property>)attachable, (Graph)hostVertexOrGraph) : Method.createProperty((Attachable<Property>)attachable, (Vertex)hostVertexOrGraph));
                }
                throw Exceptions.providedAttachableMustContainAGraphObject(attachable);
            };
        }

        public static <V> Function<Attachable<V>, V> create(Host hostVertexOrGraph) {
            return attachable -> {
                Object base = attachable.get();
                if (base instanceof Vertex) {
                    return hostVertexOrGraph instanceof Graph ? Method.createVertex((Attachable<Vertex>)attachable, (Graph)hostVertexOrGraph) : Method.createVertex((Attachable<Vertex>)attachable, (Vertex)hostVertexOrGraph);
                }
                if (base instanceof Edge) {
                    return hostVertexOrGraph instanceof Graph ? Method.createEdge((Attachable<Edge>)attachable, (Graph)hostVertexOrGraph) : Method.createEdge((Attachable<Edge>)attachable, (Vertex)hostVertexOrGraph);
                }
                if (base instanceof VertexProperty) {
                    return hostVertexOrGraph instanceof Graph ? Method.createVertexProperty((Attachable<VertexProperty>)attachable, (Graph)hostVertexOrGraph) : Method.createVertexProperty((Attachable<VertexProperty>)attachable, (Vertex)hostVertexOrGraph);
                }
                if (base instanceof Property) {
                    return hostVertexOrGraph instanceof Graph ? Method.createProperty((Attachable<Property>)attachable, (Graph)hostVertexOrGraph) : Method.createProperty((Attachable<Property>)attachable, (Vertex)hostVertexOrGraph);
                }
                throw Exceptions.providedAttachableMustContainAGraphObject(attachable);
            };
        }

        public static Optional<Vertex> getVertex(Attachable<Vertex> attachableVertex, Graph hostGraph) {
            Iterator<Vertex> vertexIterator = hostGraph.vertices(attachableVertex.get().id());
            return vertexIterator.hasNext() ? Optional.of(vertexIterator.next()) : Optional.empty();
        }

        public static Optional<Vertex> getVertex(Attachable<Vertex> attachableVertex, Vertex hostVertex) {
            return ElementHelper.areEqual(attachableVertex.get(), hostVertex) ? Optional.of(hostVertex) : Optional.empty();
        }

        public static Optional<Edge> getEdge(Attachable<Edge> attachableEdge, Graph hostGraph) {
            Iterator<Edge> edgeIterator = hostGraph.edges(attachableEdge.get().id());
            return edgeIterator.hasNext() ? Optional.of(edgeIterator.next()) : Optional.empty();
        }

        public static Optional<Edge> getEdge(Attachable<Edge> attachableEdge, Vertex hostVertex) {
            Edge baseEdge = attachableEdge.get();
            Iterator<Edge> edgeIterator = hostVertex.edges(Direction.OUT, attachableEdge.get().label());
            while (edgeIterator.hasNext()) {
                Edge edge = edgeIterator.next();
                if (!ElementHelper.areEqual(edge, baseEdge)) continue;
                return Optional.of(edge);
            }
            return Optional.empty();
        }

        public static Optional<VertexProperty> getVertexProperty(Attachable<VertexProperty> attachableVertexProperty, Graph hostGraph) {
            VertexProperty baseVertexProperty = attachableVertexProperty.get();
            Iterator<Vertex> vertexIterator = hostGraph.vertices(baseVertexProperty.element().id());
            if (vertexIterator.hasNext()) {
                Iterator vertexPropertyIterator = vertexIterator.next().properties(baseVertexProperty.key());
                while (vertexPropertyIterator.hasNext()) {
                    VertexProperty vertexProperty = vertexPropertyIterator.next();
                    if (!ElementHelper.areEqual(vertexProperty, baseVertexProperty)) continue;
                    return Optional.of(vertexProperty);
                }
            }
            return Optional.empty();
        }

        public static Optional<VertexProperty> getVertexProperty(Attachable<VertexProperty> attachableVertexProperty, Vertex hostVertex) {
            VertexProperty baseVertexProperty = attachableVertexProperty.get();
            Iterator vertexPropertyIterator = hostVertex.properties(baseVertexProperty.key());
            while (vertexPropertyIterator.hasNext()) {
                VertexProperty vertexProperty = vertexPropertyIterator.next();
                if (!ElementHelper.areEqual(vertexProperty, baseVertexProperty)) continue;
                return Optional.of(vertexProperty);
            }
            return Optional.empty();
        }

        public static Optional<Property> getProperty(Attachable<Property> attachableProperty, Graph hostGraph) {
            Property baseProperty = attachableProperty.get();
            Element propertyElement = attachableProperty.get().element();
            if (propertyElement instanceof Vertex) {
                return Method.getVertexProperty(attachableProperty, hostGraph);
            }
            if (propertyElement instanceof Edge) {
                Iterator<Edge> edgeIterator = hostGraph.edges(propertyElement.id());
                while (edgeIterator.hasNext()) {
                    Property property = edgeIterator.next().property(baseProperty.key());
                    if (!property.isPresent() || !property.value().equals(baseProperty.value())) continue;
                    return Optional.of(property);
                }
                return Optional.empty();
            }
            Iterator<Vertex> vertexIterator = hostGraph.vertices(((VertexProperty)propertyElement).element().id());
            if (vertexIterator.hasNext()) {
                Iterator vertexPropertyIterator = vertexIterator.next().properties(new String[0]);
                while (vertexPropertyIterator.hasNext()) {
                    VertexProperty vertexProperty = vertexPropertyIterator.next();
                    if (!ElementHelper.areEqual(vertexProperty, (Object)baseProperty.element())) continue;
                    Property property = vertexProperty.property(baseProperty.key());
                    if (property.isPresent() && property.value().equals(baseProperty.value())) {
                        return Optional.of(property);
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }

        public static Optional<Property> getProperty(Attachable<Property> attachableProperty, Vertex hostVertex) {
            Property baseProperty = attachableProperty.get();
            Element propertyElement = attachableProperty.get().element();
            if (propertyElement instanceof Vertex) {
                return Method.getVertexProperty(attachableProperty, hostVertex);
            }
            if (propertyElement instanceof Edge) {
                Iterator<Edge> edgeIterator = hostVertex.edges(Direction.OUT, new String[0]);
                while (edgeIterator.hasNext()) {
                    Property property;
                    Edge edge = edgeIterator.next();
                    if (!ElementHelper.areEqual((Element)edge, (Object)propertyElement) || !ElementHelper.areEqual(baseProperty, property = edge.property(baseProperty.key()))) continue;
                    return Optional.of(property);
                }
                return Optional.empty();
            }
            Iterator vertexPropertyIterator = hostVertex.properties(new String[0]);
            while (vertexPropertyIterator.hasNext()) {
                VertexProperty vertexProperty = vertexPropertyIterator.next();
                if (!ElementHelper.areEqual(vertexProperty, (Object)baseProperty.element())) continue;
                Property property = vertexProperty.property(baseProperty.key());
                if (property.isPresent() && property.value().equals(baseProperty.value())) {
                    return Optional.of(property);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        public static Vertex createVertex(Attachable<Vertex> attachableVertex, Graph hostGraph) {
            Vertex baseVertex = attachableVertex.get();
            Vertex vertex = hostGraph.features().vertex().willAllowId(baseVertex.id()) ? hostGraph.addVertex(T.id, baseVertex.id(), T.label, baseVertex.label()) : hostGraph.addVertex(T.label, baseVertex.label());
            baseVertex.properties(new String[0]).forEachRemaining(vp -> {
                VertexProperty vertexProperty = hostGraph.features().vertex().properties().willAllowId(vp.id()) ? vertex.property(hostGraph.features().vertex().getCardinality(vp.key()), vp.key(), vp.value(), T.id, vp.id()) : vertex.property(hostGraph.features().vertex().getCardinality(vp.key()), vp.key(), vp.value(), new Object[0]);
                vp.properties(new String[0]).forEachRemaining(p -> vertexProperty.property(p.key(), p.value()));
            });
            return vertex;
        }

        public static Vertex createVertex(Attachable<Vertex> attachableVertex, Vertex hostVertex) {
            throw new IllegalStateException("It is not possible to create a vertex at a host vertex");
        }

        public static Edge createEdge(Attachable<Edge> attachableEdge, Graph hostGraph) {
            Vertex inV;
            Edge baseEdge = attachableEdge.get();
            Iterator<Vertex> vertices = hostGraph.vertices(baseEdge.outVertex().id());
            Vertex outV = vertices.hasNext() ? vertices.next() : (hostGraph.features().vertex().willAllowId(baseEdge.outVertex().id()) ? hostGraph.addVertex(T.id, baseEdge.outVertex().id()) : hostGraph.addVertex(new Object[0]));
            vertices = hostGraph.vertices(baseEdge.inVertex().id());
            Vertex vertex = vertices.hasNext() ? vertices.next() : (inV = hostGraph.features().vertex().willAllowId(baseEdge.inVertex().id()) ? hostGraph.addVertex(T.id, baseEdge.inVertex().id()) : hostGraph.addVertex(new Object[0]));
            if (ElementHelper.areEqual(outV, inV)) {
                Iterator<Edge> itty = outV.edges(Direction.OUT, baseEdge.label());
                while (itty.hasNext()) {
                    Edge e = itty.next();
                    if (!ElementHelper.areEqual(baseEdge, e)) continue;
                    return e;
                }
            }
            Edge e = hostGraph.features().edge().willAllowId(baseEdge.id()) ? outV.addEdge(baseEdge.label(), inV, T.id, baseEdge.id()) : outV.addEdge(baseEdge.label(), inV, new Object[0]);
            baseEdge.properties(new String[0]).forEachRemaining(p -> e.property(p.key(), p.value()));
            return e;
        }

        public static Edge createEdge(Attachable<Edge> attachableEdge, Vertex hostVertex) {
            return Method.createEdge(attachableEdge, hostVertex.graph());
        }

        public static VertexProperty createVertexProperty(Attachable<VertexProperty> attachableVertexProperty, Graph hostGraph) {
            VertexProperty baseVertexProperty = attachableVertexProperty.get();
            Iterator<Vertex> vertexIterator = hostGraph.vertices(baseVertexProperty.element().id());
            if (vertexIterator.hasNext()) {
                VertexProperty vertexProperty = hostGraph.features().vertex().properties().willAllowId(baseVertexProperty.id()) ? vertexIterator.next().property(hostGraph.features().vertex().getCardinality(baseVertexProperty.key()), baseVertexProperty.key(), baseVertexProperty.value(), T.id, baseVertexProperty.id()) : vertexIterator.next().property(hostGraph.features().vertex().getCardinality(baseVertexProperty.key()), baseVertexProperty.key(), baseVertexProperty.value(), new Object[0]);
                baseVertexProperty.properties(new String[0]).forEachRemaining(p -> vertexProperty.property(p.key(), p.value()));
                return vertexProperty;
            }
            throw new IllegalStateException("Could not find vertex to create the attachable vertex property on");
        }

        public static VertexProperty createVertexProperty(Attachable<VertexProperty> attachableVertexProperty, Vertex hostVertex) {
            VertexProperty baseVertexProperty = attachableVertexProperty.get();
            VertexProperty vertexProperty = hostVertex.graph().features().vertex().properties().willAllowId(baseVertexProperty.id()) ? hostVertex.property(hostVertex.graph().features().vertex().getCardinality(baseVertexProperty.key()), baseVertexProperty.key(), baseVertexProperty.value(), T.id, baseVertexProperty.id()) : hostVertex.property(hostVertex.graph().features().vertex().getCardinality(baseVertexProperty.key()), baseVertexProperty.key(), baseVertexProperty.value(), new Object[0]);
            baseVertexProperty.properties(new String[0]).forEachRemaining(p -> vertexProperty.property(p.key(), p.value()));
            return vertexProperty;
        }

        public static Property createProperty(Attachable<Property> attachableProperty, Graph hostGraph) {
            Property baseProperty = attachableProperty.get();
            Element baseElement = baseProperty.element();
            if (baseElement instanceof Vertex) {
                return Method.createVertexProperty(attachableProperty, hostGraph);
            }
            if (baseElement instanceof Edge) {
                Iterator<Edge> edgeIterator = hostGraph.edges(baseElement.id());
                if (edgeIterator.hasNext()) {
                    return edgeIterator.next().property(baseProperty.key(), baseProperty.value());
                }
                throw new IllegalStateException("Could not find edge to create the attachable property on");
            }
            Iterator<Vertex> vertexIterator = hostGraph.vertices(((VertexProperty)baseElement).element().id());
            if (vertexIterator.hasNext()) {
                Vertex vertex = vertexIterator.next();
                Iterator vertexPropertyIterator = vertex.properties(((VertexProperty)baseElement).key());
                while (vertexPropertyIterator.hasNext()) {
                    VertexProperty vp = vertexPropertyIterator.next();
                    if (!ElementHelper.areEqual(vp, (Object)baseElement)) continue;
                    return vp.property(baseProperty.key(), baseProperty.value());
                }
            }
            throw new IllegalStateException("Could not find vertex property to create the attachable property on");
        }

        public static Property createProperty(Attachable<Property> attachableProperty, Vertex hostVertex) {
            Property baseProperty = attachableProperty.get();
            Element baseElement = baseProperty.element();
            if (baseElement instanceof Vertex) {
                return Method.createVertexProperty(attachableProperty, hostVertex);
            }
            if (baseElement instanceof Edge) {
                Iterator<Edge> edgeIterator = hostVertex.edges(Direction.OUT, new String[0]);
                if (edgeIterator.hasNext()) {
                    return edgeIterator.next().property(baseProperty.key(), baseProperty.value());
                }
                throw new IllegalStateException("Could not find edge to create the property on");
            }
            Iterator vertexPropertyIterator = hostVertex.properties(((VertexProperty)baseElement).key());
            while (vertexPropertyIterator.hasNext()) {
                VertexProperty vp = vertexPropertyIterator.next();
                if (!ElementHelper.areEqual(vp, (Object)baseElement)) continue;
                return vp.property(baseProperty.key(), baseProperty.value());
            }
            throw new IllegalStateException("Could not find vertex property to create the attachable property on");
        }
    }
}

