/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;

public abstract class AbstractTransaction
implements Transaction {
    private Graph g;

    public AbstractTransaction(Graph g) {
        this.g = g;
    }

    protected abstract void doOpen();

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected abstract void fireOnCommit();

    protected abstract void fireOnRollback();

    protected abstract void doReadWrite();

    protected abstract void doClose();

    @Override
    public void open() {
        if (this.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        this.doOpen();
    }

    @Override
    public void commit() {
        this.readWrite();
        try {
            this.doCommit();
            this.fireOnCommit();
        }
        catch (TransactionException te) {
            throw new RuntimeException(te);
        }
    }

    @Override
    public void rollback() {
        this.readWrite();
        try {
            this.doRollback();
            this.fireOnRollback();
        }
        catch (TransactionException te) {
            throw new RuntimeException(te);
        }
    }

    @Override
    @Deprecated
    public <R> Transaction.Workload<R> submit(Function<Graph, R> work) {
        return new Transaction.Workload<R>(this.g, work);
    }

    @Override
    public <G extends Graph> G createThreadedTx() {
        throw Transaction.Exceptions.threadedTransactionsNotSupported();
    }

    @Override
    public void readWrite() {
        this.doReadWrite();
    }

    @Override
    public void close() {
        this.doClose();
    }

    public static class TransactionException
    extends Exception {
        public TransactionException(String message) {
            super(message);
        }

        public TransactionException(Throwable cause) {
            super(cause);
        }

        public TransactionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

