/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoShimServiceLoader {
    private static volatile KryoShimService cachedShimService;
    private static volatile Configuration conf;
    private static final Logger log;
    public static final String KRYO_SHIM_SERVICE = "gremlin.io.kryoShimService";

    public static void applyConfiguration(Configuration conf) {
        KryoShimServiceLoader.conf = conf;
        KryoShimServiceLoader.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KryoShimService load(boolean forceReload) {
        if (null != cachedShimService && !forceReload) {
            return cachedShimService;
        }
        ArrayList<KryoShimService> services = new ArrayList<KryoShimService>();
        ServiceLoader<KryoShimService> sl = ServiceLoader.load(KryoShimService.class);
        KryoShimService result = null;
        Class<KryoShimServiceLoader> clazz = KryoShimServiceLoader.class;
        synchronized (KryoShimServiceLoader.class) {
            if (forceReload) {
                sl.reload();
            }
            for (KryoShimService kss : sl) {
                services.add(kss);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            String shimClass = System.getProperty(KRYO_SHIM_SERVICE);
            if (null != shimClass) {
                for (KryoShimService kss : services) {
                    if (!kss.getClass().getCanonicalName().equals(shimClass)) continue;
                    log.info("Set {} provider to {} ({}) from system property {}={}", new Object[]{KryoShimService.class.getSimpleName(), kss, kss.getClass(), KRYO_SHIM_SERVICE, shimClass});
                    result = kss;
                }
            } else {
                Collections.sort(services, KryoShimServiceComparator.INSTANCE);
                for (KryoShimService kss : services) {
                    log.debug("Found Kryo shim service class {} (priority {})", kss.getClass(), (Object)kss.getPriority());
                }
                if (0 != services.size()) {
                    result = (KryoShimService)services.get(services.size() - 1);
                }
            }
            if (null == result) {
                throw new IllegalStateException("Unable to load KryoShimService");
            }
            log.info("Set {} provider to {} ({}) because its priority value ({}) is the highest available", new Object[]{KryoShimService.class.getSimpleName(), result, result.getClass(), result.getPriority()});
            Configuration userConf = conf;
            if (null != userConf) {
                log.info("Configuring {} provider {} with user-provided configuration", (Object)KryoShimService.class.getSimpleName(), (Object)result);
                result.applyConfiguration(userConf);
            }
            cachedShimService = result;
            return cachedShimService;
        }
    }

    public static KryoShimService load() {
        return KryoShimServiceLoader.load(false);
    }

    public static byte[] writeClassAndObjectToBytes(Object o) {
        KryoShimService shimService = KryoShimServiceLoader.load();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        shimService.writeClassAndObject(o, baos);
        return baos.toByteArray();
    }

    public static <T> T readClassAndObject(InputStream source) {
        KryoShimService shimService = KryoShimServiceLoader.load();
        return (T)shimService.readClassAndObject(source);
    }

    static {
        log = LoggerFactory.getLogger(KryoShimServiceLoader.class);
    }

    private static enum KryoShimServiceComparator implements Comparator<KryoShimService>
    {
        INSTANCE;


        @Override
        public int compare(KryoShimService a, KryoShimService b) {
            int bp;
            int ap = a.getPriority();
            if (ap < (bp = b.getPriority())) {
                return -1;
            }
            if (bp < ap) {
                return 1;
            }
            int result = a.getClass().getCanonicalName().compareTo(b.getClass().getCanonicalName());
            if (0 == result) {
                log.warn("Found two {} implementations with the same canonical classname: {}.  This may indicate a problem with the classpath/classloader such as duplicate or conflicting copies of the file META-INF/services/org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService.", (Object)a.getClass().getCanonicalName());
            } else {
                String winner = 0 < result ? a.getClass().getCanonicalName() : b.getClass().getCanonicalName();
                log.warn("{} implementations {} and {} are tied with priority value {}.  Preferring {} to the other because it has a lexicographically greater classname.  Consider setting the system property \"{}\" instead of relying on priority tie-breaking.", new Object[]{KryoShimService.class.getSimpleName(), a, b, ap, winner, KryoShimServiceLoader.KRYO_SHIM_SERVICE});
            }
            return result;
        }
    }
}

