/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.gryo;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedPath;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferencePath;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.shaded.kryo.ClassResolver;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.Registration;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.apache.tinkerpop.shaded.kryo.util.IdentityObjectIntMap;
import org.apache.tinkerpop.shaded.kryo.util.IntMap;
import org.apache.tinkerpop.shaded.kryo.util.ObjectMap;
import org.apache.tinkerpop.shaded.kryo.util.Util;

public class GryoClassResolver
implements ClassResolver {
    public static final byte NAME = -1;
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final ObjectMap<Class, Registration> classToRegistration = new ObjectMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected ObjectMap<String, Class> nameToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;
    private Class memoizedClass;
    private Registration memoizedClassValue;

    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    public Registration register(Registration registration) {
        if (null == registration) {
            throw new IllegalArgumentException("Registration cannot be null.");
        }
        if (registration.getId() != -1) {
            this.idToRegistration.put(registration.getId(), (Object)registration);
        }
        this.classToRegistration.put((Object)registration.getType(), (Object)registration);
        if (registration.getType().isPrimitive()) {
            this.classToRegistration.put((Object)Util.getWrapperClass((Class)registration.getType()), (Object)registration);
        }
        return registration;
    }

    public Registration registerImplicit(Class type) {
        return this.register(new Registration(type, this.kryo.getDefaultSerializer(type), -1));
    }

    public Registration getRegistration(Class clazz) {
        Class type = !ReferenceVertex.class.isAssignableFrom(clazz) && !DetachedVertex.class.isAssignableFrom(clazz) && Vertex.class.isAssignableFrom(clazz) ? Vertex.class : (!ReferenceEdge.class.isAssignableFrom(clazz) && !DetachedEdge.class.isAssignableFrom(clazz) && Edge.class.isAssignableFrom(clazz) ? Edge.class : (!ReferenceVertexProperty.class.isAssignableFrom(clazz) && !DetachedVertexProperty.class.isAssignableFrom(clazz) && VertexProperty.class.isAssignableFrom(clazz) ? VertexProperty.class : (!ReferenceProperty.class.isAssignableFrom(clazz) && !DetachedProperty.class.isAssignableFrom(clazz) && !DetachedVertexProperty.class.isAssignableFrom(clazz) && Property.class.isAssignableFrom(clazz) ? Property.class : (!ReferencePath.class.isAssignableFrom(clazz) && !DetachedPath.class.isAssignableFrom(clazz) && Path.class.isAssignableFrom(clazz) ? Path.class : (Lambda.class.isAssignableFrom(clazz) ? Lambda.class : (ByteBuffer.class.isAssignableFrom(clazz) ? ByteBuffer.class : (Class.class.isAssignableFrom(clazz) ? Class.class : (InetAddress.class.isAssignableFrom(clazz) ? InetAddress.class : (ConnectiveP.class.isAssignableFrom(clazz) ? P.class : clazz)))))))));
        if (type == this.memoizedClass) {
            return this.memoizedClassValue;
        }
        Registration registration = (Registration)this.classToRegistration.get(type);
        if (registration != null) {
            this.memoizedClass = type;
            this.memoizedClassValue = registration;
        }
        return registration;
    }

    public Registration getRegistration(int classID) {
        return (Registration)this.idToRegistration.get(classID);
    }

    public Registration writeClass(Output output, Class type) {
        if (null == type) {
            output.writeVarInt(0, true);
            return null;
        }
        Registration registration = this.kryo.getRegistration(type);
        if (registration.getId() == -1) {
            this.writeName(output, type);
        } else {
            output.writeVarInt(registration.getId() + 2, true);
        }
        return registration;
    }

    protected void writeName(Output output, Class type) {
        int nameId;
        output.writeVarInt(1, true);
        if (this.classToNameId != null && (nameId = this.classToNameId.get((Object)type, -1)) != -1) {
            output.writeVarInt(nameId, true);
            return;
        }
        nameId = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put((Object)type, nameId);
        output.writeVarInt(nameId, true);
        output.writeString(type.getName());
    }

    public Registration readClass(Input input) {
        int classID = input.readVarInt(true);
        switch (classID) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readName(input);
            }
        }
        if (classID == this.memoizedClassId) {
            return this.memoizedClassIdValue;
        }
        Registration registration = (Registration)this.idToRegistration.get(classID - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (classID - 2));
        }
        this.memoizedClassId = classID;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    protected Registration readName(Input input) {
        Class<?> type;
        int nameId = input.readVarInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((type = (Class<?>)this.nameIdToClass.get(nameId)) == null) {
            String className = input.readString();
            type = this.getTypeByName(className);
            if (type == null) {
                try {
                    type = Class.forName(className, false, this.kryo.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new KryoException("Unable to find class: " + className, (Throwable)ex);
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put((Object)className, type);
            }
            this.nameIdToClass.put(nameId, type);
        }
        return this.kryo.getRegistration((Class)type);
    }

    protected Class<?> getTypeByName(String className) {
        return this.nameToClass != null ? (Class)this.nameToClass.get((Object)className) : null;
    }

    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear();
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

