/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.core.type.WritableTypeId;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;

public class GraphSONTypeSerializer
extends TypeSerializer {
    private final TypeIdResolver idRes;
    private final String propertyName;
    private final TypeInfo typeInfo;
    private final String valuePropertyName;
    private final Map<Class, Class> classMap = new HashMap<Class, Class>();

    GraphSONTypeSerializer(TypeIdResolver idRes, String propertyName, TypeInfo typeInfo, String valuePropertyName) {
        this.idRes = idRes;
        this.propertyName = propertyName;
        this.typeInfo = typeInfo;
        this.valuePropertyName = valuePropertyName;
    }

    public TypeSerializer forProperty(BeanProperty beanProperty) {
        return this;
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeIdResolver getTypeIdResolver() {
        return this.idRes;
    }

    public WritableTypeId writeTypePrefix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
        if (writableTypeId.valueShape == JsonToken.START_OBJECT) {
            jsonGenerator.writeStartObject();
        } else if (writableTypeId.valueShape == JsonToken.START_ARRAY) {
            jsonGenerator.writeStartArray();
        } else if (this.canWriteTypeId()) {
            this.writeTypePrefix(jsonGenerator, this.getTypeIdResolver().idFromValueAndType(writableTypeId.forValue, this.getClassFromObject(writableTypeId.forValue)));
        } else {
            throw new IllegalStateException("Could not write prefix: shape[" + writableTypeId.valueShape + "] value[" + writableTypeId.forValue + "]");
        }
        return writableTypeId;
    }

    public WritableTypeId writeTypeSuffix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
        if (writableTypeId.valueShape == JsonToken.START_OBJECT) {
            jsonGenerator.writeEndObject();
        } else if (writableTypeId.valueShape == JsonToken.START_ARRAY) {
            jsonGenerator.writeEndArray();
        } else if (this.canWriteTypeId()) {
            this.writeTypeSuffix(jsonGenerator);
        } else {
            throw new IllegalStateException("Could not write suffix: shape[" + writableTypeId.valueShape + "] value[" + writableTypeId.forValue + "]");
        }
        return writableTypeId;
    }

    private boolean canWriteTypeId() {
        return this.typeInfo != null && this.typeInfo == TypeInfo.PARTIAL_TYPES;
    }

    private void writeTypePrefix(JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(this.getPropertyName(), s);
        jsonGenerator.writeFieldName(this.valuePropertyName);
    }

    private void writeTypeSuffix(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    private Class getClassFromObject(Object o) {
        Class<?> c = o.getClass();
        if (this.classMap.containsKey(c)) {
            return this.classMap.get(c);
        }
        Class mapped = Vertex.class.isAssignableFrom(c) ? Vertex.class : (Edge.class.isAssignableFrom(c) ? Edge.class : (Path.class.isAssignableFrom(c) ? Path.class : (VertexProperty.class.isAssignableFrom(c) ? VertexProperty.class : (Metrics.class.isAssignableFrom(c) ? Metrics.class : (TraversalMetrics.class.isAssignableFrom(c) ? TraversalMetrics.class : (Property.class.isAssignableFrom(c) ? Property.class : (ByteBuffer.class.isAssignableFrom(c) ? ByteBuffer.class : (InetAddress.class.isAssignableFrom(c) ? InetAddress.class : (Traverser.class.isAssignableFrom(c) ? Traverser.class : (Lambda.class.isAssignableFrom(c) ? Lambda.class : (VertexProperty.Cardinality.class.isAssignableFrom(c) ? VertexProperty.Cardinality.class : (Column.class.isAssignableFrom(c) ? Column.class : (Direction.class.isAssignableFrom(c) ? Direction.class : (Operator.class.isAssignableFrom(c) ? Operator.class : (Order.class.isAssignableFrom(c) ? Order.class : (Pop.class.isAssignableFrom(c) ? Pop.class : (SackFunctions.Barrier.class.isAssignableFrom(c) ? SackFunctions.Barrier.class : (TraversalOptionParent.Pick.class.isAssignableFrom(c) ? TraversalOptionParent.Pick.class : (Scope.class.isAssignableFrom(c) ? Scope.class : (T.class.isAssignableFrom(c) ? T.class : c))))))))))))))))))));
        this.classMap.put(c, mapped);
        return mapped;
    }
}

