/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraphGraphSONDeserializer;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.node.JsonNodeType;

public final class GraphSONReader
implements GraphReader {
    private final ObjectMapper mapper;
    private final long batchSize;
    private final GraphSONVersion version;
    private boolean unwrapAdjacencyList = false;
    final TypeReference<Map<String, Object>> mapTypeReference = new TypeReference<Map<String, Object>>(){};

    private GraphSONReader(Builder builder) {
        this.mapper = (ObjectMapper)builder.mapper.createMapper();
        this.batchSize = builder.batchSize;
        this.unwrapAdjacencyList = builder.unwrapAdjacencyList;
        this.version = ((GraphSONMapper)builder.mapper).getVersion();
    }

    @Override
    public void readGraph(InputStream inputStream, Graph graphToWriteTo) throws IOException {
        HashMap cache = new HashMap();
        AtomicLong counter = new AtomicLong(0L);
        boolean supportsTx = graphToWriteTo.features().graph().supportsTransactions();
        Graph.Features.EdgeFeatures edgeFeatures = graphToWriteTo.features().edge();
        this.readVertexStrings(inputStream).map(FunctionUtils.wrapFunction(line -> this.readVertex(new ByteArrayInputStream(line.getBytes()), null, null, Direction.IN))).forEach(vertex -> {
            Attachable attachable = (Attachable)((Object)vertex);
            cache.put((StarGraph.StarVertex)attachable.get(), attachable.attach(Attachable.Method.create(graphToWriteTo)));
            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                graphToWriteTo.tx().commit();
            }
        });
        cache.entrySet().forEach(kv -> ((StarGraph.StarVertex)kv.getKey()).edges(Direction.IN, new String[0]).forEachRemaining(e -> {
            Vertex cachedOutV = (Vertex)cache.get(e.outVertex());
            Vertex cachedInV = (Vertex)cache.get(e.inVertex());
            if (null == cachedOutV) {
                throw new IllegalStateException(String.format("Could not find outV with id [%s] to create edge with id [%s]", e.outVertex().id(), e.id()));
            }
            if (null == cachedInV) {
                throw new IllegalStateException(String.format("Could not find inV with id [%s] to create edge with id [%s]", e.inVertex().id(), e.id()));
            }
            Edge newEdge = edgeFeatures.willAllowId(e.id()) ? cachedOutV.addEdge(e.label(), cachedInV, T.id, e.id()) : cachedOutV.addEdge(e.label(), cachedInV, new Object[0]);
            e.properties(new String[0]).forEachRemaining(p -> newEdge.property(p.key(), p.value()));
            if (supportsTx && counter.incrementAndGet() % this.batchSize == 0L) {
                graphToWriteTo.tx().commit();
            }
        }));
        if (supportsTx) {
            graphToWriteTo.tx().commit();
        }
    }

    @Override
    public Iterator<Vertex> readVertices(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        return this.readVertexStrings(inputStream).map(FunctionUtils.wrapFunction(line -> this.readVertex(new ByteArrayInputStream(line.getBytes()), vertexAttachMethod, edgeAttachMethod, attachEdgesOfThisDirection))).iterator();
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod) throws IOException {
        return this.readVertex(inputStream, vertexAttachMethod, null, null);
    }

    @Override
    public Vertex readVertex(InputStream inputStream, Function<Attachable<Vertex>, Vertex> vertexAttachMethod, Function<Attachable<Edge>, Edge> edgeAttachMethod, Direction attachEdgesOfThisDirection) throws IOException {
        Map vertexData = (Map)this.mapper.readValue(inputStream, this.mapTypeReference);
        StarGraph starGraph = StarGraphGraphSONDeserializer.readStarGraphVertex(vertexData);
        if (vertexAttachMethod != null) {
            vertexAttachMethod.apply(starGraph.getStarVertex());
        }
        if (vertexData.containsKey("outE") && (attachEdgesOfThisDirection == Direction.BOTH || attachEdgesOfThisDirection == Direction.OUT)) {
            StarGraphGraphSONDeserializer.readStarGraphEdges(edgeAttachMethod, starGraph, vertexData, "outE");
        }
        if (vertexData.containsKey("inE") && (attachEdgesOfThisDirection == Direction.BOTH || attachEdgesOfThisDirection == Direction.IN)) {
            StarGraphGraphSONDeserializer.readStarGraphEdges(edgeAttachMethod, starGraph, vertexData, "inE");
        }
        return starGraph.getStarVertex();
    }

    @Override
    public Edge readEdge(InputStream inputStream, Function<Attachable<Edge>, Edge> edgeAttachMethod) throws IOException {
        if (this.version == GraphSONVersion.V1_0) {
            Map edgeData = (Map)this.mapper.readValue(inputStream, this.mapTypeReference);
            Map edgeProperties = edgeData.containsKey("properties") ? (Map)edgeData.get("properties") : Collections.EMPTY_MAP;
            DetachedEdge edge = new DetachedEdge(edgeData.get("id"), edgeData.get("label").toString(), edgeProperties, edgeData.get("outV"), edgeData.get("outVLabel").toString(), edgeData.get("inV"), edgeData.get("inVLabel").toString());
            return edgeAttachMethod.apply(edge);
        }
        return edgeAttachMethod.apply((DetachedEdge)this.mapper.readValue(inputStream, Edge.class));
    }

    @Override
    public VertexProperty readVertexProperty(InputStream inputStream, Function<Attachable<VertexProperty>, VertexProperty> vertexPropertyAttachMethod) throws IOException {
        if (this.version == GraphSONVersion.V1_0) {
            Map vpData = (Map)this.mapper.readValue(inputStream, this.mapTypeReference);
            Map metaProperties = (Map)vpData.get("properties");
            DetachedVertexProperty vp = new DetachedVertexProperty(vpData.get("id"), vpData.get("label").toString(), vpData.get("value"), metaProperties);
            return vertexPropertyAttachMethod.apply(vp);
        }
        return vertexPropertyAttachMethod.apply((DetachedVertexProperty)this.mapper.readValue(inputStream, VertexProperty.class));
    }

    @Override
    public Property readProperty(InputStream inputStream, Function<Attachable<Property>, Property> propertyAttachMethod) throws IOException {
        if (this.version == GraphSONVersion.V1_0) {
            Map propertyData = (Map)this.mapper.readValue(inputStream, this.mapTypeReference);
            DetachedProperty p = new DetachedProperty(propertyData.get("key").toString(), propertyData.get("value"));
            return propertyAttachMethod.apply(p);
        }
        return propertyAttachMethod.apply((DetachedProperty)this.mapper.readValue(inputStream, Property.class));
    }

    @Override
    public <C> C readObject(InputStream inputStream, Class<? extends C> clazz) throws IOException {
        return (C)this.mapper.readValue(inputStream, clazz);
    }

    private Stream<String> readVertexStrings(InputStream inputStream) throws IOException {
        if (this.unwrapAdjacencyList) {
            JsonNode root = this.mapper.readTree(inputStream);
            JsonNode vertices = root.get("vertices");
            if (!vertices.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                throw new IOException(String.format("The '%s' key must be an array", "vertices"));
            }
            return IteratorUtils.stream(vertices.elements()).map(Object::toString);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        return br.lines();
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    implements GraphReader.ReaderBuilder<GraphSONReader> {
        private long batchSize = 10000L;
        private Mapper<ObjectMapper> mapper = GraphSONMapper.build().create();
        private boolean unwrapAdjacencyList = false;

        private Builder() {
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder mapper(Mapper<ObjectMapper> mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder unwrapAdjacencyList(boolean unwrapAdjacencyList) {
            this.unwrapAdjacencyList = unwrapAdjacencyList;
            return this;
        }

        @Override
        public GraphSONReader create() {
            return new GraphSONReader(this);
        }
    }
}

