/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphml;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLWriter;

public final class GraphMLIo
implements Io<GraphMLReader.Builder, GraphMLWriter.Builder, GraphMLMapper.Builder> {
    private final Graph graph;
    private Optional<Consumer<Mapper.Builder>> onMapper;

    private GraphMLIo(Builder builder) {
        this.graph = builder.graph;
        this.onMapper = Optional.ofNullable(builder.onMapper);
    }

    @Override
    public GraphMLReader.Builder reader() {
        return GraphMLReader.build();
    }

    @Override
    public GraphMLWriter.Builder writer() {
        return GraphMLWriter.build();
    }

    @Override
    public GraphMLMapper.Builder mapper() {
        GraphMLMapper.Builder builder = GraphMLMapper.build();
        this.onMapper.ifPresent(c -> c.accept(builder));
        return builder;
    }

    @Override
    public void writeGraph(String file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writer().create().writeGraph(out, this.graph);
        }
    }

    @Override
    public void readGraph(String file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.reader().create().readGraph(in, this.graph);
        }
    }

    public static Io.Builder<GraphMLIo> build() {
        return new Builder();
    }

    public static final class Builder
    implements Io.Builder<GraphMLIo> {
        private Graph graph;
        private Consumer<Mapper.Builder> onMapper = null;

        @Override
        @Deprecated
        public Io.Builder<GraphMLIo> registry(IoRegistry registry) {
            return this;
        }

        @Override
        public Io.Builder<? extends Io> onMapper(Consumer<Mapper.Builder> onMapper) {
            this.onMapper = onMapper;
            return this;
        }

        @Override
        public Io.Builder<GraphMLIo> graph(Graph g) {
            this.graph = g;
            return this;
        }

        @Override
        public GraphMLIo create() {
            if (null == this.graph) {
                throw new IllegalArgumentException("The graph argument was not specified");
            }
            return new GraphMLIo(this);
        }
    }
}

