/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Graph;

public interface Transaction
extends AutoCloseable {
    public void open();

    public void commit();

    public void rollback();

    @Deprecated
    public <R> Workload<R> submit(Function<Graph, R> var1);

    public <G extends Graph> G createThreadedTx();

    public boolean isOpen();

    public void readWrite();

    @Override
    public void close();

    public Transaction onReadWrite(Consumer<Transaction> var1);

    public Transaction onClose(Consumer<Transaction> var1);

    public void addTransactionListener(Consumer<Status> var1);

    public void removeTransactionListener(Consumer<Status> var1);

    public void clearTransactionListeners();

    @Deprecated
    public static class Workload<R> {
        public static final long DEFAULT_DELAY_MS = 20L;
        public static final int DEFAULT_TRIES = 8;
        private final Function<Graph, R> workToDo;
        private final Graph g;

        public Workload(Graph g, Function<Graph, R> work) {
            this.g = g;
            this.workToDo = work;
        }

        public R attempt(BiFunction<Graph, Function<Graph, R>, R> retryStrategy) {
            return retryStrategy.apply(this.g, this.workToDo);
        }

        public R oneAndDone() {
            return (R)this.attempt((g, w) -> {
                try {
                    Object result = w.apply(g);
                    g.tx().commit();
                    return result;
                }
                catch (Throwable t) {
                    g.tx().rollback();
                    throw new RuntimeException(t);
                }
            });
        }

        public R fireAndForget() {
            return (R)this.attempt((g, w) -> {
                Object result = null;
                try {
                    result = w.apply(g);
                    g.tx().commit();
                }
                catch (Throwable t) {
                    g.tx().rollback();
                }
                return result;
            });
        }

        public R retry() {
            return this.retry(8);
        }

        public R retry(int tries) {
            return this.retry(tries, 20L);
        }

        public R retry(int tries, long delay) {
            return this.retry(tries, delay, Collections.emptySet());
        }

        public R retry(int tries, long delay, Set<Class> exceptionsToRetryOn) {
            return this.attempt(Workload.retry(tries, exceptionsToRetryOn, i -> delay));
        }

        public R exponentialBackoff() {
            return this.exponentialBackoff(8);
        }

        public R exponentialBackoff(int tries) {
            return this.exponentialBackoff(tries, 20L);
        }

        public R exponentialBackoff(int tries, long initialDelay) {
            return this.exponentialBackoff(tries, initialDelay, Collections.emptySet());
        }

        public R exponentialBackoff(int tries, long initialDelay, Set<Class> exceptionsToRetryOn) {
            return this.attempt(Workload.retry(tries, exceptionsToRetryOn, retryCount -> (long)((double)initialDelay * Math.pow(2.0, retryCount.intValue()))));
        }

        private static <R> BiFunction<Graph, Function<Graph, R>, R> retry(int tries, Set<Class> exceptionsToRetryOn, Function<Integer, Long> delay) {
            return (g, w) -> {
                Exception previousException = new RuntimeException("Exception initialized when trying commit");
                for (int ix = 0; ix < tries; ++ix) {
                    if (ix > 0) {
                        try {
                            Thread.sleep((Long)delay.apply(ix));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!g.tx().isOpen()) {
                            g.tx().open();
                        }
                        Object returnValue = w.apply(g);
                        g.tx().commit();
                        return returnValue;
                    }
                    catch (Exception ex) {
                        g.tx().rollback();
                        boolean retry = false;
                        if (exceptionsToRetryOn.size() == 0) {
                            retry = true;
                        } else {
                            for (Class exceptionToRetryOn : exceptionsToRetryOn) {
                                if (!ex.getClass().equals(exceptionToRetryOn)) continue;
                                retry = true;
                                break;
                            }
                        }
                        if (!retry) {
                            throw new RuntimeException(ex);
                        }
                        previousException = ex;
                        continue;
                    }
                }
                throw new RuntimeException(previousException);
            };
        }
    }

    public static enum READ_WRITE_BEHAVIOR implements Consumer<Transaction>
    {
        AUTO{

            @Override
            public void accept(Transaction transaction) {
                if (!transaction.isOpen()) {
                    transaction.open();
                }
            }
        }
        ,
        MANUAL{

            @Override
            public void accept(Transaction transaction) {
                if (!transaction.isOpen()) {
                    throw Exceptions.transactionMustBeOpenToReadWrite();
                }
            }
        };

    }

    public static enum CLOSE_BEHAVIOR implements Consumer<Transaction>
    {
        COMMIT{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    transaction.commit();
                }
            }
        }
        ,
        ROLLBACK{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    transaction.rollback();
                }
            }
        }
        ,
        MANUAL{

            @Override
            public void accept(Transaction transaction) {
                if (transaction.isOpen()) {
                    throw Exceptions.openTransactionsOnClose();
                }
            }
        };

    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static IllegalStateException transactionAlreadyOpen() {
            return new IllegalStateException("Stop the current transaction before opening another");
        }

        public static IllegalStateException transactionMustBeOpenToReadWrite() {
            return new IllegalStateException("Open a transaction before attempting to read/write the transaction");
        }

        public static IllegalStateException openTransactionsOnClose() {
            return new IllegalStateException("Commit or rollback all outstanding transactions before closing the transaction");
        }

        public static UnsupportedOperationException threadedTransactionsNotSupported() {
            return new UnsupportedOperationException("Graph does not support threaded transactions");
        }

        public static IllegalArgumentException onCloseBehaviorCannotBeNull() {
            return new IllegalArgumentException("Transaction behavior for onClose cannot be null");
        }

        public static IllegalArgumentException onReadWriteBehaviorCannotBeNull() {
            return new IllegalArgumentException("Transaction behavior for onReadWrite cannot be null");
        }
    }

    public static enum Status {
        COMMIT,
        ROLLBACK;

    }
}

