/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalSourceFactory;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class TraversalScriptFunction<S, E>
implements Function<Graph, Traversal.Admin<S, E>>,
Serializable {
    private final TraversalSourceFactory traversalSourceFactory;
    private final String scriptEngineName;
    private final String traversalScript;
    private final Object[] bindings;

    public TraversalScriptFunction(TraversalSource traversalSource, String scriptEngineName, String traversalScript, Object ... bindings) {
        this.traversalSourceFactory = new TraversalSourceFactory<TraversalSource>(traversalSource);
        this.scriptEngineName = scriptEngineName;
        this.traversalScript = traversalScript;
        this.bindings = bindings;
        if (this.bindings.length % 2 != 0) {
            throw new IllegalArgumentException("The provided key/value bindings array length must be a multiple of two");
        }
    }

    @Override
    public Traversal.Admin<S, E> apply(Graph graph) {
        try {
            GremlinScriptEngine engine = SingleGremlinScriptEngineManager.get(this.scriptEngineName);
            Bindings engineBindings = engine.createBindings();
            engineBindings.put("g", this.traversalSourceFactory.createTraversalSource(graph));
            for (int i = 0; i < this.bindings.length; i += 2) {
                engineBindings.put((String)this.bindings[i], this.bindings[i + 1]);
            }
            Traversal.Admin traversal = (Traversal.Admin)engine.eval(this.traversalScript, engineBindings);
            if (!traversal.isLocked()) {
                traversal.applyStrategies();
            }
            return traversal;
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return this.traversalScript;
    }
}

