/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;

public final class DefaultTraversalMetrics
implements TraversalMetrics,
Serializable {
    private static final String[] HEADERS = new String[]{"Step", "Count", "Traversers", "Time (ms)", "% Dur"};
    private final Map<String, MutableMetrics> metrics = new HashMap<String, MutableMetrics>();
    private final TreeMap<Integer, String> indexToLabelMap = new TreeMap();
    private long totalStepDuration;
    private Map<String, ImmutableMetrics> computedMetrics;

    public DefaultTraversalMetrics() {
    }

    public DefaultTraversalMetrics(long totalStepDurationNs, List<MutableMetrics> metricsMap) {
        this.totalStepDuration = totalStepDurationNs;
        this.computedMetrics = new LinkedHashMap<String, ImmutableMetrics>(this.metrics.size());
        metricsMap.forEach(metric -> this.computedMetrics.put(metric.getId(), metric.getImmutableClone()));
    }

    @Override
    public long getDuration(TimeUnit unit) {
        return unit.convert(this.totalStepDuration, MutableMetrics.SOURCE_UNIT);
    }

    @Override
    public Metrics getMetrics(int index) {
        return this.computedMetrics.get(this.indexToLabelMap.get(index));
    }

    @Override
    public Metrics getMetrics(String id) {
        return this.computedMetrics.get(id);
    }

    public Collection<ImmutableMetrics> getMetrics() {
        return this.computedMetrics.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Traversal Metrics\n").append(String.format("%-50s %21s %11s %15s %8s", HEADERS));
        sb.append("\n=============================================================================================================");
        this.appendMetrics(this.computedMetrics.values(), sb, 0);
        sb.append(String.format("%n%50s %21s %11s %15.3f %8s", ">TOTAL", "-", "-", (double)this.getDuration(TimeUnit.MICROSECONDS) / 1000.0, "-"));
        return sb.toString();
    }

    private void appendMetrics(Collection<? extends Metrics> metrics, StringBuilder sb, int indent) {
        for (Metrics metrics2 : metrics) {
            Map<String, Object> annotations;
            String rowName = metrics2.getName();
            for (int ii = 0; ii < indent; ++ii) {
                rowName = "  " + rowName;
            }
            rowName = StringUtils.abbreviate((String)rowName, (int)50);
            Long itemCount = metrics2.getCount("elementCount");
            Long traverserCount = metrics2.getCount("traverserCount");
            Double percentDur = (Double)metrics2.getAnnotation("percentDur");
            sb.append(String.format("%n%-50s", rowName));
            if (itemCount != null) {
                sb.append(String.format(" %21d", itemCount));
            } else {
                sb.append(String.format(" %21s", ""));
            }
            if (traverserCount != null) {
                sb.append(String.format(" %11d", traverserCount));
            } else {
                sb.append(String.format(" %11s", ""));
            }
            sb.append(String.format(" %15.3f", (double)metrics2.getDuration(TimeUnit.MICROSECONDS) / 1000.0));
            if (percentDur != null) {
                sb.append(String.format(" %8.2f", percentDur));
            }
            if (!(annotations = metrics2.getAnnotations()).isEmpty()) {
                annotations.entrySet().stream().filter(kv -> !((String)kv.getKey()).equals("percentDur")).forEach(kv -> {
                    String prefix = "    \\_";
                    String separator = "=";
                    String k = "    \\_" + StringUtils.abbreviate((String)((String)kv.getKey()), (int)30);
                    int valueIndentLen = "=".length() + k.length() + indent;
                    int leftover = 110 - valueIndentLen;
                    String[] splitValues = DefaultTraversalMetrics.splitOnSize(kv.getValue().toString(), leftover);
                    for (int ix = 0; ix < splitValues.length; ++ix) {
                        if (ix == 0) {
                            sb.append(String.format("%n%s", k + "=" + splitValues[ix]));
                            continue;
                        }
                        sb.append(String.format("%n%s", DefaultTraversalMetrics.padLeft(splitValues[ix], valueIndentLen - 1)));
                    }
                });
            }
            this.appendMetrics(metrics2.getNested(), sb, indent + 1);
        }
    }

    private static String[] splitOnSize(String text, int size) {
        String[] ret = new String[(text.length() + size - 1) / size];
        int counter = 0;
        for (int start = 0; start < text.length(); start += size) {
            ret[counter] = text.substring(start, Math.min(text.length(), start + size));
            ++counter;
        }
        return ret;
    }

    private static String padLeft(String text, int amountToPad) {
        String newText = text;
        for (int ix = 0; ix < amountToPad; ++ix) {
            newText = " " + newText;
        }
        return newText;
    }

    private void computeTotals() {
        ArrayList<MutableMetrics> tempMetrics = new ArrayList<MutableMetrics>(this.metrics.size());
        for (String label : this.indexToLabelMap.values()) {
            tempMetrics.add(this.metrics.get(label).clone());
        }
        this.totalStepDuration = 0L;
        tempMetrics.forEach(metric -> this.totalStepDuration += metric.getDuration(MutableMetrics.SOURCE_UNIT));
        tempMetrics.forEach(m -> {
            double dur = (double)m.getDuration(TimeUnit.NANOSECONDS) * 100.0 / (double)this.totalStepDuration;
            m.setAnnotation("percentDur", dur);
        });
        this.computedMetrics = new LinkedHashMap<String, ImmutableMetrics>(this.metrics.size());
        tempMetrics.forEach(it -> this.computedMetrics.put(it.getId(), it.getImmutableClone()));
    }

    public static DefaultTraversalMetrics merge(Iterator<DefaultTraversalMetrics> toMerge) {
        DefaultTraversalMetrics newTraversalMetrics = new DefaultTraversalMetrics();
        toMerge.forEachRemaining(inTraversalMetrics -> inTraversalMetrics.metrics.forEach((metricsId, toAggregate) -> {
            MutableMetrics aggregateMetrics = newTraversalMetrics.metrics.get(metricsId);
            if (null == aggregateMetrics) {
                aggregateMetrics = new MutableMetrics(toAggregate.getId(), toAggregate.getName());
                newTraversalMetrics.metrics.put((String)metricsId, aggregateMetrics);
                for (Map.Entry<Integer, String> entry : inTraversalMetrics.indexToLabelMap.entrySet()) {
                    if (!metricsId.equals(entry.getValue())) continue;
                    newTraversalMetrics.indexToLabelMap.put(entry.getKey(), (String)metricsId);
                    break;
                }
            }
            aggregateMetrics.aggregate((MutableMetrics)toAggregate);
        }));
        return newTraversalMetrics;
    }

    public void setMetrics(Traversal.Admin traversal, boolean onGraphComputer) {
        this.addTopLevelMetrics(traversal, onGraphComputer);
        this.handleNestedTraversals(traversal, null, onGraphComputer);
        this.computeTotals();
    }

    private void addTopLevelMetrics(Traversal.Admin traversal, boolean onGraphComputer) {
        List<ProfileStep> profileSteps = TraversalHelper.getStepsOfClass(ProfileStep.class, traversal);
        for (int ii = 0; ii < profileSteps.size(); ++ii) {
            MutableMetrics stepMetrics;
            ProfileStep step = profileSteps.get(ii);
            if (onGraphComputer) {
                stepMetrics = (MutableMetrics)traversal.getSideEffects().get(step.getId());
                this.indexToLabelMap.put(ii, stepMetrics.getId());
                this.metrics.put(stepMetrics.getId(), stepMetrics);
                continue;
            }
            stepMetrics = step.getMetrics();
            this.indexToLabelMap.put(ii, stepMetrics.getId());
            this.metrics.put(stepMetrics.getId(), stepMetrics);
        }
    }

    private void handleNestedTraversals(Traversal.Admin traversal, MutableMetrics parentMetrics, boolean onGraphComputer) {
        long prevDur = 0L;
        for (int i = 0; i < traversal.getSteps().size(); ++i) {
            MutableMetrics metrics;
            Step step = traversal.getSteps().get(i);
            if (!(step instanceof ProfileStep)) continue;
            MutableMetrics mutableMetrics = metrics = onGraphComputer ? (MutableMetrics)traversal.getSideEffects().get(step.getId()) : ((ProfileStep)step).getMetrics();
            if (null == metrics) continue;
            if (!onGraphComputer) {
                long durBeforeAdjustment = metrics.getDuration(TimeUnit.NANOSECONDS);
                metrics.setDuration(metrics.getDuration(TimeUnit.NANOSECONDS) - prevDur, TimeUnit.NANOSECONDS);
                prevDur = durBeforeAdjustment;
            }
            if (parentMetrics != null) {
                parentMetrics.addNested(metrics);
            }
            if (!(step.getPreviousStep() instanceof TraversalParent)) continue;
            for (Traversal.Admin t : ((TraversalParent)((Object)step.getPreviousStep())).getLocalChildren()) {
                this.handleNestedTraversals(t, metrics, onGraphComputer);
            }
            for (Traversal.Admin t : ((TraversalParent)((Object)step.getPreviousStep())).getGlobalChildren()) {
                this.handleNestedTraversals(t, metrics, onGraphComputer);
            }
        }
    }
}

