/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GraphComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.DefaultTraversalMetricsSupplier;

public final class ProfileSideEffectStep<S>
extends SideEffectStep<S>
implements SideEffectCapable<DefaultTraversalMetrics, DefaultTraversalMetrics>,
GraphComputing {
    public static final String DEFAULT_METRICS_KEY = Graph.Hidden.hide("metrics");
    private String sideEffectKey;
    private boolean onGraphComputer = false;

    public ProfileSideEffectStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, DefaultTraversalMetricsSupplier.instance(), Operator.assign);
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public Traverser.Admin<S> next() {
        Object start = null;
        try {
            Object object = start = super.next();
            return object;
        }
        finally {
            if (!this.onGraphComputer && start == null) {
                ((DefaultTraversalMetrics)this.getTraversal().getSideEffects().get(this.sideEffectKey)).setMetrics(this.getTraversal(), false);
            }
        }
    }

    @Override
    public boolean hasNext() {
        boolean start = super.hasNext();
        if (!this.onGraphComputer && !start) {
            ((DefaultTraversalMetrics)this.getTraversal().getSideEffects().get(this.sideEffectKey)).setMetrics(this.getTraversal(), false);
        }
        return start;
    }

    @Override
    public DefaultTraversalMetrics generateFinalResult(DefaultTraversalMetrics tm) {
        if (this.onGraphComputer) {
            tm.setMetrics(this.getTraversal(), true);
        }
        return tm;
    }

    @Override
    public void onGraphComputer() {
        this.onGraphComputer = true;
    }
}

