/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.NumberHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.function.MeanNumberSupplier;

public final class MeanGlobalStep<S extends Number, E extends Number>
extends ReducingBarrierStep<S, E> {
    private static final Set<TraverserRequirement> REQUIREMENTS = EnumSet.of(TraverserRequirement.OBJECT, TraverserRequirement.BULK);

    public MeanGlobalStep(Traversal.Admin traversal) {
        super(traversal);
        this.setSeedSupplier(MeanNumberSupplier.instance());
        this.setReducingBiOperator(MeanGlobalBiOperator.INSTANCE);
    }

    @Override
    public E projectTraverser(Traverser.Admin<S> traverser) {
        return (E)new MeanNumber((Number)traverser.get(), traverser.bulk());
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return REQUIREMENTS;
    }

    @Override
    public E generateFinalResult(E meanNumber) {
        return (E)((MeanNumber)meanNumber).getFinal();
    }

    public static final class MeanNumber
    extends Number
    implements Comparable<Number> {
        private long count;
        private Number sum;

        public MeanNumber() {
            this(0, 0L);
        }

        public MeanNumber(Number number, long count) {
            this.count = count;
            this.sum = NumberHelper.mul(number, count);
        }

        public MeanNumber add(Number amount, long count) {
            this.count += count;
            this.sum = NumberHelper.add(this.sum, NumberHelper.mul(amount, count));
            return this;
        }

        public MeanNumber add(MeanNumber other) {
            this.count += other.count;
            this.sum = NumberHelper.add(this.sum, other.sum);
            return this;
        }

        @Override
        public int intValue() {
            return NumberHelper.div(this.sum, this.count).intValue();
        }

        @Override
        public long longValue() {
            return NumberHelper.div(this.sum, this.count).longValue();
        }

        @Override
        public float floatValue() {
            return NumberHelper.div(this.sum, this.count, true).floatValue();
        }

        @Override
        public double doubleValue() {
            return NumberHelper.div(this.sum, this.count, true).doubleValue();
        }

        public String toString() {
            return this.getFinal().toString();
        }

        @Override
        public int compareTo(Number number) {
            return Double.valueOf(this.doubleValue()).compareTo(number.doubleValue());
        }

        public boolean equals(Object object) {
            return object instanceof Number && Double.valueOf(this.doubleValue()).equals(((Number)object).doubleValue());
        }

        public int hashCode() {
            return Double.valueOf(this.doubleValue()).hashCode();
        }

        public Number getFinal() {
            return NumberHelper.div(this.sum, this.count, true);
        }
    }

    public static final class MeanGlobalBiOperator<S extends Number>
    implements BinaryOperator<S>,
    Serializable {
        private static final MeanGlobalBiOperator INSTANCE = new MeanGlobalBiOperator();

        @Override
        public S apply(S mutatingSeed, S number) {
            if (mutatingSeed instanceof MeanNumber) {
                return (S)(number instanceof MeanNumber ? ((MeanNumber)mutatingSeed).add((MeanNumber)number) : ((MeanNumber)mutatingSeed).add((Number)number, 1L));
            }
            return (S)(number instanceof MeanNumber ? ((MeanNumber)number).add((Number)mutatingSeed, 1L) : new MeanNumber((Number)number, 1L).add((Number)mutatingSeed, 1L));
        }
    }
}

