/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.FunctionTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupStep<S, K, V>
extends ReducingBarrierStep<S, Map<K, V>>
implements ByModulating,
TraversalParent {
    private char state = (char)107;
    private Traversal.Admin<S, K> keyTraversal;
    private Traversal.Admin<S, V> valueTraversal = this.integrateChild(__.fold().asAdmin());
    private Barrier barrierStep = TraversalHelper.getFirstStepOfAssignableClass(Barrier.class, this.valueTraversal).orElse(null);

    public GroupStep(Traversal.Admin traversal) {
        super(traversal);
        this.setReducingBiOperator(new GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
        this.setSeedSupplier(HashMapSupplier.instance());
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> kvTraversal) {
        if ('k' == this.state) {
            this.keyTraversal = this.integrateChild(kvTraversal);
            this.state = (char)118;
        } else if ('v' == this.state) {
            this.valueTraversal = this.integrateChild(GroupStep.convertValueTraversal(kvTraversal));
            this.barrierStep = TraversalHelper.getFirstStepOfAssignableClass(Barrier.class, this.valueTraversal).orElse(null);
            this.setReducingBiOperator(new GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
            this.state = (char)120;
        } else {
            throw new IllegalStateException("The key and value traversals for group()-step have already been set: " + this);
        }
    }

    @Override
    public Map<K, V> projectTraverser(Traverser.Admin<S> traverser) {
        HashMap<K, Object> map = new HashMap<K, Object>(1);
        this.valueTraversal.reset();
        this.valueTraversal.addStart(traverser);
        if (null == this.barrierStep) {
            if (this.valueTraversal.hasNext()) {
                map.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), this.valueTraversal.next());
            }
        } else if (this.barrierStep.hasNextBarrier()) {
            map.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), this.barrierStep.nextBarrier());
        }
        return map;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.keyTraversal, this.valueTraversal);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList children = new ArrayList(2);
        if (null != this.keyTraversal) {
            children.add(this.keyTraversal);
        }
        children.add(this.valueTraversal);
        return children;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.BULK);
    }

    @Override
    public GroupStep<S, K, V> clone() {
        GroupStep clone = (GroupStep)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        clone.valueTraversal = this.valueTraversal.clone();
        clone.barrierStep = TraversalHelper.getFirstStepOfAssignableClass(Barrier.class, clone.valueTraversal).orElse(null);
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
        this.integrateChild(this.valueTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        return result ^= this.valueTraversal.hashCode();
    }

    @Override
    public Map<K, V> generateFinalResult(Map<K, V> object) {
        return GroupStep.doFinalReduction(object, this.valueTraversal);
    }

    public static <S, E> Traversal.Admin<S, E> convertValueTraversal(Traversal.Admin<S, E> valueTraversal) {
        if (valueTraversal instanceof ElementValueTraversal || valueTraversal instanceof TokenTraversal || valueTraversal instanceof IdentityTraversal || valueTraversal.getStartStep() instanceof LambdaMapStep && ((LambdaMapStep)valueTraversal.getStartStep()).getMapFunction() instanceof FunctionTraverser) {
            return (Traversal.Admin)((Object)__.map(valueTraversal).fold());
        }
        return valueTraversal;
    }

    public static <K, V> Map<K, V> doFinalReduction(Map<K, Object> map, Traversal.Admin<?, V> valueTraversal) {
        TraversalHelper.getFirstStepOfAssignableClass(Barrier.class, valueTraversal).ifPresent(barrierStep -> {
            for (Object key : map.keySet()) {
                valueTraversal.reset();
                barrierStep.addBarrier(map.get(key));
                if (!valueTraversal.hasNext()) continue;
                map.put(key, valueTraversal.next());
            }
        });
        return map;
    }

    public static final class GroupBiOperator<K, V>
    implements BinaryOperator<Map<K, V>>,
    Serializable {
        private BinaryOperator<V> barrierAggregator;

        public GroupBiOperator() {
        }

        public GroupBiOperator(BinaryOperator<V> barrierAggregator) {
            this.barrierAggregator = barrierAggregator;
        }

        @Override
        public Map<K, V> apply(Map<K, V> mapA, Map<K, V> mapB) {
            for (K key : mapB.keySet()) {
                Object objectA = mapA.get(key);
                V objectB = mapB.get(key);
                if (null == objectA) {
                    objectA = objectB;
                } else if (null != objectB) {
                    objectA = this.barrierAggregator.apply(objectA, objectB);
                }
                mapA.put(key, objectA);
            }
            return mapA;
        }
    }
}

