/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.dsl.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bindings;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.engine.ComputerTraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.engine.StandardTraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.RequirementsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class GraphTraversalSource
implements TraversalSource {
    protected transient RemoteConnection connection;
    protected final Graph graph;
    protected TraversalStrategies strategies;
    protected Bytecode bytecode = new Bytecode();

    @Override
    public Optional<Class> getAnonymousTraversalClass() {
        return Optional.of(__.class);
    }

    public GraphTraversalSource(Graph graph, TraversalStrategies traversalStrategies) {
        this.graph = graph;
        this.strategies = traversalStrategies;
    }

    public GraphTraversalSource(Graph graph) {
        this(graph, TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
    }

    @Override
    public TraversalStrategies getStrategies() {
        return this.strategies;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    @Override
    public GraphTraversalSource clone() {
        try {
            GraphTraversalSource clone = (GraphTraversalSource)super.clone();
            clone.strategies = this.strategies.clone();
            clone.bytecode = this.bytecode.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public GraphTraversalSource withStrategies(TraversalStrategy ... traversalStrategies) {
        return (GraphTraversalSource)TraversalSource.super.withStrategies(traversalStrategies);
    }

    @Override
    public GraphTraversalSource withoutStrategies(Class<? extends TraversalStrategy> ... traversalStrategyClasses) {
        return (GraphTraversalSource)TraversalSource.super.withoutStrategies(traversalStrategyClasses);
    }

    @Override
    @Deprecated
    public GraphTraversalSource withBindings(Bindings bindings) {
        return (GraphTraversalSource)TraversalSource.super.withBindings(bindings);
    }

    @Override
    public GraphTraversalSource withComputer(Computer computer) {
        return (GraphTraversalSource)TraversalSource.super.withComputer(computer);
    }

    @Override
    public GraphTraversalSource withComputer(Class<? extends GraphComputer> graphComputerClass) {
        return (GraphTraversalSource)TraversalSource.super.withComputer(graphComputerClass);
    }

    @Override
    public GraphTraversalSource withComputer() {
        return (GraphTraversalSource)TraversalSource.super.withComputer();
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, Supplier<A> initialValue, BinaryOperator<A> reducer) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue, reducer);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, A initialValue, BinaryOperator<A> reducer) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue, reducer);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, A initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, Supplier<A> initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, mergeOperator);
    }

    public GraphTraversalSource withBulk(boolean useBulk) {
        if (useBulk) {
            return this;
        }
        GraphTraversalSource clone = this.clone();
        RequirementsStrategy.addRequirements(clone.getStrategies(), TraverserRequirement.ONE_BULK);
        clone.bytecode.addSource("withBulk", useBulk);
        return clone;
    }

    public GraphTraversalSource withPath() {
        GraphTraversalSource clone = this.clone();
        RequirementsStrategy.addRequirements(clone.getStrategies(), TraverserRequirement.PATH);
        clone.bytecode.addSource("withPath", new Object[0]);
        return clone;
    }

    @Override
    public GraphTraversalSource withRemote(Configuration conf) {
        return (GraphTraversalSource)TraversalSource.super.withRemote(conf);
    }

    @Override
    public GraphTraversalSource withRemote(String configFile) throws Exception {
        return (GraphTraversalSource)TraversalSource.super.withRemote(configFile);
    }

    @Override
    public GraphTraversalSource withRemote(RemoteConnection connection) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = connection;
        GraphTraversalSource clone = this.clone();
        clone.getStrategies().addStrategies(new RemoteStrategy(connection));
        return clone;
    }

    @Deprecated
    public GraphTraversal<Vertex, Vertex> addV(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        if (keyValues.length != 0 && keyValues[0].equals(T.label)) {
            GraphTraversal<Vertex, Vertex> traversal = this.addV(keyValues[1].toString());
            for (int i = 2; i < keyValues.length; i += 2) {
                traversal.property(keyValues[i], keyValues[i + 1], new Object[0]);
            }
            return traversal;
        }
        GraphTraversal<Vertex, Vertex> traversal = this.addV();
        for (int i = 0; i < keyValues.length; i += 2) {
            traversal.property(keyValues[i], keyValues[i + 1], new Object[0]);
        }
        return traversal;
    }

    public GraphTraversal<Vertex, Vertex> addV(String label) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addV", label);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddVertexStartStep(traversal, label));
    }

    public GraphTraversal<Vertex, Vertex> addV() {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addV", new Object[0]);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddVertexStartStep(traversal, null));
    }

    public <S> GraphTraversal<S, S> inject(S ... starts) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("inject", starts);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep(new InjectStep<S>((Traversal.Admin)traversal, starts));
    }

    public GraphTraversal<Vertex, Vertex> V(Object ... vertexIds) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("V", vertexIds);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new GraphStep(traversal, Vertex.class, true, vertexIds));
    }

    public GraphTraversal<Edge, Edge> E(Object ... edgesIds) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("E", edgesIds);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new GraphStep(traversal, Edge.class, true, edgesIds));
    }

    public Transaction tx() {
        return this.graph.tx();
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public String toString() {
        return StringFactory.traversalSourceString(this);
    }

    @Deprecated
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public static Builder standard() {
        return GraphTraversalSource.build().engine(StandardTraversalEngine.build());
    }

    @Deprecated
    public static Builder computer() {
        return GraphTraversalSource.build().engine(ComputerTraversalEngine.build());
    }

    @Deprecated
    public static Builder computer(Class<? extends GraphComputer> graphComputerClass) {
        return GraphTraversalSource.build().engine(ComputerTraversalEngine.build().computer(graphComputerClass));
    }

    @Deprecated
    public static final class Builder
    implements TraversalSource.Builder<GraphTraversalSource> {
        private TraversalEngine.Builder engineBuilder = StandardTraversalEngine.build();
        private List<TraversalStrategy> withStrategies = new ArrayList<TraversalStrategy>();
        private List<Class<? extends TraversalStrategy>> withoutStrategies = new ArrayList<Class<? extends TraversalStrategy>>();

        private Builder() {
        }

        @Override
        @Deprecated
        public Builder engine(TraversalEngine.Builder engineBuilder) {
            this.engineBuilder = engineBuilder;
            return this;
        }

        @Override
        @Deprecated
        public Builder with(TraversalStrategy strategy) {
            this.withStrategies.add(strategy);
            return this;
        }

        @Override
        @Deprecated
        public TraversalSource.Builder without(Class<? extends TraversalStrategy> strategyClass) {
            this.withoutStrategies.add(strategyClass);
            return this;
        }

        @Override
        @Deprecated
        public GraphTraversalSource create(Graph graph) {
            TraversalSource traversalSource = new GraphTraversalSource(graph);
            if (!this.withStrategies.isEmpty()) {
                traversalSource = traversalSource.withStrategies(this.withStrategies.toArray(new TraversalStrategy[this.withStrategies.size()]));
            }
            if (!this.withoutStrategies.isEmpty()) {
                traversalSource = traversalSource.withoutStrategies(this.withoutStrategies.toArray(new Class[this.withoutStrategies.size()]));
            }
            if (this.engineBuilder instanceof ComputerTraversalEngine.Builder) {
                traversalSource = (GraphTraversalSource)((ComputerTraversalEngine.Builder)this.engineBuilder).create((GraphTraversalSource)traversalSource);
            }
            return traversalSource;
        }
    }

    public static final class Symbols {
        public static final String withBulk = "withBulk";
        public static final String withPath = "withPath";

        private Symbols() {
        }
    }
}

