/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public interface TraversalSideEffects
extends Cloneable,
Serializable,
AutoCloseable {
    default public boolean exists(String key) {
        return this.keys().contains(key);
    }

    public <V> V get(String var1) throws IllegalArgumentException;

    public void set(String var1, Object var2) throws IllegalArgumentException;

    public void remove(String var1);

    public Set<String> keys();

    @Override
    default public void close() throws Exception {
    }

    default public boolean isEmpty() {
        return this.keys().size() == 0;
    }

    public <V> void register(String var1, Supplier<V> var2, BinaryOperator<V> var3);

    public <V> void registerIfAbsent(String var1, Supplier<V> var2, BinaryOperator<V> var3);

    public <V> BinaryOperator<V> getReducer(String var1) throws IllegalArgumentException;

    public <V> Supplier<V> getSupplier(String var1) throws IllegalArgumentException;

    public void add(String var1, Object var2) throws IllegalArgumentException;

    public <S> void setSack(Supplier<S> var1, UnaryOperator<S> var2, BinaryOperator<S> var3);

    public <S> Supplier<S> getSackInitialValue();

    public <S> UnaryOperator<S> getSackSplitter();

    public <S> BinaryOperator<S> getSackMerger();

    default public <V> void forEach(BiConsumer<String, V> biConsumer) {
        this.keys().forEach((? super T key) -> biConsumer.accept((String)key, this.get((String)key)));
    }

    public TraversalSideEffects clone();

    public void mergeInto(TraversalSideEffects var1);

    @Deprecated
    public void registerSupplier(String var1, Supplier var2);

    @Deprecated
    default public void registerSupplierIfAbsent(String key, Supplier supplier) {
        if (!this.getRegisteredSupplier(key).isPresent()) {
            this.registerSupplier(key, supplier);
        }
    }

    @Deprecated
    public <V> Optional<Supplier<V>> getRegisteredSupplier(String var1);

    @Deprecated
    default public <V> V getOrCreate(String key, Supplier<V> orCreate) {
        V value;
        V v = value = this.exists(key) ? (V)this.get(key) : null;
        if (null != value) {
            return value;
        }
        Optional<Supplier<V>> with = this.getRegisteredSupplier(key);
        if (with.isPresent()) {
            V v2 = with.get().get();
            this.set(key, v2);
            return v2;
        }
        V v3 = orCreate.get();
        this.set(key, v3);
        return v3;
    }

    public static class Exceptions {
        public static IllegalArgumentException sideEffectKeyCanNotBeEmpty() {
            return new IllegalArgumentException("Side-effect key can not be the empty string");
        }

        public static IllegalArgumentException sideEffectKeyCanNotBeNull() {
            return new IllegalArgumentException("Side-effect key can not be null");
        }

        public static IllegalArgumentException sideEffectValueCanNotBeNull() {
            return new IllegalArgumentException("Side-effect value can not be null");
        }

        public static IllegalArgumentException sideEffectKeyDoesNotExist(String key) {
            return new IllegalArgumentException("The side-effect key does not exist in the side-effects: " + key);
        }
    }
}

