/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import org.apache.tinkerpop.gremlin.process.traversal.NumberHelper;

public enum Order implements Comparator<Object>
{
    incr{

        @Override
        public int compare(Object first, Object second) {
            return first instanceof Number && second instanceof Number ? NumberHelper.compare((Number)first, (Number)second).intValue() : Comparator.naturalOrder().compare((Comparable)first, (Comparable)second);
        }

        @Override
        public Order reversed() {
            return decr;
        }
    }
    ,
    decr{

        @Override
        public int compare(Object first, Object second) {
            return first instanceof Number && second instanceof Number ? NumberHelper.compare((Number)second, (Number)first).intValue() : Comparator.reverseOrder().compare((Comparable)first, (Comparable)second);
        }

        @Override
        public Order reversed() {
            return incr;
        }
    }
    ,
    keyIncr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.naturalOrder().compare(((Map.Entry)first).getKey(), ((Map.Entry)second).getKey());
        }

        @Override
        public Order reversed() {
            return keyDecr;
        }
    }
    ,
    valueIncr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.naturalOrder().compare(((Map.Entry)first).getValue(), ((Map.Entry)second).getValue());
        }

        @Override
        public Order reversed() {
            return valueDecr;
        }
    }
    ,
    keyDecr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.reverseOrder().compare(((Map.Entry)first).getKey(), ((Map.Entry)second).getKey());
        }

        @Override
        public Order reversed() {
            return keyIncr;
        }
    }
    ,
    valueDecr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.reverseOrder().compare(((Map.Entry)first).getValue(), ((Map.Entry)second).getValue());
        }

        @Override
        public Order reversed() {
            return valueIncr;
        }
    }
    ,
    shuffle{

        @Override
        public int compare(Object first, Object second) {
            return RANDOM.nextBoolean() ? -1 : 1;
        }

        @Override
        public Order reversed() {
            return shuffle;
        }
    };

    private static final Random RANDOM;

    @Override
    public abstract int compare(Object var1, Object var2);

    public abstract Order reversed();

    static {
        RANDOM = new Random();
    }
}

