/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Bindings;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class Bytecode
implements Cloneable,
Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private List<Instruction> sourceInstructions = new ArrayList<Instruction>();
    private List<Instruction> stepInstructions = new ArrayList<Instruction>();

    public void addSource(String sourceName, Object ... arguments) {
        if (sourceName.equals("withoutStrategies")) {
            Object[] classes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                classes[i] = arguments[i] instanceof TraversalStrategyProxy ? ((TraversalStrategyProxy)arguments[i]).getStrategyClass() : (Class)arguments[i];
            }
            this.sourceInstructions.add(new Instruction(sourceName, classes));
        } else {
            this.sourceInstructions.add(new Instruction(sourceName, this.flattenArguments(arguments)));
        }
        Bindings.clear();
    }

    public void addStep(String stepName, Object ... arguments) {
        this.stepInstructions.add(new Instruction(stepName, this.flattenArguments(arguments)));
        Bindings.clear();
    }

    public Iterable<Instruction> getSourceInstructions() {
        return this.sourceInstructions;
    }

    public Iterable<Instruction> getStepInstructions() {
        return this.stepInstructions;
    }

    public Iterable<Instruction> getInstructions() {
        return () -> IteratorUtils.concat(this.sourceInstructions.iterator(), this.stepInstructions.iterator());
    }

    public Map<String, Object> getBindings() {
        HashMap<String, Object> bindingsMap = new HashMap<String, Object>();
        for (Instruction instruction : this.sourceInstructions) {
            for (Object argument : instruction.getArguments()) {
                Bytecode.addArgumentBinding(bindingsMap, argument);
            }
        }
        for (Instruction instruction : this.stepInstructions) {
            for (Object argument : instruction.getArguments()) {
                Bytecode.addArgumentBinding(bindingsMap, argument);
            }
        }
        return bindingsMap;
    }

    private static final void addArgumentBinding(Map<String, Object> bindingsMap, Object argument) {
        if (argument instanceof Binding) {
            bindingsMap.put(((Binding)argument).key, ((Binding)argument).value);
        } else if (argument instanceof Map) {
            for (Map.Entry entry : ((Map)argument).entrySet()) {
                Bytecode.addArgumentBinding(bindingsMap, entry.getKey());
                Bytecode.addArgumentBinding(bindingsMap, entry.getValue());
            }
        } else if (argument instanceof Collection) {
            for (Object item : (Collection)argument) {
                Bytecode.addArgumentBinding(bindingsMap, item);
            }
        } else if (argument instanceof Bytecode) {
            bindingsMap.putAll(((Bytecode)argument).getBindings());
        }
    }

    public String toString() {
        return Arrays.asList(this.sourceInstructions, this.stepInstructions).toString();
    }

    public boolean equals(Object object) {
        return object instanceof Bytecode && this.sourceInstructions.equals(((Bytecode)object).sourceInstructions) && this.stepInstructions.equals(((Bytecode)object).stepInstructions);
    }

    public int hashCode() {
        return this.sourceInstructions.hashCode() + this.stepInstructions.hashCode();
    }

    public Bytecode clone() {
        try {
            Bytecode clone = (Bytecode)super.clone();
            clone.sourceInstructions = new ArrayList<Instruction>(this.sourceInstructions);
            clone.stepInstructions = new ArrayList<Instruction>(this.stepInstructions);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private final Object[] flattenArguments(Object ... arguments) {
        if (arguments.length == 0) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> flatArguments = new ArrayList<Object>();
        for (Object object : arguments) {
            if (object instanceof Object[]) {
                for (Object nestObject : (Object[])object) {
                    flatArguments.add(this.convertArgument(nestObject, true));
                }
                continue;
            }
            flatArguments.add(this.convertArgument(object, true));
        }
        return flatArguments.toArray();
    }

    private final Object convertArgument(Object argument, boolean searchBindings) {
        String variable;
        if (searchBindings && null != (variable = Bindings.getBoundVariable(argument))) {
            return new Binding<Object>(variable, this.convertArgument(argument, false));
        }
        if (argument instanceof Traversal) {
            return ((Traversal)argument).asAdmin().getBytecode();
        }
        if (argument instanceof Map) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(((Map)argument).size());
            for (Map.Entry entry : ((Map)argument).entrySet()) {
                map.put(this.convertArgument(entry.getKey(), true), this.convertArgument(entry.getValue(), true));
            }
            return map;
        }
        if (argument instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>(((List)argument).size());
            for (Object item : (List)argument) {
                list.add(this.convertArgument(item, true));
            }
            return list;
        }
        if (argument instanceof Set) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(((Set)argument).size());
            for (Object item : (Set)argument) {
                set.add(this.convertArgument(item, true));
            }
            return set;
        }
        return argument;
    }

    public static class Binding<V>
    implements Serializable {
        private final String key;
        private final V value;

        public Binding(String key, V value) {
            this.key = key;
            this.value = value;
        }

        public String variable() {
            return this.key;
        }

        public V value() {
            return this.value;
        }

        public String toString() {
            return "binding[" + this.key + "=" + this.value + "]";
        }

        public boolean equals(Object object) {
            return object instanceof Binding && this.key.equals(((Binding)object).key) && this.value.equals(((Binding)object).value);
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }
    }

    public static class Instruction
    implements Serializable {
        private final String operator;
        private final Object[] arguments;

        private Instruction(String operator, Object ... arguments) {
            this.operator = operator;
            this.arguments = arguments;
        }

        public String getOperator() {
            return this.operator;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            return this.operator + "(" + StringFactory.removeEndBrackets(Arrays.asList(this.arguments)) + ")";
        }

        public boolean equals(Object object) {
            return object instanceof Instruction && this.operator.equals(((Instruction)object).operator) && Arrays.equals(this.arguments, ((Instruction)object).arguments);
        }

        public int hashCode() {
            return this.operator.hashCode() + Arrays.hashCode(this.arguments);
        }
    }
}

