/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class AbstractVertexProgramBuilder<B extends VertexProgram.Builder>
implements VertexProgram.Builder {
    protected final BaseConfiguration configuration = new BaseConfiguration();

    public AbstractVertexProgramBuilder() {
        this.configuration.setDelimiterParsingDisabled(true);
    }

    public AbstractVertexProgramBuilder(Class<? extends VertexProgram> vertexProgramClass) {
        this();
        this.configuration.setProperty("gremlin.vertexProgram", (Object)vertexProgramClass.getName());
    }

    public B configure(Object ... keyValues) {
        VertexProgramHelper.legalConfigurationKeyValueArray(keyValues);
        for (int i = 0; i < keyValues.length; i += 2) {
            this.configuration.setProperty((String)keyValues[i], keyValues[i + 1]);
        }
        return (B)this;
    }

    @Override
    public <P extends VertexProgram> P create(Graph graph) {
        return (P)VertexProgram.createVertexProgram(graph, (Configuration)this.configuration);
    }
}

