/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.VertexComputing;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.util.EmptyMemory;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class VertexProgramStep
extends AbstractStep<ComputerResult, ComputerResult>
implements VertexComputing {
    public static final String ROOT_TRAVERSAL = "gremlin.vertexProgramStep.rootTraversal";
    public static final String STEP_ID = "gremlin.vertexProgramStep.stepId";
    protected Computer computer = Computer.compute();
    protected boolean first = true;

    public VertexProgramStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Traverser.Admin<ComputerResult> processNextStart() throws NoSuchElementException {
        Future<ComputerResult> future = null;
        try {
            if (this.first && this.getPreviousStep() instanceof EmptyStep) {
                this.first = false;
                Graph graph = this.getTraversal().getGraph().get();
                future = this.getComputer().apply(graph).program(this.generateProgram(graph, EmptyMemory.instance())).submit();
                ComputerResult result = future.get();
                this.processMemorySideEffects(result.memory());
                return this.getTraversal().getTraverserGenerator().generate(result, this, 1L);
            }
            Object traverser = this.starts.next();
            Graph graph = ((ComputerResult)traverser.get()).graph();
            Memory memory = ((ComputerResult)traverser.get()).memory();
            future = this.generateComputer(graph).program(this.generateProgram(graph, memory)).submit();
            ComputerResult result = future.get();
            this.processMemorySideEffects(result.memory());
            return traverser.split(result, this);
        }
        catch (InterruptedException ie) {
            if (future != null) {
                future.cancel(true);
            }
            throw new TraversalInterruptedException();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Computer getComputer() {
        Computer tempComputer = this.computer;
        if (!this.isEndStep()) {
            if (null == tempComputer.getPersist()) {
                tempComputer = tempComputer.persist(GraphComputer.Persist.EDGES);
            }
            if (null == tempComputer.getResultGraph()) {
                tempComputer = tempComputer.result(GraphComputer.ResultGraph.NEW);
            }
        }
        return tempComputer;
    }

    @Override
    public void setComputer(Computer computer) {
        this.computer = computer;
    }

    protected boolean previousTraversalVertexProgram() {
        Step<ComputerResult, ComputerResult> currentStep = this;
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof TraversalVertexProgramStep) {
                return true;
            }
            currentStep = currentStep.getPreviousStep();
        }
        return false;
    }

    private void processMemorySideEffects(Memory memory) {
        TraversalSideEffects sideEffects = this.getTraversal().getSideEffects();
        for (String key : memory.keys()) {
            if (!sideEffects.exists(key)) continue;
            assert (!key.equals("gremlin.traversalVertexProgram.haltedTraversers"));
            sideEffects.set(key, memory.get(key));
        }
    }

    protected boolean isEndStep() {
        return this.getNextStep() instanceof ComputerResultStep || this.getNextStep() instanceof ProfileStep && this.getNextStep().getNextStep() instanceof ComputerResultStep;
    }
}

