/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure.PeerPressureVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.lambda.HaltedTraversersCountTraversal;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TimesModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class PeerPressureVertexProgramStep
extends VertexProgramStep
implements TraversalParent,
ByModulating,
TimesModulating {
    private PureTraversal<Vertex, Edge> edgeTraversal;
    private String clusterProperty = "gremlin.peerPressureVertexProgram.cluster";
    private int times = 30;

    public PeerPressureVertexProgramStep(Traversal.Admin traversal) {
        super(traversal);
        this.modulateBy(__.outE(new String[0]).asAdmin());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.edgeTraversal.hashCode() ^ this.clusterProperty.hashCode() ^ this.times;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> edgeTraversal) {
        this.edgeTraversal = new PureTraversal(edgeTraversal);
        this.integrateChild(this.edgeTraversal.get());
    }

    @Override
    public void modulateBy(String clusterProperty) {
        this.clusterProperty = clusterProperty;
    }

    @Override
    public void modulateTimes(int times) {
        this.times = times;
    }

    public List<Traversal.Admin<Vertex, Edge>> getLocalChildren() {
        return Collections.singletonList(this.edgeTraversal.get());
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.edgeTraversal.get(), this.clusterProperty, this.times, new GraphFilter(this.computer));
    }

    @Override
    public PeerPressureVertexProgram generateProgram(Graph graph, Memory memory) {
        Traversal.Admin<Vertex, Edge> detachedTraversal = this.edgeTraversal.getPure();
        detachedTraversal.setStrategies(TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
        PeerPressureVertexProgram.Builder builder = PeerPressureVertexProgram.build().property(this.clusterProperty).maxIterations(this.times).edges(detachedTraversal);
        if (this.previousTraversalVertexProgram()) {
            builder.initialVoteStrength(new HaltedTraversersCountTraversal());
        }
        return (PeerPressureVertexProgram)builder.create(graph);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return TraversalParent.super.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public PeerPressureVertexProgramStep clone() {
        PeerPressureVertexProgramStep clone = (PeerPressureVertexProgramStep)super.clone();
        clone.edgeTraversal = this.edgeTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.edgeTraversal.get());
    }
}

