/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.ProgramPhase;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.MasterExecutor;
import org.apache.tinkerpop.gremlin.process.computer.traversal.MemoryTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgramMessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.traversal.WorkerExecutor;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.finalization.ComputerFinalizationStrategy;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.computer.util.SingleMessenger;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.MapReducer;
import org.apache.tinkerpop.gremlin.process.traversal.step.MemoryComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.HaltedTraverserStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.IndexedTraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.ScriptTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMatrix;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.MutableMetricsSupplier;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TraversalVertexProgram
implements VertexProgram<TraverserSet<Object>> {
    public static final String TRAVERSAL = "gremlin.traversalVertexProgram.traversal";
    public static final String HALTED_TRAVERSERS = "gremlin.traversalVertexProgram.haltedTraversers";
    public static final String ACTIVE_TRAVERSERS = "gremlin.traversalVertexProgram.activeTraversers";
    protected static final String MUTATED_MEMORY_KEYS = "gremlin.traversalVertexProgram.mutatedMemoryKeys";
    private static final String VOTE_TO_HALT = "gremlin.traversalVertexProgram.voteToHalt";
    private static final String COMPLETED_BARRIERS = "gremlin.traversalVertexProgram.completedBarriers";
    private static final Set<MessageScope> MESSAGE_SCOPES = new HashSet<MessageScope.Global>(Collections.singletonList(MessageScope.Global.instance()));
    private Set<MemoryComputeKey> memoryComputeKeys = new HashSet<MemoryComputeKey>();
    private static final Set<VertexComputeKey> VERTEX_COMPUTE_KEYS = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of("gremlin.traversalVertexProgram.haltedTraversers", false), VertexComputeKey.of("gremlin.traversalVertexProgram.activeTraversers", true)));
    private PureTraversal<?, ?> traversal;
    private TraversalMatrix<?, ?> traversalMatrix;
    private final Set<MapReduce> mapReducers = new HashSet<MapReduce>();
    private TraverserSet<Object> haltedTraversers;
    private boolean returnHaltedTraversers = false;
    private HaltedTraverserStrategy haltedTraverserStrategy;
    private boolean profile = false;
    private MutableMetrics iterationMetrics;

    private TraversalVertexProgram() {
    }

    public PureTraversal<?, ?> getTraversal() {
        return this.traversal;
    }

    public static <R> TraverserSet<R> loadHaltedTraversers(Configuration configuration) {
        Object object;
        if (!configuration.containsKey(HALTED_TRAVERSERS)) {
            return new TraverserSet();
        }
        Object object2 = object = configuration.getProperty(HALTED_TRAVERSERS) instanceof String ? VertexProgramHelper.deserialize(configuration, HALTED_TRAVERSERS) : configuration.getProperty(HALTED_TRAVERSERS);
        if (object instanceof Traverser.Admin) {
            return new TraverserSet((Traverser.Admin)object);
        }
        TraverserSet traverserSet = new TraverserSet();
        traverserSet.addAll((Collection)object);
        return traverserSet;
    }

    public static <R> void storeHaltedTraversers(Configuration configuration, TraverserSet<R> haltedTraversers) {
        if (null != haltedTraversers && !haltedTraversers.isEmpty()) {
            try {
                VertexProgramHelper.serialize(haltedTraversers, configuration, HALTED_TRAVERSERS);
            }
            catch (Exception e) {
                configuration.setProperty(HALTED_TRAVERSERS, haltedTraversers);
            }
        }
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        if (!configuration.containsKey(TRAVERSAL)) {
            throw new IllegalArgumentException("The configuration does not have a traversal: gremlin.traversalVertexProgram.traversal");
        }
        this.traversal = PureTraversal.loadState(configuration, TRAVERSAL, graph);
        if (!this.traversal.get().isLocked()) {
            this.traversal.get().applyStrategies();
        }
        this.traversalMatrix = new TraversalMatrix(this.traversal.get());
        this.haltedTraversers = TraversalVertexProgram.loadHaltedTraversers(configuration);
        this.returnHaltedTraversers = this.traversal.get().getParent().asStep().getNextStep() instanceof ComputerResultStep || this.traversal.get().getParent().asStep().getNextStep() instanceof EmptyStep || this.traversal.get().getParent().asStep().getNextStep() instanceof ProfileStep && this.traversal.get().getParent().asStep().getNextStep().getNextStep() instanceof ComputerResultStep;
        this.haltedTraverserStrategy = (HaltedTraverserStrategy)this.traversal.get().getStrategies().toList().stream().filter(strategy -> strategy instanceof HaltedTraverserStrategy).findAny().orElse(HaltedTraverserStrategy.reference());
        this.memoryComputeKeys.addAll(MemoryTraversalSideEffects.getMemoryComputeKeys(this.traversal.get()));
        for (MapReducer mapReducer : TraversalHelper.getStepsOfAssignableClassRecursively(MapReducer.class, this.traversal.get())) {
            this.mapReducers.add(mapReducer.getMapReduce());
            this.memoryComputeKeys.add(MemoryComputeKey.of(mapReducer.getMapReduce().getMemoryKey(), Operator.assign, false, false));
        }
        for (MemoryComputing memoryComputing : TraversalHelper.getStepsOfAssignableClassRecursively(MemoryComputing.class, this.traversal.get())) {
            this.memoryComputeKeys.add(memoryComputing.getMemoryComputeKey());
        }
        for (ProfileStep profileStep : TraversalHelper.getStepsOfAssignableClassRecursively(ProfileStep.class, this.traversal.get())) {
            this.traversal.get().getSideEffects().register(profileStep.getId(), new MutableMetricsSupplier(profileStep.getPreviousStep()), ProfileStep.ProfileBiOperator.instance());
        }
        this.memoryComputeKeys.add(MemoryComputeKey.of(VOTE_TO_HALT, Operator.and, false, true));
        this.memoryComputeKeys.add(MemoryComputeKey.of(HALTED_TRAVERSERS, Operator.addAll, false, false));
        this.memoryComputeKeys.add(MemoryComputeKey.of(ACTIVE_TRAVERSERS, Operator.addAll, true, true));
        this.memoryComputeKeys.add(MemoryComputeKey.of(MUTATED_MEMORY_KEYS, Operator.addAll, false, true));
        this.memoryComputeKeys.add(MemoryComputeKey.of(COMPLETED_BARRIERS, Operator.addAll, true, true));
        this.profile = !TraversalHelper.getStepsOfAssignableClassRecursively(ProfileStep.class, this.traversal.get()).isEmpty();
    }

    @Override
    public void storeState(Configuration configuration) {
        VertexProgram.super.storeState(configuration);
        this.traversal.storeState(configuration, TRAVERSAL);
        TraversalVertexProgram.storeHaltedTraversers(configuration, this.haltedTraversers);
    }

    @Override
    public void setup(Memory memory) {
        MemoryTraversalSideEffects.setMemorySideEffects(this.traversal.get(), memory, ProgramPhase.SETUP);
        ((MemoryTraversalSideEffects)this.traversal.get().getSideEffects()).storeSideEffectsInMemory();
        memory.set(VOTE_TO_HALT, true);
        memory.set(MUTATED_MEMORY_KEYS, new HashSet());
        memory.set(COMPLETED_BARRIERS, new HashSet());
        if (!this.haltedTraversers.isEmpty()) {
            TraverserSet<Object> toProcessTraversers = new TraverserSet<Object>();
            IteratorUtils.removeOnNext(this.haltedTraversers.iterator()).forEachRemaining(traverser -> {
                traverser.setStepId(this.traversal.get().getStartStep().getId());
                toProcessTraversers.add((Traverser.Admin<Object>)traverser);
            });
            assert (this.haltedTraversers.isEmpty());
            IndexedTraverserSet.VertexIndexedTraverserSet remoteActiveTraversers = new IndexedTraverserSet.VertexIndexedTraverserSet();
            MasterExecutor.processTraversers(this.traversal, this.traversalMatrix, toProcessTraversers, remoteActiveTraversers, this.haltedTraversers, this.haltedTraverserStrategy);
            memory.set(HALTED_TRAVERSERS, this.haltedTraversers);
            memory.set(ACTIVE_TRAVERSERS, remoteActiveTraversers);
        } else {
            memory.set(HALTED_TRAVERSERS, new TraverserSet());
            memory.set(ACTIVE_TRAVERSERS, new IndexedTraverserSet.VertexIndexedTraverserSet());
        }
        this.haltedTraversers = null;
        this.profile = !TraversalHelper.getStepsOfAssignableClassRecursively(ProfileStep.class, this.traversal.get()).isEmpty();
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return MESSAGE_SCOPES;
    }

    @Override
    public void execute(Vertex vertex, Messenger<TraverserSet<Object>> messenger, Memory memory) {
        TraverserSet<Object> haltedTraversers;
        if (null != this.haltedTraversers) {
            this.haltedTraversers = null;
        }
        MemoryTraversalSideEffects.setMemorySideEffects(this.traversal.get(), memory, ProgramPhase.EXECUTE);
        Set completedBarriers = (Set)memory.get(COMPLETED_BARRIERS);
        for (String stepId : completedBarriers) {
            Object step = this.traversalMatrix.getStepById(stepId);
            if (!(step instanceof Barrier)) continue;
            ((Barrier)this.traversalMatrix.getStepById(stepId)).done();
        }
        Property property = vertex.property(HALTED_TRAVERSERS);
        if (property.isPresent()) {
            haltedTraversers = (TraverserSet<Object>)property.value();
        } else {
            haltedTraversers = new TraverserSet<Object>();
            vertex.property(VertexProperty.Cardinality.single, HALTED_TRAVERSERS, haltedTraversers, new Object[0]);
        }
        if (memory.isInitialIteration()) {
            TraverserSet activeTraversers = new TraverserSet();
            IteratorUtils.removeOnNext(haltedTraversers.iterator()).forEachRemaining(traverser -> {
                traverser.setStepId(this.traversal.get().getStartStep().getId());
                activeTraversers.add(traverser);
            });
            assert (haltedTraversers.isEmpty());
            if (this.traversal.get().getStartStep() instanceof GraphStep) {
                GraphStep graphStep = (GraphStep)this.traversal.get().getStartStep();
                graphStep.reset();
                activeTraversers.forEach(traverser -> graphStep.addStart(traverser));
                activeTraversers.clear();
                if (graphStep.returnsVertex()) {
                    graphStep.setIteratorSupplier(() -> ElementHelper.idExists(vertex.id(), graphStep.getIds()) ? IteratorUtils.of(vertex) : EmptyIterator.instance());
                } else {
                    graphStep.setIteratorSupplier(() -> IteratorUtils.filter(vertex.edges(Direction.OUT, new String[0]), edge -> ElementHelper.idExists(edge.id(), graphStep.getIds())));
                }
                graphStep.forEachRemaining(traverser -> {
                    if (traverser.isHalted()) {
                        if (this.returnHaltedTraversers) {
                            memory.add(HALTED_TRAVERSERS, new TraverserSet(this.haltedTraverserStrategy.halt(traverser)));
                        } else {
                            haltedTraversers.add(traverser.detach());
                        }
                    } else {
                        activeTraversers.add(traverser);
                    }
                });
            }
            memory.add(VOTE_TO_HALT, activeTraversers.isEmpty() || WorkerExecutor.execute(vertex, new SingleMessenger<TraverserSet<Object>>(messenger, activeTraversers), this.traversalMatrix, memory, this.returnHaltedTraversers, haltedTraversers, this.haltedTraverserStrategy));
        } else {
            memory.add(VOTE_TO_HALT, WorkerExecutor.execute(vertex, messenger, this.traversalMatrix, memory, this.returnHaltedTraversers, haltedTraversers, this.haltedTraverserStrategy));
        }
        if (this.returnHaltedTraversers || haltedTraversers.isEmpty()) {
            vertex.property(HALTED_TRAVERSERS).remove();
        }
    }

    @Override
    public boolean terminate(Memory memory) {
        block4: {
            TraverserSet haltedTraversers;
            block6: {
                IndexedTraverserSet.VertexIndexedTraverserSet remoteActiveTraversers;
                block5: {
                    MemoryTraversalSideEffects.setMemorySideEffects(this.traversal.get(), memory, ProgramPhase.TERMINATE);
                    boolean voteToHalt = (Boolean)memory.get(VOTE_TO_HALT);
                    memory.set(VOTE_TO_HALT, true);
                    memory.set(ACTIVE_TRAVERSERS, new IndexedTraverserSet.VertexIndexedTraverserSet());
                    if (!voteToHalt) break block4;
                    TraverserSet<Object> toProcessTraversers = new TraverserSet<Object>();
                    remoteActiveTraversers = new IndexedTraverserSet.VertexIndexedTraverserSet();
                    haltedTraversers = (TraverserSet)memory.get(HALTED_TRAVERSERS);
                    HashSet<String> completedBarriers = new HashSet<String>();
                    MasterExecutor.processMemory(this.traversalMatrix, memory, toProcessTraversers, completedBarriers);
                    MasterExecutor.processTraversers(this.traversal, this.traversalMatrix, toProcessTraversers, remoteActiveTraversers, haltedTraversers, this.haltedTraverserStrategy);
                    memory.set(COMPLETED_BARRIERS, completedBarriers);
                    if (!remoteActiveTraversers.isEmpty()) break block5;
                    if (!completedBarriers.stream().map(this.traversalMatrix::getStepById).filter(step -> step instanceof LocalBarrier).findAny().isPresent()) break block6;
                }
                memory.set(ACTIVE_TRAVERSERS, remoteActiveTraversers);
                return false;
            }
            Step<?, ?> endStep = this.traversal.get().getEndStep();
            while (endStep.hasNext()) {
                haltedTraversers.add(this.haltedTraverserStrategy.halt((Traverser.Admin)endStep.next()));
            }
            memory.set(HALTED_TRAVERSERS, haltedTraversers);
            for (ProfileSideEffectStep profileStep : TraversalHelper.getStepsOfAssignableClassRecursively(ProfileSideEffectStep.class, this.traversal.get())) {
                this.traversal.get().getSideEffects().set(profileStep.getSideEffectKey(), profileStep.generateFinalResult((DefaultTraversalMetrics)this.traversal.get().getSideEffects().get(profileStep.getSideEffectKey())));
            }
            return true;
        }
        return false;
    }

    @Override
    public void workerIterationStart(Memory memory) {
        if (this.profile) {
            this.iterationMetrics = new MutableMetrics("iteration" + memory.getIteration(), "Worker Iteration " + memory.getIteration());
            this.iterationMetrics.start();
        }
    }

    @Override
    public void workerIterationEnd(Memory memory) {
        if (this.profile) {
            List<ProfileStep> profileSteps = TraversalHelper.getStepsOfAssignableClassRecursively(ProfileStep.class, this.traversal.get());
            int profileStepIndex = memory.getIteration();
            profileStepIndex = profileStepIndex >= profileSteps.size() ? profileSteps.size() - 1 : profileStepIndex;
            this.iterationMetrics.finish(0L);
            this.iterationMetrics.setCount("traverserCount", 0L);
            if (null != MemoryTraversalSideEffects.getMemorySideEffectsPhase(this.traversal.get())) {
                this.traversal.get().getSideEffects().add(profileSteps.get(profileStepIndex).getId(), this.iterationMetrics);
            }
            this.iterationMetrics = null;
        }
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return VERTEX_COMPUTE_KEYS;
    }

    @Override
    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return this.memoryComputeKeys;
    }

    @Override
    public Set<MapReduce> getMapReducers() {
        return this.mapReducers;
    }

    @Override
    public Optional<MessageCombiner<TraverserSet<Object>>> getMessageCombiner() {
        return TraversalVertexProgramMessageCombiner.instance();
    }

    public TraversalVertexProgram clone() {
        try {
            TraversalVertexProgram clone = (TraversalVertexProgram)super.clone();
            clone.traversal = this.traversal.clone();
            if (!clone.traversal.get().isLocked()) {
                clone.traversal.get().applyStrategies();
            }
            clone.traversalMatrix = new TraversalMatrix(clone.traversal.get());
            clone.memoryComputeKeys = new HashSet<MemoryComputeKey>();
            for (MemoryComputeKey memoryComputeKey : this.memoryComputeKeys) {
                clone.memoryComputeKeys.add((MemoryComputeKey)memoryComputeKey.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.NOTHING;
    }

    public String toString() {
        String traversalString = this.traversal.get().toString().substring(1);
        return StringFactory.vertexProgramString(this, traversalString.substring(0, traversalString.length() - 1));
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresGlobalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(TraversalVertexProgram.class);
        }

        public Builder haltedTraversers(TraverserSet<Object> haltedTraversers) {
            TraversalVertexProgram.storeHaltedTraversers((Configuration)this.configuration, haltedTraversers);
            return this;
        }

        public Builder traversal(TraversalSource traversalSource, String scriptEngine, String traversalScript, Object ... bindings) {
            return this.traversal(new ScriptTraversal(traversalSource, scriptEngine, traversalScript, bindings));
        }

        public Builder traversal(Traversal.Admin<?, ?> traversal) {
            if (!(traversal.getParent() instanceof TraversalVertexProgramStep)) {
                MemoryTraversalSideEffects memoryTraversalSideEffects = new MemoryTraversalSideEffects(traversal.getSideEffects());
                DefaultTraversal parentTraversal = new DefaultTraversal();
                traversal.getGraph().ifPresent(parentTraversal::setGraph);
                TraversalStrategies strategies = traversal.getStrategies().clone();
                strategies.addStrategies(ComputerFinalizationStrategy.instance(), ComputerVerificationStrategy.instance(), new VertexProgramStrategy(Computer.compute()));
                parentTraversal.setStrategies(strategies);
                traversal.setStrategies(strategies);
                parentTraversal.setSideEffects(memoryTraversalSideEffects);
                parentTraversal.addStep(new TraversalVertexProgramStep(parentTraversal, traversal));
                traversal = ((TraversalVertexProgramStep)parentTraversal.getStartStep()).getGlobalChildren().get(0);
                traversal.setSideEffects(memoryTraversalSideEffects);
            }
            PureTraversal.storeState((Configuration)this.configuration, TraversalVertexProgram.TRAVERSAL, traversal);
            return this;
        }
    }
}

