/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankMessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.ScriptTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class PageRankVertexProgram
implements VertexProgram<Double> {
    public static final String PAGE_RANK = "gremlin.pageRankVertexProgram.pageRank";
    private static final String EDGE_COUNT = "gremlin.pageRankVertexProgram.edgeCount";
    private static final String PROPERTY = "gremlin.pageRankVertexProgram.property";
    private static final String VERTEX_COUNT = "gremlin.pageRankVertexProgram.vertexCount";
    private static final String ALPHA = "gremlin.pageRankVertexProgram.alpha";
    private static final String TOTAL_ITERATIONS = "gremlin.pageRankVertexProgram.totalIterations";
    private static final String EDGE_TRAVERSAL = "gremlin.pageRankVertexProgram.edgeTraversal";
    private static final String INITIAL_RANK_TRAVERSAL = "gremlin.pageRankVertexProgram.initialRankTraversal";
    private MessageScope.Local<Double> incidentMessageScope = MessageScope.Local.of(() -> __.outE(new String[0]));
    private MessageScope.Local<Double> countMessageScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.incidentMessageScope));
    private PureTraversal<Vertex, Edge> edgeTraversal = null;
    private PureTraversal<Vertex, ? extends Number> initialRankTraversal = null;
    private double vertexCountAsDouble = 1.0;
    private double alpha = 0.85;
    private int totalIterations = 30;
    private String property = "gremlin.pageRankVertexProgram.pageRank";
    private Set<VertexComputeKey> vertexComputeKeys;

    private PageRankVertexProgram() {
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        if (configuration.containsKey(INITIAL_RANK_TRAVERSAL)) {
            this.initialRankTraversal = PureTraversal.loadState(configuration, INITIAL_RANK_TRAVERSAL, graph);
        }
        if (configuration.containsKey(EDGE_TRAVERSAL)) {
            this.edgeTraversal = PureTraversal.loadState(configuration, EDGE_TRAVERSAL, graph);
            this.incidentMessageScope = MessageScope.Local.of(() -> this.edgeTraversal.get().clone());
            this.countMessageScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.incidentMessageScope));
        }
        this.vertexCountAsDouble = configuration.getDouble(VERTEX_COUNT, 1.0);
        this.alpha = configuration.getDouble(ALPHA, 0.85);
        this.totalIterations = configuration.getInt(TOTAL_ITERATIONS, 30);
        this.property = configuration.getString(PROPERTY, PAGE_RANK);
        this.vertexComputeKeys = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of(this.property, false), VertexComputeKey.of(EDGE_COUNT, true)));
    }

    @Override
    public void storeState(Configuration configuration) {
        VertexProgram.super.storeState(configuration);
        configuration.setProperty(VERTEX_COUNT, (Object)this.vertexCountAsDouble);
        configuration.setProperty(ALPHA, (Object)this.alpha);
        configuration.setProperty(TOTAL_ITERATIONS, (Object)this.totalIterations);
        configuration.setProperty(PROPERTY, (Object)this.property);
        if (null != this.edgeTraversal) {
            this.edgeTraversal.storeState(configuration, EDGE_TRAVERSAL);
        }
        if (null != this.initialRankTraversal) {
            this.initialRankTraversal.storeState(configuration, INITIAL_RANK_TRAVERSAL);
        }
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.NEW;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return this.vertexComputeKeys;
    }

    @Override
    public Optional<MessageCombiner<Double>> getMessageCombiner() {
        return PageRankMessageCombiner.instance();
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        HashSet<MessageScope> set = new HashSet<MessageScope>();
        set.add(memory.isInitialIteration() ? this.countMessageScope : this.incidentMessageScope);
        return set;
    }

    public PageRankVertexProgram clone() {
        try {
            PageRankVertexProgram clone = (PageRankVertexProgram)super.clone();
            if (null != this.initialRankTraversal) {
                clone.initialRankTraversal = this.initialRankTraversal.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setup(Memory memory) {
    }

    @Override
    public void execute(Vertex vertex, Messenger<Double> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            messenger.sendMessage(this.countMessageScope, 1.0);
        } else if (1 == memory.getIteration()) {
            double initialPageRank = (null == this.initialRankTraversal ? 1.0 : TraversalUtil.apply(vertex, this.initialRankTraversal.get()).doubleValue()) / this.vertexCountAsDouble;
            double edgeCount = IteratorUtils.reduce(messenger.receiveMessages(), Double.valueOf(0.0), (a, b) -> a + b);
            vertex.property(VertexProperty.Cardinality.single, this.property, initialPageRank, new Object[0]);
            vertex.property(VertexProperty.Cardinality.single, EDGE_COUNT, edgeCount, new Object[0]);
            if (!this.terminate(memory)) {
                messenger.sendMessage(this.incidentMessageScope, initialPageRank / edgeCount);
            }
        } else {
            double newPageRank = IteratorUtils.reduce(messenger.receiveMessages(), Double.valueOf(0.0), (a, b) -> a + b);
            newPageRank = this.alpha * newPageRank + (1.0 - this.alpha) / this.vertexCountAsDouble;
            vertex.property(VertexProperty.Cardinality.single, this.property, newPageRank, new Object[0]);
            if (!this.terminate(memory)) {
                messenger.sendMessage(this.incidentMessageScope, newPageRank / (Double)vertex.value(EDGE_COUNT));
            }
        }
    }

    @Override
    public boolean terminate(Memory memory) {
        return memory.getIteration() >= this.totalIterations;
    }

    public String toString() {
        return StringFactory.vertexProgramString(this, "alpha=" + this.alpha + ", iterations=" + this.totalIterations);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresLocalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(PageRankVertexProgram.class);
        }

        public Builder iterations(int iterations) {
            this.configuration.setProperty(PageRankVertexProgram.TOTAL_ITERATIONS, (Object)iterations);
            return this;
        }

        public Builder alpha(double alpha) {
            this.configuration.setProperty(PageRankVertexProgram.ALPHA, (Object)alpha);
            return this;
        }

        public Builder property(String key) {
            this.configuration.setProperty(PageRankVertexProgram.PROPERTY, (Object)key);
            return this;
        }

        public Builder edges(Traversal.Admin<Vertex, Edge> edgeTraversal) {
            PureTraversal.storeState((Configuration)this.configuration, PageRankVertexProgram.EDGE_TRAVERSAL, edgeTraversal);
            return this;
        }

        public Builder initialRank(Traversal.Admin<Vertex, ? extends Number> initialRankTraversal) {
            PureTraversal.storeState((Configuration)this.configuration, PageRankVertexProgram.INITIAL_RANK_TRAVERSAL, initialRankTraversal);
            return this;
        }

        @Deprecated
        public Builder vertexCount(long vertexCount) {
            this.configuration.setProperty(PageRankVertexProgram.VERTEX_COUNT, (Object)vertexCount);
            return this;
        }

        @Deprecated
        public Builder traversal(TraversalSource traversalSource, String scriptEngine, String traversalScript, Object ... bindings) {
            return this.edges(new ScriptTraversal<Vertex, Edge>(traversalSource, scriptEngine, traversalScript, bindings));
        }

        @Deprecated
        public Builder traversal(Traversal.Admin<Vertex, Edge> traversal) {
            return this.edges(traversal);
        }
    }
}

