/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class GraphFilter
implements Cloneable,
Serializable {
    private Traversal.Admin<Vertex, Vertex> vertexFilter = null;
    private Traversal.Admin<Vertex, Edge> edgeFilter = null;
    private Map<Direction, Map<String, Legal>> edgeLegality = new HashMap<Direction, Map<String, Legal>>();
    private boolean allowNoEdges = false;

    public GraphFilter() {
    }

    public GraphFilter(Computer computer) {
        if (null != computer.getVertices()) {
            this.setVertexFilter(computer.getVertices());
        }
        if (null != computer.getEdges()) {
            this.setEdgeFilter(computer.getEdges());
        }
    }

    public void setVertexFilter(Traversal<Vertex, Vertex> vertexFilter) {
        if (!TraversalHelper.isLocalProperties(vertexFilter.asAdmin())) {
            throw GraphComputer.Exceptions.vertexFilterAccessesIncidentEdges(vertexFilter);
        }
        this.vertexFilter = vertexFilter.asAdmin().clone();
    }

    public void setEdgeFilter(Traversal<Vertex, Edge> edgeFilter) {
        AbstractStep step;
        if (!TraversalHelper.isLocalStarGraph(edgeFilter.asAdmin())) {
            throw GraphComputer.Exceptions.edgeFilterAccessesAdjacentVertices(edgeFilter);
        }
        this.edgeFilter = edgeFilter.asAdmin().clone();
        this.edgeLegality = new HashMap<Direction, Map<String, Legal>>();
        this.edgeLegality.put(Direction.OUT, new HashMap());
        this.edgeLegality.put(Direction.IN, new HashMap());
        this.edgeLegality.put(Direction.BOTH, new HashMap());
        if (this.edgeFilter.getEndStep() instanceof RangeGlobalStep && 0L == ((RangeGlobalStep)this.edgeFilter.getEndStep()).getHighRange()) {
            this.allowNoEdges = true;
        }
        if (this.edgeFilter.getStartStep() instanceof VertexStep) {
            step = (VertexStep)this.edgeFilter.getStartStep();
            Map<String, Legal> map = this.edgeLegality.get((Object)((VertexStep)step).getDirection());
            if (((VertexStep)step).returnsEdge()) {
                if (((VertexStep)step).getEdgeLabels().length == 0) {
                    map.put(null, 1 == this.edgeFilter.getSteps().size() ? Legal.YES : Legal.MAYBE);
                } else {
                    for (String string : ((VertexStep)step).getEdgeLabels()) {
                        map.put(string, 1 == this.edgeFilter.getSteps().size() ? Legal.YES : Legal.MAYBE);
                    }
                }
            }
        } else if (this.edgeFilter.getStartStep() instanceof UnionStep) {
            step = (UnionStep)this.edgeFilter.getStartStep();
            for (Traversal.Admin admin : ((BranchStep)step).getGlobalChildren()) {
                if (!(admin.getStartStep() instanceof VertexStep)) continue;
                VertexStep vertexStep = (VertexStep)admin.getStartStep();
                Map<String, Legal> map = this.edgeLegality.get((Object)vertexStep.getDirection());
                if (!vertexStep.returnsEdge()) continue;
                if (vertexStep.getEdgeLabels().length == 0) {
                    map.put(null, 2 == admin.getSteps().size() ? Legal.YES : Legal.MAYBE);
                    continue;
                }
                for (String label : vertexStep.getEdgeLabels()) {
                    map.put(label, 2 == admin.getSteps().size() ? Legal.YES : Legal.MAYBE);
                }
            }
        }
        Map<String, Legal> outMap = this.edgeLegality.get((Object)Direction.OUT);
        Map<String, Legal> inMap = this.edgeLegality.get((Object)Direction.IN);
        Map<String, Legal> map = this.edgeLegality.get((Object)Direction.BOTH);
        for (Map.Entry<String, Legal> entry : map.entrySet()) {
            Legal legal = inMap.get(entry.getKey());
            if (null != legal && legal.compareTo((Enum)entry.getValue()) <= 0) continue;
            inMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Legal> entry : map.entrySet()) {
            Legal legal = outMap.get(entry.getKey());
            if (null != legal && legal.compareTo((Enum)entry.getValue()) <= 0) continue;
            outMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Legal> entry : outMap.entrySet()) {
            Legal legal = inMap.get(entry.getKey());
            if (null == legal) continue;
            map.put(entry.getKey(), legal.compareTo((Enum)entry.getValue()) > 0 ? legal : entry.getValue());
        }
        if (outMap.isEmpty() && inMap.isEmpty() && map.isEmpty()) {
            outMap.put(null, Legal.MAYBE);
            inMap.put(null, Legal.MAYBE);
            map.put(null, Legal.MAYBE);
        }
    }

    public boolean legalVertex(Vertex vertex) {
        return null == this.vertexFilter || TraversalUtil.test(vertex, this.vertexFilter);
    }

    public Iterator<Edge> legalEdges(Vertex vertex) {
        return null == this.edgeFilter ? vertex.edges(Direction.BOTH, new String[0]) : TraversalUtil.applyAll(vertex, this.edgeFilter);
    }

    public final Traversal.Admin<Vertex, Vertex> getVertexFilter() {
        return this.vertexFilter;
    }

    public final Traversal.Admin<Vertex, Edge> getEdgeFilter() {
        return this.edgeFilter;
    }

    public boolean hasFilter() {
        return this.vertexFilter != null || this.edgeFilter != null;
    }

    public boolean hasEdgeFilter() {
        return this.edgeFilter != null;
    }

    public boolean hasVertexFilter() {
        return this.vertexFilter != null;
    }

    public Set<String> getLegallyPositiveEdgeLabels(Direction direction) {
        if (null == this.edgeFilter) {
            return Collections.singleton(null);
        }
        if (this.allowNoEdges) {
            return Collections.emptySet();
        }
        return this.edgeLegality.get((Object)direction).containsKey(null) ? Collections.singleton(null) : this.edgeLegality.get((Object)direction).entrySet().stream().filter(entry -> ((Legal)((Object)((Object)entry.getValue()))).positive()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Legal checkEdgeLegality(Direction direction, String label) {
        if (null == this.edgeFilter) {
            return Legal.YES;
        }
        if (this.checkEdgeLegality(direction).negative()) {
            return Legal.NO;
        }
        Map<String, Legal> legalMap = this.edgeLegality.get((Object)direction);
        if (legalMap.containsKey(label)) {
            return legalMap.get(label);
        }
        if (legalMap.containsKey(null)) {
            return legalMap.get(null);
        }
        return Legal.NO;
    }

    public Legal checkEdgeLegality(Direction direction) {
        if (null == this.edgeFilter) {
            return Legal.YES;
        }
        if (this.allowNoEdges) {
            return Legal.NO;
        }
        return this.edgeLegality.get((Object)direction).values().stream().reduce(Legal.NO, (a, b) -> a.compareTo(b) < 0 ? a : b);
    }

    public int hashCode() {
        return (null == this.edgeFilter ? 111 : this.edgeFilter.hashCode()) ^ (null == this.vertexFilter ? 222 : this.vertexFilter.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof GraphFilter)) {
            return false;
        }
        if (((GraphFilter)object).hasVertexFilter() && !((GraphFilter)object).getVertexFilter().equals(this.vertexFilter)) {
            return false;
        }
        return !((GraphFilter)object).hasEdgeFilter() || ((GraphFilter)object).getEdgeFilter().equals(this.edgeFilter);
    }

    public GraphFilter clone() {
        try {
            GraphFilter clone = (GraphFilter)super.clone();
            if (null != this.vertexFilter) {
                clone.vertexFilter = this.vertexFilter.clone();
            }
            if (null != this.edgeFilter) {
                clone.edgeFilter = this.edgeFilter.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        if (!this.hasFilter()) {
            return "graphfilter[none]";
        }
        if (this.hasVertexFilter() && this.hasEdgeFilter()) {
            return "graphfilter[" + this.vertexFilter + "," + this.edgeFilter + "]";
        }
        if (this.hasVertexFilter()) {
            return "graphfilter[" + this.vertexFilter + "]";
        }
        return "graphfilter[" + this.edgeFilter + "]";
    }

    public static enum Legal {
        YES,
        MAYBE,
        NO;


        public boolean positive() {
            return this != NO;
        }

        public boolean negative() {
            return this == NO;
        }
    }
}

