/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.callgraph;

import groovyx.gprof.CallInfo;
import groovyx.gprof.CallTree;
import groovyx.gprof.MethodCallInfo;
import groovyx.gprof.MethodInfo;
import groovyx.gprof.ReportNormalizer;
import groovyx.gprof.ThreadRunInfo;
import groovyx.gprof.callgraph.CallGraphReportElement;
import groovyx.gprof.callgraph.CallGraphReportMethodElement;
import groovyx.gprof.callgraph.CallGraphReportSpontaneousElement;
import groovyx.gprof.callgraph.CallGraphReportThreadElement;
import groovyx.gprof.callgraph.CallGraphReportWholeCycleElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphReportNormalizer
implements ReportNormalizer {
    private boolean separateThread = false;

    public void setSeparateThread(boolean separateThread) {
        this.separateThread = separateThread;
    }

    private void sortAndReindexMethodElements(List<CallGraphReportMethodElement> methodElements, Comparator comparator) {
        if (methodElements.isEmpty()) {
            return;
        }
        long fi = methodElements.get(0).getIndex();
        Collections.sort(methodElements, comparator);
        HashMap<Long, Long> indexMapper = new HashMap<Long, Long>();
        indexMapper.put(0L, 0L);
        int n = methodElements.size();
        for (int i = 0; i < n; ++i) {
            CallGraphReportMethodElement e = methodElements.get(i);
            long newIndex = (long)i + fi;
            long oldIndex = e.getIndex();
            e.setIndex(newIndex);
            indexMapper.put(oldIndex, newIndex);
        }
        for (CallGraphReportMethodElement e : methodElements) {
            ArrayList<CallGraphReportMethodElement.Parent> parents = new ArrayList<CallGraphReportMethodElement.Parent>(e.getParents().values());
            e.getParents().clear();
            for (CallGraphReportMethodElement.Parent p : parents) {
                p.setIndex((Long)indexMapper.get(p.getIndex()));
                e.addParent(p);
            }
            ArrayList<CallGraphReportMethodElement.Child> children = new ArrayList<CallGraphReportMethodElement.Child>(e.getChildren().values());
            e.getChildren().clear();
            for (CallGraphReportMethodElement.Child c : children) {
                c.setIndex((Long)indexMapper.get(c.getIndex()));
                e.addChild(c);
            }
        }
    }

    private void setTimePercent(List<CallGraphReportThreadElement> tes) {
        for (CallGraphReportThreadElement te : tes) {
            long totalTime = 0L;
            for (CallGraphReportMethodElement subElement : te.getSubElements()) {
                if (subElement instanceof CallGraphReportWholeCycleElement || subElement instanceof CallGraphReportSpontaneousElement) continue;
                totalTime += subElement.getSelfTime();
            }
            for (CallGraphReportMethodElement subElement : te.getSubElements()) {
                subElement.setTimePercent((float)subElement.getTime() / (float)totalTime * 100.0f);
            }
        }
    }

    private void removeSpontaneous(List<CallGraphReportThreadElement> tes) {
        for (CallGraphReportThreadElement te : tes) {
            te.removeSubElement(0L);
        }
    }

    private void sortAndReindex(List<? extends CallGraphReportElement> elements) {
        Comparator<CallGraphReportMethodElement> comparator = new Comparator<CallGraphReportMethodElement>(){

            @Override
            public int compare(CallGraphReportMethodElement e1, CallGraphReportMethodElement e2) {
                return -Long.compare(e1.getTime(), e2.getTime());
            }
        };
        CallGraphReportElement first = elements.get(0);
        if (first instanceof CallGraphReportMethodElement) {
            this.sortAndReindexMethodElements(elements, comparator);
        } else {
            for (CallGraphReportThreadElement callGraphReportThreadElement : elements) {
                ArrayList<CallGraphReportMethodElement> mes = new ArrayList<CallGraphReportMethodElement>(callGraphReportThreadElement.getSubElements());
                this.sortAndReindexMethodElements(mes, comparator);
                callGraphReportThreadElement.getSubElements().clear();
                for (CallGraphReportMethodElement me : mes) {
                    callGraphReportThreadElement.addSubElement(me);
                }
            }
        }
    }

    public List<CallGraphReportThreadElement> normalize(CallTree callTree) {
        final ArrayList<CallGraphReportThreadElement> elements = new ArrayList<CallGraphReportThreadElement>();
        callTree.visit(new CallTree.NodeVisitor(){
            Map<MethodInfo, Long> indexTable = new HashMap<MethodInfo, Long>();
            Map<Long, CallGraphReportWholeCycleElement> cycleTable = new HashMap<Long, CallGraphReportWholeCycleElement>();
            Stack<Long> parentStack = new Stack();
            long lastIndex = 0L;
            long lastCycleIndex = 0L;
            CallGraphReportThreadElement element;
            CallGraphReportSpontaneousElement spontaneous;

            long searchCycleParent(long index, long parentIndex) {
                CallGraphReportMethodElement parentElement = this.element.getSubElement(parentIndex);
                if (parentElement != null && parentElement.getCycleIndex() > 0L) {
                    int n = this.parentStack.size() - 1;
                    for (int i = 0; i < n; ++i) {
                        CallGraphReportMethodElement nextParentElement = this.element.getSubElement((Long)this.parentStack.get(i + 1));
                        if (nextParentElement.getCycleIndex() != parentElement.getCycleIndex()) continue;
                        return i;
                    }
                }
                return parentIndex;
            }

            public void visit(CallTree.Node node) {
                CallInfo call = node.getData();
                if (call instanceof ThreadRunInfo) {
                    ThreadRunInfo threadRun = (ThreadRunInfo)call;
                    if (CallGraphReportNormalizer.this.separateThread || this.element == null) {
                        this.indexTable.clear();
                        this.cycleTable.clear();
                        this.lastIndex = 0L;
                        this.lastCycleIndex = 0L;
                        this.element = new CallGraphReportThreadElement(threadRun.getThread());
                        this.spontaneous = new CallGraphReportSpontaneousElement();
                        this.element.addSubElement(this.spontaneous);
                        elements.add(this.element);
                    }
                    this.handleSubElement(node, 0L, false, this.spontaneous, new CallGraphReportMethodElement.Parent(-1L));
                    for (CallTree.Node child : node.getChildren()) {
                        if (!(child.getData() instanceof MethodCallInfo)) continue;
                        MethodCallInfo childMethodCall = (MethodCallInfo)child.getData();
                        long index = this.indexTable.containsKey(childMethodCall.getMethod()) ? this.indexTable.get(childMethodCall.getMethod()) : ++this.lastIndex;
                        this.indexTable.put(childMethodCall.getMethod(), index);
                    }
                    this.parentStack.push(0L);
                } else if (call instanceof MethodCallInfo) {
                    CallGraphReportMethodElement.Parent parent;
                    CallGraphReportMethodElement subElement;
                    long parentIndex;
                    boolean recursive;
                    MethodCallInfo methodCall = (MethodCallInfo)call;
                    long index = this.indexTable.get(methodCall.getMethod());
                    boolean bl = recursive = index == (parentIndex = this.parentStack.peek().longValue());
                    if (recursive && this.parentStack.size() > 1) {
                        for (int i = this.parentStack.size() - 1; i >= 0 && parentIndex == index; --i) {
                            parentIndex = (Long)this.parentStack.get(i);
                        }
                    } else if (this.parentStack.size() > 2) {
                        ArrayList<Long> inCycleIndices = new ArrayList<Long>();
                        inCycleIndices.add(index);
                        inCycleIndices.add(parentIndex);
                        for (int i = this.parentStack.size() - 2; i > 0; --i) {
                            long cycleIndex;
                            long pi = (Long)this.parentStack.get(i);
                            inCycleIndices.add(pi);
                            if (pi != index) continue;
                            CallGraphReportMethodElement cycleEntryElement = this.element.getSubElement(pi);
                            boolean newCycle = cycleEntryElement.getCycleIndex() == 0L;
                            long l = cycleIndex = newCycle ? (this.lastCycleIndex = this.lastCycleIndex + 1L) : cycleEntryElement.getCycleIndex();
                            if (newCycle) {
                                CallGraphReportWholeCycleElement cycleElement = new CallGraphReportWholeCycleElement(++this.lastIndex, cycleIndex);
                                this.cycleTable.put(cycleIndex, cycleElement);
                                this.element.addSubElement(cycleElement);
                            }
                            for (int j = inCycleIndices.size() - 1; j > 0; --j) {
                                CallGraphReportMethodElement inCycleElement = this.element.getSubElement((Long)inCycleIndices.get(j));
                                inCycleElement.setCycleIndex(cycleIndex);
                            }
                            break;
                        }
                    }
                    if ((subElement = this.element.getSubElement(index)) == null) {
                        subElement = new CallGraphReportMethodElement(index, methodCall.getMethod());
                        this.element.addSubElement(subElement);
                    }
                    if ((parent = subElement.getParents().get(parentIndex)) == null) {
                        parent = new CallGraphReportMethodElement.Parent(parentIndex);
                        subElement.addParent(parent);
                    }
                    this.handleSubElement(node, index, recursive, subElement, parent);
                    this.parentStack.push(index);
                }
            }

            private void handleSubElement(CallTree.Node node, long index, boolean recursive, CallGraphReportMethodElement subElement, CallGraphReportMethodElement.Parent parent) {
                CallInfo call = node.getData();
                subElement.setCalls(subElement.getCalls() + 1L);
                parent.setCalls(parent.getCalls() + 1L);
                if (subElement.getCycleIndex() > 0L) {
                    subElement.setCycleCalls(subElement.getCycleCalls() + 1L);
                }
                if (!recursive) {
                    subElement.setTime(subElement.getTime() + call.getTime());
                    parent.setTime(parent.getTime() + call.getTime());
                }
                for (CallTree.Node child : node.getChildren()) {
                    long childIndex;
                    if (!(child.getData() instanceof MethodCallInfo)) continue;
                    MethodCallInfo childMethodCall = (MethodCallInfo)child.getData();
                    if (childMethodCall.getMethod().equals(subElement.getMethod())) {
                        subElement.setRecursiveCalls(subElement.getRecursiveCalls() + 1L);
                        parent.setRecursiveCalls(parent.getRecursiveCalls() + 1L);
                        this.indexTable.put(childMethodCall.getMethod(), index);
                        continue;
                    }
                    if (this.indexTable.containsKey(childMethodCall.getMethod())) {
                        childIndex = this.indexTable.get(childMethodCall.getMethod());
                    } else {
                        childIndex = ++this.lastIndex;
                        this.indexTable.put(childMethodCall.getMethod(), childIndex);
                    }
                    if (!subElement.getChildren().containsKey(childIndex)) {
                        subElement.addChild(new CallGraphReportMethodElement.Child(childIndex));
                    }
                    subElement.setChildrenTime(subElement.getChildrenTime() + childMethodCall.getTime());
                    parent.setChildrenTime(parent.getChildrenTime() + childMethodCall.getTime());
                }
            }

            public void exit(CallTree.Node node) {
                if (!(node.getData() instanceof ThreadRunInfo) && node.getData() instanceof MethodCallInfo) {
                    CallGraphReportMethodElement subElement;
                    long parentIndex;
                    boolean recursiveCall;
                    MethodCallInfo methodCall = (MethodCallInfo)node.getData();
                    long index = this.indexTable.get(methodCall.getMethod());
                    boolean bl = recursiveCall = index == (parentIndex = ((Long)this.parentStack.get(this.parentStack.size() - 2)).longValue());
                    if (recursiveCall) {
                        for (int i = this.parentStack.size() - 1; i >= 0 && parentIndex == index; --i) {
                            parentIndex = (Long)this.parentStack.get(i);
                        }
                    }
                    if ((subElement = this.element.getSubElement(index)).getCycleIndex() > 0L) {
                        CallGraphReportMethodElement.Parent parent = subElement.getParents().get(parentIndex);
                        CallGraphReportMethodElement parentElement = this.element.getSubElement(parentIndex);
                        for (CallTree.Node childNode : node.getChildren()) {
                            CallGraphReportMethodElement childElement;
                            MethodCallInfo childMethodCall = (MethodCallInfo)childNode.getData();
                            long childIndex = this.indexTable.get(childMethodCall.getMethod());
                            boolean recursiveChildCall = childIndex == index;
                            if (recursiveChildCall || (childElement = this.element.getSubElement(childIndex)).getCycleIndex() != subElement.getCycleIndex()) continue;
                            if (parentElement != null && parentElement.getCycleIndex() == subElement.getCycleIndex()) {
                                parent.setTime(parent.getTime() - childMethodCall.getTime());
                                parent.setChildrenTime(parent.getChildrenTime() - childMethodCall.getTime());
                            }
                            subElement.setTime(subElement.getTime() - childMethodCall.getTime());
                            subElement.setChildrenTime(subElement.getChildrenTime() - childMethodCall.getTime());
                        }
                        long cycleParentIndex = this.searchCycleParent(index, parentIndex);
                        CallGraphReportWholeCycleElement cycleElement = this.cycleTable.get(subElement.getCycleIndex());
                        cycleElement.setCalls(cycleElement.getCalls() + 1L);
                        if (parentIndex != cycleParentIndex) {
                            cycleElement.setRecursiveCalls(cycleElement.getRecursiveCalls() + 1L);
                        } else {
                            cycleElement.setTime(parent.getTime());
                            cycleElement.setChildrenTime(parent.getChildrenTime());
                            cycleElement.addChild(new CallGraphReportMethodElement.Child(subElement.getIndex()));
                        }
                        if (parentIndex != cycleParentIndex) {
                            CallGraphReportMethodElement cycleParentElement = this.element.getSubElement(cycleParentIndex);
                            CallGraphReportMethodElement cycleEntryElement = null;
                            for (CallGraphReportMethodElement.Child child : cycleParentElement.getChildren().values()) {
                                CallGraphReportMethodElement childElement = this.element.getSubElement(child.getIndex());
                                if (childElement.getCycleIndex() != subElement.getCycleIndex()) continue;
                                cycleEntryElement = childElement;
                            }
                            CallGraphReportMethodElement.Parent cycleParent = cycleEntryElement.getParents().get(cycleParentIndex);
                            long childrenTime = 0L;
                            for (CallTree.Node childNode : node.getChildren()) {
                                MethodCallInfo childCall = (MethodCallInfo)childNode.getData();
                                if (childCall.getMethod().equals(methodCall.getMethod())) continue;
                                childrenTime += childCall.getTime();
                            }
                            long selfTime = methodCall.getTime() - childrenTime;
                            cycleParent.setChildrenTime(cycleParent.getChildrenTime() - selfTime);
                        }
                    }
                }
                this.parentStack.pop();
            }
        });
        this.removeSpontaneous(elements);
        this.setTimePercent(elements);
        this.sortAndReindex(elements);
        return elements;
    }
}

