/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof.callgraph;

import groovyx.gprof.MethodInfo;
import groovyx.gprof.callgraph.CallGraphReportElement;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphReportMethodElement
implements CallGraphReportElement {
    private long index;
    private long cycleIndex;
    private MethodInfo method;
    private float timePercent;
    private long time;
    private long childrenTime;
    private long calls;
    private long recursiveCalls;
    private long cycleCalls;
    private SortedMap<Long, Parent> parents = new TreeMap<Long, Parent>();
    private SortedMap<Long, Child> children = new TreeMap<Long, Child>();

    public CallGraphReportMethodElement(long index, MethodInfo method) {
        this.index = index;
        this.method = method;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public long getIndex() {
        return this.index;
    }

    public long getCycleIndex() {
        return this.cycleIndex;
    }

    public void setCycleIndex(long cycleIndex) {
        this.cycleIndex = cycleIndex;
    }

    public long getCycleCalls() {
        return this.cycleCalls;
    }

    public void setCycleCalls(long cycleCalls) {
        this.cycleCalls = cycleCalls;
    }

    public void setTimePercent(float timePercent) {
        this.timePercent = timePercent;
    }

    public float getTimePercent() {
        return this.timePercent;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public void addParent(Parent parent) {
        this.parents.put(parent.getIndex(), parent);
    }

    public Map<Long, Parent> getParents() {
        return this.parents;
    }

    public void addChild(Child child) {
        this.children.put(child.getIndex(), child);
    }

    public Map<Long, Child> getChildren() {
        return this.children;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getSelfTime() {
        return this.time - this.childrenTime;
    }

    public long getChildrenTime() {
        return this.childrenTime;
    }

    public void setChildrenTime(long childrenTime) {
        this.childrenTime = childrenTime;
    }

    public long getCalls() {
        return this.calls;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    public void setRecursiveCalls(long recursiveCalls) {
        this.recursiveCalls = recursiveCalls;
    }

    public long getRecursiveCalls() {
        return this.recursiveCalls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallGraphReportMethodElement that = (CallGraphReportMethodElement)o;
        if (this.calls != that.calls) {
            return false;
        }
        if (this.childrenTime != that.childrenTime) {
            return false;
        }
        if (this.cycleCalls != that.cycleCalls) {
            return false;
        }
        if (this.cycleIndex != that.cycleIndex) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.recursiveCalls != that.recursiveCalls) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (Float.compare(that.timePercent, this.timePercent) != 0) {
            return false;
        }
        if (this.children != null ? !this.children.equals(that.children) : that.children != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        return !(this.parents != null ? !this.parents.equals(that.parents) : that.parents != null);
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.cycleIndex ^ this.cycleIndex >>> 32);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.timePercent != 0.0f ? Float.floatToIntBits(this.timePercent) : 0);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.childrenTime ^ this.childrenTime >>> 32);
        result = 31 * result + (int)(this.calls ^ this.calls >>> 32);
        result = 31 * result + (int)(this.recursiveCalls ^ this.recursiveCalls >>> 32);
        result = 31 * result + (int)(this.cycleCalls ^ this.cycleCalls >>> 32);
        result = 31 * result + (this.parents != null ? this.parents.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CallGraphReportMethodElement{index=" + this.index + ", method=" + this.method + ", timePercent=" + this.timePercent + ", time=" + this.time + ", childrenTime=" + this.childrenTime + ", calls=" + this.calls + ", recursiveCalls=" + this.recursiveCalls + ", cycleCalls=" + this.cycleCalls + ", parents=" + this.parents + ", children=" + this.children + '}';
    }

    public static class Child {
        private long index;

        public Child(long index) {
            this.index = index;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Child child = (Child)o;
            return this.index == child.index;
        }

        public int hashCode() {
            return (int)(this.index ^ this.index >>> 32);
        }

        public String toString() {
            return "Child{index=" + this.index + '}';
        }
    }

    public static class Parent {
        private long index;
        private long time;
        private long childrenTime;
        private long calls;
        private long recursiveCalls;
        private long cycleCalls;

        public Parent(long index) {
            this.index = index;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getSelfTime() {
            return this.time - this.childrenTime;
        }

        public long getChildrenTime() {
            return this.childrenTime;
        }

        public void setChildrenTime(long childrenTime) {
            this.childrenTime = childrenTime;
        }

        public long getCalls() {
            return this.calls;
        }

        public void setCalls(long calls) {
            this.calls = calls;
        }

        public long getRecursiveCalls() {
            return this.recursiveCalls;
        }

        public void setRecursiveCalls(long recursiveCalls) {
            this.recursiveCalls = recursiveCalls;
        }

        public long getCycleCalls() {
            return this.cycleCalls;
        }

        public void setCycleCalls(long cycleCalls) {
            this.cycleCalls = cycleCalls;
        }

        public void setIndex(long index) {
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parent parent = (Parent)o;
            if (this.calls != parent.calls) {
                return false;
            }
            if (this.childrenTime != parent.childrenTime) {
                return false;
            }
            if (this.cycleCalls != parent.cycleCalls) {
                return false;
            }
            if (this.index != parent.index) {
                return false;
            }
            if (this.recursiveCalls != parent.recursiveCalls) {
                return false;
            }
            return this.time == parent.time;
        }

        public int hashCode() {
            int result = (int)(this.index ^ this.index >>> 32);
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (int)(this.childrenTime ^ this.childrenTime >>> 32);
            result = 31 * result + (int)(this.calls ^ this.calls >>> 32);
            result = 31 * result + (int)(this.recursiveCalls ^ this.recursiveCalls >>> 32);
            result = 31 * result + (int)(this.cycleCalls ^ this.cycleCalls >>> 32);
            return result;
        }

        public String toString() {
            return "Parent{index=" + this.index + ", time=" + this.time + ", childrenTime=" + this.childrenTime + ", calls=" + this.calls + ", recursiveCalls=" + this.recursiveCalls + ", cycleCalls=" + this.cycleCalls + '}';
        }
    }
}

