/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.Reference;
import groovyx.gprof.CallInterceptor;
import groovyx.gprof.MethodCallFilter;
import groovyx.gprof.ProfileMetaClass;
import groovyx.gprof.ProxyReport;
import groovyx.gprof.Report;
import groovyx.gprof.ThreadRunFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler
extends MetaClassRegistry.MetaClassCreationHandle {
    private static Map defaultOptions = new HashMap();
    private MetaClassRegistry.MetaClassCreationHandle originalMetaClassCreationHandle;
    private CallInterceptor interceptor;

    public Report run(Closure profiled) {
        return this.run(Collections.<String, Object>emptyMap(), profiled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report run(Map<String, Object> options, Closure profiled) {
        try {
            ArrayList<Reference> refs = new ArrayList<Reference>();
            try {
                for (Field field : profiled.getClass().getDeclaredFields()) {
                    if (!field.getType().equals(Reference.class)) continue;
                    field.setAccessible(true);
                    Reference ref = (Reference)field.get(profiled);
                    refs.add(ref);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            refs.add(new Reference((Object)profiled));
            refs.add(new Reference(profiled.getDelegate()));
            HashMap<String, Object> _options = new HashMap<String, Object>(options);
            _options.put("references", refs);
            options = null;
            this.start(_options);
            try {
                profiled.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.stop();
            Report report = this.getReport();
            return report;
        }
        finally {
            this.reset();
        }
    }

    public void start() {
        this.start(Collections.<String, Object>emptyMap());
    }

    public void start(Map<String, Object> options) {
        MethodCallFilter methodFilter = new MethodCallFilter();
        ThreadRunFilter threadFilter = new ThreadRunFilter();
        HashMap<String, Object> opts = new HashMap<String, Object>(defaultOptions);
        opts.putAll(options);
        methodFilter.addIncludes((List)opts.get("includeMethods"));
        methodFilter.addExcludes((List)opts.get("excludeMethods"));
        threadFilter.addIncludes((List)opts.get("includeThreads"));
        threadFilter.addExcludes((List)opts.get("excludeThreads"));
        if (this.interceptor == null) {
            this.interceptor = new CallInterceptor(methodFilter, threadFilter);
        }
        this.proxyMetaClasses();
        List refs = (List)opts.get("references");
        if (refs != null) {
            this.proxyPerInstanceMetaClasses(refs);
        }
    }

    private void proxyPerInstanceMetaClasses(List<Reference> refs) {
        for (Reference ref : refs) {
            Object obj = ref.get();
            if (obj == null) continue;
            Class<?> theClass = obj.getClass();
            if (obj instanceof GroovyObject) {
                GroovyObject gobj = (GroovyObject)obj;
                MetaClass metaClass = gobj.getMetaClass();
                MetaClass proxyMetaClass = this.proxyMetaClass(theClass, metaClass);
                DefaultGroovyMethods.setMetaClass((GroovyObject)gobj, (MetaClass)proxyMetaClass);
                continue;
            }
            MetaClass metaClass = DefaultGroovyMethods.getMetaClass((Object)obj);
            MetaClass proxyMetaClass = this.proxyMetaClass(theClass, metaClass);
            MetaClassHelper.doSetMetaClass((Object)obj, (MetaClass)proxyMetaClass);
        }
    }

    private void proxyMetaClasses() {
        Set<Class> allClasses = this.getLoadedClasses();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        HashMap<Class, MetaClass> originalMetaClasses = new HashMap<Class, MetaClass>();
        for (Class clazz : allClasses) {
            MetaClass originalMetaClass = registry.getMetaClass(clazz);
            originalMetaClasses.put(clazz, originalMetaClass);
        }
        this.originalMetaClassCreationHandle = registry.getMetaClassCreationHandler();
        registry.setMetaClassCreationHandle((MetaClassRegistry.MetaClassCreationHandle)this);
        for (Map.Entry entry : originalMetaClasses.entrySet()) {
            Class theClass = (Class)entry.getKey();
            MetaClass metaClass = (MetaClass)entry.getValue();
            MetaClass proxyMetaClass = this.proxyMetaClass(theClass, metaClass);
            registry.setMetaClass(theClass, proxyMetaClass);
        }
    }

    private Set<Class> getLoadedClasses() {
        HashSet<Class> allClasses = new HashSet<Class>();
        try {
            Field classSetField = ClassInfo.class.getDeclaredField("globalClassSet");
            classSetField.setAccessible(true);
            Object classSet = classSetField.get(ClassInfo.class);
            Method valuesMethod = classSet.getClass().getDeclaredMethod("values", new Class[0]);
            valuesMethod.setAccessible(true);
            for (ClassInfo classInfo : (Collection)valuesMethod.invoke(classSet, new Object[0])) {
                allClasses.add(classInfo.getMetaClass().getTheClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allClasses;
    }

    public void stop() {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        HashSet<ProfileMetaClass> proxyMetaClasses = new HashSet<ProfileMetaClass>();
        for (ClassInfo classInfo : ClassInfo.getAllClassInfo()) {
            MetaClass metaClass = classInfo.getMetaClass();
            if (!(metaClass instanceof ProfileMetaClass)) continue;
            proxyMetaClasses.add((ProfileMetaClass)metaClass);
        }
        registry.setMetaClassCreationHandle(this.originalMetaClassCreationHandle);
        for (ProfileMetaClass proxyMetaClass : proxyMetaClasses) {
            registry.setMetaClass(proxyMetaClass.getTheClass(), proxyMetaClass.getAdaptee());
        }
    }

    public void reset() {
        this.interceptor = null;
    }

    public Report getReport() {
        return new ProxyReport(this.interceptor.getTree());
    }

    private MetaClass proxyMetaClass(Class theClass, MetaClass metaClass) {
        if (MetaClass.class.isAssignableFrom(theClass)) {
            return metaClass;
        }
        ProfileMetaClass proxyMetaClass = new ProfileMetaClass(theClass, metaClass);
        proxyMetaClass.setInterceptor(this.interceptor);
        return proxyMetaClass;
    }

    protected MetaClass createNormalMetaClass(Class theClass, MetaClassRegistry registry) {
        if (theClass == ProfileMetaClass.class) {
            return super.createNormalMetaClass(theClass, registry);
        }
        MetaClassImpl metaClass = new MetaClassImpl(registry, theClass);
        return this.proxyMetaClass(theClass, (MetaClass)metaClass);
    }

    static {
        defaultOptions.put("includeMethods", Collections.emptyList());
        defaultOptions.put("excludeMethods", Arrays.asList(Profiler.class.getName() + ".stop"));
        defaultOptions.put("includeThreads", Collections.emptyList());
        defaultOptions.put("excludeThreads", Collections.emptyList());
    }
}

