/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof;

import groovy.lang.Closure;
import groovy.lang.ClosureInvokingMethod;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovyx.gprof.AdaptingExpandoMetaClass;
import groovyx.gprof.CallInterceptor;
import groovyx.gprof.MethodCallInfo;

public class ProfileMetaClass
extends AdaptingExpandoMetaClass {
    protected CallInterceptor interceptor = null;

    public ProfileMetaClass(Class theClass, MetaClass metaClass) {
        super(metaClass, theClass);
        super.initialize();
    }

    public void setInterceptor(CallInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    private long time() {
        return System.nanoTime();
    }

    private long elapsedTime(long from) {
        return this.time() - from;
    }

    public MetaMethod pickMethod(String methodName, Class[] arguments) {
        Closure closure;
        MetaMethod metaMethod = super.pickMethod(methodName, arguments);
        if (metaMethod instanceof ClosureInvokingMethod && !((closure = ((ClosureInvokingMethod)metaMethod).getClosure()).getMetaClass() instanceof ProfileMetaClass)) {
            ProfileMetaClass proxyMetaClass = new ProfileMetaClass(closure.getClass(), closure.getMetaClass());
            proxyMetaClass.setInterceptor(this.interceptor);
            closure.setMetaClass((MetaClass)proxyMetaClass);
        }
        return metaMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(Object object, String methodName, Object[] arguments) {
        long interceptStartTime = this.time();
        MethodCallInfo methodCall = new MethodCallInfo(object.getClass().getName(), methodName);
        this.interceptor.beforeInvoke(methodCall);
        long executeStartTime = this.time();
        try {
            Object object2 = super.invokeMethod(object, methodName, arguments);
            return object2;
        }
        finally {
            long executeTime = this.elapsedTime(executeStartTime);
            methodCall.setTime(executeTime);
            this.interceptor.afterInvoke(methodCall);
            long interceptTime = this.elapsedTime(interceptStartTime);
            methodCall.setOverheadTime(interceptTime - executeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        long interceptStartTime = this.time();
        MethodCallInfo methodCall = new MethodCallInfo(this.theClass.getName(), methodName);
        this.interceptor.beforeInvoke(methodCall);
        long executeStartTime = this.time();
        try {
            Object object2 = super.invokeStaticMethod(object, methodName, arguments);
            return object2;
        }
        finally {
            long executeTime = this.elapsedTime(executeStartTime);
            methodCall.setTime(executeTime);
            this.interceptor.afterInvoke(methodCall);
            long interceptTime = this.elapsedTime(interceptStartTime);
            methodCall.setOverheadTime(interceptTime - executeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeConstructor(Object[] arguments) {
        long interceptStartTime = this.time();
        MethodCallInfo methodCall = new MethodCallInfo(this.theClass.getName(), "ctor");
        this.interceptor.beforeInvoke(methodCall);
        long executeStartTime = this.time();
        try {
            Object object = super.invokeConstructor(arguments);
            return object;
        }
        finally {
            long executeTime = this.elapsedTime(executeStartTime);
            methodCall.setTime(executeTime);
            this.interceptor.afterInvoke(methodCall);
            long interceptTime = this.elapsedTime(interceptStartTime);
            methodCall.setOverheadTime(interceptTime - executeTime);
        }
    }
}

