/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gprof;

import groovyx.gprof.CallInfo;
import groovyx.gprof.CallTree;
import groovyx.gprof.MethodCallFilter;
import groovyx.gprof.MethodCallInfo;
import groovyx.gprof.ThreadRunFilter;
import groovyx.gprof.ThreadRunInfo;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CallInterceptor {
    private ConcurrentMap<Thread, LocalInterceptor> interceptors = new ConcurrentHashMap<Thread, LocalInterceptor>();
    private MethodCallFilter methodFilter;
    private ThreadRunFilter threadFilter;

    public CallInterceptor(MethodCallFilter methodFilter, ThreadRunFilter threadFilter) {
        this.methodFilter = methodFilter;
        this.threadFilter = threadFilter;
    }

    private LocalInterceptor getLocalInterceptor() {
        Thread thread = Thread.currentThread();
        LocalInterceptor theInterceptor = (LocalInterceptor)this.interceptors.get(thread);
        if (theInterceptor == null) {
            theInterceptor = this.threadFilter.accept(thread) ? new LocalInterceptor(this.methodFilter) : LocalInterceptor.DO_NOT_INTERCEPT;
            this.interceptors.put(Thread.currentThread(), theInterceptor);
        }
        return theInterceptor;
    }

    public void beforeInvoke(MethodCallInfo methodCall) {
        this.getLocalInterceptor().beforeInvoke(methodCall);
    }

    public void afterInvoke(MethodCallInfo methodCall) {
        this.getLocalInterceptor().afterInvoke(methodCall);
    }

    public CallTree getTree() {
        return this.makeTree();
    }

    private CallTree makeTree() {
        CallTree tree = new CallTree(Thread.currentThread());
        ThreadRunInfo mainThreadRun = (ThreadRunInfo)tree.getRoot().getData();
        for (LocalInterceptor interceptor : this.interceptors.values()) {
            CallTree theTree = interceptor.getTree();
            ThreadRunInfo threadRun = (ThreadRunInfo)theTree.getRoot().getData();
            if (threadRun.equals(mainThreadRun)) {
                for (CallTree.Node child : theTree.getRoot().getChildren()) {
                    tree.getRoot().addChild(child);
                }
                continue;
            }
            tree.getRoot().addChild(theTree.getRoot());
        }
        return tree;
    }

    static class LocalInterceptor {
        private CallTree tree;
        private CallTree tmpTree = new CallTree(Thread.currentThread());
        private Stack<CallTree.Node> nodeStack = new Stack();
        private MethodCallFilter methodFilter;
        private static LocalInterceptor DO_NOT_INTERCEPT = new LocalInterceptor(null){

            public void beforeInvoke(MethodCallInfo methodCall) {
            }

            public void afterInvoke(MethodCallInfo methodCall) {
            }
        };

        public LocalInterceptor(MethodCallFilter methodFilter) {
            this.nodeStack.push(this.tmpTree.getRoot());
            this.methodFilter = methodFilter;
        }

        public void beforeInvoke(MethodCallInfo methodCall) {
            CallTree.Node node = new CallTree.Node(methodCall);
            CallTree.Node parentNode = this.nodeStack.peek();
            node.setParent(parentNode);
            parentNode.addChild(node);
            this.nodeStack.push(node);
        }

        public void afterInvoke(MethodCallInfo methodCall) {
            this.nodeStack.pop();
        }

        public CallTree getTree() {
            if (this.tree == null) {
                this.tree = this.makeTree();
            }
            return this.tree;
        }

        private CallTree makeTree() {
            CallTree tree = this.tmpTree;
            this.sumUpOverheadTime(tree);
            this.subtractOverheadTime(tree);
            this.setChildrenTime(tree);
            this.filterMethods(tree);
            return tree;
        }

        private void filterMethods(CallTree tree) {
            tree.visit(new CallTree.NodeVisitor(){

                public void visit(CallTree.Node node) {
                }

                public void exit(CallTree.Node node) {
                    CallInfo call = node.getData();
                    if (call instanceof MethodCallInfo) {
                        MethodCallInfo methodCall = (MethodCallInfo)call;
                        if (!LocalInterceptor.this.methodFilter.accept(methodCall.getMethod())) {
                            CallTree.Node parentNode = node.getParent();
                            parentNode.removeChild(node);
                            for (CallTree.Node child : node.getChildren()) {
                                parentNode.addChild(child);
                            }
                        }
                    }
                }
            });
        }

        private void sumUpOverheadTime(CallTree tree) {
            tree.visit(new CallTree.NodeVisitor(){

                public void visit(CallTree.Node node) {
                }

                public void exit(CallTree.Node node) {
                    if (node.hasParent()) {
                        CallInfo call = node.getData();
                        CallInfo parentCall = node.getParent().getData();
                        parentCall.setOverheadTime(parentCall.getOverheadTime() + call.getOverheadTime());
                    }
                }
            });
        }

        private void subtractOverheadTime(CallTree tree) {
            tree.visit(new CallTree.NodeVisitor(){

                public void visit(CallTree.Node node) {
                    CallInfo call = node.getData();
                    if (node.hasParent()) {
                        CallInfo parentCall = node.getParent().getData();
                        parentCall.setTime(parentCall.getTime() - call.getOverheadTime());
                    }
                }
            });
        }

        private void setChildrenTime(CallTree tree) {
            tree.visit(new CallTree.NodeVisitor(){

                public void visit(CallTree.Node node) {
                    if (node.hasParent()) {
                        CallInfo call = node.getData();
                        CallInfo parentCall = node.getParent().getData();
                        if (parentCall instanceof ThreadRunInfo) {
                            parentCall.setTime(parentCall.getTime() + call.getTime());
                        }
                        parentCall.setChildrenTime(parentCall.getChildrenTime() + call.getTime());
                    }
                }
            });
        }
    }
}

