<!DOCTYPE html>
<!--[if IE]><![endif]-->
<html>
  
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Class Path
   | Apache TinkerPop - Gremlin.NET API Docs </title>
    <meta name="viewport" content="width=device-width">
    <meta name="title" content="Class Path
   | Apache TinkerPop - Gremlin.NET API Docs ">
    <meta name="generator" content="docfx 2.40.2.0">
    
    <link rel="shortcut icon" href="../images/favicon.ico">
    <link rel="stylesheet" href="../styles/docfx.vendor.css">
    <link rel="stylesheet" href="../styles/docfx.css">
    <link rel="stylesheet" href="../styles/main.css">
    <meta property="docfx:navrel" content="../toc.html">
    <meta property="docfx:tocrel" content="toc.html">
    
    <meta property="docfx:rel" content="../">
    
  </head>
  <body data-spy="scroll" data-target="#affix" data-offset="120">
    <div id="wrapper">
      <header>
        
        <nav id="autocollapse" class="navbar navbar-inverse ng-scope" role="navigation">
          <div class="container">
            <div class="navbar-header">
              <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
              </button>
              
              <a class="navbar-brand" href="../index.html">
                <img id="logo" class="svg" src="../images/tinkerpop-character.png" alt="">
              </a>
            </div>
            <div class="collapse navbar-collapse" id="navbar">
              <form class="navbar-form navbar-right" role="search" id="search">
                <div class="form-group">
                  <input type="text" class="form-control" id="search-query" placeholder="Search" autocomplete="off">
                </div>
              </form>
            </div>
          </div>
        </nav>
        
        <div class="subnav navbar navbar-default">
          <div class="container hide-when-search" id="breadcrumb">
            <ul class="breadcrumb">
              <li></li>
            </ul>
          </div>
        </div>
      </header>
      <div class="container body-content">
        
        <div id="search-results">
          <div class="search-list"></div>
          <div class="sr-items">
            <p><i class="glyphicon glyphicon-refresh index-loading"></i></p>
          </div>
          <ul id="pagination"></ul>
        </div>
      </div>
      <div role="main" class="container body-content hide-when-search">
        
        <div class="sidenav hide-when-search">
          <a class="btn toc-toggle collapse" data-toggle="collapse" href="#sidetoggle" aria-expanded="false" aria-controls="sidetoggle">Show / Hide Table of Contents</a>
          <div class="sidetoggle collapse" id="sidetoggle">
            <div id="sidetoc"></div>
          </div>
        </div>
        <div class="article row grid-right">
          <div class="col-md-10">
            <article class="content wrap" id="_content" data-uid="Gremlin.Net.Structure.Path">
  
  
  <h1 id="Gremlin_Net_Structure_Path" data-uid="Gremlin.Net.Structure.Path" class="text-break">Class Path
  </h1>
  <div class="markdown level0 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">A Path denotes a particular walk through a graph as defined by a <see cref="!:ITraversal"></see>.</p>
</div>
  <div class="markdown level0 conceptual"></div>
  <div class="inheritance">
    <h5>Inheritance</h5>
    <div class="level0"><span class="xref">System.Object</span></div>
    <div class="level1"><span class="xref">Path</span></div>
  </div>
  <div classs="implements">
    <h5>Implements</h5>
    <div><span class="xref">System.Collections.Generic.IReadOnlyList</span>&lt;<span class="xref">System.Object</span>&gt;</div>
    <div><span class="xref">System.Collections.Generic.IReadOnlyCollection</span>&lt;<span class="xref">System.Object</span>&gt;</div>
    <div><span class="xref">System.Collections.Generic.IEnumerable</span>&lt;<span class="xref">System.Object</span>&gt;</div>
    <div><span class="xref">System.Collections.IEnumerable</span></div>
    <div><span class="xref">System.IEquatable</span>&lt;<a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a>&gt;</div>
  </div>
  <div class="inheritedMembers">
    <h5>Inherited Members</h5>
    <div>
      <span class="xref">System.Object.Equals(System.Object, System.Object)</span>
    </div>
    <div>
      <span class="xref">System.Object.GetType()</span>
    </div>
    <div>
      <span class="xref">System.Object.MemberwiseClone()</span>
    </div>
    <div>
      <span class="xref">System.Object.ReferenceEquals(System.Object, System.Object)</span>
    </div>
  </div>
  <h6><strong>Namespace</strong>: <a class="xref" href="Gremlin.Net.Structure.html">Gremlin.Net.Structure</a></h6>
  <h6><strong>Assembly</strong>: cs.temp.dll.dll</h6>
  <h5 id="Gremlin_Net_Structure_Path_syntax">Syntax</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public class Path : IReadOnlyList&lt;object&gt;, IReadOnlyCollection&lt;object&gt;, IEnumerable&lt;object&gt;, IEnumerable, IEquatable&lt;Path&gt;</code></pre>
  </div>
  <h5 id="Gremlin_Net_Structure_Path_remarks"><strong>Remarks</strong></h5>
  <div class="markdown level0 remarks"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">In abstraction, any Path implementation maintains two lists: a list of sets of labels and a list of objects.
The list of labels are the labels of the steps traversed. The list of objects are the objects traversed.</p>
</div>
  <h3 id="constructors">Constructors
  </h3>
  <a id="Gremlin_Net_Structure_Path__ctor_" data-uid="Gremlin.Net.Structure.Path.#ctor*"></a>
  <h4 id="Gremlin_Net_Structure_Path__ctor_System_Collections_Generic_IList_ISet_System_String___System_Collections_Generic_IList_System_Object__" data-uid="Gremlin.Net.Structure.Path.#ctor(System.Collections.Generic.IList{ISet{System.String}},System.Collections.Generic.IList{System.Object})">Path(IList&lt;ISet&lt;String&gt;&gt;, IList&lt;Object&gt;)</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Initializes a new instance of the <a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a> class.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public Path(IList&lt;ISet&lt;string&gt;&gt; labels, IList&lt;object&gt; objects)</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Collections.Generic.IList</span>&lt;<span class="xref">ISet</span>&lt;<span class="xref">System.String</span>&gt;&gt;</td>
        <td><span class="parametername">labels</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The labels associated with the path</p>
</td>
      </tr>
      <tr>
        <td><span class="xref">System.Collections.Generic.IList</span>&lt;<span class="xref">System.Object</span>&gt;</td>
        <td><span class="parametername">objects</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The objects in the <a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a>.</p>
</td>
      </tr>
    </tbody>
  </table>
  <h3 id="properties">Properties
  </h3>
  <a id="Gremlin_Net_Structure_Path_Count_" data-uid="Gremlin.Net.Structure.Path.Count*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Count" data-uid="Gremlin.Net.Structure.Path.Count">Count</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Gets the number of steps in the path.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public int Count { get; }</code></pre>
  </div>
  <h5 class="propertyValue">Property Value</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Int32</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Item_" data-uid="Gremlin.Net.Structure.Path.Item*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Item_System_Int32_" data-uid="Gremlin.Net.Structure.Path.Item(System.Int32)">Item[Int32]</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Get the object associated with the specified index into the path.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public dynamic this[int index] { get; }</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Int32</span></td>
        <td><span class="parametername">index</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The index of the path</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 class="propertyValue">Property Value</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Object</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The object associated with the index of the path</p>
</td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Item_" data-uid="Gremlin.Net.Structure.Path.Item*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Item_System_String_" data-uid="Gremlin.Net.Structure.Path.Item(System.String)">Item[String]</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Gets the object associated with the particular label of the path.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public object this[string label] { get; }</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.String</span></td>
        <td><span class="parametername">label</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The label of the path</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 class="propertyValue">Property Value</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Object</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The object associated with the label of the path</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 id="Gremlin_Net_Structure_Path_Item_System_String__remarks">Remarks</h5>
  <div class="markdown level1 remarks"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">If the path has multiple labels of the type, then get a collection of those objects.</p>
</div>
  <h5 class="exceptions">Exceptions</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Condition</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Collections.Generic.KeyNotFoundException</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">Thrown if the path does not contain the label.</p>
</td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Labels_" data-uid="Gremlin.Net.Structure.Path.Labels*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Labels" data-uid="Gremlin.Net.Structure.Path.Labels">Labels</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Gets an ordered list of the labels associated with the <a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a>.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public IList&lt;ISet&lt;string&gt;&gt; Labels { get; }</code></pre>
  </div>
  <h5 class="propertyValue">Property Value</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Collections.Generic.IList</span>&lt;<span class="xref">ISet</span>&lt;<span class="xref">System.String</span>&gt;&gt;</td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Objects_" data-uid="Gremlin.Net.Structure.Path.Objects*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Objects" data-uid="Gremlin.Net.Structure.Path.Objects">Objects</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Gets an ordered list of the objects in the <a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a>.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public IList&lt;object&gt; Objects { get; }</code></pre>
  </div>
  <h5 class="propertyValue">Property Value</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Collections.Generic.IList</span>&lt;<span class="xref">System.Object</span>&gt;</td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h3 id="methods">Methods
  </h3>
  <a id="Gremlin_Net_Structure_Path_ContainsKey_" data-uid="Gremlin.Net.Structure.Path.ContainsKey*"></a>
  <h4 id="Gremlin_Net_Structure_Path_ContainsKey_System_String_" data-uid="Gremlin.Net.Structure.Path.ContainsKey(System.String)">ContainsKey(String)</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Returns true if the path has the specified label, else return false.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public bool ContainsKey(string key)</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.String</span></td>
        <td><span class="parametername">key</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The label to search for.</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Boolean</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">True if the label exists in the path.</p>
</td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Equals_" data-uid="Gremlin.Net.Structure.Path.Equals*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Equals_Gremlin_Net_Structure_Path_" data-uid="Gremlin.Net.Structure.Path.Equals(Gremlin.Net.Structure.Path)">Equals(Path)</h4>
  <div class="markdown level1 summary"></div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public bool Equals(Path other)</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><a class="xref" href="Gremlin.Net.Structure.Path.html">Path</a></td>
        <td><span class="parametername">other</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Boolean</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_Equals_" data-uid="Gremlin.Net.Structure.Path.Equals*"></a>
  <h4 id="Gremlin_Net_Structure_Path_Equals_System_Object_" data-uid="Gremlin.Net.Structure.Path.Equals(System.Object)">Equals(Object)</h4>
  <div class="markdown level1 summary"></div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public override bool Equals(object obj)</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Object</span></td>
        <td><span class="parametername">obj</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Boolean</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h5 class="overrides">Overrides</h5>
  <div><span class="xref">System.Object.Equals(System.Object)</span></div>
  <a id="Gremlin_Net_Structure_Path_GetEnumerator_" data-uid="Gremlin.Net.Structure.Path.GetEnumerator*"></a>
  <h4 id="Gremlin_Net_Structure_Path_GetEnumerator" data-uid="Gremlin.Net.Structure.Path.GetEnumerator">GetEnumerator()</h4>
  <div class="markdown level1 summary"></div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public IEnumerator&lt;object&gt; GetEnumerator()</code></pre>
  </div>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Collections.Generic.IEnumerator</span>&lt;<span class="xref">System.Object</span>&gt;</td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <a id="Gremlin_Net_Structure_Path_GetHashCode_" data-uid="Gremlin.Net.Structure.Path.GetHashCode*"></a>
  <h4 id="Gremlin_Net_Structure_Path_GetHashCode" data-uid="Gremlin.Net.Structure.Path.GetHashCode">GetHashCode()</h4>
  <div class="markdown level1 summary"></div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public override int GetHashCode()</code></pre>
  </div>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Int32</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h5 class="overrides">Overrides</h5>
  <div><span class="xref">System.Object.GetHashCode()</span></div>
  <a id="Gremlin_Net_Structure_Path_ToString_" data-uid="Gremlin.Net.Structure.Path.ToString*"></a>
  <h4 id="Gremlin_Net_Structure_Path_ToString" data-uid="Gremlin.Net.Structure.Path.ToString">ToString()</h4>
  <div class="markdown level1 summary"></div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public override string ToString()</code></pre>
  </div>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.String</span></td>
        <td></td>
      </tr>
    </tbody>
  </table>
  <h5 class="overrides">Overrides</h5>
  <div><span class="xref">System.Object.ToString()</span></div>
  <a id="Gremlin_Net_Structure_Path_TryGetValue_" data-uid="Gremlin.Net.Structure.Path.TryGetValue*"></a>
  <h4 id="Gremlin_Net_Structure_Path_TryGetValue_System_String_System_Object__" data-uid="Gremlin.Net.Structure.Path.TryGetValue(System.String,System.Object@)">TryGetValue(String, out Object)</h4>
  <div class="markdown level1 summary"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="2">Tries to get the object associated with the particular label of the path.</p>
</div>
  <div class="markdown level1 conceptual"></div>
  <h5 class="decalaration">Declaration</h5>
  <div class="codewrapper">
    <pre><code class="lang-csharp hljs">public bool TryGetValue(string label, out object value)</code></pre>
  </div>
  <h5 class="parameters">Parameters</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Name</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.String</span></td>
        <td><span class="parametername">label</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The label of the path.</p>
</td>
      </tr>
      <tr>
        <td><span class="xref">System.Object</span></td>
        <td><span class="parametername">value</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">The object associated with the label of the path.</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 class="returns">Returns</h5>
  <table class="table table-bordered table-striped table-condensed">
    <thead>
      <tr>
        <th>Type</th>
        <th>Description</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><span class="xref">System.Boolean</span></td>
        <td><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">True, if an object was found for the label.</p>
</td>
      </tr>
    </tbody>
  </table>
  <h5 id="Gremlin_Net_Structure_Path_TryGetValue_System_String_System_Object___remarks">Remarks</h5>
  <div class="markdown level1 remarks"><p sourcefile="obj/api/Gremlin.Net.Structure.Path.yml" sourcestartlinenumber="1">If the path has multiple labels of the type, then get a collection of those objects.</p>
</div>
  <h3 id="implements">Implements</h3>
  <div>
      <span class="xref">System.Collections.Generic.IReadOnlyList&lt;T&gt;</span>
  </div>
  <div>
      <span class="xref">System.Collections.Generic.IReadOnlyCollection&lt;T&gt;</span>
  </div>
  <div>
      <span class="xref">System.Collections.Generic.IEnumerable&lt;T&gt;</span>
  </div>
  <div>
      <span class="xref">System.Collections.IEnumerable</span>
  </div>
  <div>
      <span class="xref">System.IEquatable&lt;T&gt;</span>
  </div>
</article>
          </div>
          
          <div class="hidden-sm col-md-2" role="complementary">
            <div class="sideaffix">
              <nav class="bs-docs-sidebar hidden-print hidden-xs hidden-sm affix" id="affix">
              <!-- <p><a class="back-to-top" href="#top">Back to top</a><p> -->
              </nav>
            </div>
          </div>
        </div>
      </div>
      
      <footer>
        <div class="grad-bottom"></div>
        <div class="footer">
          <div class="container">
            <span class="pull-right">
              <a href="#top">Back to top</a>
            </span>
            Copyright © 2018 The Apache Software Foundation
            
          </div>
        </div>
      </footer>
    </div>
    
    <script type="text/javascript" src="../styles/docfx.vendor.js"></script>
    <script type="text/javascript" src="../styles/docfx.js"></script>
    <script type="text/javascript" src="../styles/main.js"></script>
  </body>
</html>
