[{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">A traversal represents a directed walk over a graph.</p>\n","Type":"class","Syntax":{"content":"public abstract class DefaultTraversal<S, E> : ITraversal<S, E>, ITraversal, IEnumerator, IEnumerator<E>, IDisposable, IEnumerator","typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Public MustInherit Class DefaultTraversal(Of S, E)\n    Implements ITraversal(Of S, E), ITraversal, IEnumerator, IEnumerator(Of E), IDisposable, IEnumerator"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Bytecode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> representation of this traversal.</p>\n","Type":"property","Syntax":{"content":"public Bytecode Bytecode { get; protected set; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Bytecode"},"content.vb":"Public Property Bytecode As Bytecode"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> representation of this traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.SideEffects","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects\" data-throw-if-not-resolved=\"false\"></xref> of this traversal.</p>\n","Type":"property","Syntax":{"content":"public ITraversalSideEffects SideEffects { get; set; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.ITraversalSideEffects"},"content.vb":"Public Property SideEffects As ITraversalSideEffects"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects\" data-throw-if-not-resolved=\"false\"></xref> of this traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Traversers","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>'s of this traversal that hold the results of the traversal.</p>\n","Type":"property","Syntax":{"content":"public IEnumerable<Traverser> Traversers { get; set; }","parameters":[],"return":{"type":"System.Collections.Generic.IEnumerable{Gremlin.Net.Process.Traversal.Traverser}"},"content.vb":"Public Property Traversers As IEnumerable(Of Traverser)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>'s of this traversal that hold the results of the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Gremlin#Net#Process#Traversal#ITraversal#Iterate","Type":"method","Syntax":{"content":"ITraversal ITraversal.Iterate()","return":{"type":"Gremlin.Net.Process.Traversal.ITraversal"},"content.vb":"Function Gremlin.Net.Process.Traversal.ITraversal.Iterate As ITraversal Implements ITraversal.Iterate"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.TraversalStrategies","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalStrategy\" data-throw-if-not-resolved=\"false\"></xref> strategies of this traversal.</p>\n","Type":"property","Syntax":{"content":"protected ICollection<ITraversalStrategy> TraversalStrategies { get; set; }","parameters":[],"return":{"type":"System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy}"},"content.vb":"Protected Property TraversalStrategies As ICollection(Of ITraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalStrategy\" data-throw-if-not-resolved=\"false\"></xref> strategies of this traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Dispose","Type":"method","Syntax":{"content":"public void Dispose()","content.vb":"Public Sub Dispose"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.MoveNext","Type":"method","Syntax":{"content":"public bool MoveNext()","return":{"type":"System.Boolean"},"content.vb":"Public Function MoveNext As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Reset","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Reset is not supported.</p>\n","Type":"method","Syntax":{"content":"public void Reset()","content.vb":"Public Sub Reset"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Reset is not supported.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Current","Type":"property","Syntax":{"content":"public E Current { get; }","parameters":[],"return":{"type":"{E}"},"content.vb":"Public ReadOnly Property Current As E"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Next","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next result from the traversal.</p>\n","Type":"method","Syntax":{"content":"public E Next()","return":{"type":"{E}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The result.</p>\n"},"content.vb":"Public Function Next As E"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next result from the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Next(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next n-number of results from the traversal.</p>\n","Type":"method","Syntax":{"content":"public IEnumerable<E> Next(int amount)","parameters":[{"id":"amount","type":"System.Int32","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The number of results to get.</p>\n"}],"return":{"type":"System.Collections.Generic.IEnumerable{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The n-results.</p>\n"},"content.vb":"Public Function Next(amount As Integer) As IEnumerable(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next n-number of results from the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Iterate","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","Type":"method","Syntax":{"content":"public ITraversal<S, E> Iterate()","return":{"type":"Gremlin.Net.Process.Traversal.ITraversal{{S},{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The fully drained traversal.</p>\n"},"content.vb":"Public Function Iterate As ITraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.NextTraverser","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public Traverser NextTraverser()","return":{"type":"Gremlin.Net.Process.Traversal.Traverser","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Function NextTraverser As Traverser"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.ToList","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <xref href=\"System.Collections.Generic.List%601\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public IList<E> ToList()","return":{"type":"System.Collections.Generic.IList{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The results in a list.</p>\n"},"content.vb":"Public Function ToList As IList(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <xref href=\"System.Collections.Generic.List%601\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.ToSet","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <see cref=\"!:HashSet&lt;T>\"></see>.</p>\n","Type":"method","Syntax":{"content":"public ISet<E> ToSet()","return":{"type":"ISet{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The results in a set.</p>\n"},"content.vb":"Public Function ToSet As ISet(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <see cref=\"!:HashSet&lt;T>\"></see>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Dispose(System.Boolean)","Type":"method","Syntax":{"content":"protected virtual void Dispose(bool disposing)","parameters":[{"id":"disposing","type":"System.Boolean"}],"content.vb":"Protected Overridable Sub Dispose(disposing As Boolean)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.DefaultTraversal`2.Promise``1(System.Func{Gremlin.Net.Process.Traversal.ITraversal{`0,`1},``0})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Starts a promise to execute a function on the current traversal that will be completed in the future.</p>\n","Type":"method","Syntax":{"content":"public Task<TReturn> Promise<TReturn>(Func<ITraversal<S, E>, TReturn> callback)","parameters":[{"id":"callback","type":"System.Func{Gremlin.Net.Process.Traversal.ITraversal{{S},{E}},{TReturn}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The function to execute on the current traversal.</p>\n"}],"typeParameters":[{"id":"TReturn","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The return type of the <code data-dev-comment-type=\"paramref\" class=\"paramref\">callback</code>.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{{TReturn}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"1\">The result of the executed <code data-dev-comment-type=\"paramref\" class=\"paramref\">callback</code>.</p>\n"},"content.vb":"Public Function Promise(Of TReturn)(callback As Func(Of ITraversal(Of S, E), TReturn)) As Task(Of TReturn)"},"File":"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.DefaultTraversal-2.yml\" sourcestartlinenumber=\"2\">Starts a promise to execute a function on the current traversal that will be completed in the future.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Verification.ReadOnlyStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Verification.ReadOnlyStrategy.yml\" sourcestartlinenumber=\"2\">Detects mutating steps and throws an exception if one is found.</p>\n","Type":"class","Syntax":{"content":"public class ReadOnlyStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class ReadOnlyStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Verification.ReadOnlyStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.LazyBarrierStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.LazyBarrierStrategy.yml\" sourcestartlinenumber=\"2\">Inserts <code>Barrier()</code>-steps into a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> where appropriate in order to gain the &quot;bulking\noptimization&quot;.</p>\n","Type":"class","Syntax":{"content":"public class LazyBarrierStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class LazyBarrierStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.LazyBarrierStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.InlineFilterStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.InlineFilterStrategy.yml\" sourcestartlinenumber=\"2\">Analyzes filter-steps with child traversals that themselves are pure filters.</p>\n","Type":"class","Syntax":{"content":"public class InlineFilterStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class InlineFilterStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.InlineFilterStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.AdjacentToIncidentStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.AdjacentToIncidentStrategy.yml\" sourcestartlinenumber=\"2\">Optimizes vertex- and value-emitting steps.</p>\n","Type":"class","Syntax":{"content":"public class AdjacentToIncidentStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class AdjacentToIncidentStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.AdjacentToIncidentStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator","Type":"class","Syntax":{"content":"public class Operator : EnumWrapper, IEquatable<EnumWrapper>, IBinaryOperator, IBiFunction","content.vb":"Public Class Operator\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper), IBinaryOperator, IBiFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.AddAll","Type":"property","Syntax":{"content":"public static Operator AddAll { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property AddAll As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.And","Type":"property","Syntax":{"content":"public static Operator And { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property And As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Assign","Type":"property","Syntax":{"content":"public static Operator Assign { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Assign As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Div","Type":"property","Syntax":{"content":"public static Operator Div { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Div As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Max","Type":"property","Syntax":{"content":"public static Operator Max { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Max As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Min","Type":"property","Syntax":{"content":"public static Operator Min { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Min As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Minus","Type":"property","Syntax":{"content":"public static Operator Minus { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Minus As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Mult","Type":"property","Syntax":{"content":"public static Operator Mult { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Mult As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Or","Type":"property","Syntax":{"content":"public static Operator Or { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Or As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.Sum","Type":"property","Syntax":{"content":"public static Operator Sum { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property Sum As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.SumLong","Type":"property","Syntax":{"content":"public static Operator SumLong { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared ReadOnly Property SumLong As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Operator.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Operator.yml\" sourcestartlinenumber=\"2\">Gets the Operator enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Operator GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Operator"},"content.vb":"Public Shared Function GetByValue(value As String) As "},"File":"obj/api/Gremlin.Net.Process.Traversal.Operator.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Operator.yml\" sourcestartlinenumber=\"2\">Gets the Operator enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Lambda","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"2\">Provides methods to create lambdas.</p>\n","Type":"class","Syntax":{"content":"public static class Lambda","content.vb":"Public Module Lambda"},"File":"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Lambda.Groovy(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"2\">Creates a new Groovy lambda.</p>\n","Type":"method","Syntax":{"content":"public static ILambda Groovy(string expression)","parameters":[{"id":"expression","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"1\">The lambda expression.</p>\n"}],"return":{"type":"Gremlin.Net.Process.Traversal.ILambda","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"1\">The created lambda.</p>\n"},"content.vb":"Public Shared Function Groovy(expression As String) As ILambda"},"File":"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"2\">Creates a new Groovy lambda.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Lambda.Python(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"2\">Creates a new Python lambda.</p>\n","Type":"method","Syntax":{"content":"public static ILambda Python(string expression)","parameters":[{"id":"expression","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"1\">The lambda expression.</p>\n"}],"return":{"type":"Gremlin.Net.Process.Traversal.ILambda","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"1\">The created lambda.</p>\n"},"content.vb":"Public Shared Function Python(expression As String) As ILambda"},"File":"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Lambda.yml\" sourcestartlinenumber=\"2\">Creates a new Python lambda.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Represents the basic information for a walk over a graph.</p>\n","Type":"interface","Syntax":{"content":"public interface ITraversal : IEnumerator","content.vb":"Public Interface ITraversal\n    Inherits IEnumerator"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal.Bytecode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> representation of this traversal.</p>\n","Type":"property","Syntax":{"content":"Bytecode Bytecode { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Bytecode"},"content.vb":"ReadOnly Property Bytecode As Bytecode"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> representation of this traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal.SideEffects","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects\" data-throw-if-not-resolved=\"false\"></xref> of this traversal.</p>\n","Type":"property","Syntax":{"content":"ITraversalSideEffects SideEffects { get; set; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.ITraversalSideEffects"},"content.vb":"Property SideEffects As ITraversalSideEffects"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects\" data-throw-if-not-resolved=\"false\"></xref> of this traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal.Traversers","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>'s of this traversal that hold the results of the traversal.</p>\n","Type":"property","Syntax":{"content":"IEnumerable<Traverser> Traversers { get; set; }","parameters":[],"return":{"type":"System.Collections.Generic.IEnumerable{Gremlin.Net.Process.Traversal.Traverser}"},"content.vb":"Property Traversers As IEnumerable(Of Traverser)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>'s of this traversal that hold the results of the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal.Iterate","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","Type":"method","Syntax":{"content":"ITraversal Iterate()","return":{"type":"Gremlin.Net.Process.Traversal.ITraversal","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"1\">The fully drained traversal.</p>\n"},"content.vb":"Function Iterate As ITraversal"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">A traversal represents a directed walk over a graph.</p>\n","Type":"interface","Syntax":{"content":"public interface ITraversal<S, E> : ITraversal, IEnumerator, IEnumerator<E>, IDisposable, IEnumerator","typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Public Interface ITraversal(Of S, E)\n    Inherits ITraversal, IEnumerator(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.Next","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next result from the traversal.</p>\n","Type":"method","Syntax":{"content":"E Next()","return":{"type":"{E}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The result.</p>\n"},"content.vb":"Function Next As E"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next result from the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.Next(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next n-number of results from the traversal.</p>\n","Type":"method","Syntax":{"content":"IEnumerable<E> Next(int amount)","parameters":[{"id":"amount","type":"System.Int32","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The number of results to get.</p>\n"}],"return":{"type":"System.Collections.Generic.IEnumerable{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The n-results.</p>\n"},"content.vb":"Function Next(amount As Integer) As IEnumerable(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next n-number of results from the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.Iterate","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","Type":"method","Syntax":{"content":"ITraversal<S, E> Iterate()","return":{"type":"Gremlin.Net.Process.Traversal.ITraversal`2","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The fully drained traversal.</p>\n"},"content.vb":"Function Iterate As ITraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Iterates all <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> instances in the traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.NextTraverser","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"Traverser NextTraverser()","return":{"type":"Gremlin.Net.Process.Traversal.Traverser","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Function NextTraverser As Traverser"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Gets the next <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.ToList","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <xref href=\"System.Collections.Generic.IList%601\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"IList<E> ToList()","return":{"type":"System.Collections.Generic.IList{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The results in a list.</p>\n"},"content.vb":"Function ToList As IList(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <xref href=\"System.Collections.Generic.IList%601\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.ToSet","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <see cref=\"!:ISet&lt;T>\"></see>.</p>\n","Type":"method","Syntax":{"content":"ISet<E> ToSet()","return":{"type":"ISet{{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The results in a set.</p>\n"},"content.vb":"Function ToSet As ISet(Of E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Puts all the results into a <see cref=\"!:ISet&lt;T>\"></see>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversal`2.Promise``1(System.Func{Gremlin.Net.Process.Traversal.ITraversal{`0,`1},``0})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Starts a promise to execute a function on the current traversal that will be completed in the future.</p>\n","Type":"method","Syntax":{"content":"Task<TReturn> Promise<TReturn>(Func<ITraversal<S, E>, TReturn> callback)","parameters":[{"id":"callback","type":"System.Func{Gremlin.Net.Process.Traversal.ITraversal`2,{TReturn}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The function to execute on the current traversal.</p>\n"}],"typeParameters":[{"id":"TReturn","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The return type of the <code data-dev-comment-type=\"paramref\" class=\"paramref\">callback</code>.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{{TReturn}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"1\">The result of the executed <code data-dev-comment-type=\"paramref\" class=\"paramref\">callback</code>.</p>\n"},"content.vb":"Function Promise(Of TReturn)(callback As Func(Of ITraversal(Of S, E), TReturn)) As Task(Of TReturn)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversal-2.yml\" sourcestartlinenumber=\"2\">Starts a promise to execute a function on the current traversal that will be completed in the future.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IConsumer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IConsumer.yml\" sourcestartlinenumber=\"2\">Represents an operation that accepts a single input argument and returns no result. Unlike most other functional\ninterfaces, Consumer is expected to operate via side-effects.</p>\n","Type":"interface","Syntax":{"content":"public interface IConsumer","content.vb":"Public Interface IConsumer"},"File":"obj/api/Gremlin.Net.Process.Traversal.IConsumer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IComparator","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IComparator.yml\" sourcestartlinenumber=\"2\">A comparison function, which imposes a total ordering on some collection of objects.</p>\n","Type":"interface","Syntax":{"content":"public interface IComparator","content.vb":"Public Interface IComparator"},"File":"obj/api/Gremlin.Net.Process.Traversal.IComparator.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Direction","Type":"class","Syntax":{"content":"public class Direction : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class Direction\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Direction.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Direction.Both","Type":"property","Syntax":{"content":"public static Direction Both { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Direction"},"content.vb":"Public Shared ReadOnly Property Both As Direction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Direction.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Direction.In","Type":"property","Syntax":{"content":"public static Direction In { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Direction"},"content.vb":"Public Shared ReadOnly Property In As Direction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Direction.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Direction.Out","Type":"property","Syntax":{"content":"public static Direction Out { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Direction"},"content.vb":"Public Shared ReadOnly Property Out As Direction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Direction.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Direction.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Direction.yml\" sourcestartlinenumber=\"2\">Gets the Direction enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Direction GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Direction"},"content.vb":"Public Shared Function GetByValue(value As String) As Direction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Direction.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Direction.yml\" sourcestartlinenumber=\"2\">Gets the Direction enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">An anonymous <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public static class __","content.vb":"Public Module __"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Start","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Starts an empty <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Start()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Start As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Starts an empty <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.V(System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the V step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> V(params object[] vertexIdsOrElements)","parameters":[{"id":"vertexIdsOrElements","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function V(ParamArray vertexIdsOrElements As Object()) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the V step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.AddE(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> AddE(string edgeLabel)","parameters":[{"id":"edgeLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function AddE(edgeLabel As String) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.AddE(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> AddE(ITraversal edgeLabelTraversal)","parameters":[{"id":"edgeLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function AddE(edgeLabelTraversal As ITraversal) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.AddV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> AddV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function AddV As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.AddV(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> AddV(string vertexLabel)","parameters":[{"id":"vertexLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function AddV(vertexLabel As String) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.AddV(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> AddV(ITraversal vertexLabelTraversal)","parameters":[{"id":"vertexLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function AddV(vertexLabelTraversal As ITraversal) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the addV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Aggregate(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the aggregate step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Aggregate(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Aggregate(sideEffectKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the aggregate step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.And(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the and step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> And(params ITraversal[] andTraversals)","parameters":[{"id":"andTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function And(ParamArray andTraversals As ITraversal()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the and step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.As(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the as step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> As(string label, params string[] labels)","parameters":[{"id":"label","type":"System.String"},{"id":"labels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function As(label As String, ParamArray labels As String()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the as step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Barrier","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Barrier()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Barrier As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Barrier(Gremlin.Net.Process.Traversal.IConsumer)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Barrier(IConsumer barrierConsumer)","parameters":[{"id":"barrierConsumer","type":"Gremlin.Net.Process.Traversal.IConsumer"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Barrier(barrierConsumer As IConsumer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Barrier(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Barrier(int maxBarrierSize)","parameters":[{"id":"maxBarrierSize","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Barrier(maxBarrierSize As Integer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the barrier step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Both(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the both step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> Both(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function Both(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the both step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.BothE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the bothE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> BothE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function BothE(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the bothE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.BothV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the bothV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> BothV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function BothV As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the bothV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Branch``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the branch step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Branch<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Branch(Of E2)(function As IFunction) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the branch step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Branch``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the branch step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Branch<E2>(ITraversal traversalFunction)","parameters":[{"id":"traversalFunction","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Branch(Of E2)(traversalFunction As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the branch step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Cap``1(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the cap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Cap<E2>(string sideEffectKey, params string[] sideEffectKeys)","parameters":[{"id":"sideEffectKey","type":"System.String"},{"id":"sideEffectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Cap(Of E2)(sideEffectKey As String, ParamArray sideEffectKeys As String()) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the cap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(IFunction choiceFunction)","parameters":[{"id":"choiceFunction","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(choiceFunction As IFunction) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.IPredicate,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(IPredicate choosePredicate, ITraversal trueChoice)","parameters":[{"id":"choosePredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(choosePredicate As IPredicate, trueChoice As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.IPredicate,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(IPredicate choosePredicate, ITraversal trueChoice, ITraversal falseChoice)","parameters":[{"id":"choosePredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"falseChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(choosePredicate As IPredicate, trueChoice As ITraversal, falseChoice As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(ITraversal traversalFunction)","parameters":[{"id":"traversalFunction","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(traversalFunction As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(ITraversal traversalPredicate, ITraversal trueChoice)","parameters":[{"id":"traversalPredicate","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(traversalPredicate As ITraversal, trueChoice As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Choose``1(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Choose<E2>(ITraversal traversalPredicate, ITraversal trueChoice, ITraversal falseChoice)","parameters":[{"id":"traversalPredicate","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"falseChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Choose(Of E2)(traversalPredicate As ITraversal, trueChoice As ITraversal, falseChoice As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the choose step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Coalesce``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the coalesce step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Coalesce<E2>(params ITraversal[] traversals)","parameters":[{"id":"traversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Coalesce(Of E2)(ParamArray traversals As ITraversal()) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the coalesce step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Coin(System.Double)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the coin step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Coin(double probability)","parameters":[{"id":"probability","type":"System.Double"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Coin(probability As Double) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the coin step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Constant``1(``0)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the constant step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Constant<E2>(E2 a)","parameters":[{"id":"a","type":"{E2}"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Constant(Of E2)(a As E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the constant step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Count","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the count step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, long> Count()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Int64}"},"content.vb":"Public Shared Function Count As GraphTraversal(Of Object, Long)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the count step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Count(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the count step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, long> Count(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Int64}"},"content.vb":"Public Shared Function Count(scope As Scope) As GraphTraversal(Of Object, Long)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the count step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.CyclicPath","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the cyclicPath step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> CyclicPath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function CyclicPath As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the cyclicPath step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Dedup(Gremlin.Net.Process.Traversal.Scope,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the dedup step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Dedup(Scope scope, params string[] dedupLabels)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"dedupLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Dedup(scope As Scope, ParamArray dedupLabels As String()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the dedup step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Dedup(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the dedup step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Dedup(params string[] dedupLabels)","parameters":[{"id":"dedupLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Dedup(ParamArray dedupLabels As String()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the dedup step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Drop","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the drop step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Drop()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Drop As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the drop step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Emit","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Emit()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Emit As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Emit(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Emit(IPredicate emitPredicate)","parameters":[{"id":"emitPredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Emit(emitPredicate As IPredicate) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Emit(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Emit(ITraversal emitTraversal)","parameters":[{"id":"emitTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Emit(emitTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the emit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Filter(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the filter step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Filter(IPredicate predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Filter(predicate As IPredicate) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the filter step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Filter(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the filter step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Filter(ITraversal filterTraversal)","parameters":[{"id":"filterTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Filter(filterTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the filter step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.FlatMap``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the flatMap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> FlatMap<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function FlatMap(Of E2)(function As IFunction) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the flatMap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.FlatMap``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the flatMap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> FlatMap<E2>(ITraversal flatMapTraversal)","parameters":[{"id":"flatMapTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function FlatMap(Of E2)(flatMapTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the flatMap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Fold``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the fold step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IList<E2>> Fold<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IList{{E2}}}"},"content.vb":"Public Shared Function Fold(Of E2) As GraphTraversal(Of Object, IList(Of E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the fold step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Fold``1(``0,Gremlin.Net.Process.Traversal.IBiFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the fold step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Fold<E2>(E2 seed, IBiFunction foldFunction)","parameters":[{"id":"seed","type":"{E2}"},{"id":"foldFunction","type":"Gremlin.Net.Process.Traversal.IBiFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Fold(Of E2)(seed As E2, foldFunction As IBiFunction) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the fold step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Group``2","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the group step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<K, V>> Group<K, V>()","typeParameters":[{"id":"K"},{"id":"V"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{{K},{V}}}"},"content.vb":"Public Shared Function Group(Of K, V) As GraphTraversal(Of Object, IDictionary(Of K, V))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the group step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Group(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the group step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Group(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Group(sideEffectKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the group step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.GroupCount``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the groupCount step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<K, long>> GroupCount<K>()","typeParameters":[{"id":"K"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{{K},System.Int64}}"},"content.vb":"Public Shared Function GroupCount(Of K) As GraphTraversal(Of Object, IDictionary(Of K, Long))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the groupCount step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.GroupCount(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the groupCount step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> GroupCount(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function GroupCount(sideEffectKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the groupCount step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string propertyKey)","parameters":[{"id":"propertyKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(propertyKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string propertyKey, object value)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(propertyKey As String, value As Object) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string propertyKey, P predicate)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(propertyKey As String, predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String,System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string label, string propertyKey, object value)","parameters":[{"id":"label","type":"System.String"},{"id":"propertyKey","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(label As String, propertyKey As String, value As Object) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String,System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string label, string propertyKey, P predicate)","parameters":[{"id":"label","type":"System.String"},{"id":"propertyKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(label As String, propertyKey As String, predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(System.String,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(string propertyKey, ITraversal propertyTraversal)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"propertyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(propertyKey As String, propertyTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(Gremlin.Net.Process.Traversal.T,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(T accessor, object value)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(accessor As T, value As Object) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(Gremlin.Net.Process.Traversal.T,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(T accessor, P predicate)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(accessor As T, predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Has(Gremlin.Net.Process.Traversal.T,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Has(T accessor, ITraversal propertyTraversal)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"propertyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Has(accessor As T, propertyTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the has step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasId(System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasId step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasId(object id, params object[] otherIds)","parameters":[{"id":"id","type":"System.Object"},{"id":"otherIds","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasId(id As Object, ParamArray otherIds As Object()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasId step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasId(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasId step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasId(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasId(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasId step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasKey(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasKey step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasKey(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasKey(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasKey step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasKey(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasKey step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasKey(string label, params string[] otherLabels)","parameters":[{"id":"label","type":"System.String"},{"id":"otherLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasKey(label As String, ParamArray otherLabels As String()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasKey step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasLabel(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasLabel step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasLabel(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasLabel(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasLabel step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasLabel(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasLabel step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasLabel(string label, params string[] otherLabels)","parameters":[{"id":"label","type":"System.String"},{"id":"otherLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasLabel(label As String, ParamArray otherLabels As String()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasLabel step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasNot(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasNot step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasNot(string propertyKey)","parameters":[{"id":"propertyKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasNot(propertyKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasNot step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasValue(System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasValue step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasValue(object value, params object[] values)","parameters":[{"id":"value","type":"System.Object"},{"id":"values","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasValue(value As Object, ParamArray values As Object()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasValue step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.HasValue(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasValue step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> HasValue(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function HasValue(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the hasValue step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Id","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the id step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Id()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Id As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the id step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Identity","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the identity step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Identity()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Identity As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the identity step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.In(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the in step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> In(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function In(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the in step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.InE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> InE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function InE(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.InV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> InV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function InV As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Index``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the index step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Index<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Index(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the index step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Inject(System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inject step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Inject(params object[] injections)","parameters":[{"id":"injections","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Inject(ParamArray injections As Object()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the inject step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Is(System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the is step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Is(object value)","parameters":[{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Is(value As Object) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the is step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Is(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the is step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Is(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Is(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the is step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Key","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the key step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, string> Key()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.String}"},"content.vb":"Public Shared Function Key As GraphTraversal(Of Object, String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the key step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Label","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the label step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, string> Label()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.String}"},"content.vb":"Public Shared Function Label As GraphTraversal(Of Object, String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the label step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Limit``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the limit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Limit<E2>(Scope scope, long limit)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Limit(Of E2)(scope As Scope, limit As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the limit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Limit``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the limit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Limit<E2>(long limit)","parameters":[{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Limit(Of E2)(limit As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the limit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Local``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the local step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Local<E2>(ITraversal localTraversal)","parameters":[{"id":"localTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Local(Of E2)(localTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the local step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Loops","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the loops step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, int> Loops()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Int32}"},"content.vb":"Public Shared Function Loops As GraphTraversal(Of Object, Integer)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the loops step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Loops(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the loops step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, int> Loops(string loopName)","parameters":[{"id":"loopName","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Int32}"},"content.vb":"Public Shared Function Loops(loopName As String) As GraphTraversal(Of Object, Integer)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the loops step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Map``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the map step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Map<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Map(Of E2)(function As IFunction) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the map step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Map``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the map step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Map<E2>(ITraversal mapTraversal)","parameters":[{"id":"mapTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Map(Of E2)(mapTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the map step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Match``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the match step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<string, E2>> Match<E2>(params ITraversal[] matchTraversals)","parameters":[{"id":"matchTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Shared Function Match(Of E2)(ParamArray matchTraversals As ITraversal()) As GraphTraversal(Of Object, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the match step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Math(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the math step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, double> Math(string expression)","parameters":[{"id":"expression","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Double}"},"content.vb":"Public Shared Function Math(expression As String) As GraphTraversal(Of Object, Double)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the math step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Max``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the max step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Max<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Max(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the max step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Max``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the max step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Max<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Max(Of E2)(scope As Scope) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the max step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Mean``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the mean step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Mean<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Mean(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the mean step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Mean``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the mean step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Mean<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Mean(Of E2)(scope As Scope) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the mean step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Min``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the min step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Min<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Min(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the min step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Min``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the min step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Min<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Min(Of E2)(scope As Scope) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the min step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Not(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the not step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Not(ITraversal notTraversal)","parameters":[{"id":"notTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Not(notTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the not step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Optional``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the optional step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Optional<E2>(ITraversal optionalTraversal)","parameters":[{"id":"optionalTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Optional(Of E2)(optionalTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the optional step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Or(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the or step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Or(params ITraversal[] orTraversals)","parameters":[{"id":"orTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Or(ParamArray orTraversals As ITraversal()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the or step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Order","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the order step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Order()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Order As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the order step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Order(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the order step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Order(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Order(scope As Scope) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the order step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.OtherV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the otherV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> OtherV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function OtherV As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the otherV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Out(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the out step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> Out(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function Out(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the out step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.OutE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the outE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> OutE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function OutE(ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the outE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.OutV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the outV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> OutV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function OutV As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the outV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Path","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the path step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Path> Path()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Path}"},"content.vb":"Public Shared Function Path As GraphTraversal(Of Object, Path)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the path step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Project``1(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the project step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<string, E2>> Project<E2>(string projectKey, params string[] projectKeys)","parameters":[{"id":"projectKey","type":"System.String"},{"id":"projectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Shared Function Project(Of E2)(projectKey As String, ParamArray projectKeys As String()) As GraphTraversal(Of Object, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the project step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Properties``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the properties step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Properties<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Properties(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the properties step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Property(Gremlin.Net.Process.Traversal.Cardinality,System.Object,System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the property step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Property(Cardinality cardinality, object key, object value, params object[] keyValues)","parameters":[{"id":"cardinality","type":"Gremlin.Net.Process.Traversal.Cardinality"},{"id":"key","type":"System.Object"},{"id":"value","type":"System.Object"},{"id":"keyValues","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Property(cardinality As Cardinality, key As Object, value As Object, ParamArray keyValues As Object()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the property step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Property(System.Object,System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the property step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Property(object key, object value, params object[] keyValues)","parameters":[{"id":"key","type":"System.Object"},{"id":"value","type":"System.Object"},{"id":"keyValues","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Property(key As Object, value As Object, ParamArray keyValues As Object()) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the property step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.PropertyMap``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the propertyMap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<string, E2>> PropertyMap<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Shared Function PropertyMap(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of Object, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the propertyMap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Range``1(Gremlin.Net.Process.Traversal.Scope,System.Int64,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the range step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Range<E2>(Scope scope, long low, long high)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"low","type":"System.Int64"},{"id":"high","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Range(Of E2)(scope As Scope, low As Long, high As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the range step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Range``1(System.Int64,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the range step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Range<E2>(long low, long high)","parameters":[{"id":"low","type":"System.Int64"},{"id":"high","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Range(Of E2)(low As Long, high As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the range step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Repeat(System.String,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the repeat step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Repeat(string loopName, ITraversal traversal)","parameters":[{"id":"loopName","type":"System.String"},{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Repeat(loopName As String, traversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the repeat step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Repeat(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the repeat step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Repeat(ITraversal traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Repeat(traversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the repeat step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sack``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sack step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Sack<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Sack(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sack step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sack(Gremlin.Net.Process.Traversal.IBiFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sack step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Sack(IBiFunction sackOperator)","parameters":[{"id":"sackOperator","type":"Gremlin.Net.Process.Traversal.IBiFunction"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Sack(sackOperator As IBiFunction) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sack step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sample(Gremlin.Net.Process.Traversal.Scope,System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sample step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Sample(Scope scope, int amountToSample)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"amountToSample","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Sample(scope As Scope, amountToSample As Integer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sample step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sample(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sample step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Sample(int amountToSample)","parameters":[{"id":"amountToSample","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Sample(amountToSample As Integer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sample step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(Gremlin.Net.Process.Traversal.Column)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, ICollection<E2>> Select<E2>(Column column)","parameters":[{"id":"column","type":"Gremlin.Net.Process.Traversal.Column"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.ICollection{{E2}}}"},"content.vb":"Public Shared Function Select(Of E2)(column As Column) As GraphTraversal(Of Object, ICollection(Of E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(Gremlin.Net.Process.Traversal.Pop,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Select<E2>(Pop pop, string selectKey)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"selectKey","type":"System.String"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Select(Of E2)(pop As Pop, selectKey As String) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(Gremlin.Net.Process.Traversal.Pop,System.String,System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<string, E2>> Select<E2>(Pop pop, string selectKey1, string selectKey2, params string[] otherSelectKeys)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"selectKey1","type":"System.String"},{"id":"selectKey2","type":"System.String"},{"id":"otherSelectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Shared Function Select(Of E2)(pop As Pop, selectKey1 As String, selectKey2 As String, ParamArray otherSelectKeys As String()) As GraphTraversal(Of Object, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(Gremlin.Net.Process.Traversal.Pop,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Select<E2>(Pop pop, ITraversal keyTraversal)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"keyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Select(Of E2)(pop As Pop, keyTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Select<E2>(string selectKey)","parameters":[{"id":"selectKey","type":"System.String"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Select(Of E2)(selectKey As String) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(System.String,System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<string, E2>> Select<E2>(string selectKey1, string selectKey2, params string[] otherSelectKeys)","parameters":[{"id":"selectKey1","type":"System.String"},{"id":"selectKey2","type":"System.String"},{"id":"otherSelectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Shared Function Select(Of E2)(selectKey1 As String, selectKey2 As String, ParamArray otherSelectKeys As String()) As GraphTraversal(Of Object, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Select``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Select<E2>(ITraversal keyTraversal)","parameters":[{"id":"keyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Select(Of E2)(keyTraversal As ITraversal) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the select step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.SideEffect(Gremlin.Net.Process.Traversal.IConsumer)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sideEffect step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> SideEffect(IConsumer consumer)","parameters":[{"id":"consumer","type":"Gremlin.Net.Process.Traversal.IConsumer"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function SideEffect(consumer As IConsumer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sideEffect step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.SideEffect(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sideEffect step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> SideEffect(ITraversal sideEffectTraversal)","parameters":[{"id":"sideEffectTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function SideEffect(sideEffectTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sideEffect step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.SimplePath","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the simplePath step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> SimplePath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function SimplePath As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the simplePath step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Skip``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the skip step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Skip<E2>(Scope scope, long skip)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"skip","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Skip(Of E2)(scope As Scope, skip As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the skip step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Skip``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the skip step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Skip<E2>(long skip)","parameters":[{"id":"skip","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Skip(Of E2)(skip As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the skip step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Store(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the store step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Store(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Store(sideEffectKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the store step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Subgraph(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the subgraph step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> Subgraph(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function Subgraph(sideEffectKey As String) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the subgraph step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sum``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sum step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Sum<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Sum(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sum step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Sum``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sum step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Sum<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Sum(Of E2)(scope As Scope) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the sum step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tail``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Tail<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Tail(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tail``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Tail<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Tail(Of E2)(scope As Scope) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tail``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Tail<E2>(Scope scope, long limit)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Tail(Of E2)(scope As Scope, limit As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tail``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Tail<E2>(long limit)","parameters":[{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Tail(Of E2)(limit As Long) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tail step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.TimeLimit(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the timeLimit step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> TimeLimit(long timeLimit)","parameters":[{"id":"timeLimit","type":"System.Int64"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function TimeLimit(timeLimit As Long) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the timeLimit step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Times(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the times step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Times(int maxLoops)","parameters":[{"id":"maxLoops","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Times(maxLoops As Integer) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the times step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.To(Gremlin.Net.Process.Traversal.Direction,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the to step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> To(Direction direction, params string[] edgeLabels)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"},{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function To(direction As Direction, ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the to step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.ToE(Gremlin.Net.Process.Traversal.Direction,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the toE step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Edge> ToE(Direction direction, params string[] edgeLabels)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"},{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Edge}"},"content.vb":"Public Shared Function ToE(direction As Direction, ParamArray edgeLabels As String()) As GraphTraversal(Of Object, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the toE step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.ToV(Gremlin.Net.Process.Traversal.Direction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the toV step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, Vertex> ToV(Direction direction)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,Vertex}"},"content.vb":"Public Shared Function ToV(direction As Direction) As GraphTraversal(Of Object, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the toV step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tree``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tree step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Tree<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Tree(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tree step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Tree(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tree step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Tree(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Tree(sideEffectKey As String) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the tree step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Unfold``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the unfold step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Unfold<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Unfold(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the unfold step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Union``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the union step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Union<E2>(params ITraversal[] traversals)","parameters":[{"id":"traversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Union(Of E2)(ParamArray traversals As ITraversal()) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the union step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Until(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the until step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Until(IPredicate untilPredicate)","parameters":[{"id":"untilPredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Until(untilPredicate As IPredicate) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the until step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Until(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the until step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Until(ITraversal untilTraversal)","parameters":[{"id":"untilTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Until(untilTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the until step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Value``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the value step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Value<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Value(Of E2) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the value step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.ValueMap``2(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the valueMap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<TKey, TValue>> ValueMap<TKey, TValue>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"TKey"},{"id":"TValue"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{{TKey},{TValue}}}"},"content.vb":"Public Shared Function ValueMap(Of TKey, TValue)(ParamArray propertyKeys As String()) As GraphTraversal(Of Object, IDictionary(Of TKey, TValue))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the valueMap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.ValueMap``2(System.Boolean,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the valueMap step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, IDictionary<TKey, TValue>> ValueMap<TKey, TValue>(bool includeTokens, params string[] propertyKeys)","parameters":[{"id":"includeTokens","type":"System.Boolean"},{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"TKey"},{"id":"TValue"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Collections.Generic.IDictionary{{TKey},{TValue}}}"},"content.vb":"Public Shared Function ValueMap(Of TKey, TValue)(includeTokens As Boolean, ParamArray propertyKeys As String()) As GraphTraversal(Of Object, IDictionary(Of TKey, TValue))"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the valueMap step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Values``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the values step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, E2> Values<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,{E2}}"},"content.vb":"Public Shared Function Values(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of Object, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the values step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Where(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Where(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Where(predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Where(System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Where(string startKey, P predicate)","parameters":[{"id":"startKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Where(startKey As String, predicate As P) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.__.Where(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversal<object, object> Where(ITraversal whereTraversal)","parameters":[{"id":"whereTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{System.Object,System.Object}"},"content.vb":"Public Shared Function Where(whereTraversal As ITraversal) As GraphTraversal(Of Object, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.__.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.__.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> and adds the where step to that traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Verification.LambdaRestrictionStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Verification.LambdaRestrictionStrategy.yml\" sourcestartlinenumber=\"2\">Does not allow lambdas to be used in a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class LambdaRestrictionStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class LambdaRestrictionStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Verification.LambdaRestrictionStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Column","Type":"class","Syntax":{"content":"public class Column : EnumWrapper, IEquatable<EnumWrapper>, IFunction","content.vb":"Public Class Column\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper), IFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Column.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Column.Keys","Type":"property","Syntax":{"content":"public static Column Keys { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Column"},"content.vb":"Public Shared ReadOnly Property Keys As Column"},"File":"obj/api/Gremlin.Net.Process.Traversal.Column.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Column.Values","Type":"property","Syntax":{"content":"public static Column Values { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Column"},"content.vb":"Public Shared ReadOnly Property Values As Column"},"File":"obj/api/Gremlin.Net.Process.Traversal.Column.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Column.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Column.yml\" sourcestartlinenumber=\"2\">Gets the Column enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Column GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Column"},"content.vb":"Public Shared Function GetByValue(value As String) As Column"},"File":"obj/api/Gremlin.Net.Process.Traversal.Column.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Column.yml\" sourcestartlinenumber=\"2\">Gets the Column enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Associates a variable with a value.</p>\n","Type":"class","Syntax":{"content":"public class Binding : IEquatable<Binding>","content.vb":"Public Class Binding\n    Implements IEquatable(Of Binding)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.#ctor(System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Binding(string key, object value)","parameters":[{"id":"key","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"1\">The key that identifies the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"1\">The value of the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Public Sub New(key As String, value As Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.Key","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Gets the key that identifies the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public string Key { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Key As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Gets the key that identifies the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.Value","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Gets the value of the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public object Value { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Value As Object"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Binding.yml\" sourcestartlinenumber=\"2\">Gets the value of the <xref href=\"Gremlin.Net.Process.Traversal.Binding\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.Equals(Gremlin.Net.Process.Traversal.Binding)","Type":"method","Syntax":{"content":"public bool Equals(Binding other)","parameters":[{"id":"other","type":"Gremlin.Net.Process.Traversal.Binding"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As Binding) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object other)","parameters":[{"id":"other","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(other As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Binding.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Binding.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Structure.Property\" data-throw-if-not-resolved=\"false\"></xref> denotes a key/value pair associated with an <xref href=\"Gremlin.Net.Structure.Edge\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class Property : IEquatable<Property>","content.vb":"Public Class Property\n    Implements IEquatable(Of  Property)"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.#ctor(System.String,System.Object,Gremlin.Net.Structure.Element)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Property\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Property(string key, dynamic value, Element element)","parameters":[{"id":"key","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"1\">The key of the property.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"1\">The value of the property.</p>\n"},{"id":"element","type":"Gremlin.Net.Structure.Element","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"1\">The element that the property is associated with.</p>\n"}],"content.vb":"Public Sub New(key As String, value As Object, element As Element)"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Property\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.Key","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the key of the property.</p>\n","Type":"property","Syntax":{"content":"public string Key { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Key As String"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the key of the property.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.Value","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the value of the property.</p>\n","Type":"property","Syntax":{"content":"public dynamic Value { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Value As Object"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the value of the property.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.Element","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the element that this property is associated with.</p>\n","Type":"property","Syntax":{"content":"public Element Element { get; }","parameters":[],"return":{"type":"Gremlin.Net.Structure.Element"},"content.vb":"Public ReadOnly Property Element As Element"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Property.yml\" sourcestartlinenumber=\"2\">Gets the element that this property is associated with.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.Equals(Gremlin.Net.Structure.Property)","Type":"method","Syntax":{"content":"public bool Equals(Property other)","parameters":[{"id":"other","type":"Gremlin.Net.Structure.Property"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As  Property) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Property.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Structure.Property.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Handles deserialization of GraphSON3 data.</p>\n","Type":"class","Syntax":{"content":"public class GraphSON3Reader : GraphSONReader","content.vb":"Public Class GraphSON3Reader\n    Inherits GraphSONReader"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON3Reader()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON3Reader(IReadOnlyDictionary<string, IGraphSONDeserializer> deserializerByGraphSONType)","parameters":[{"id":"deserializerByGraphSONType","type":"System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Overrides <xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer\" data-throw-if-not-resolved=\"false\"></xref> instances by their type identifier.</p>\n"}],"content.vb":"Public Sub New(deserializerByGraphSONType As IReadOnlyDictionary(Of String, IGraphSONDeserializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.MatchPredicateStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.MatchPredicateStrategy.yml\" sourcestartlinenumber=\"2\">Folds any post<code>Where()</code> step that maintains a traversal constraint into <code>Match()</code>.</p>\n","Type":"class","Syntax":{"content":"public class MatchPredicateStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class MatchPredicateStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.MatchPredicateStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml\" sourcestartlinenumber=\"2\">Handles deserialization of GraphSON3 data.</p>\n","Type":"class","Syntax":{"content":"public class GraphSON2Reader : GraphSONReader","content.vb":"Public Class GraphSON2Reader\n    Inherits GraphSONReader"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON2Reader()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON2Reader(IReadOnlyDictionary<string, IGraphSONDeserializer> deserializerByGraphSONType)","parameters":[{"id":"deserializerByGraphSONType","type":"System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer}"}],"content.vb":"Public Sub New(deserializerByGraphSONType As IReadOnlyDictionary(Of String, IGraphSONDeserializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Reader\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Graph","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Graph.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Structure.Graph\" data-throw-if-not-resolved=\"false\"></xref> is a container object for a collection of <xref href=\"Gremlin.Net.Structure.Vertex\" data-throw-if-not-resolved=\"false\"></xref>, <xref href=\"Gremlin.Net.Structure.Edge\" data-throw-if-not-resolved=\"false\"></xref>,\n<xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>, and <xref href=\"Gremlin.Net.Structure.Property\" data-throw-if-not-resolved=\"false\"></xref> objects.</p>\n","Type":"class","Syntax":{"content":"public class Graph","content.vb":"Public Class Graph"},"File":"obj/api/Gremlin.Net.Structure.Graph.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Graph.Traversal","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Graph.yml\" sourcestartlinenumber=\"2\">Generates a reusable <see cref=\"!:GraphTraversalSource\"></see> instance.</p>\n","Type":"method","Syntax":{"content":"[Obsolete(\"As of release 3.3.5, replaced by AnonymousTraversalSource.Traversal() called statically.\", false)]\npublic GraphTraversalSource Traversal()","return":{"type":"GraphTraversalSource","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Graph.yml\" sourcestartlinenumber=\"1\">A graph traversal source.</p>\n"},"content.vb":"<Obsolete(\"As of release 3.3.5, replaced by AnonymousTraversalSource.Traversal() called statically.\", False)>\nPublic Function Traversal As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Structure.Graph.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Graph.yml\" sourcestartlinenumber=\"2\">Generates a reusable <see cref=\"!:GraphTraversalSource\"></see> instance.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">A common base class for Graph elements.</p>\n","Type":"class","Syntax":{"content":"public abstract class Element : IEquatable<Element>","content.vb":"Public MustInherit Class Element\n    Implements IEquatable(Of Element)"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.#ctor(System.Object,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected Element(object id, string label)","parameters":[{"id":"id","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"1\">The id of the element.</p>\n"},{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"1\">The label of the element.</p>\n"}],"content.vb":"Protected Sub New(id As Object, label As String)"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.Id","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Gets the id of this <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public object Id { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Id As Object"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Gets the id of this <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.Label","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Gets the label of this <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public string Label { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Label As String"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Element.yml\" sourcestartlinenumber=\"2\">Gets the label of this <xref href=\"Gremlin.Net.Structure.Element\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.Equals(Gremlin.Net.Structure.Element)","Type":"method","Syntax":{"content":"public bool Equals(Element other)","parameters":[{"id":"other","type":"Gremlin.Net.Structure.Element"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As Element) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Element.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Structure.Element.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Edge","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Represents an edge between to vertices.</p>\n","Type":"class","Syntax":{"content":"public class Edge : Element, IEquatable<Element>","content.vb":"Public Class Edge\n    Inherits Element\n    Implements IEquatable(Of Element)"},"File":"obj/api/Gremlin.Net.Structure.Edge.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Edge.#ctor(System.Object,Gremlin.Net.Structure.Vertex,System.String,Gremlin.Net.Structure.Vertex)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Edge\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Edge(object id, Vertex outV, string label, Vertex inV)","parameters":[{"id":"id","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"1\">The id of the edge.</p>\n"},{"id":"outV","type":"Gremlin.Net.Structure.Vertex","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"1\">The outgoing/tail vertex of the edge.</p>\n"},{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"1\">The label of the edge.</p>\n"},{"id":"inV","type":"Gremlin.Net.Structure.Vertex","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"1\">The incoming/head vertex of the edge.</p>\n"}],"content.vb":"Public Sub New(id As Object, outV As Vertex, label As String, inV As Vertex)"},"File":"obj/api/Gremlin.Net.Structure.Edge.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Edge\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Edge.InV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Gets or sets the incoming/head vertex of this edge.</p>\n","Type":"property","Syntax":{"content":"public Vertex InV { get; set; }","parameters":[],"return":{"type":"Gremlin.Net.Structure.Vertex"},"content.vb":"Public Property InV As Vertex"},"File":"obj/api/Gremlin.Net.Structure.Edge.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Gets or sets the incoming/head vertex of this edge.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Edge.OutV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Gets or sets the outgoing/tail vertex of this edge.</p>\n","Type":"property","Syntax":{"content":"public Vertex OutV { get; set; }","parameters":[],"return":{"type":"Gremlin.Net.Structure.Vertex"},"content.vb":"Public Property OutV As Vertex"},"File":"obj/api/Gremlin.Net.Structure.Edge.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Edge.yml\" sourcestartlinenumber=\"2\">Gets or sets the outgoing/tail vertex of this edge.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Edge.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Structure.Edge.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.RepeatUnrollStrategy","Type":"class","Syntax":{"content":"public class RepeatUnrollStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class RepeatUnrollStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.RepeatUnrollStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.RangeByIsCountStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.RangeByIsCountStrategy.yml\" sourcestartlinenumber=\"2\">Optimizes any occurrence of <code>Count()</code>-step followed by an <code>Is()</code>-step.</p>\n","Type":"class","Syntax":{"content":"public class RangeByIsCountStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class RangeByIsCountStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.RangeByIsCountStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.PathRetractionStrategy","Type":"class","Syntax":{"content":"public class PathRetractionStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class PathRetractionStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.PathRetractionStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.PathProcessorStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.PathProcessorStrategy.yml\" sourcestartlinenumber=\"2\">Helps to ensure that more traversals meet the local child constraint imposed on OLAP traversals.</p>\n","Type":"class","Syntax":{"content":"public class PathProcessorStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class PathProcessorStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.PathProcessorStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bindings","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"2\">Bindings are used to associate a variable with a value.</p>\n","Type":"class","Syntax":{"content":"public class Bindings","content.vb":"Public Class Bindings"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bindings.Instance","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"2\">Gets an instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bindings\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"property","Syntax":{"content":"public static Bindings Instance { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Bindings"},"content.vb":"Public Shared ReadOnly Property Instance As Bindings"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"2\">Gets an instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bindings\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bindings.Of``1(System.String,``0)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"2\">Binds the variable to the specified value.</p>\n","Type":"method","Syntax":{"content":"public TV Of<TV>(string variable, TV value)","parameters":[{"id":"variable","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"1\">The variable to bind.</p>\n"},{"id":"value","type":"{TV}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"1\">The value to which the variable should be bound.</p>\n"}],"typeParameters":[{"id":"TV"}],"return":{"type":"{TV}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"1\">The bound value.</p>\n"},"content.vb":"Public Function Of(Of TV)(variable As String, value As TV) As TV"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bindings.yml\" sourcestartlinenumber=\"2\">Binds the variable to the specified value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver","Type":"namespace","File":"obj/api/Gremlin.Net.Driver.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.ResultSet`1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"2\">A ResultSet is returned from the submission of a Gremlin script to the server and represents the results\nprovided by the server. ResultSet includes enumerable data and status attributes.</p>\n","Type":"class","Syntax":{"content":"public sealed class ResultSet<T> : IReadOnlyCollection<T>, IEnumerable<T>, IEnumerable","typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"1\">Type of the result elements</p>\n"}],"content.vb":"Public NotInheritable Class ResultSet(Of T)\n    Implements IReadOnlyCollection(Of T), IEnumerable(Of T), IEnumerable"},"File":"obj/api/Gremlin.Net.Driver.ResultSet-1.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.ResultSet`1.StatusAttributes","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"2\">Gets or sets the status attributes from the gremlin response</p>\n","Type":"property","Syntax":{"content":"public IReadOnlyDictionary<string, object> StatusAttributes { get; }","parameters":[],"return":{"type":"System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object}"},"content.vb":"Public ReadOnly Property StatusAttributes As IReadOnlyDictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Driver.ResultSet-1.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"2\">Gets or sets the status attributes from the gremlin response</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.ResultSet`1.#ctor(System.Collections.Generic.IReadOnlyCollection{`0},System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the ResultSet class for the specified data and status attributes.</p>\n","Type":"constructor","Syntax":{"content":"public ResultSet(IReadOnlyCollection<T> data, IReadOnlyDictionary<string, object> attributes)","parameters":[{"id":"data","type":"System.Collections.Generic.IReadOnlyCollection{{T}}","description":""},{"id":"attributes","type":"System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object}","description":""}],"content.vb":"Public Sub New(data As IReadOnlyCollection(Of T), attributes As IReadOnlyDictionary(Of String, Object))"},"File":"obj/api/Gremlin.Net.Driver.ResultSet-1.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.ResultSet-1.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the ResultSet class for the specified data and status attributes.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.ResultSet`1.GetEnumerator","Type":"method","Syntax":{"content":"public IEnumerator<T> GetEnumerator()","return":{"type":"System.Collections.Generic.IEnumerator{{T}}"},"content.vb":"Public Function GetEnumerator As IEnumerator(Of T)"},"File":"obj/api/Gremlin.Net.Driver.ResultSet-1.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.ResultSet`1.Count","Type":"property","Syntax":{"content":"public int Count { get; }","parameters":[],"return":{"type":"System.Int32"},"content.vb":"Public ReadOnly Property Count As Integer"},"File":"obj/api/Gremlin.Net.Driver.ResultSet-1.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages","Type":"namespace","File":"obj/api/Gremlin.Net.Driver.Messages.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.IGremlinClient","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"2\">Provides a mechanism for submitting Gremlin requests.</p>\n","Type":"interface","Syntax":{"content":"public interface IGremlinClient : IDisposable","content.vb":"Public Interface IGremlinClient\n    Inherits IDisposable"},"File":"obj/api/Gremlin.Net.Driver.IGremlinClient.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.IGremlinClient.SubmitAsync``1(Gremlin.Net.Driver.Messages.RequestMessage)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation.</p>\n","Type":"method","Syntax":{"content":"Task<ResultSet<T>> SubmitAsync<T>(RequestMessage requestMessage)","parameters":[{"id":"requestMessage","type":"Gremlin.Net.Driver.Messages.RequestMessage","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> to send.</p>\n"}],"typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"1\">The type of the expected results.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{Gremlin.Net.Driver.ResultSet{{T}}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Driver.ResultSet%601\" data-throw-if-not-resolved=\"false\"></xref> containing the data and status attributes returned from the server.</p>\n"},"content.vb":"Function SubmitAsync(Of T)(requestMessage As RequestMessage) As Task(Of ResultSet(Of T))"},"File":"obj/api/Gremlin.Net.Driver.IGremlinClient.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.IGremlinClient.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Provides a mechanism for submitting Gremlin requests to one Gremlin Server.</p>\n","Type":"class","Syntax":{"content":"public class GremlinClient : IGremlinClient, IDisposable","content.vb":"Public Class GremlinClient\n    Implements IGremlinClient, IDisposable"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.DefaultMimeType","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Defines the default mime type to use.</p>\n","Type":"field","Syntax":{"content":"public const string DefaultMimeType = \"application/vnd.gremlin-v3.0+json\"","return":{"type":"System.String"},"content.vb":"Public Const DefaultMimeType As String = \"application/vnd.gremlin-v3.0+json\""},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Defines the default mime type to use.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.GraphSON2MimeType","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">The GraphSON2 mime type to use.</p>\n","Type":"field","Syntax":{"content":"public const string GraphSON2MimeType = \"application/vnd.gremlin-v2.0+json\"","return":{"type":"System.String"},"content.vb":"Public Const GraphSON2MimeType As String = \"application/vnd.gremlin-v2.0+json\""},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">The GraphSON2 mime type to use.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.#ctor(Gremlin.Net.Driver.GremlinServer,Gremlin.Net.Structure.IO.GraphSON.GraphSONReader,Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter,System.String,System.Action{ClientWebSocketOptions})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.GremlinClient\" data-throw-if-not-resolved=\"false\"></xref> class for the specified Gremlin Server.</p>\n","Type":"constructor","Syntax":{"content":"public GremlinClient(GremlinServer gremlinServer, GraphSONReader graphSONReader = null, GraphSONWriter graphSONWriter = null, string mimeType = null, Action<ClientWebSocketOptions> webSocketConfiguration = null)","parameters":[{"id":"gremlinServer","type":"Gremlin.Net.Driver.GremlinServer","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.GremlinServer\" data-throw-if-not-resolved=\"false\"></xref> the requests should be sent to.</p>\n"},{"id":"graphSONReader","type":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> instance to read received GraphSON data.</p>\n"},{"id":"graphSONWriter","type":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">a <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> instance to write GraphSON data.</p>\n"},{"id":"mimeType","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">The GraphSON version mime type, defaults to latest supported by the server.</p>\n"},{"id":"webSocketConfiguration","type":"System.Action{ClientWebSocketOptions}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">A delegate that will be invoked with the <see cref=\"!:ClientWebSocketOptions\"></see>\nobject used to configure WebSocket connections.</p>\n"}],"content.vb":"Public Sub New(gremlinServer As GremlinServer, graphSONReader As GraphSONReader = Nothing, graphSONWriter As GraphSONWriter = Nothing, mimeType As String = Nothing, webSocketConfiguration As Action(Of ClientWebSocketOptions) = Nothing)"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.GremlinClient\" data-throw-if-not-resolved=\"false\"></xref> class for the specified Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.NrConnections","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Gets the number of open connections.</p>\n","Type":"property","Syntax":{"content":"public int NrConnections { get; }","parameters":[],"return":{"type":"System.Int32"},"content.vb":"Public ReadOnly Property NrConnections As Integer"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Gets the number of open connections.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.SubmitAsync``1(Gremlin.Net.Driver.Messages.RequestMessage)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation.</p>\n","Type":"method","Syntax":{"content":"public Task<ResultSet<T>> SubmitAsync<T>(RequestMessage requestMessage)","parameters":[{"id":"requestMessage","type":"Gremlin.Net.Driver.Messages.RequestMessage","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> to send.</p>\n"}],"typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">The type of the expected results.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{Gremlin.Net.Driver.ResultSet{{T}}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Driver.ResultSet%601\" data-throw-if-not-resolved=\"false\"></xref> containing the data and status attributes returned from the server.</p>\n"},"content.vb":"Public Function SubmitAsync(Of T)(requestMessage As RequestMessage) As Task(Of ResultSet(Of T))"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.Dispose","Type":"method","Syntax":{"content":"public void Dispose()","content.vb":"Public Sub Dispose"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClient.Dispose(System.Boolean)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Releases the resources used by the <xref href=\"Gremlin.Net.Driver.GremlinClient\" data-throw-if-not-resolved=\"false\"></xref> instance.</p>\n","Type":"method","Syntax":{"content":"protected virtual void Dispose(bool disposing)","parameters":[{"id":"disposing","type":"System.Boolean","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"1\">Specifies whether managed resources should be released.</p>\n"}],"content.vb":"Protected Overridable Sub Dispose(disposing As Boolean)"},"File":"obj/api/Gremlin.Net.Driver.GremlinClient.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClient.yml\" sourcestartlinenumber=\"2\">Releases the resources used by the <xref href=\"Gremlin.Net.Driver.GremlinClient\" data-throw-if-not-resolved=\"false\"></xref> instance.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PageRank","Type":"class","Syntax":{"content":"public class PageRank","content.vb":"Public Class PageRank"},"File":"obj/api/Gremlin.Net.Process.Traversal.PageRank.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PageRank.edges","Type":"field","Syntax":{"content":"public const string edges = \"~tinkerpop.pageRank.edges\"","return":{"type":"System.String"},"content.vb":"Public Const edges As String = \"~tinkerpop.pageRank.edges\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PageRank.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PageRank.propertyName","Type":"field","Syntax":{"content":"public const string propertyName = \"~tinkerpop.pageRank.propertyName\"","return":{"type":"System.String"},"content.vb":"Public Const propertyName As String = \"~tinkerpop.pageRank.propertyName\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PageRank.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PageRank.times","Type":"field","Syntax":{"content":"public const string times = \"~tinkerpop.pageRank.times\"","return":{"type":"System.String"},"content.vb":"Public Const times As String = \"~tinkerpop.pageRank.times\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PageRank.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Instruction","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Represents a <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> instruction by an operator name and its arguments.</p>\n","Type":"class","Syntax":{"content":"public class Instruction","content.vb":"Public Class Instruction"},"File":"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Instruction.#ctor(System.String,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Instruction\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Instruction(string operatorName, params dynamic[] arguments)","parameters":[{"id":"operatorName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"1\">The name of the operator.</p>\n"},{"id":"arguments","type":"System.Object[]","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"1\">The arguments.</p>\n"}],"content.vb":"Public Sub New(operatorName As String, ParamArray arguments As Object())"},"File":"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Instruction\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Instruction.OperatorName","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Gets the name of the operator.</p>\n","Type":"property","Syntax":{"content":"public string OperatorName { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property OperatorName As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Gets the name of the operator.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Instruction.Arguments","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Gets the arguments.</p>\n","Type":"property","Syntax":{"content":"public dynamic[] Arguments { get; }","parameters":[],"return":{"type":"System.Object[]"},"content.vb":"Public ReadOnly Property Arguments As Object()"},"File":"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Instruction.yml\" sourcestartlinenumber=\"2\">Gets the arguments.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IUnaryOperator","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IUnaryOperator.yml\" sourcestartlinenumber=\"2\">Represents an operation on a single operand that produces a result of the same type as its operand. This is a\nspecialization of Function for the case where the operand and result are of the same type.</p>\n","Type":"interface","Syntax":{"content":"public interface IUnaryOperator : IFunction","content.vb":"Public Interface IUnaryOperator\n    Inherits IFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.IUnaryOperator.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO","Type":"class","Syntax":{"content":"public class IO","content.vb":"Public Class IO"},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.graphml","Type":"field","Syntax":{"content":"public const string graphml = \"graphml\"","return":{"type":"System.String"},"content.vb":"Public Const graphml As String = \"graphml\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.graphson","Type":"field","Syntax":{"content":"public const string graphson = \"graphson\"","return":{"type":"System.String"},"content.vb":"Public Const graphson As String = \"graphson\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.gryo","Type":"field","Syntax":{"content":"public const string gryo = \"gryo\"","return":{"type":"System.String"},"content.vb":"Public Const gryo As String = \"gryo\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.reader","Type":"field","Syntax":{"content":"public const string reader = \"~tinkerpop.io.reader\"","return":{"type":"System.String"},"content.vb":"Public Const reader As String = \"~tinkerpop.io.reader\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.registry","Type":"field","Syntax":{"content":"public const string registry = \"~tinkerpop.io.registry\"","return":{"type":"System.String"},"content.vb":"Public Const registry As String = \"~tinkerpop.io.registry\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IO.writer","Type":"field","Syntax":{"content":"public const string writer = \"~tinkerpop.io.writer\"","return":{"type":"System.String"},"content.vb":"Public Const writer As String = \"~tinkerpop.io.writer\""},"File":"obj/api/Gremlin.Net.Process.Traversal.IO.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ILambda","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Represents a lambda.</p>\n","Type":"interface","Syntax":{"content":"public interface ILambda : IPredicate, IUnaryOperator, IFunction, IBinaryOperator, IBiFunction, IComparator, IConsumer, ISupplier","content.vb":"Public Interface ILambda\n    Inherits IFunction, IBiFunction, IPredicate, IUnaryOperator, IBinaryOperator, IComparator, IConsumer, ISupplier"},"File":"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ILambda.LambdaExpression","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the lambda expression.</p>\n","Type":"property","Syntax":{"content":"string LambdaExpression { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"ReadOnly Property LambdaExpression As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the lambda expression.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ILambda.Language","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the language of this lambda.</p>\n","Type":"property","Syntax":{"content":"string Language { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"ReadOnly Property Language As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the language of this lambda.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ILambda.Arguments","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the arguments of this lambda.</p>\n","Type":"property","Syntax":{"content":"object Arguments { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"ReadOnly Property Arguments As Object"},"File":"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ILambda.yml\" sourcestartlinenumber=\"2\">Gets the arguments of this lambda.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> is the primary DSL of the Gremlin traversal machine.\nIt provides access to all the configurations and steps for Turing complete graph computing.</p>\n","Type":"class","Syntax":{"content":"public class GraphTraversalSource","content.vb":"Public Class GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.TraversalStrategies","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Gets or sets the traversal strategies associated with this graph traversal source.</p>\n","Type":"property","Syntax":{"content":"public ICollection<ITraversalStrategy> TraversalStrategies { get; set; }","parameters":[],"return":{"type":"System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy}"},"content.vb":"Public Property TraversalStrategies As ICollection(Of ITraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Gets or sets the traversal strategies associated with this graph traversal source.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.Bytecode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> associated with the current state of this graph traversal\nsource.</p>\n","Type":"property","Syntax":{"content":"public Bytecode Bytecode { get; set; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Bytecode"},"content.vb":"Public Property Bytecode As Bytecode"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Gets or sets the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> associated with the current state of this graph traversal\nsource.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public GraphTraversalSource()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.#ctor(System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy},Gremlin.Net.Process.Traversal.Bytecode)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public GraphTraversalSource(ICollection<ITraversalStrategy> traversalStrategies, Bytecode bytecode)","parameters":[{"id":"traversalStrategies","type":"System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"1\">The traversal strategies associated with this graph traversal source.</p>\n"},{"id":"bytecode","type":"Gremlin.Net.Process.Traversal.Bytecode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">The <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> associated with the current state of this graph traversal\nsource.</p>\n"}],"content.vb":"Public Sub New(traversalStrategies As ICollection(Of ITraversalStrategy), bytecode As Bytecode)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.With(System.String)","Type":"method","Syntax":{"content":"public GraphTraversalSource With(string key)","parameters":[{"id":"key","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function With(key As String) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.With(System.String,System.Object)","Type":"method","Syntax":{"content":"public GraphTraversalSource With(string key, object value)","parameters":[{"id":"key","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function With(key As String, value As Object) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithBulk(System.Boolean)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithBulk(bool useBulk)","parameters":[{"id":"useBulk","type":"System.Boolean"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithBulk(useBulk As Boolean) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithPath","Type":"method","Syntax":{"content":"public GraphTraversalSource WithPath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithPath As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(System.Object)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(object initialValue)","parameters":[{"id":"initialValue","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As Object) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(System.Object,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(object initialValue, IBinaryOperator mergeOperator)","parameters":[{"id":"initialValue","type":"System.Object"},{"id":"mergeOperator","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As Object, mergeOperator As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(System.Object,Gremlin.Net.Process.Traversal.IUnaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(object initialValue, IUnaryOperator splitOperator)","parameters":[{"id":"initialValue","type":"System.Object"},{"id":"splitOperator","type":"Gremlin.Net.Process.Traversal.IUnaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As Object, splitOperator As IUnaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(System.Object,Gremlin.Net.Process.Traversal.IUnaryOperator,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(object initialValue, IUnaryOperator splitOperator, IBinaryOperator mergeOperator)","parameters":[{"id":"initialValue","type":"System.Object"},{"id":"splitOperator","type":"Gremlin.Net.Process.Traversal.IUnaryOperator"},{"id":"mergeOperator","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As Object, splitOperator As IUnaryOperator, mergeOperator As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(Gremlin.Net.Process.Traversal.ISupplier)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(ISupplier initialValue)","parameters":[{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As ISupplier) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(Gremlin.Net.Process.Traversal.ISupplier,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(ISupplier initialValue, IBinaryOperator mergeOperator)","parameters":[{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"},{"id":"mergeOperator","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As ISupplier, mergeOperator As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(Gremlin.Net.Process.Traversal.ISupplier,Gremlin.Net.Process.Traversal.IUnaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(ISupplier initialValue, IUnaryOperator splitOperator)","parameters":[{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"},{"id":"splitOperator","type":"Gremlin.Net.Process.Traversal.IUnaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As ISupplier, splitOperator As IUnaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSack(Gremlin.Net.Process.Traversal.ISupplier,Gremlin.Net.Process.Traversal.IUnaryOperator,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSack(ISupplier initialValue, IUnaryOperator splitOperator, IBinaryOperator mergeOperator)","parameters":[{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"},{"id":"splitOperator","type":"Gremlin.Net.Process.Traversal.IUnaryOperator"},{"id":"mergeOperator","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSack(initialValue As ISupplier, splitOperator As IUnaryOperator, mergeOperator As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSideEffect(System.String,System.Object)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSideEffect(string key, object initialValue)","parameters":[{"id":"key","type":"System.String"},{"id":"initialValue","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSideEffect(key As String, initialValue As Object) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSideEffect(System.String,System.Object,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSideEffect(string key, object initialValue, IBinaryOperator reducer)","parameters":[{"id":"key","type":"System.String"},{"id":"initialValue","type":"System.Object"},{"id":"reducer","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSideEffect(key As String, initialValue As Object, reducer As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSideEffect(System.String,Gremlin.Net.Process.Traversal.ISupplier)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSideEffect(string key, ISupplier initialValue)","parameters":[{"id":"key","type":"System.String"},{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSideEffect(key As String, initialValue As ISupplier) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithSideEffect(System.String,Gremlin.Net.Process.Traversal.ISupplier,Gremlin.Net.Process.Traversal.IBinaryOperator)","Type":"method","Syntax":{"content":"public GraphTraversalSource WithSideEffect(string key, ISupplier initialValue, IBinaryOperator reducer)","parameters":[{"id":"key","type":"System.String"},{"id":"initialValue","type":"Gremlin.Net.Process.Traversal.ISupplier"},{"id":"reducer","type":"Gremlin.Net.Process.Traversal.IBinaryOperator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithSideEffect(key As String, initialValue As ISupplier, reducer As IBinaryOperator) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithStrategies(Gremlin.Net.Process.Traversal.ITraversalStrategy[])","Type":"method","Syntax":{"content":"public GraphTraversalSource WithStrategies(params ITraversalStrategy[] traversalStrategies)","parameters":[{"id":"traversalStrategies","type":"Gremlin.Net.Process.Traversal.ITraversalStrategy[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithStrategies(ParamArray traversalStrategies As ITraversalStrategy()) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithoutStrategies(System.Type[])","Type":"method","Syntax":{"content":"public GraphTraversalSource WithoutStrategies(params Type[] traversalStrategyClasses)","parameters":[{"id":"traversalStrategyClasses","type":"System.Type[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithoutStrategies(ParamArray traversalStrategyClasses As Type()) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithBindings(System.Object)","Type":"method","Syntax":{"content":"[Obsolete(\"Use the Bindings class instead.\", false)]\npublic GraphTraversalSource WithBindings(object bindings)","parameters":[{"id":"bindings","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"<Obsolete(\"Use the Bindings class instead.\", False)>\nPublic Function WithBindings(bindings As Object) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithRemote(IRemoteConnection)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Configures the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> as a &quot;remote&quot; to issue the\n<xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> for execution elsewhere.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversalSource WithRemote(IRemoteConnection remoteConnection)","parameters":[{"id":"remoteConnection","type":"IRemoteConnection","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">The <see cref=\"!:IRemoteConnection\"></see> instance to use to submit the\n<xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> configured to use the provided <see cref=\"!:IRemoteConnection\"></see>.</p>\n"},"content.vb":"Public Function WithRemote(remoteConnection As IRemoteConnection) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Configures the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> as a &quot;remote&quot; to issue the\n<xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> for execution elsewhere.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.WithComputer(System.String,System.Nullable{System.Int32},System.String,System.String,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal,System.Collections.Generic.Dictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Add a GraphComputer class used to execute the traversal.\nThis adds a <see cref=\"!:VertexProgramStrategy\"></see> to the strategies.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversalSource WithComputer(string graphComputer = null, int? workers = default(int? ), string persist = null, string result = null, ITraversal vertices = null, ITraversal edges = null, Dictionary<string, dynamic> configuration = null)","parameters":[{"id":"graphComputer","type":"System.String"},{"id":"workers","type":"System.Nullable{System.Int32}"},{"id":"persist","type":"System.String"},{"id":"result","type":"System.String"},{"id":"vertices","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"edges","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"configuration","type":"System.Collections.Generic.Dictionary{System.String,System.Object}"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource"},"content.vb":"Public Function WithComputer(graphComputer As String = Nothing, workers As Integer? = Nothing, persist As String = Nothing, result As String = Nothing, vertices As ITraversal = Nothing, edges As ITraversal = Nothing, configuration As Dictionary(Of String, Object) = Nothing) As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Add a GraphComputer class used to execute the traversal.\nThis adds a <see cref=\"!:VertexProgramStrategy\"></see> to the strategies.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.E(System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the E step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Edge, Edge> E(params object[] edgesIds)","parameters":[{"id":"edgesIds","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Edge,Edge}"},"content.vb":"Public Function E(ParamArray edgesIds As Object()) As GraphTraversal(Of Edge, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the E step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.V(System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the V step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Vertex, Vertex> V(params object[] vertexIds)","parameters":[{"id":"vertexIds","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Vertex,Vertex}"},"content.vb":"Public Function V(ParamArray vertexIds As Object()) As GraphTraversal(Of Vertex, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the V step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.AddE(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addE step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Edge, Edge> AddE(string label)","parameters":[{"id":"label","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Edge,Edge}"},"content.vb":"Public Function AddE(label As String) As GraphTraversal(Of Edge, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addE step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.AddE(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addE step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Edge, Edge> AddE(ITraversal edgeLabelTraversal)","parameters":[{"id":"edgeLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Edge,Edge}"},"content.vb":"Public Function AddE(edgeLabelTraversal As ITraversal) As GraphTraversal(Of Edge, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addE step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.AddV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Vertex, Vertex> AddV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Vertex,Vertex}"},"content.vb":"Public Function AddV As GraphTraversal(Of Vertex, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.AddV(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Vertex, Vertex> AddV(string label)","parameters":[{"id":"label","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Vertex,Vertex}"},"content.vb":"Public Function AddV(label As String) As GraphTraversal(Of Vertex, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.AddV(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<Vertex, Vertex> AddV(ITraversal vertexLabelTraversal)","parameters":[{"id":"vertexLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{Vertex,Vertex}"},"content.vb":"Public Function AddV(vertexLabelTraversal As ITraversal) As GraphTraversal(Of Vertex, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the addV step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.Inject``1(``0[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the inject step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, S> Inject<S>(params S[] starts)","parameters":[{"id":"starts","type":"{S}[]"}],"typeParameters":[{"id":"S"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{S}}"},"content.vb":"Public Function Inject(Of S)(ParamArray starts As S()) As GraphTraversal(Of S, S)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the inject step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversalSource.Io``1(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the io step to that\ntraversal.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, S> Io<S>(string file)","parameters":[{"id":"file","type":"System.String"}],"typeParameters":[{"id":"S"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{S}}"},"content.vb":"Public Function Io(Of S)(file As String) As GraphTraversal(Of S, S)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversalSource.yml\" sourcestartlinenumber=\"2\">Spawns a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> off this graph traversal source and adds the io step to that\ntraversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Represents an enum.</p>\n","Type":"class","Syntax":{"content":"public abstract class EnumWrapper : IEquatable<EnumWrapper>","content.vb":"Public MustInherit Class EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.EnumName","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Gets the name of the enum.</p>\n","Type":"property","Syntax":{"content":"public string EnumName { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property EnumName As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Gets the name of the enum.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.EnumValue","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Gets the value of the enum.</p>\n","Type":"property","Syntax":{"content":"public string EnumValue { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property EnumValue As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Gets the value of the enum.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.#ctor(System.String,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.EnumWrapper\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected EnumWrapper(string enumName, string enumValue)","parameters":[{"id":"enumName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"1\">The name of the enum.</p>\n"},{"id":"enumValue","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"1\">The value of the enum.</p>\n"}],"content.vb":"Protected Sub New(enumName As String, enumValue As String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.EnumWrapper\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.Equals(Gremlin.Net.Process.Traversal.EnumWrapper)","Type":"method","Syntax":{"content":"public bool Equals(EnumWrapper other)","parameters":[{"id":"other","type":"Gremlin.Net.Process.Traversal.EnumWrapper"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As EnumWrapper) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.EnumWrapper.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.EnumWrapper.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Cardinality","Type":"class","Syntax":{"content":"public class Cardinality : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class Cardinality\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Cardinality.List","Type":"property","Syntax":{"content":"public static Cardinality List { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Cardinality"},"content.vb":"Public Shared ReadOnly Property List As Cardinality"},"File":"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Cardinality.Set","Type":"property","Syntax":{"content":"public static Cardinality Set { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Cardinality"},"content.vb":"Public Shared ReadOnly Property Set As Cardinality"},"File":"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Cardinality.Single","Type":"property","Syntax":{"content":"public static Cardinality Single { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Cardinality"},"content.vb":"Public Shared ReadOnly Property Single As Cardinality"},"File":"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Cardinality.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml\" sourcestartlinenumber=\"2\">Gets the Cardinality enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Cardinality GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Cardinality"},"content.vb":"Public Shared Function GetByValue(value As String) As Cardinality"},"File":"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Cardinality.yml\" sourcestartlinenumber=\"2\">Gets the Cardinality enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Barrier","Type":"class","Syntax":{"content":"public class Barrier : EnumWrapper, IEquatable<EnumWrapper>, IConsumer","content.vb":"Public Class Barrier\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper), IConsumer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Barrier.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Barrier.NormSack","Type":"property","Syntax":{"content":"public static Barrier NormSack { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Barrier"},"content.vb":"Public Shared ReadOnly Property NormSack As Barrier"},"File":"obj/api/Gremlin.Net.Process.Traversal.Barrier.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Barrier.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Barrier.yml\" sourcestartlinenumber=\"2\">Gets the Barrier enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Barrier GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Barrier"},"content.vb":"Public Shared Function GetByValue(value As String) As Barrier"},"File":"obj/api/Gremlin.Net.Process.Traversal.Barrier.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Barrier.yml\" sourcestartlinenumber=\"2\">Gets the Barrier enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.RemoteStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml\" sourcestartlinenumber=\"2\">Reconstructs a <see cref=\"!:ITraversal\"></see> by submitting it to a remote server via an\n<xref href=\"Gremlin.Net.Process.Remote.IRemoteConnection\" data-throw-if-not-resolved=\"false\"></xref> instance.</p>\n","Type":"class","Syntax":{"content":"public class RemoteStrategy : ITraversalStrategy","content.vb":"Public Class RemoteStrategy\n    Inherits ITraversalStrategy"},"File":"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.RemoteStrategy.#ctor(Gremlin.Net.Process.Remote.IRemoteConnection)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Remote.RemoteStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public RemoteStrategy(IRemoteConnection remoteConnection)","parameters":[{"id":"remoteConnection","type":"Gremlin.Net.Process.Remote.IRemoteConnection","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Process.Remote.IRemoteConnection\" data-throw-if-not-resolved=\"false\"></xref> that should be used.</p>\n"}],"content.vb":"Public Sub New(remoteConnection As IRemoteConnection)"},"File":"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Remote.RemoteStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.RemoteStrategy.Apply``2(ITraversal{``0,``1})","Type":"method","Syntax":{"content":"public void Apply<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"ITraversal{{S},{E}}"}],"typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Public Sub Apply(Of S, E)(traversal As ITraversal(Of S, E))"},"File":"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.RemoteStrategy.ApplyAsync``2(ITraversal{``0,``1})","Type":"method","Syntax":{"content":"public Task ApplyAsync<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"ITraversal{{S},{E}}"}],"typeParameters":[{"id":"S"},{"id":"E"}],"return":{"type":"System.Threading.Tasks.Task"},"content.vb":"Public Function ApplyAsync(Of S, E)(traversal As ITraversal(Of S, E)) As Task"},"File":"obj/api/Gremlin.Net.Process.Remote.RemoteStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote.DriverRemoteConnection","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">A <see cref=\"!:IRemoteConnection\"></see> implementation for Gremlin Server.</p>\n","Type":"class","Syntax":{"content":"public class DriverRemoteConnection : IRemoteConnection, IDisposable","content.vb":"Public Class DriverRemoteConnection\n    Inherits IRemoteConnection\n    Implements IDisposable"},"File":"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote.DriverRemoteConnection.#ctor(Gremlin.Net.Driver.IGremlinClient)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Initializes a new <see cref=\"!:IRemoteConnection\"></see>.</p>\n","Type":"constructor","Syntax":{"content":"public DriverRemoteConnection(IGremlinClient client)","parameters":[{"id":"client","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that will be used for the connection.</p>\n"}],"content.vb":"Public Sub New(client As IGremlinClient)"},"File":"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Initializes a new <see cref=\"!:IRemoteConnection\"></see>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote.DriverRemoteConnection.#ctor(Gremlin.Net.Driver.IGremlinClient,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Initializes a new <see cref=\"!:IRemoteConnection\"></see>.</p>\n","Type":"constructor","Syntax":{"content":"public DriverRemoteConnection(IGremlinClient client, string traversalSource)","parameters":[{"id":"client","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that will be used for the connection.</p>\n"},{"id":"traversalSource","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"1\">The name of the traversal source on the server to bind to.</p>\n"}],"content.vb":"Public Sub New(client As IGremlinClient, traversalSource As String)"},"File":"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Initializes a new <see cref=\"!:IRemoteConnection\"></see>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote.DriverRemoteConnection.SubmitAsync``2(Bytecode)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Submits <see cref=\"!:Bytecode\"></see> for evaluation to a remote Gremlin Server.</p>\n","Type":"method","Syntax":{"content":"public Task<ITraversal<S, E>> SubmitAsync<S, E>(Bytecode bytecode)","parameters":[{"id":"bytecode","type":"Bytecode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"1\">The <see cref=\"!:Bytecode\"></see> to submit.</p>\n"}],"typeParameters":[{"id":"S"},{"id":"E"}],"return":{"type":"System.Threading.Tasks.Task{ITraversal{{S},{E}}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"1\">A <see cref=\"!:ITraversal\"></see> allowing to access the results and side-effects.</p>\n"},"content.vb":"Public Function SubmitAsync(Of S, E)(bytecode As Bytecode) As Task(Of ITraversal(Of S, E))"},"File":"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml\" sourcestartlinenumber=\"2\">Submits <see cref=\"!:Bytecode\"></see> for evaluation to a remote Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote.DriverRemoteConnection.Dispose","Type":"method","Syntax":{"content":"public void Dispose()","content.vb":"Public Sub Dispose"},"File":"obj/api/Gremlin.Net.Driver.Remote.DriverRemoteConnection.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Builder","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Allows to build <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> objects.</p>\n","Type":"class","Syntax":{"content":"public class Builder","content.vb":"Public Class Builder"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Builder.Processor(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">If this value is not set in the builder then the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Processor\" data-throw-if-not-resolved=\"false\"></xref> defaults to\nthe standard op processor (empty string).</p>\n","Type":"method","Syntax":{"content":"public RequestMessage.Builder Processor(string processor)","parameters":[{"id":"processor","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The name of the processor.</p>\n"}],"return":{"type":"Gremlin.Net.Driver.Messages.RequestMessage.Builder","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Function Processor(processor As String) As RequestMessage.Builder"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">If this value is not set in the builder then the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Processor\" data-throw-if-not-resolved=\"false\"></xref> defaults to\nthe standard op processor (empty string).</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Builder.OverrideRequestId(System.Guid)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Overrides the request identifier with a specified one, otherwise the\n<xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref> will randomly generate a <xref href=\"System.Guid\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public RequestMessage.Builder OverrideRequestId(Guid requestId)","parameters":[{"id":"requestId","type":"System.Guid","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The request identifier to use.</p>\n"}],"return":{"type":"Gremlin.Net.Driver.Messages.RequestMessage.Builder","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Function OverrideRequestId(requestId As Guid) As RequestMessage.Builder"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Overrides the request identifier with a specified one, otherwise the\n<xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref> will randomly generate a <xref href=\"System.Guid\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Builder.AddArgument(System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Adds and argument to the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public RequestMessage.Builder AddArgument(string key, object value)","parameters":[{"id":"key","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The key of the argument.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The value of the argument.</p>\n"}],"return":{"type":"Gremlin.Net.Driver.Messages.RequestMessage.Builder","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Function AddArgument(key As String, value As Object) As RequestMessage.Builder"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Adds and argument to the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Builder.Create","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Creates the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> given the settings provided to the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public RequestMessage Create()","return":{"type":"Gremlin.Net.Driver.Messages.RequestMessage","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"1\">The built <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Function Create As RequestMessage"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.Builder.yml\" sourcestartlinenumber=\"2\">Creates the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> given the settings provided to the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.GraphFilterStrategy","Type":"class","Syntax":{"content":"public class GraphFilterStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class GraphFilterStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.GraphFilterStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.FilterRankingStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.FilterRankingStrategy.yml\" sourcestartlinenumber=\"2\">Reorders filter- and order-steps according to their rank.</p>\n","Type":"class","Syntax":{"content":"public class FilterRankingStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class FilterRankingStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.FilterRankingStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy","Type":"class","Syntax":{"content":"public class VertexProgramStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class VertexProgramStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy.#ctor","Type":"constructor","Syntax":{"content":"public VertexProgramStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy.#ctor(System.String,System.Nullable{System.Int32},System.String,System.String,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal,System.Collections.Generic.Dictionary{System.String,System.Object})","Type":"constructor","Syntax":{"content":"public VertexProgramStrategy(string graphComputer = null, int? workers = default(int? ), string persist = null, string result = null, ITraversal vertices = null, ITraversal edges = null, Dictionary<string, dynamic> configuration = null)","parameters":[{"id":"graphComputer","type":"System.String"},{"id":"workers","type":"System.Nullable{System.Int32}"},{"id":"persist","type":"System.String"},{"id":"result","type":"System.String"},{"id":"vertices","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"edges","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"configuration","type":"System.Collections.Generic.Dictionary{System.String,System.Object}"}],"content.vb":"Public Sub New(graphComputer As String = Nothing, workers As Integer? = Nothing, persist As String = Nothing, result As String = Nothing, vertices As ITraversal = Nothing, edges As ITraversal = Nothing, configuration As Dictionary(Of String, Object) = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.VertexProgramStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IPredicate","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IPredicate.yml\" sourcestartlinenumber=\"2\">Represents a predicate (boolean-valued function) of one argument.</p>\n","Type":"interface","Syntax":{"content":"public interface IPredicate","content.vb":"Public Interface IPredicate"},"File":"obj/api/Gremlin.Net.Process.Traversal.IPredicate.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IFunction","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IFunction.yml\" sourcestartlinenumber=\"2\">Represents a function that accepts one argument and produces a result.</p>\n","Type":"interface","Syntax":{"content":"public interface IFunction","content.vb":"Public Interface IFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.IFunction.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IBinaryOperator","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IBinaryOperator.yml\" sourcestartlinenumber=\"2\">Represents an operation upon two operands of the same type, producing a result of the same type as the operands.\nThis is a specialization of <xref href=\"Gremlin.Net.Process.Traversal.IBiFunction\" data-throw-if-not-resolved=\"false\"></xref> for the case where the operands and the result are all of\nthe same type.</p>\n","Type":"interface","Syntax":{"content":"public interface IBinaryOperator : IBiFunction","content.vb":"Public Interface IBinaryOperator\n    Inherits IBiFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.IBinaryOperator.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphSONVersion","Type":"class","Syntax":{"content":"public class GraphSONVersion : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class GraphSONVersion\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphSONVersion.V1_0","Type":"property","Syntax":{"content":"public static GraphSONVersion V1_0 { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.GraphSONVersion"},"content.vb":"Public Shared ReadOnly Property V1_0 As GraphSONVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphSONVersion.V2_0","Type":"property","Syntax":{"content":"public static GraphSONVersion V2_0 { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.GraphSONVersion"},"content.vb":"Public Shared ReadOnly Property V2_0 As GraphSONVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphSONVersion.V3_0","Type":"property","Syntax":{"content":"public static GraphSONVersion V3_0 { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.GraphSONVersion"},"content.vb":"Public Shared ReadOnly Property V3_0 As GraphSONVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphSONVersion.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml\" sourcestartlinenumber=\"2\">Gets the GraphSONVersion enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static GraphSONVersion GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphSONVersion"},"content.vb":"Public Shared Function GetByValue(value As String) As GraphSONVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphSONVersion.yml\" sourcestartlinenumber=\"2\">Gets the GraphSONVersion enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.IRemoteConnection","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml\" sourcestartlinenumber=\"2\">A simple abstraction of a &quot;connection&quot; to a &quot;server&quot;.</p>\n","Type":"interface","Syntax":{"content":"public interface IRemoteConnection","content.vb":"Public Interface IRemoteConnection"},"File":"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote.IRemoteConnection.SubmitAsync``2(Bytecode)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml\" sourcestartlinenumber=\"2\">Submits <see cref=\"!:ITraversal\"></see> <see cref=\"!:Bytecode\"></see> to a server and returns a\n<see cref=\"!:ITraversal\"></see>.</p>\n","Type":"method","Syntax":{"content":"Task<ITraversal<S, E>> SubmitAsync<S, E>(Bytecode bytecode)","parameters":[{"id":"bytecode","type":"Bytecode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml\" sourcestartlinenumber=\"1\">The <see cref=\"!:Bytecode\"></see> to send.</p>\n"}],"typeParameters":[{"id":"S"},{"id":"E"}],"return":{"type":"System.Threading.Tasks.Task{ITraversal{{S},{E}}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml\" sourcestartlinenumber=\"1\">The <see cref=\"!:ITraversal\"></see> with the results and optional side-effects.</p>\n"},"content.vb":"Function SubmitAsync(Of S, E)(bytecode As Bytecode) As Task(Of ITraversal(Of S, E))"},"File":"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Remote.IRemoteConnection.yml\" sourcestartlinenumber=\"2\">Submits <see cref=\"!:ITraversal\"></see> <see cref=\"!:Bytecode\"></see> to a server and returns a\n<see cref=\"!:ITraversal\"></see>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">The model for a request message sent to the server.</p>\n","Type":"class","Syntax":{"content":"public class RequestMessage","content.vb":"Public Class RequestMessage"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.RequestId","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the ID of this request message.</p>\n","Type":"property","Syntax":{"content":"public Guid RequestId { get; }","parameters":[],"return":{"type":"System.Guid","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"1\">A UUID representing the unique identification for the request.</p>\n"},"content.vb":"Public ReadOnly Property RequestId As Guid"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the ID of this request message.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Operation","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the name of the operation that should be executed by the Gremlin Server.</p>\n","Type":"property","Syntax":{"content":"public string Operation { get; }","parameters":[],"return":{"type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">The name of the &quot;operation&quot; to execute based on the available OpProcessor configured in the Gremlin Server. This\ndefaults to &quot;eval&quot; which evaluates a request script.</p>\n"},"content.vb":"Public ReadOnly Property Operation As String"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the name of the operation that should be executed by the Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Processor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the name of the OpProcessor to utilize.</p>\n","Type":"property","Syntax":{"content":"public string Processor { get; }","parameters":[],"return":{"type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">The name of the OpProcessor to utilize. This defaults to an empty string which represents the default\nOpProcessor for evaluating scripts.</p>\n"},"content.vb":"Public ReadOnly Property Processor As String"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets the name of the OpProcessor to utilize.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Arguments","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets arguments of the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public Dictionary<string, object> Arguments { get; }","parameters":[],"return":{"type":"System.Collections.Generic.Dictionary{System.String,System.Object}"},"content.vb":"Public ReadOnly Property Arguments As Dictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Gets arguments of the <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.RequestMessage.Build(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Initializes a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref> to build a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public static RequestMessage.Builder Build(string operation)","parameters":[{"id":"operation","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"1\">The name of the OpProcessor to utilize.</p>\n"}],"return":{"type":"Gremlin.Net.Driver.Messages.RequestMessage.Builder","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref> to build a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},"content.vb":"Public Shared Function Build(operation As String) As RequestMessage.Builder"},"File":"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.RequestMessage.yml\" sourcestartlinenumber=\"2\">Initializes a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage.Builder\" data-throw-if-not-resolved=\"false\"></xref> to build a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml\" sourcestartlinenumber=\"2\">Handles serialization of GraphSON2 data.</p>\n","Type":"class","Syntax":{"content":"public class GraphSON2Writer : GraphSONWriter","content.vb":"Public Class GraphSON2Writer\n    Inherits GraphSONWriter"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON2Writer()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON2Writer(IReadOnlyDictionary<Type, IGraphSONSerializer> customSerializerByType)","parameters":[{"id":"customSerializerByType","type":"System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer}"}],"content.vb":"Public Sub New(customSerializerByType As IReadOnlyDictionary(Of Type, IGraphSONSerializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON2Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T","Type":"class","Syntax":{"content":"public class T : EnumWrapper, IEquatable<EnumWrapper>, IFunction","content.vb":"Public Class T\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper), IFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T.Id","Type":"property","Syntax":{"content":"public static T Id { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.T"},"content.vb":"Public Shared ReadOnly Property Id As T"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T.Key","Type":"property","Syntax":{"content":"public static T Key { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.T"},"content.vb":"Public Shared ReadOnly Property Key As T"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T.Label","Type":"property","Syntax":{"content":"public static T Label { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.T"},"content.vb":"Public Shared ReadOnly Property Label As T"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T.Value","Type":"property","Syntax":{"content":"public static T Value { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.T"},"content.vb":"Public Shared ReadOnly Property Value As T"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.T.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.T.yml\" sourcestartlinenumber=\"2\">Gets the T enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static T GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.T"},"content.vb":"Public Shared Function GetByValue(value As String) As T"},"File":"obj/api/Gremlin.Net.Process.Traversal.T.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.T.yml\" sourcestartlinenumber=\"2\">Gets the T enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Process.Traversal.P\" data-throw-if-not-resolved=\"false\"></xref> is a predicate of the form Func&lt;object, bool&gt;.\nThat is, given some object, return true or false.</p>\n","Type":"class","Syntax":{"content":"public class P : IPredicate","content.vb":"Public Class P\n    Implements IPredicate"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.#ctor(System.String,System.Object,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.P\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public P(string operatorName, dynamic value, P other = null)","parameters":[{"id":"operatorName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">The name of the predicate.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">The value of the predicate.</p>\n"},{"id":"other","type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">An optional other predicate that is used as an argument for this predicate.</p>\n"}],"content.vb":"Public Sub New(operatorName As String, value As Object, other As P = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.P\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.OperatorName","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets the name of the predicate.</p>\n","Type":"property","Syntax":{"content":"public string OperatorName { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property OperatorName As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets the name of the predicate.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Value","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets the value of the predicate.</p>\n","Type":"property","Syntax":{"content":"public dynamic Value { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Value As Object"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets the value of the predicate.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Other","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets an optional other predicate that is used as an argument for this predicate.</p>\n","Type":"property","Syntax":{"content":"public P Other { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public ReadOnly Property Other As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Gets an optional other predicate that is used as an argument for this predicate.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.And(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Returns a composed predicate that represents a logical AND of this predicate and another.</p>\n","Type":"method","Syntax":{"content":"public P And(P otherPredicate)","parameters":[{"id":"otherPredicate","type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">A predicate that will be logically-ANDed with this predicate.</p>\n"}],"return":{"type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">The composed predicate.</p>\n"},"content.vb":"Public Function And(otherPredicate As P) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Returns a composed predicate that represents a logical AND of this predicate and another.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Or(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Returns a composed predicate that represents a logical OR of this predicate and another.</p>\n","Type":"method","Syntax":{"content":"public P Or(P otherPredicate)","parameters":[{"id":"otherPredicate","type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">A predicate that will be logically-ORed with this predicate.</p>\n"}],"return":{"type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"1\">The composed predicate.</p>\n"},"content.vb":"Public Function Or(otherPredicate As P) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.P.yml\" sourcestartlinenumber=\"2\">Returns a composed predicate that represents a logical OR of this predicate and another.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Between(System.Object[])","Type":"method","Syntax":{"content":"public static P Between(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Between(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Eq(System.Object[])","Type":"method","Syntax":{"content":"public static P Eq(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Eq(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Gt(System.Object[])","Type":"method","Syntax":{"content":"public static P Gt(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Gt(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Gte(System.Object[])","Type":"method","Syntax":{"content":"public static P Gte(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Gte(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Inside(System.Object[])","Type":"method","Syntax":{"content":"public static P Inside(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Inside(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Lt(System.Object[])","Type":"method","Syntax":{"content":"public static P Lt(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Lt(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Lte(System.Object[])","Type":"method","Syntax":{"content":"public static P Lte(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Lte(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Neq(System.Object[])","Type":"method","Syntax":{"content":"public static P Neq(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Neq(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Not(System.Object[])","Type":"method","Syntax":{"content":"public static P Not(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Not(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Outside(System.Object[])","Type":"method","Syntax":{"content":"public static P Outside(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Outside(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Test(System.Object[])","Type":"method","Syntax":{"content":"public static P Test(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Test(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Within(System.Object[])","Type":"method","Syntax":{"content":"public static P Within(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Within(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.Without(System.Object[])","Type":"method","Syntax":{"content":"public static P Without(params object[] args)","parameters":[{"id":"args","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.P"},"content.vb":"Public Shared Function Without(ParamArray args As Object()) As P"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.P.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.P.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order","Type":"class","Syntax":{"content":"public class Order : EnumWrapper, IEquatable<EnumWrapper>, IComparator","content.vb":"Public Class Order\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper), IComparator"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.Asc","Type":"property","Syntax":{"content":"public static Order Asc { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared ReadOnly Property Asc As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.Decr","Type":"property","Syntax":{"content":"public static Order Decr { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared ReadOnly Property Decr As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.Desc","Type":"property","Syntax":{"content":"public static Order Desc { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared ReadOnly Property Desc As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.Incr","Type":"property","Syntax":{"content":"public static Order Incr { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared ReadOnly Property Incr As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.Shuffle","Type":"property","Syntax":{"content":"public static Order Shuffle { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared ReadOnly Property Shuffle As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Order.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Order.yml\" sourcestartlinenumber=\"2\">Gets the Order enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Order GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Order"},"content.vb":"Public Shared Function GetByValue(value As String) As Order"},"File":"obj/api/Gremlin.Net.Process.Traversal.Order.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Order.yml\" sourcestartlinenumber=\"2\">Gets the Order enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GryoVersion","Type":"class","Syntax":{"content":"public class GryoVersion : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class GryoVersion\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GryoVersion.V1_0","Type":"property","Syntax":{"content":"public static GryoVersion V1_0 { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.GryoVersion"},"content.vb":"Public Shared ReadOnly Property V1_0 As GryoVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GryoVersion.V3_0","Type":"property","Syntax":{"content":"public static GryoVersion V3_0 { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.GryoVersion"},"content.vb":"Public Shared ReadOnly Property V3_0 As GryoVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GryoVersion.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml\" sourcestartlinenumber=\"2\">Gets the GryoVersion enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static GryoVersion GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GryoVersion"},"content.vb":"Public Shared Function GetByValue(value As String) As GryoVersion"},"File":"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GryoVersion.yml\" sourcestartlinenumber=\"2\">Gets the GryoVersion enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">String constants used to configure a <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class Tokens","content.vb":"Public Class Tokens"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsAuthentication","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used by the client to authenticate itself.</p>\n","Type":"field","Syntax":{"content":"public static string OpsAuthentication","return":{"type":"System.String"},"content.vb":"Public Shared OpsAuthentication As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used by the client to authenticate itself.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsBytecode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used for a request that contains the Bytecode representation of a Traversal.</p>\n","Type":"field","Syntax":{"content":"public static string OpsBytecode","return":{"type":"System.String"},"content.vb":"Public Shared OpsBytecode As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used for a request that contains the Bytecode representation of a Traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsEval","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to evaluate a Gremlin script provided as a string.</p>\n","Type":"field","Syntax":{"content":"public static string OpsEval","return":{"type":"System.String"},"content.vb":"Public Shared OpsEval As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to evaluate a Gremlin script provided as a string.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsGather","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get a particular side-effect as produced by a previously executed Traversal.</p>\n","Type":"field","Syntax":{"content":"public static string OpsGather","return":{"type":"System.String"},"content.vb":"Public Shared OpsGather As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get a particular side-effect as produced by a previously executed Traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsKeys","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get all the keys of all side-effects as produced by a previously executed Traversal.</p>\n","Type":"field","Syntax":{"content":"public static string OpsKeys","return":{"type":"System.String"},"content.vb":"Public Shared OpsKeys As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get all the keys of all side-effects as produced by a previously executed Traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.OpsClose","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get all the keys of all side-effects as produced by a previously executed Traversal.</p>\n","Type":"field","Syntax":{"content":"public static string OpsClose","return":{"type":"System.String"},"content.vb":"Public Shared OpsClose As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Operation used to get all the keys of all side-effects as produced by a previously executed Traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ProcessorTraversal","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Default OpProcessor.</p>\n","Type":"field","Syntax":{"content":"public static string ProcessorTraversal","return":{"type":"System.String"},"content.vb":"Public Shared ProcessorTraversal As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Default OpProcessor.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsBatchSize","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to defines the number of iterations each ResponseMessage should contain - overrides the\nresultIterationBatchSize server setting.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsBatchSize","return":{"type":"System.String"},"content.vb":"Public Shared ArgsBatchSize As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to defines the number of iterations each ResponseMessage should contain - overrides the\nresultIterationBatchSize server setting.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsBindings","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to provide a map of key/value pairs to apply as variables in the context of the Gremlin\nscript.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsBindings","return":{"type":"System.String"},"content.vb":"Public Shared ArgsBindings As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to provide a map of key/value pairs to apply as variables in the context of the Gremlin\nscript.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsAliases","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to define aliases that represent globally bound Graph and TraversalSource objects.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsAliases","return":{"type":"System.String"},"content.vb":"Public Shared ArgsAliases As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to define aliases that represent globally bound Graph and TraversalSource objects.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsGremlin","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that corresponds to the Traversal to evaluate.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsGremlin","return":{"type":"System.String"},"content.vb":"Public Shared ArgsGremlin As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that corresponds to the Traversal to evaluate.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsSideEffect","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to specify the unique identifier for the request.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsSideEffect","return":{"type":"System.String"},"content.vb":"Public Shared ArgsSideEffect As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to specify the unique identifier for the request.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsSideEffectKey","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to specify the key for a specific side-effect.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsSideEffectKey","return":{"type":"System.String"},"content.vb":"Public Shared ArgsSideEffectKey As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to specify the key for a specific side-effect.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsAggregateTo","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\"><xref href=\"Gremlin.Net.Driver.Messages.ResponseMessage%601\" data-throw-if-not-resolved=\"false\"></xref> argument that describes how side-effect data should be treated.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsAggregateTo","return":{"type":"System.String"},"content.vb":"Public Shared ArgsAggregateTo As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\"><xref href=\"Gremlin.Net.Driver.Messages.ResponseMessage%601\" data-throw-if-not-resolved=\"false\"></xref> argument that describes how side-effect data should be treated.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsLanguage","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to change the flavor of Gremlin used (e.g. gremlin-groovy).</p>\n","Type":"field","Syntax":{"content":"public static string ArgsLanguage","return":{"type":"System.String"},"content.vb":"Public Shared ArgsLanguage As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to change the flavor of Gremlin used (e.g. gremlin-groovy).</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsEvalTimeout","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to override the server setting that determines the maximum time to wait for a script to\nexecute on the server.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsEvalTimeout","return":{"type":"System.String"},"content.vb":"Public Shared ArgsEvalTimeout As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name that allows to override the server setting that determines the maximum time to wait for a script to\nexecute on the server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Tokens.ArgsSasl","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name for the response to the server authentication challenge. This value is dependent on the SASL\nauthentication mechanism required by the server.</p>\n","Type":"field","Syntax":{"content":"public static string ArgsSasl","return":{"type":"System.String"},"content.vb":"Public Shared ArgsSasl As String"},"File":"obj/api/Gremlin.Net.Driver.Tokens.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Tokens.yml\" sourcestartlinenumber=\"2\">Argument name for the response to the server authentication challenge. This value is dependent on the SASL\nauthentication mechanism required by the server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Partitions the vertices, edges and vertex properties of a graph into String named partitions.</p>\n","Type":"class","Syntax":{"content":"public class PartitionStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class PartitionStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public PartitionStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.#ctor(System.String,System.String,System.Collections.Generic.IEnumerable{System.String},System.Nullable{System.Boolean})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public PartitionStrategy(string partitionKey = null, string writePartition = null, IEnumerable<string> readPartitions = null, bool? includeMetaProperties = default(bool? ))","parameters":[{"id":"partitionKey","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"1\">Specifies the partition key name.</p>\n"},{"id":"writePartition","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Specifies the name of the partition to write when adding vertices, edges and vertex\nproperties.</p>\n"},{"id":"readPartitions","type":"System.Collections.Generic.IEnumerable{System.String}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"1\">Specifies the partition of the graph to read from.</p>\n"},{"id":"includeMetaProperties","type":"System.Nullable{System.Boolean}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"1\">Set to true if vertex properties should get assigned to partitions.</p>\n"}],"content.vb":"Public Sub New(partitionKey As String = Nothing, writePartition As String = Nothing, readPartitions As IEnumerable(Of String) = Nothing, includeMetaProperties As Boolean? = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.PartitionStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"2\">OptionsStrategy makes no changes to the traversal itself - it just carries configuration information\nat the traversal level.</p>\n","Type":"class","Syntax":{"content":"public class OptionsStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class OptionsStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public OptionsStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.#ctor(System.Collections.Generic.IDictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public OptionsStrategy(IDictionary<string, object> options)","parameters":[{"id":"options","type":"System.Collections.Generic.IDictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"1\">Specifies the options for the traversal.</p>\n"}],"content.vb":"Public Sub New(options As IDictionary(Of String, Object))"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.OptionsStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath","Type":"class","Syntax":{"content":"public class ShortestPath","content.vb":"Public Class ShortestPath"},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath.distance","Type":"field","Syntax":{"content":"public const string distance = \"~tinkerpop.shortestPath.distance\"","return":{"type":"System.String"},"content.vb":"Public Const distance As String = \"~tinkerpop.shortestPath.distance\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath.edges","Type":"field","Syntax":{"content":"public const string edges = \"~tinkerpop.shortestPath.edges\"","return":{"type":"System.String"},"content.vb":"Public Const edges As String = \"~tinkerpop.shortestPath.edges\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath.includeEdges","Type":"field","Syntax":{"content":"public const string includeEdges = \"~tinkerpop.shortestPath.includeEdges\"","return":{"type":"System.String"},"content.vb":"Public Const includeEdges As String = \"~tinkerpop.shortestPath.includeEdges\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath.maxDistance","Type":"field","Syntax":{"content":"public const string maxDistance = \"~tinkerpop.shortestPath.maxDistance\"","return":{"type":"System.String"},"content.vb":"Public Const maxDistance As String = \"~tinkerpop.shortestPath.maxDistance\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ShortestPath.target","Type":"field","Syntax":{"content":"public const string target = \"~tinkerpop.shortestPath.target\"","return":{"type":"System.String"},"content.vb":"Public Const target As String = \"~tinkerpop.shortestPath.target\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ShortestPath.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Scope","Type":"class","Syntax":{"content":"public class Scope : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class Scope\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Scope.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Scope.Global","Type":"property","Syntax":{"content":"public static Scope Global { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Scope"},"content.vb":"Public Shared ReadOnly Property Global As Scope"},"File":"obj/api/Gremlin.Net.Process.Traversal.Scope.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Scope.Local","Type":"property","Syntax":{"content":"public static Scope Local { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Scope"},"content.vb":"Public Shared ReadOnly Property Local As Scope"},"File":"obj/api/Gremlin.Net.Process.Traversal.Scope.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Scope.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Scope.yml\" sourcestartlinenumber=\"2\">Gets the Scope enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Scope GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Scope"},"content.vb":"Public Shared Function GetByValue(value As String) As Scope"},"File":"obj/api/Gremlin.Net.Process.Traversal.Scope.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Scope.yml\" sourcestartlinenumber=\"2\">Gets the Scope enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"2\">Supports deserializing GraphSON into an object.</p>\n","Type":"interface","Syntax":{"content":"public interface IGraphSONDeserializer","content.vb":"Public Interface IGraphSONDeserializer"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.Objectify(JToken,Gremlin.Net.Structure.IO.GraphSON.GraphSONReader)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"2\">Deserializes GraphSON to an object.</p>\n","Type":"method","Syntax":{"content":"dynamic Objectify(JToken graphsonObject, GraphSONReader reader)","parameters":[{"id":"graphsonObject","type":"JToken","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"1\">The GraphSON object to objectify.</p>\n"},{"id":"reader","type":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> that can be used to objectify properties of the GraphSON object.</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"1\">The deserialized object.</p>\n"},"content.vb":"Function Objectify(graphsonObject As JToken, reader As GraphSONReader) As Object"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer.yml\" sourcestartlinenumber=\"2\">Deserializes GraphSON to an object.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Graph traversals are the primary way in which graphs are processed.</p>\n","Type":"class","Syntax":{"content":"public class GraphTraversal<S, E> : DefaultTraversal<S, E>, ITraversal<S, E>, ITraversal, IEnumerator, IEnumerator<E>, IDisposable, IEnumerator","typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Public Class GraphTraversal(Of S, E)\n    Inherits DefaultTraversal(Of S, E)\n    Implements ITraversal(Of S, E), ITraversal, IEnumerator, IEnumerator(Of E), IDisposable, IEnumerator"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public GraphTraversal()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.#ctor(System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy},Gremlin.Net.Process.Traversal.Bytecode)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public GraphTraversal(ICollection<ITraversalStrategy> traversalStrategies, Bytecode bytecode)","parameters":[{"id":"traversalStrategies","type":"System.Collections.Generic.ICollection{Gremlin.Net.Process.Traversal.ITraversalStrategy}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"1\">The traversal strategies to be used by this graph traversal at evaluation time.</p>\n"},{"id":"bytecode","type":"Gremlin.Net.Process.Traversal.Bytecode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> associated with the construction of this graph traversal.</p>\n"}],"content.vb":"Public Sub New(traversalStrategies As ICollection(Of ITraversalStrategy), bytecode As Bytecode)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.V(System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the V step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> V(params object[] vertexIdsOrElements)","parameters":[{"id":"vertexIdsOrElements","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function V(ParamArray vertexIdsOrElements As Object()) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the V step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.AddE(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> AddE(string edgeLabel)","parameters":[{"id":"edgeLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function AddE(edgeLabel As String) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.AddE(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> AddE(ITraversal edgeLabelTraversal)","parameters":[{"id":"edgeLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function AddE(edgeLabelTraversal As ITraversal) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.AddV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> AddV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function AddV As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.AddV(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> AddV(string vertexLabel)","parameters":[{"id":"vertexLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function AddV(vertexLabel As String) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.AddV(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> AddV(ITraversal vertexLabelTraversal)","parameters":[{"id":"vertexLabelTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function AddV(vertexLabelTraversal As ITraversal) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the addV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Aggregate(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the aggregate step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Aggregate(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Aggregate(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the aggregate step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.And(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the and step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> And(params ITraversal[] andTraversals)","parameters":[{"id":"andTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function And(ParamArray andTraversals As ITraversal()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the and step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.As(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the as step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> As(string stepLabel, params string[] stepLabels)","parameters":[{"id":"stepLabel","type":"System.String"},{"id":"stepLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function As(stepLabel As String, ParamArray stepLabels As String()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the as step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Barrier","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Barrier()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Barrier As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Barrier(Gremlin.Net.Process.Traversal.IConsumer)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Barrier(IConsumer barrierConsumer)","parameters":[{"id":"barrierConsumer","type":"Gremlin.Net.Process.Traversal.IConsumer"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Barrier(barrierConsumer As IConsumer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Barrier(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Barrier(int maxBarrierSize)","parameters":[{"id":"maxBarrierSize","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Barrier(maxBarrierSize As Integer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the barrier step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Both(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the both step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> Both(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function Both(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the both step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.BothE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the bothE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> BothE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function BothE(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the bothE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.BothV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the bothV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> BothV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function BothV As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the bothV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Branch``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the branch step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Branch<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Branch(Of E2)(function As IFunction) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the branch step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Branch``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the branch step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Branch<E2>(ITraversal branchTraversal)","parameters":[{"id":"branchTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Branch(Of E2)(branchTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the branch step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.IComparator)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(IComparator comparator)","parameters":[{"id":"comparator","type":"Gremlin.Net.Process.Traversal.IComparator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(comparator As IComparator) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(function As IFunction) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.IFunction,Gremlin.Net.Process.Traversal.IComparator)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(IFunction function, IComparator comparator)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"},{"id":"comparator","type":"Gremlin.Net.Process.Traversal.IComparator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(function As IFunction, comparator As IComparator) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.Order)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(Order order)","parameters":[{"id":"order","type":"Gremlin.Net.Process.Traversal.Order"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(order As Order) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(string key)","parameters":[{"id":"key","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(key As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(System.String,Gremlin.Net.Process.Traversal.IComparator)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(string key, IComparator comparator)","parameters":[{"id":"key","type":"System.String"},{"id":"comparator","type":"Gremlin.Net.Process.Traversal.IComparator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(key As String, comparator As IComparator) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.T)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(T token)","parameters":[{"id":"token","type":"Gremlin.Net.Process.Traversal.T"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(token As T) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(ITraversal traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(traversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.By(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.IComparator)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> By(ITraversal traversal, IComparator comparator)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"comparator","type":"Gremlin.Net.Process.Traversal.IComparator"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function By(traversal As ITraversal, comparator As IComparator) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the by step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Cap``1(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the cap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Cap<E2>(string sideEffectKey, params string[] sideEffectKeys)","parameters":[{"id":"sideEffectKey","type":"System.String"},{"id":"sideEffectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Cap(Of E2)(sideEffectKey As String, ParamArray sideEffectKeys As String()) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the cap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(IFunction choiceFunction)","parameters":[{"id":"choiceFunction","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(choiceFunction As IFunction) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.IPredicate,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(IPredicate choosePredicate, ITraversal trueChoice)","parameters":[{"id":"choosePredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(choosePredicate As IPredicate, trueChoice As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.IPredicate,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(IPredicate choosePredicate, ITraversal trueChoice, ITraversal falseChoice)","parameters":[{"id":"choosePredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"falseChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(choosePredicate As IPredicate, trueChoice As ITraversal, falseChoice As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(ITraversal choiceTraversal)","parameters":[{"id":"choiceTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(choiceTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(ITraversal traversalPredicate, ITraversal trueChoice)","parameters":[{"id":"traversalPredicate","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(traversalPredicate As ITraversal, trueChoice As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Choose``1(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Choose<E2>(ITraversal traversalPredicate, ITraversal trueChoice, ITraversal falseChoice)","parameters":[{"id":"traversalPredicate","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"trueChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"},{"id":"falseChoice","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Choose(Of E2)(traversalPredicate As ITraversal, trueChoice As ITraversal, falseChoice As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the choose step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Coalesce``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the coalesce step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Coalesce<E2>(params ITraversal[] coalesceTraversals)","parameters":[{"id":"coalesceTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Coalesce(Of E2)(ParamArray coalesceTraversals As ITraversal()) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the coalesce step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Coin(System.Double)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the coin step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Coin(double probability)","parameters":[{"id":"probability","type":"System.Double"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Coin(probability As Double) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the coin step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ConnectedComponent","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the connectedComponent step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> ConnectedComponent()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function ConnectedComponent As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the connectedComponent step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Constant``1(``0)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the constant step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Constant<E2>(E2 e)","parameters":[{"id":"e","type":"{E2}"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Constant(Of E2)(e As E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the constant step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Count","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the count step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, long> Count()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Int64}"},"content.vb":"Public Function Count As GraphTraversal(Of S, Long)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the count step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Count(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the count step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, long> Count(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Int64}"},"content.vb":"Public Function Count(scope As Scope) As GraphTraversal(Of S, Long)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the count step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.CyclicPath","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the cyclicPath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> CyclicPath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function CyclicPath As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the cyclicPath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Dedup(Gremlin.Net.Process.Traversal.Scope,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the dedup step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Dedup(Scope scope, params string[] dedupLabels)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"dedupLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Dedup(scope As Scope, ParamArray dedupLabels As String()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the dedup step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Dedup(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the dedup step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Dedup(params string[] dedupLabels)","parameters":[{"id":"dedupLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Dedup(ParamArray dedupLabels As String()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the dedup step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Drop","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the drop step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Drop()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Drop As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the drop step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Emit","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Emit()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Emit As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Emit(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Emit(IPredicate emitPredicate)","parameters":[{"id":"emitPredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Emit(emitPredicate As IPredicate) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Emit(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Emit(ITraversal emitTraversal)","parameters":[{"id":"emitTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Emit(emitTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the emit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Filter(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the filter step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Filter(IPredicate predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Filter(predicate As IPredicate) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the filter step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Filter(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the filter step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Filter(ITraversal filterTraversal)","parameters":[{"id":"filterTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Filter(filterTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the filter step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.FlatMap``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the flatMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> FlatMap<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function FlatMap(Of E2)(function As IFunction) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the flatMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.FlatMap``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the flatMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> FlatMap<E2>(ITraversal flatMapTraversal)","parameters":[{"id":"flatMapTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function FlatMap(Of E2)(flatMapTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the flatMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Fold","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the fold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IList<E>> Fold()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IList{{E}}}"},"content.vb":"Public Function Fold As GraphTraversal(Of S, IList(Of E))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the fold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Fold``1(``0,Gremlin.Net.Process.Traversal.IBiFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the fold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Fold<E2>(E2 seed, IBiFunction foldFunction)","parameters":[{"id":"seed","type":"{E2}"},{"id":"foldFunction","type":"Gremlin.Net.Process.Traversal.IBiFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Fold(Of E2)(seed As E2, foldFunction As IBiFunction) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the fold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.From(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> From(string fromStepLabel)","parameters":[{"id":"fromStepLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function From(fromStepLabel As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.From(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> From(ITraversal fromVertex)","parameters":[{"id":"fromVertex","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function From(fromVertex As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.From(Vertex)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> From(Vertex fromVertex)","parameters":[{"id":"fromVertex","type":"Vertex"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function From(fromVertex As Vertex) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the from step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Group``2","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the group step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<K, V>> Group<K, V>()","typeParameters":[{"id":"K"},{"id":"V"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{{K},{V}}}"},"content.vb":"Public Function Group(Of K, V) As GraphTraversal(Of S, IDictionary(Of K, V))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the group step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Group(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the group step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Group(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Group(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the group step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.GroupCount``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the groupCount step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<K, long>> GroupCount<K>()","typeParameters":[{"id":"K"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{{K},System.Int64}}"},"content.vb":"Public Function GroupCount(Of K) As GraphTraversal(Of S, IDictionary(Of K, Long))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the groupCount step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.GroupCount(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the groupCount step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> GroupCount(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function GroupCount(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the groupCount step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string propertyKey)","parameters":[{"id":"propertyKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(propertyKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string propertyKey, object value)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(propertyKey As String, value As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string propertyKey, P predicate)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(propertyKey As String, predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String,System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string label, string propertyKey, object value)","parameters":[{"id":"label","type":"System.String"},{"id":"propertyKey","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(label As String, propertyKey As String, value As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String,System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string label, string propertyKey, P predicate)","parameters":[{"id":"label","type":"System.String"},{"id":"propertyKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(label As String, propertyKey As String, predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(System.String,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(string propertyKey, ITraversal propertyTraversal)","parameters":[{"id":"propertyKey","type":"System.String"},{"id":"propertyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(propertyKey As String, propertyTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(Gremlin.Net.Process.Traversal.T,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(T accessor, object value)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(accessor As T, value As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(Gremlin.Net.Process.Traversal.T,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(T accessor, P predicate)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(accessor As T, predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Has(Gremlin.Net.Process.Traversal.T,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Has(T accessor, ITraversal propertyTraversal)","parameters":[{"id":"accessor","type":"Gremlin.Net.Process.Traversal.T"},{"id":"propertyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Has(accessor As T, propertyTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the has step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasId(System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasId step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasId(object id, params object[] otherIds)","parameters":[{"id":"id","type":"System.Object"},{"id":"otherIds","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasId(id As Object, ParamArray otherIds As Object()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasId step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasId(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasId step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasId(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasId(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasId step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasKey(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasKey step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasKey(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasKey(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasKey step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasKey(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasKey step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasKey(string label, params string[] otherLabels)","parameters":[{"id":"label","type":"System.String"},{"id":"otherLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasKey(label As String, ParamArray otherLabels As String()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasKey step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasLabel(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasLabel step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasLabel(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasLabel(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasLabel step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasLabel(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasLabel step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasLabel(string label, params string[] otherLabels)","parameters":[{"id":"label","type":"System.String"},{"id":"otherLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasLabel(label As String, ParamArray otherLabels As String()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasLabel step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasNot(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasNot step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasNot(string propertyKey)","parameters":[{"id":"propertyKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasNot(propertyKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasNot step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasValue(System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasValue step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasValue(object value, params object[] otherValues)","parameters":[{"id":"value","type":"System.Object"},{"id":"otherValues","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasValue(value As Object, ParamArray otherValues As Object()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasValue step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.HasValue(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasValue step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> HasValue(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function HasValue(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the hasValue step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Id","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the id step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, object> Id()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Object}"},"content.vb":"Public Function Id As GraphTraversal(Of S, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the id step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Identity","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the identity step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Identity()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Identity As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the identity step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.In(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the in step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> In(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function In(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the in step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.InE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> InE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function InE(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.InV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> InV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function InV As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Index``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the index step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Index<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Index(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the index step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Inject(`1[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inject step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Inject(params E[] injections)","parameters":[{"id":"injections","type":"{E}[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Inject(ParamArray injections As E()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the inject step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Is(System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the is step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Is(object value)","parameters":[{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Is(value As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the is step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Is(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the is step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Is(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Is(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the is step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Key","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the key step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, string> Key()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.String}"},"content.vb":"Public Function Key As GraphTraversal(Of S, String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the key step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Label","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the label step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, string> Label()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.String}"},"content.vb":"Public Function Label As GraphTraversal(Of S, String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the label step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Limit``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the limit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Limit<E2>(Scope scope, long limit)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Limit(Of E2)(scope As Scope, limit As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the limit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Limit``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the limit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Limit<E2>(long limit)","parameters":[{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Limit(Of E2)(limit As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the limit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Local``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the local step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Local<E2>(ITraversal localTraversal)","parameters":[{"id":"localTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Local(Of E2)(localTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the local step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Loops","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the loops step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, int> Loops()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Int32}"},"content.vb":"Public Function Loops As GraphTraversal(Of S, Integer)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the loops step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Loops(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the loops step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, int> Loops(string loopName)","parameters":[{"id":"loopName","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Int32}"},"content.vb":"Public Function Loops(loopName As String) As GraphTraversal(Of S, Integer)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the loops step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Map``1(Gremlin.Net.Process.Traversal.IFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the map step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Map<E2>(IFunction function)","parameters":[{"id":"function","type":"Gremlin.Net.Process.Traversal.IFunction"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Map(Of E2)(function As IFunction) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the map step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Map``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the map step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Map<E2>(ITraversal mapTraversal)","parameters":[{"id":"mapTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Map(Of E2)(mapTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the map step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Match``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the match step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<string, E2>> Match<E2>(params ITraversal[] matchTraversals)","parameters":[{"id":"matchTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Function Match(Of E2)(ParamArray matchTraversals As ITraversal()) As GraphTraversal(Of S, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the match step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Math(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the math step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, double> Math(string expression)","parameters":[{"id":"expression","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Double}"},"content.vb":"Public Function Math(expression As String) As GraphTraversal(Of S, Double)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the math step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Max``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the max step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Max<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Max(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the max step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Max``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the max step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Max<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Max(Of E2)(scope As Scope) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the max step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Mean``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the mean step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Mean<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Mean(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the mean step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Mean``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the mean step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Mean<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Mean(Of E2)(scope As Scope) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the mean step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Min``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the min step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Min<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Min(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the min step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Min``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the min step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Min<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Min(Of E2)(scope As Scope) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the min step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Not(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the not step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Not(ITraversal notTraversal)","parameters":[{"id":"notTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Not(notTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the not step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Option(System.Object,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the option step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Option(object pickToken, ITraversal traversalOption)","parameters":[{"id":"pickToken","type":"System.Object"},{"id":"traversalOption","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Option(pickToken As Object, traversalOption As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the option step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Option(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the option step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Option(ITraversal traversalOption)","parameters":[{"id":"traversalOption","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Option(traversalOption As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the option step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Optional``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the optional step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Optional<E2>(ITraversal optionalTraversal)","parameters":[{"id":"optionalTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Optional(Of E2)(optionalTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the optional step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Or(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the or step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Or(params ITraversal[] orTraversals)","parameters":[{"id":"orTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Or(ParamArray orTraversals As ITraversal()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the or step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Order","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the order step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Order()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Order As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the order step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Order(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the order step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Order(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Order(scope As Scope) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the order step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.OtherV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the otherV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> OtherV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function OtherV As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the otherV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Out(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the out step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> Out(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function Out(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the out step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.OutE(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the outE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> OutE(params string[] edgeLabels)","parameters":[{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function OutE(ParamArray edgeLabels As String()) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the outE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.OutV","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the outV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> OutV()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function OutV As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the outV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.PageRank","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the pageRank step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> PageRank()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function PageRank As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the pageRank step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.PageRank(System.Double)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the pageRank step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> PageRank(double alpha)","parameters":[{"id":"alpha","type":"System.Double"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function PageRank(alpha As Double) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the pageRank step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Path","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the path step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Path> Path()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Path}"},"content.vb":"Public Function Path As GraphTraversal(Of S, Path)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the path step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.PeerPressure","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the peerPressure step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> PeerPressure()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function PeerPressure As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the peerPressure step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Profile``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the profile step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Profile<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Profile(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the profile step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Profile(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the profile step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Profile(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Profile(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the profile step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Program(System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the program step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Program(object vertexProgram)","parameters":[{"id":"vertexProgram","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Program(vertexProgram As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the program step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Project``1(System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the project step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<string, E2>> Project<E2>(string projectKey, params string[] otherProjectKeys)","parameters":[{"id":"projectKey","type":"System.String"},{"id":"otherProjectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Function Project(Of E2)(projectKey As String, ParamArray otherProjectKeys As String()) As GraphTraversal(Of S, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the project step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Properties``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the properties step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Properties<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Properties(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the properties step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Property(Gremlin.Net.Process.Traversal.Cardinality,System.Object,System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the property step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Property(Cardinality cardinality, object key, object value, params object[] keyValues)","parameters":[{"id":"cardinality","type":"Gremlin.Net.Process.Traversal.Cardinality"},{"id":"key","type":"System.Object"},{"id":"value","type":"System.Object"},{"id":"keyValues","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Property(cardinality As Cardinality, key As Object, value As Object, ParamArray keyValues As Object()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the property step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Property(System.Object,System.Object,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the property step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Property(object key, object value, params object[] keyValues)","parameters":[{"id":"key","type":"System.Object"},{"id":"value","type":"System.Object"},{"id":"keyValues","type":"System.Object[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Property(key As Object, value As Object, ParamArray keyValues As Object()) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the property step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.PropertyMap``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the propertyMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<string, E2>> PropertyMap<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Function PropertyMap(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of S, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the propertyMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Range``1(Gremlin.Net.Process.Traversal.Scope,System.Int64,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the range step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Range<E2>(Scope scope, long low, long high)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"low","type":"System.Int64"},{"id":"high","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Range(Of E2)(scope As Scope, low As Long, high As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the range step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Range``1(System.Int64,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the range step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Range<E2>(long low, long high)","parameters":[{"id":"low","type":"System.Int64"},{"id":"high","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Range(Of E2)(low As Long, high As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the range step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Read","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the read step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Read()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Read As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the read step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Repeat(System.String,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the repeat step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Repeat(string loopName, ITraversal repeatTraversal)","parameters":[{"id":"loopName","type":"System.String"},{"id":"repeatTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Repeat(loopName As String, repeatTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the repeat step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Repeat(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the repeat step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Repeat(ITraversal repeatTraversal)","parameters":[{"id":"repeatTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Repeat(repeatTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the repeat step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sack``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sack step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Sack<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Sack(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sack step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sack(Gremlin.Net.Process.Traversal.IBiFunction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sack step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Sack(IBiFunction sackOperator)","parameters":[{"id":"sackOperator","type":"Gremlin.Net.Process.Traversal.IBiFunction"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Sack(sackOperator As IBiFunction) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sack step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sample(Gremlin.Net.Process.Traversal.Scope,System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sample step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Sample(Scope scope, int amountToSample)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"amountToSample","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Sample(scope As Scope, amountToSample As Integer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sample step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sample(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sample step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Sample(int amountToSample)","parameters":[{"id":"amountToSample","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Sample(amountToSample As Integer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sample step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(Gremlin.Net.Process.Traversal.Column)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, ICollection<E2>> Select<E2>(Column column)","parameters":[{"id":"column","type":"Gremlin.Net.Process.Traversal.Column"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.ICollection{{E2}}}"},"content.vb":"Public Function Select(Of E2)(column As Column) As GraphTraversal(Of S, ICollection(Of E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(Gremlin.Net.Process.Traversal.Pop,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Select<E2>(Pop pop, string selectKey)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"selectKey","type":"System.String"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Select(Of E2)(pop As Pop, selectKey As String) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(Gremlin.Net.Process.Traversal.Pop,System.String,System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<string, E2>> Select<E2>(Pop pop, string selectKey1, string selectKey2, params string[] otherSelectKeys)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"selectKey1","type":"System.String"},{"id":"selectKey2","type":"System.String"},{"id":"otherSelectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Function Select(Of E2)(pop As Pop, selectKey1 As String, selectKey2 As String, ParamArray otherSelectKeys As String()) As GraphTraversal(Of S, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(Gremlin.Net.Process.Traversal.Pop,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Select<E2>(Pop pop, ITraversal keyTraversal)","parameters":[{"id":"pop","type":"Gremlin.Net.Process.Traversal.Pop"},{"id":"keyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Select(Of E2)(pop As Pop, keyTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Select<E2>(string selectKey)","parameters":[{"id":"selectKey","type":"System.String"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Select(Of E2)(selectKey As String) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(System.String,System.String,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<string, E2>> Select<E2>(string selectKey1, string selectKey2, params string[] otherSelectKeys)","parameters":[{"id":"selectKey1","type":"System.String"},{"id":"selectKey2","type":"System.String"},{"id":"otherSelectKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{System.String,{E2}}}"},"content.vb":"Public Function Select(Of E2)(selectKey1 As String, selectKey2 As String, ParamArray otherSelectKeys As String()) As GraphTraversal(Of S, IDictionary(Of String, E2))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Select``1(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Select<E2>(ITraversal keyTraversal)","parameters":[{"id":"keyTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Select(Of E2)(keyTraversal As ITraversal) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the select step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ShortestPath","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the shortestPath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Path> ShortestPath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Path}"},"content.vb":"Public Function ShortestPath As GraphTraversal(Of S, Path)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the shortestPath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.SideEffect(Gremlin.Net.Process.Traversal.IConsumer)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sideEffect step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> SideEffect(IConsumer consumer)","parameters":[{"id":"consumer","type":"Gremlin.Net.Process.Traversal.IConsumer"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function SideEffect(consumer As IConsumer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sideEffect step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.SideEffect(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sideEffect step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> SideEffect(ITraversal sideEffectTraversal)","parameters":[{"id":"sideEffectTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function SideEffect(sideEffectTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sideEffect step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.SimplePath","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the simplePath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> SimplePath()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function SimplePath As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the simplePath step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Skip``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the skip step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Skip<E2>(Scope scope, long skip)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"skip","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Skip(Of E2)(scope As Scope, skip As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the skip step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Skip``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the skip step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Skip<E2>(long skip)","parameters":[{"id":"skip","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Skip(Of E2)(skip As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the skip step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Store(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the store step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Store(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Store(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the store step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Subgraph(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the subgraph step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> Subgraph(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function Subgraph(sideEffectKey As String) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the subgraph step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sum``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sum step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Sum<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Sum(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sum step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Sum``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sum step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Sum<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Sum(Of E2)(scope As Scope) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the sum step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tail``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Tail<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Tail(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tail``1(Gremlin.Net.Process.Traversal.Scope)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Tail<E2>(Scope scope)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Tail(Of E2)(scope As Scope) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tail``1(Gremlin.Net.Process.Traversal.Scope,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Tail<E2>(Scope scope, long limit)","parameters":[{"id":"scope","type":"Gremlin.Net.Process.Traversal.Scope"},{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Tail(Of E2)(scope As Scope, limit As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tail``1(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Tail<E2>(long limit)","parameters":[{"id":"limit","type":"System.Int64"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Tail(Of E2)(limit As Long) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tail step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.TimeLimit(System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the timeLimit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> TimeLimit(long timeLimit)","parameters":[{"id":"timeLimit","type":"System.Int64"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function TimeLimit(timeLimit As Long) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the timeLimit step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Times(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the times step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Times(int maxLoops)","parameters":[{"id":"maxLoops","type":"System.Int32"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Times(maxLoops As Integer) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the times step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.To(Gremlin.Net.Process.Traversal.Direction,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> To(Direction direction, params string[] edgeLabels)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"},{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function To(direction As Direction, ParamArray edgeLabels As String()) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.To(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> To(string toStepLabel)","parameters":[{"id":"toStepLabel","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function To(toStepLabel As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.To(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> To(ITraversal toVertex)","parameters":[{"id":"toVertex","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function To(toVertex As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.To(Vertex)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> To(Vertex toVertex)","parameters":[{"id":"toVertex","type":"Vertex"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function To(toVertex As Vertex) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the to step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ToE(Gremlin.Net.Process.Traversal.Direction,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the toE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Edge> ToE(Direction direction, params string[] edgeLabels)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"},{"id":"edgeLabels","type":"System.String[]"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Edge}"},"content.vb":"Public Function ToE(direction As Direction, ParamArray edgeLabels As String()) As GraphTraversal(Of S, Edge)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the toE step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ToV(Gremlin.Net.Process.Traversal.Direction)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the toV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, Vertex> ToV(Direction direction)","parameters":[{"id":"direction","type":"Gremlin.Net.Process.Traversal.Direction"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},Vertex}"},"content.vb":"Public Function ToV(direction As Direction) As GraphTraversal(Of S, Vertex)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the toV step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tree``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tree step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Tree<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Tree(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tree step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Tree(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tree step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Tree(string sideEffectKey)","parameters":[{"id":"sideEffectKey","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Tree(sideEffectKey As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the tree step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Unfold``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the unfold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Unfold<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Unfold(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the unfold step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Union``1(Gremlin.Net.Process.Traversal.ITraversal[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the union step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Union<E2>(params ITraversal[] unionTraversals)","parameters":[{"id":"unionTraversals","type":"Gremlin.Net.Process.Traversal.ITraversal[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Union(Of E2)(ParamArray unionTraversals As ITraversal()) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the union step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Until(Gremlin.Net.Process.Traversal.IPredicate)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the until step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Until(IPredicate untilPredicate)","parameters":[{"id":"untilPredicate","type":"Gremlin.Net.Process.Traversal.IPredicate"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Until(untilPredicate As IPredicate) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the until step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Until(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the until step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Until(ITraversal untilTraversal)","parameters":[{"id":"untilTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Until(untilTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the until step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Value``1","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the value step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Value<E2>()","typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Value(Of E2) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the value step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ValueMap``2(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the valueMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<TKey, TValue>> ValueMap<TKey, TValue>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"TKey"},{"id":"TValue"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{{TKey},{TValue}}}"},"content.vb":"Public Function ValueMap(Of TKey, TValue)(ParamArray propertyKeys As String()) As GraphTraversal(Of S, IDictionary(Of TKey, TValue))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the valueMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.ValueMap``2(System.Boolean,System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the valueMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, IDictionary<TKey, TValue>> ValueMap<TKey, TValue>(bool includeTokens, params string[] propertyKeys)","parameters":[{"id":"includeTokens","type":"System.Boolean"},{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"TKey"},{"id":"TValue"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},System.Collections.Generic.IDictionary{{TKey},{TValue}}}"},"content.vb":"Public Function ValueMap(Of TKey, TValue)(includeTokens As Boolean, ParamArray propertyKeys As String()) As GraphTraversal(Of S, IDictionary(Of TKey, TValue))"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the valueMap step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Values``1(System.String[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the values step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E2> Values<E2>(params string[] propertyKeys)","parameters":[{"id":"propertyKeys","type":"System.String[]"}],"typeParameters":[{"id":"E2"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal{{S},{E2}}"},"content.vb":"Public Function Values(Of E2)(ParamArray propertyKeys As String()) As GraphTraversal(Of S, E2)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the values step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Where(Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Where(P predicate)","parameters":[{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Where(predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Where(System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Where(string startKey, P predicate)","parameters":[{"id":"startKey","type":"System.String"},{"id":"predicate","type":"Gremlin.Net.Process.Traversal.P"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Where(startKey As String, predicate As P) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Where(Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Where(ITraversal whereTraversal)","parameters":[{"id":"whereTraversal","type":"Gremlin.Net.Process.Traversal.ITraversal"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Where(whereTraversal As ITraversal) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the where step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.With(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the with step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> With(string key)","parameters":[{"id":"key","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function With(key As String) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the with step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.With(System.String,System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the with step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> With(string key, object value)","parameters":[{"id":"key","type":"System.String"},{"id":"value","type":"System.Object"}],"return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function With(key As String, value As Object) As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the with step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.GraphTraversal`2.Write","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the write step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"public GraphTraversal<S, E> Write()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversal`2"},"content.vb":"Public Function Write As GraphTraversal(Of S, E)"},"File":"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.GraphTraversal-2.yml\" sourcestartlinenumber=\"2\">Adds the write step to this <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversal%602\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.AnonymousTraversalSource","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml\" sourcestartlinenumber=\"2\">Provides a method for creating a <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> that does not spawn from a\n<see cref=\"!:Graph\"></see> instance.</p>\n","Type":"class","Syntax":{"content":"public class AnonymousTraversalSource","content.vb":"Public Class AnonymousTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.AnonymousTraversalSource.Traversal","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml\" sourcestartlinenumber=\"2\">Generates a reusable <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> instance.</p>\n","Type":"method","Syntax":{"content":"public static GraphTraversalSource Traversal()","return":{"type":"Gremlin.Net.Process.Traversal.GraphTraversalSource","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml\" sourcestartlinenumber=\"1\">A graph traversal source.</p>\n"},"content.vb":"Public Shared Function Traversal As GraphTraversalSource"},"File":"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.AnonymousTraversalSource.yml\" sourcestartlinenumber=\"2\">Generates a reusable <xref href=\"Gremlin.Net.Process.Traversal.GraphTraversalSource\" data-throw-if-not-resolved=\"false\"></xref> instance.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Allows to serialize objects to GraphSON.</p>\n","Type":"class","Syntax":{"content":"public abstract class GraphSONWriter","content.vb":"Public MustInherit Class GraphSONWriter"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.Serializers","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Contains the information of serializers by type.</p>\n","Type":"field","Syntax":{"content":"protected readonly Dictionary<Type, IGraphSONSerializer> Serializers","return":{"type":"System.Collections.Generic.Dictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer}"},"content.vb":"Protected ReadOnly Serializers As Dictionary(Of Type, IGraphSONSerializer)"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Contains the information of serializers by type.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected GraphSONWriter()","content.vb":"Protected Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected GraphSONWriter(IReadOnlyDictionary<Type, IGraphSONSerializer> customSerializerByType)","parameters":[{"id":"customSerializerByType","type":"System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\"><xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer\" data-throw-if-not-resolved=\"false\"></xref> serializers identified by their\n<xref href=\"System.Type\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Protected Sub New(customSerializerByType As IReadOnlyDictionary(Of Type, IGraphSONSerializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.WriteObject(System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Serializes an object to GraphSON.</p>\n","Type":"method","Syntax":{"content":"public virtual string WriteObject(dynamic objectData)","parameters":[{"id":"objectData","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"1\">The object to serialize.</p>\n"}],"return":{"type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"1\">The serialized GraphSON.</p>\n"},"content.vb":"Public Overridable Function WriteObject(objectData As Object) As String"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Serializes an object to GraphSON.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.ToDict(System.Object)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Transforms an object into its GraphSON representation including type information.</p>\n","Type":"method","Syntax":{"content":"public dynamic ToDict(dynamic objectData)","parameters":[{"id":"objectData","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"1\">The object to transform.</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"1\">A GraphSON representation of the object ready to be serialized.</p>\n"},"content.vb":"Public Function ToDict(objectData As Object) As Object"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter.yml\" sourcestartlinenumber=\"2\">Transforms an object into its GraphSON representation including type information.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"2\">Provides helper methods for GraphSON serialization.</p>\n","Type":"class","Syntax":{"content":"public static class GraphSONUtil","content.vb":"Public Module GraphSONUtil"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.ToTypedValue(System.String,System.Object,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"2\">Transforms a value intos its GraphSON representation including type information.</p>\n","Type":"method","Syntax":{"content":"public static Dictionary<string, dynamic> ToTypedValue(string typename, dynamic value, string prefix = \"g\")","parameters":[{"id":"typename","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The name of the type.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The value to transform.</p>\n"},{"id":"prefix","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">A namespace prefix for the typename.</p>\n"}],"return":{"type":"System.Collections.Generic.Dictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The GraphSON representation including type information.</p>\n"},"content.vb":"Public Shared Function ToTypedValue(typename As String, value As Object, prefix As String = \"g\") As Dictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"2\">Transforms a value intos its GraphSON representation including type information.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.FormatTypeName(System.String,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"2\">Formats a type name with its prefix to a GraphSON TypeID.</p>\n","Type":"method","Syntax":{"content":"public static string FormatTypeName(string namespacePrefix, string typeName)","parameters":[{"id":"namespacePrefix","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The namespace prefix (default is &quot;g&quot;).</p>\n"},{"id":"typeName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The name of the type.</p>\n"}],"return":{"type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"1\">The formatted TypeID.</p>\n"},"content.vb":"Public Shared Function FormatTypeName(namespacePrefix As String, typeName As String) As String"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONUtil.yml\" sourcestartlinenumber=\"2\">Formats a type name with its prefix to a GraphSON TypeID.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Allows to deserialize GraphSON to objects.</p>\n","Type":"class","Syntax":{"content":"public abstract class GraphSONReader","content.vb":"Public MustInherit Class GraphSONReader"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.Deserializers","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Contains the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer\" data-throw-if-not-resolved=\"false\"></xref> instances by their type identifier.</p>\n","Type":"field","Syntax":{"content":"protected readonly Dictionary<string, IGraphSONDeserializer> Deserializers","return":{"type":"System.Collections.Generic.Dictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer}"},"content.vb":"Protected ReadOnly Deserializers As Dictionary(Of String, IGraphSONDeserializer)"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Contains the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer\" data-throw-if-not-resolved=\"false\"></xref> instances by their type identifier.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected GraphSONReader()","content.vb":"Protected Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"protected GraphSONReader(IReadOnlyDictionary<string, IGraphSONDeserializer> deserializerByGraphSONType)","parameters":[{"id":"deserializerByGraphSONType","type":"System.Collections.Generic.IReadOnlyDictionary{System.String,Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\"><xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONDeserializer\" data-throw-if-not-resolved=\"false\"></xref> deserializers identified by their\nGraphSON type.</p>\n"}],"content.vb":"Protected Sub New(deserializerByGraphSONType As IReadOnlyDictionary(Of String, IGraphSONDeserializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.ToObject(System.Collections.Generic.IEnumerable{JToken})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Deserializes a GraphSON collection to an object.</p>\n","Type":"method","Syntax":{"content":"public virtual dynamic ToObject(IEnumerable<JToken> graphSonData)","parameters":[{"id":"graphSonData","type":"System.Collections.Generic.IEnumerable{JToken}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"1\">The GraphSON collection to deserialize.</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"1\">The deserialized object.</p>\n"},"content.vb":"Public Overridable Function ToObject(graphSonData As IEnumerable(Of JToken)) As Object"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Deserializes a GraphSON collection to an object.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.ToObject(JToken)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Deserializes GraphSON to an object.</p>\n","Type":"method","Syntax":{"content":"public virtual dynamic ToObject(JToken jToken)","parameters":[{"id":"jToken","type":"JToken","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"1\">The GraphSON to deserialize.</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"1\">The deserialized object.</p>\n"},"content.vb":"Public Overridable Function ToObject(jToken As JToken) As Object"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSONReader.yml\" sourcestartlinenumber=\"2\">Deserializes GraphSON to an object.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\">Handles serialization of GraphSON3 data.</p>\n","Type":"class","Syntax":{"content":"public class GraphSON3Writer : GraphSONWriter","content.vb":"Public Class GraphSON3Writer\n    Inherits GraphSONWriter"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON3Writer()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.#ctor(System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"constructor","Syntax":{"content":"public GraphSON3Writer(IReadOnlyDictionary<Type, IGraphSONSerializer> customSerializerByType)","parameters":[{"id":"customSerializerByType","type":"System.Collections.Generic.IReadOnlyDictionary{System.Type,Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\"><xref href=\"Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer\" data-throw-if-not-resolved=\"false\"></xref> serializers identified by their\n<xref href=\"System.Type\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Public Sub New(customSerializerByType As IReadOnlyDictionary(Of Type, IGraphSONSerializer))"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer.yml\" sourcestartlinenumber=\"2\">Creates a new instance of <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSON3Writer\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">A traverser represents the current state of an object flowing through a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class Traverser","content.vb":"Public Class Traverser"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.#ctor(System.Object,System.Int64)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Traverser(dynamic obj, long bulk = 1L)","parameters":[{"id":"obj","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"1\">The object of the traverser.</p>\n"},{"id":"bulk","type":"System.Int64","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"1\">The number of traversers represented in this traverser.</p>\n"}],"content.vb":"Public Sub New(obj As Object, bulk As Long = 1L)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Traverser\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.Object","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Gets the object of this traverser.</p>\n","Type":"property","Syntax":{"content":"public dynamic Object { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Object As Object"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Gets the object of this traverser.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.Bulk","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Gets the number of traversers represented in this traverser.</p>\n","Type":"property","Syntax":{"content":"public long Bulk { get; }","parameters":[],"return":{"type":"System.Int64"},"content.vb":"Public ReadOnly Property Bulk As Long"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml\" sourcestartlinenumber=\"2\">Gets the number of traversers represented in this traverser.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.Equals(Gremlin.Net.Process.Traversal.Traverser)","Type":"method","Syntax":{"content":"public bool Equals(Traverser other)","parameters":[{"id":"other","type":"Gremlin.Net.Process.Traversal.Traverser"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As Traverser) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Traverser.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Traverser.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Process.Traversal.TextP\" data-throw-if-not-resolved=\"false\"></xref> is a predicate of the form Func&lt;string, bool&gt;.\nThat is, given some string, return true or false.</p>\n","Type":"class","Syntax":{"content":"public class TextP : P, IPredicate","content.vb":"Public Class TextP\n    Inherits P\n    Implements IPredicate"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.#ctor(System.String,System.String,Gremlin.Net.Process.Traversal.P)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.TextP\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public TextP(string operatorName, string value, P other = null)","parameters":[{"id":"operatorName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"1\">The name of the predicate.</p>\n"},{"id":"value","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"1\">The value of the predicate.</p>\n"},{"id":"other","type":"Gremlin.Net.Process.Traversal.P","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"1\">An optional other predicate that is used as an argument for this predicate.</p>\n"}],"content.vb":"Public Sub New(operatorName As String, value As String, other As P = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.TextP.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.TextP\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.Containing(System.String)","Type":"method","Syntax":{"content":"public static TextP Containing(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function Containing(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.EndingWith(System.String)","Type":"method","Syntax":{"content":"public static TextP EndingWith(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function EndingWith(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.NotContaining(System.String)","Type":"method","Syntax":{"content":"public static TextP NotContaining(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function NotContaining(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.NotEndingWith(System.String)","Type":"method","Syntax":{"content":"public static TextP NotEndingWith(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function NotEndingWith(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.NotStartingWith(System.String)","Type":"method","Syntax":{"content":"public static TextP NotStartingWith(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function NotStartingWith(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.StartingWith(System.String)","Type":"method","Syntax":{"content":"public static TextP StartingWith(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.TextP"},"content.vb":"Public Shared Function StartingWith(value As String) As TextP"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.TextP.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.TextP.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml\" sourcestartlinenumber=\"2\">Provides a common base class for strategies that are only included in <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref>\nto be applied remotely.</p>\n","Type":"class","Syntax":{"content":"public abstract class AbstractTraversalStrategy : ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public MustInherit Class AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.StrategyName","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml\" sourcestartlinenumber=\"2\">Gets the name of the strategy.</p>\n","Type":"property","Syntax":{"content":"public string StrategyName { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property StrategyName As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml\" sourcestartlinenumber=\"2\">Gets the name of the strategy.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.Configuration","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml\" sourcestartlinenumber=\"2\">Gets the configuration of the strategy.</p>\n","Type":"property","Syntax":{"content":"public Dictionary<string, dynamic> Configuration { get; }","parameters":[],"return":{"type":"System.Collections.Generic.Dictionary{System.String,System.Object}"},"content.vb":"Public ReadOnly Property Configuration As Dictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml\" sourcestartlinenumber=\"2\">Gets the configuration of the strategy.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.Equals(Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy)","Type":"method","Syntax":{"content":"public bool Equals(AbstractTraversalStrategy other)","parameters":[{"id":"other","type":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As AbstractTraversalStrategy) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.Apply``2(Gremlin.Net.Process.Traversal.ITraversal{``0,``1})","Type":"method","Syntax":{"content":"public virtual void Apply<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal{{S},{E}}"}],"typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Public Overridable Sub Apply(Of S, E)(traversal As ITraversal(Of S, E))"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.ApplyAsync``2(Gremlin.Net.Process.Traversal.ITraversal{``0,``1})","Type":"method","Syntax":{"content":"public virtual Task ApplyAsync<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal{{S},{E}}"}],"typeParameters":[{"id":"S"},{"id":"E"}],"return":{"type":"System.Threading.Tasks.Task"},"content.vb":"Public Overridable Function ApplyAsync(Of S, E)(traversal As ITraversal(Of S, E)) As Task"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.AbstractTraversalStrategy.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Process.Traversal.ITraversalStrategy\" data-throw-if-not-resolved=\"false\"></xref> defines a particular atomic operation for mutating a\n<xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> prior to its evaluation.</p>\n","Type":"interface","Syntax":{"content":"public interface ITraversalStrategy","content.vb":"Public Interface ITraversalStrategy"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalStrategy.Apply``2(Gremlin.Net.Process.Traversal.ITraversal{``0,``1})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"2\">Applies the strategy to the given <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"void Apply<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal{{S},{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> the strategy should be applied to.</p>\n"}],"typeParameters":[{"id":"S"},{"id":"E"}],"content.vb":"Sub Apply(Of S, E)(traversal As ITraversal(Of S, E))"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"2\">Applies the strategy to the given <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalStrategy.ApplyAsync``2(Gremlin.Net.Process.Traversal.ITraversal{``0,``1})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"2\">Applies the strategy to the given <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> asynchronously.</p>\n","Type":"method","Syntax":{"content":"Task ApplyAsync<S, E>(ITraversal<S, E> traversal)","parameters":[{"id":"traversal","type":"Gremlin.Net.Process.Traversal.ITraversal{{S},{E}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> the strategy should be applied to.</p>\n"}],"typeParameters":[{"id":"S"},{"id":"E"}],"return":{"type":"System.Threading.Tasks.Task"},"content.vb":"Function ApplyAsync(Of S, E)(traversal As ITraversal(Of S, E)) As Task"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalStrategy.yml\" sourcestartlinenumber=\"2\">Applies the strategy to the given <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> asynchronously.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalSideEffects","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> can maintain global sideEffects.</p>\n","Type":"interface","Syntax":{"content":"public interface ITraversalSideEffects : IDisposable","content.vb":"Public Interface ITraversalSideEffects\n    Inherits IDisposable"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalSideEffects.Keys","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Retrieves the keys of the side-effect that can be supplied to <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects.Get(System.String)\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"method","Syntax":{"content":"IReadOnlyCollection<string> Keys()","return":{"type":"System.Collections.Generic.IReadOnlyCollection{System.String}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"1\">The keys of the side-effect.</p>\n"},"content.vb":"Function Keys As IReadOnlyCollection(Of String)"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Retrieves the keys of the side-effect that can be supplied to <xref href=\"Gremlin.Net.Process.Traversal.ITraversalSideEffects.Get(System.String)\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalSideEffects.Get(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Gets the side-effect associated with the provided key.</p>\n","Type":"method","Syntax":{"content":"object Get(string key)","parameters":[{"id":"key","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"1\">The key to get the value for.</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"1\">The value associated with key.</p>\n"},"content.vb":"Function Get(key As String) As Object"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Gets the side-effect associated with the provided key.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ITraversalSideEffects.Close","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Invalidates the side effect cache for traversal.</p>\n","Type":"method","Syntax":{"content":"void Close()","content.vb":"Sub Close"},"File":"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ITraversalSideEffects.yml\" sourcestartlinenumber=\"2\">Invalidates the side effect cache for traversal.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.IBiFunction","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.IBiFunction.yml\" sourcestartlinenumber=\"2\">Represents a function that accepts two arguments and produces a result. This is the two-arity specialization of\n<xref href=\"Gremlin.Net.Process.Traversal.IFunction\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"interface","Syntax":{"content":"public interface IBiFunction","content.vb":"Public Interface IBiFunction"},"File":"obj/api/Gremlin.Net.Process.Traversal.IBiFunction.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ConnectedComponent","Type":"class","Syntax":{"content":"public class ConnectedComponent","content.vb":"Public Class ConnectedComponent"},"File":"obj/api/Gremlin.Net.Process.Traversal.ConnectedComponent.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ConnectedComponent.component","Type":"field","Syntax":{"content":"public const string component = \"gremlin.connectedComponentVertexProgram.component\"","return":{"type":"System.String"},"content.vb":"Public Const component As String = \"gremlin.connectedComponentVertexProgram.component\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ConnectedComponent.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ConnectedComponent.edges","Type":"field","Syntax":{"content":"public const string edges = \"~tinkerpop.connectedComponent.edges\"","return":{"type":"System.String"},"content.vb":"Public Const edges As String = \"~tinkerpop.connectedComponent.edges\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ConnectedComponent.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ConnectedComponent.propertyName","Type":"field","Syntax":{"content":"public const string propertyName = \"~tinkerpop.connectedComponent.propertyName\"","return":{"type":"System.String"},"content.vb":"Public Const propertyName As String = \"~tinkerpop.connectedComponent.propertyName\""},"File":"obj/api/Gremlin.Net.Process.Traversal.ConnectedComponent.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinServer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Represents a Gremlin Server.</p>\n","Type":"class","Syntax":{"content":"public class GremlinServer","content.vb":"Public Class GremlinServer"},"File":"obj/api/Gremlin.Net.Driver.GremlinServer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinServer.#ctor(System.String,System.Int32,System.Boolean,System.String,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.GremlinServer\" data-throw-if-not-resolved=\"false\"></xref> class with the specified connection parameters.</p>\n","Type":"constructor","Syntax":{"content":"public GremlinServer(string hostname = \"localhost\", int port = 8182, bool enableSsl = false, string username = null, string password = null)","parameters":[{"id":"hostname","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">The hostname of the server.</p>\n"},{"id":"port","type":"System.Int32","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">The port on which Gremlin Server can be reached.</p>\n"},{"id":"enableSsl","type":"System.Boolean","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">Specifies whether SSL should be enabled.</p>\n"},{"id":"username","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">The username to submit on requests that require authentication.</p>\n"},{"id":"password","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">The password to submit on requests that require authentication.</p>\n"}],"content.vb":"Public Sub New(hostname As String = \"localhost\", port As Integer = 8182, enableSsl As Boolean = False, username As String = Nothing, password As String = Nothing)"},"File":"obj/api/Gremlin.Net.Driver.GremlinServer.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.GremlinServer\" data-throw-if-not-resolved=\"false\"></xref> class with the specified connection parameters.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinServer.Uri","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the URI of the Gremlin Server.</p>\n","Type":"property","Syntax":{"content":"public Uri Uri { get; }","parameters":[],"return":{"type":"Uri","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"1\">The WebSocket <see cref=\"!:System.Uri\"></see> that the Gremlin Server responds to.</p>\n"},"content.vb":"Public ReadOnly Property Uri As Uri"},"File":"obj/api/Gremlin.Net.Driver.GremlinServer.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the URI of the Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinServer.Username","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the username to submit on requests that require authentication.</p>\n","Type":"property","Syntax":{"content":"public string Username { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Username As String"},"File":"obj/api/Gremlin.Net.Driver.GremlinServer.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the username to submit on requests that require authentication.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinServer.Password","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the password to submit on requests that require authentication.</p>\n","Type":"property","Syntax":{"content":"public string Password { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Password As String"},"File":"obj/api/Gremlin.Net.Driver.GremlinServer.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinServer.yml\" sourcestartlinenumber=\"2\">Gets the password to submit on requests that require authentication.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.IncidentToAdjacentStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.IncidentToAdjacentStrategy.yml\" sourcestartlinenumber=\"2\">Replaces <code>.OutE().InV()</code> with <code>.Out()</code>, <code>.InE().OutV()</code> with <code>In()</code> and <code>.BothE().BothV()</code>\nwith <code>Both()</code>.</p>\n","Type":"class","Syntax":{"content":"public class IncidentToAdjacentStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class IncidentToAdjacentStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.IncidentToAdjacentStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.IdentityRemovalStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.IdentityRemovalStrategy.yml\" sourcestartlinenumber=\"2\">Looks for <code>Identity()</code>-steps and removes them.</p>\n","Type":"class","Syntax":{"content":"public class IdentityRemovalStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class IdentityRemovalStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.IdentityRemovalStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy","Type":"class","Syntax":{"content":"public class MatchAlgorithmStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class MatchAlgorithmStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy.#ctor","Type":"constructor","Syntax":{"content":"public MatchAlgorithmStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy.#ctor(System.String)","Type":"constructor","Syntax":{"content":"public MatchAlgorithmStrategy(string matchAlgorithm = null)","parameters":[{"id":"matchAlgorithm","type":"System.String"}],"content.vb":"Public Sub New(matchAlgorithm As String = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Finalization.MatchAlgorithmStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy","Type":"class","Syntax":{"content":"public class HaltedTraverserStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class HaltedTraverserStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy.#ctor","Type":"constructor","Syntax":{"content":"public HaltedTraverserStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy.#ctor(System.String)","Type":"constructor","Syntax":{"content":"public HaltedTraverserStrategy(string haltedTraverserFactoryName = null)","parameters":[{"id":"haltedTraverserFactoryName","type":"System.String"}],"content.vb":"Public Sub New(haltedTraverserFactoryName As String = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.HaltedTraverserStrategy.yml","Metadata":{"type":"constructor","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.ElementIdStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.ElementIdStrategy.yml\" sourcestartlinenumber=\"2\">Provides a degree of control over element identifier assignment as some graphs don't provide that feature.</p>\n","Type":"class","Syntax":{"content":"public class ElementIdStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class ElementIdStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.ElementIdStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PeerPressure","Type":"class","Syntax":{"content":"public class PeerPressure","content.vb":"Public Class PeerPressure"},"File":"obj/api/Gremlin.Net.Process.Traversal.PeerPressure.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PeerPressure.edges","Type":"field","Syntax":{"content":"public const string edges = \"~tinkerpop.peerPressure.edges\"","return":{"type":"System.String"},"content.vb":"Public Const edges As String = \"~tinkerpop.peerPressure.edges\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PeerPressure.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PeerPressure.propertyName","Type":"field","Syntax":{"content":"public const string propertyName = \"~tinkerpop.peerPressure.propertyName\"","return":{"type":"System.String"},"content.vb":"Public Const propertyName As String = \"~tinkerpop.peerPressure.propertyName\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PeerPressure.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.PeerPressure.times","Type":"field","Syntax":{"content":"public const string times = \"~tinkerpop.peerPressure.times\"","return":{"type":"System.String"},"content.vb":"Public Const times As String = \"~tinkerpop.peerPressure.times\""},"File":"obj/api/Gremlin.Net.Process.Traversal.PeerPressure.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Provides extension methods for the <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> interface.</p>\n","Type":"class","Syntax":{"content":"public static class GremlinClientExtensions","content.vb":"Public Module GremlinClientExtensions"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions.SubmitWithSingleResultAsync``1(Gremlin.Net.Driver.IGremlinClient,System.String,System.Collections.Generic.Dictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation where only a single\nresult gets returned.</p>\n","Type":"method","Syntax":{"content":"public static Task<T> SubmitWithSingleResultAsync<T>(this IGremlinClient gremlinClient, string requestScript, Dictionary<string, object> bindings = null)","parameters":[{"id":"gremlinClient","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that submits the request.</p>\n"},{"id":"requestScript","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The Gremlin request script to send.</p>\n"},{"id":"bindings","type":"System.Collections.Generic.Dictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">Bindings for parameters used in the requestScript.</p>\n"}],"typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The type of the expected result.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{{T}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">A single result received from the Gremlin Server.</p>\n"},"content.vb":"<ExtensionAttribute>\nPublic Shared Function SubmitWithSingleResultAsync(Of T)(gremlinClient As IGremlinClient, requestScript As String, bindings As Dictionary(Of String, Object) = Nothing) As Task(Of T)"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation where only a single\nresult gets returned.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions.SubmitWithSingleResultAsync``1(Gremlin.Net.Driver.IGremlinClient,Gremlin.Net.Driver.Messages.RequestMessage)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation where only a single result gets returned.</p>\n","Type":"method","Syntax":{"content":"public static Task<T> SubmitWithSingleResultAsync<T>(this IGremlinClient gremlinClient, RequestMessage requestMessage)","parameters":[{"id":"gremlinClient","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that submits the request.</p>\n"},{"id":"requestMessage","type":"Gremlin.Net.Driver.Messages.RequestMessage","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> to send.</p>\n"}],"typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The type of the expected result.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{{T}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">A single result received from the Gremlin Server.</p>\n"},"content.vb":"<ExtensionAttribute>\nPublic Shared Function SubmitWithSingleResultAsync(Of T)(gremlinClient As IGremlinClient, requestMessage As RequestMessage) As Task(Of T)"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation where only a single result gets returned.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions.SubmitAsync(Gremlin.Net.Driver.IGremlinClient,System.String,System.Collections.Generic.Dictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation without returning\nthe result received from the Gremlin Server.</p>\n","Type":"method","Syntax":{"content":"public static Task SubmitAsync(this IGremlinClient gremlinClient, string requestScript, Dictionary<string, object> bindings = null)","parameters":[{"id":"gremlinClient","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that submits the request.</p>\n"},{"id":"requestScript","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The Gremlin request script to send.</p>\n"},{"id":"bindings","type":"System.Collections.Generic.Dictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">Bindings for parameters used in the requestScript.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The task object representing the asynchronous operation.</p>\n"},"content.vb":"<ExtensionAttribute>\nPublic Shared Function SubmitAsync(gremlinClient As IGremlinClient, requestScript As String, bindings As Dictionary(Of String, Object) = Nothing) As Task"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation without returning\nthe result received from the Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions.SubmitAsync(Gremlin.Net.Driver.IGremlinClient,Gremlin.Net.Driver.Messages.RequestMessage)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation without returning the result received from the Gremlin\nServer.</p>\n","Type":"method","Syntax":{"content":"public static Task SubmitAsync(this IGremlinClient gremlinClient, RequestMessage requestMessage)","parameters":[{"id":"gremlinClient","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that submits the request.</p>\n"},{"id":"requestMessage","type":"Gremlin.Net.Driver.Messages.RequestMessage","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.Messages.RequestMessage\" data-throw-if-not-resolved=\"false\"></xref> to send.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The task object representing the asynchronous operation.</p>\n"},"content.vb":"<ExtensionAttribute>\nPublic Shared Function SubmitAsync(gremlinClient As IGremlinClient, requestMessage As RequestMessage) As Task"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message as an asynchronous operation without returning the result received from the Gremlin\nServer.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.GremlinClientExtensions.SubmitAsync``1(Gremlin.Net.Driver.IGremlinClient,System.String,System.Collections.Generic.Dictionary{System.String,System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation.</p>\n","Type":"method","Syntax":{"content":"public static Task<ResultSet<T>> SubmitAsync<T>(this IGremlinClient gremlinClient, string requestScript, Dictionary<string, object> bindings = null)","parameters":[{"id":"gremlinClient","type":"Gremlin.Net.Driver.IGremlinClient","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Driver.IGremlinClient\" data-throw-if-not-resolved=\"false\"></xref> that submits the request.</p>\n"},{"id":"requestScript","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The Gremlin request script to send.</p>\n"},{"id":"bindings","type":"System.Collections.Generic.Dictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">Bindings for parameters used in the requestScript.</p>\n"}],"typeParameters":[{"id":"T","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">The type of the expected results.</p>\n"}],"return":{"type":"System.Threading.Tasks.Task{Gremlin.Net.Driver.ResultSet{{T}}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Driver.ResultSet%601\" data-throw-if-not-resolved=\"false\"></xref> containing the data and status attributes returned from the server.</p>\n"},"content.vb":"<ExtensionAttribute>\nPublic Shared Function SubmitAsync(Of T)(gremlinClient As IGremlinClient, requestScript As String, bindings As Dictionary(Of String, Object) = Nothing) As Task(Of ResultSet(Of T))"},"File":"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.GremlinClientExtensions.yml\" sourcestartlinenumber=\"2\">Submits a request message that consists of a script with bindings as an asynchronous operation.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">A Path denotes a particular walk through a graph as defined by a <see cref=\"!:ITraversal\"></see>.</p>\n","Type":"class","Syntax":{"content":"public class Path : IReadOnlyList<object>, IReadOnlyCollection<object>, IEnumerable<object>, IEnumerable, IEquatable<Path>","content.vb":"Public Class Path\n    Implements IReadOnlyList(Of Object), IReadOnlyCollection(Of Object), IEnumerable(Of Object), IEnumerable, IEquatable(Of Path)"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.#ctor(System.Collections.Generic.IList{ISet{System.String}},System.Collections.Generic.IList{System.Object})","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Path(IList<ISet<string>> labels, IList<object> objects)","parameters":[{"id":"labels","type":"System.Collections.Generic.IList{ISet{System.String}}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The labels associated with the path</p>\n"},{"id":"objects","type":"System.Collections.Generic.IList{System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The objects in the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Public Sub New(labels As IList(Of ISet(Of String)), objects As IList(Of Object))"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Labels","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets an ordered list of the labels associated with the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public IList<ISet<string>> Labels { get; }","parameters":[],"return":{"type":"System.Collections.Generic.IList{ISet{System.String}}"},"content.vb":"Public ReadOnly Property Labels As IList(Of ISet(Of String))"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets an ordered list of the labels associated with the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Objects","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets an ordered list of the objects in the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public IList<object> Objects { get; }","parameters":[],"return":{"type":"System.Collections.Generic.IList{System.Object}"},"content.vb":"Public ReadOnly Property Objects As IList(Of Object)"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets an ordered list of the objects in the <xref href=\"Gremlin.Net.Structure.Path\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Item(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets the object associated with the particular label of the path.</p>\n","Type":"property","Syntax":{"content":"public object this[string label] { get; }","parameters":[{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The label of the path</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The object associated with the label of the path</p>\n"},"content.vb":"Public ReadOnly Property Item(label As String) As Object"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets the object associated with the particular label of the path.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Equals(Gremlin.Net.Structure.Path)","Type":"method","Syntax":{"content":"public bool Equals(Path other)","parameters":[{"id":"other","type":"Gremlin.Net.Structure.Path"}],"return":{"type":"System.Boolean"},"content.vb":"Public Function Equals(other As Path) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Item(System.Int32)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Get the object associated with the specified index into the path.</p>\n","Type":"property","Syntax":{"content":"public dynamic this[int index] { get; }","parameters":[{"id":"index","type":"System.Int32","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The index of the path</p>\n"}],"return":{"type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The object associated with the index of the path</p>\n"},"content.vb":"Public ReadOnly Property Item(index As Integer) As Object"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Get the object associated with the specified index into the path.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Count","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets the number of steps in the path.</p>\n","Type":"property","Syntax":{"content":"public int Count { get; }","parameters":[],"return":{"type":"System.Int32"},"content.vb":"Public ReadOnly Property Count As Integer"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Gets the number of steps in the path.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.GetEnumerator","Type":"method","Syntax":{"content":"public IEnumerator<object> GetEnumerator()","return":{"type":"System.Collections.Generic.IEnumerator{System.Object}"},"content.vb":"Public Function GetEnumerator As IEnumerator(Of Object)"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.ContainsKey(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Returns true if the path has the specified label, else return false.</p>\n","Type":"method","Syntax":{"content":"public bool ContainsKey(string key)","parameters":[{"id":"key","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The label to search for.</p>\n"}],"return":{"type":"System.Boolean","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">True if the label exists in the path.</p>\n"},"content.vb":"Public Function ContainsKey(key As String) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Returns true if the path has the specified label, else return false.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.TryGetValue(System.String,System.Object@)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Tries to get the object associated with the particular label of the path.</p>\n","Type":"method","Syntax":{"content":"public bool TryGetValue(string label, out object value)","parameters":[{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The label of the path.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">The object associated with the label of the path.</p>\n"}],"return":{"type":"System.Boolean","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"1\">True, if an object was found for the label.</p>\n"},"content.vb":"Public Function TryGetValue(label As String, ByRef value As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Path.yml\" sourcestartlinenumber=\"2\">Tries to get the object associated with the particular label of the path.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.Equals(System.Object)","Type":"method","Syntax":{"content":"public override bool Equals(object obj)","parameters":[{"id":"obj","type":"System.Object"}],"return":{"type":"System.Boolean"},"content.vb":"Public Overrides Function Equals(obj As Object) As Boolean"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Path.GetHashCode","Type":"method","Syntax":{"content":"public override int GetHashCode()","return":{"type":"System.Int32"},"content.vb":"Public Overrides Function GetHashCode As Integer"},"File":"obj/api/Gremlin.Net.Structure.Path.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"2\">Supports serializing of an object to GraphSON.</p>\n","Type":"interface","Syntax":{"content":"public interface IGraphSONSerializer","content.vb":"Public Interface IGraphSONSerializer"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.Dictify(System.Object,Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"2\">Transforms an object into a dictionary that resembles its GraphSON representation.</p>\n","Type":"method","Syntax":{"content":"Dictionary<string, dynamic> Dictify(dynamic objectData, GraphSONWriter writer)","parameters":[{"id":"objectData","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"1\">The object to dictify.</p>\n"},{"id":"writer","type":"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"1\">A <xref href=\"Gremlin.Net.Structure.IO.GraphSON.GraphSONWriter\" data-throw-if-not-resolved=\"false\"></xref> that can be used to dictify properties of the object.</p>\n"}],"return":{"type":"System.Collections.Generic.Dictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"1\">The GraphSON representation.</p>\n"},"content.vb":"Function Dictify(objectData As Object, writer As GraphSONWriter) As Dictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.IO.GraphSON.IGraphSONSerializer.yml\" sourcestartlinenumber=\"2\">Transforms an object into a dictionary that resembles its GraphSON representation.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"2\">Provides a way to limit the view of a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class SubgraphStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class SubgraphStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public SubgraphStrategy()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.#ctor(Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal,Gremlin.Net.Process.Traversal.ITraversal)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public SubgraphStrategy(ITraversal vertices = null, ITraversal edges = null, ITraversal vertexProperties = null)","parameters":[{"id":"vertices","type":"Gremlin.Net.Process.Traversal.ITraversal","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"1\">Constrains vertices for the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},{"id":"edges","type":"Gremlin.Net.Process.Traversal.ITraversal","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"1\">Constrains edges for the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"},{"id":"vertexProperties","type":"Gremlin.Net.Process.Traversal.ITraversal","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"1\">Constrains vertex properties for the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Public Sub New(vertices As ITraversal = Nothing, edges As ITraversal = Nothing, vertexProperties As ITraversal = Nothing)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Strategy.Decoration.SubgraphStrategy\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop","Type":"class","Syntax":{"content":"public class Pop : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class Pop\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop.All","Type":"property","Syntax":{"content":"public static Pop All { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pop"},"content.vb":"Public Shared ReadOnly Property All As Pop"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop.First","Type":"property","Syntax":{"content":"public static Pop First { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pop"},"content.vb":"Public Shared ReadOnly Property First As Pop"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop.Last","Type":"property","Syntax":{"content":"public static Pop Last { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pop"},"content.vb":"Public Shared ReadOnly Property Last As Pop"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop.Mixed","Type":"property","Syntax":{"content":"public static Pop Mixed { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pop"},"content.vb":"Public Shared ReadOnly Property Mixed As Pop"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pop.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Pop.yml\" sourcestartlinenumber=\"2\">Gets the Pop enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Pop GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Pop"},"content.vb":"Public Shared Function GetByValue(value As String) As Pop"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pop.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Pop.yml\" sourcestartlinenumber=\"2\">Gets the Pop enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pick","Type":"class","Syntax":{"content":"public class Pick : EnumWrapper, IEquatable<EnumWrapper>","content.vb":"Public Class Pick\n    Inherits EnumWrapper\n    Implements IEquatable(Of EnumWrapper)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pick.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pick.Any","Type":"property","Syntax":{"content":"public static Pick Any { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pick"},"content.vb":"Public Shared ReadOnly Property Any As Pick"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pick.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pick.None","Type":"property","Syntax":{"content":"public static Pick None { get; }","parameters":[],"return":{"type":"Gremlin.Net.Process.Traversal.Pick"},"content.vb":"Public Shared ReadOnly Property None As Pick"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pick.yml","Metadata":{"type":"property","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Pick.GetByValue(System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Pick.yml\" sourcestartlinenumber=\"2\">Gets the Pick enumeration by value.</p>\n","Type":"method","Syntax":{"content":"public static Pick GetByValue(string value)","parameters":[{"id":"value","type":"System.String"}],"return":{"type":"Gremlin.Net.Process.Traversal.Pick"},"content.vb":"Public Shared Function GetByValue(value As String) As Pick"},"File":"obj/api/Gremlin.Net.Process.Traversal.Pick.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Pick.yml\" sourcestartlinenumber=\"2\">Gets the Pick enumeration by value.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.ISupplier","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.ISupplier.yml\" sourcestartlinenumber=\"2\">Represents a supplier of results</p>\n","Type":"interface","Syntax":{"content":"public interface ISupplier","content.vb":"Public Interface ISupplier"},"File":"obj/api/Gremlin.Net.Process.Traversal.ISupplier.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Exceptions.ResponseException","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">The exception that is thrown when a response is received from Gremlin Server that indicates that an error occurred.</p>\n","Type":"class","Syntax":{"content":"public class ResponseException : Exception, ISerializable, _Exception","content.vb":"Public Class ResponseException\n    Inherits Exception\n    Implements ISerializable, _Exception"},"File":"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Exceptions.ResponseException.#ctor(Gremlin.Net.Driver.Messages.ResponseStatusCode,System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object},System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.Exceptions.ResponseException\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public ResponseException(ResponseStatusCode statusCode, IReadOnlyDictionary<string, object> statusAttributes, string message)","parameters":[{"id":"statusCode","type":"Gremlin.Net.Driver.Messages.ResponseStatusCode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"1\">The status code returned by the server.</p>\n"},{"id":"statusAttributes","type":"System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object}","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"1\">The status attributes from the gremlin response.</p>\n"},{"id":"message","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"1\">The error message string.</p>\n"}],"content.vb":"Public Sub New(statusCode As ResponseStatusCode, statusAttributes As IReadOnlyDictionary(Of String, Object), message As String)"},"File":"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Driver.Exceptions.ResponseException\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Exceptions.ResponseException.StatusCode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Gets the status code returned from the server.</p>\n","Type":"property","Syntax":{"content":"public ResponseStatusCode StatusCode { get; }","parameters":[],"return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"},"content.vb":"Public ReadOnly Property StatusCode As ResponseStatusCode"},"File":"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Gets the status code returned from the server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Exceptions.ResponseException.StatusAttributes","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Gets the status attributes from the gremlin response</p>\n","Type":"property","Syntax":{"content":"public IReadOnlyDictionary<string, object> StatusAttributes { get; }","parameters":[],"return":{"type":"System.Collections.Generic.IReadOnlyDictionary{System.String,System.Object}"},"content.vb":"Public ReadOnly Property StatusAttributes As IReadOnlyDictionary(Of String, Object)"},"File":"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Exceptions.ResponseException.yml\" sourcestartlinenumber=\"2\">Gets the status attributes from the gremlin response</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">A <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref> denotes a key/value pair associated with a <xref href=\"Gremlin.Net.Structure.VertexProperty.Vertex\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"class","Syntax":{"content":"public class VertexProperty : Element, IEquatable<Element>","content.vb":"Public Class VertexProperty\n    Inherits Element\n    Implements IEquatable(Of Element)"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty.#ctor(System.Object,System.String,System.Object,Gremlin.Net.Structure.Vertex)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public VertexProperty(object id, string label, dynamic value, Vertex vertex)","parameters":[{"id":"id","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"1\">The id of the vertex property.</p>\n"},{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"1\">The label of the vertex property.</p>\n"},{"id":"value","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"1\">The id of the vertex property.</p>\n"},{"id":"vertex","type":"Gremlin.Net.Structure.Vertex","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"1\">The <xref href=\"Gremlin.Net.Structure.VertexProperty.Vertex\" data-throw-if-not-resolved=\"false\"></xref> that owns this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n"}],"content.vb":"Public Sub New(id As Object, label As String, value As Object, vertex As Vertex)"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty.Value","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The value of this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public dynamic Value { get; }","parameters":[],"return":{"type":"System.Object"},"content.vb":"Public ReadOnly Property Value As Object"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The value of this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty.Vertex","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The <xref href=\"Gremlin.Net.Structure.VertexProperty.Vertex\" data-throw-if-not-resolved=\"false\"></xref> that owns this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public Vertex Vertex { get; }","parameters":[],"return":{"type":"Gremlin.Net.Structure.Vertex"},"content.vb":"Public ReadOnly Property Vertex As Vertex"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The <xref href=\"Gremlin.Net.Structure.VertexProperty.Vertex\" data-throw-if-not-resolved=\"false\"></xref> that owns this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty.Key","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The key of this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","Type":"property","Syntax":{"content":"public string Key { get; }","parameters":[],"return":{"type":"System.String"},"content.vb":"Public ReadOnly Property Key As String"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.VertexProperty.yml\" sourcestartlinenumber=\"2\">The key of this <xref href=\"Gremlin.Net.Structure.VertexProperty\" data-throw-if-not-resolved=\"false\"></xref>.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.VertexProperty.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Structure.VertexProperty.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Vertex","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"2\">Represents a vertex.</p>\n","Type":"class","Syntax":{"content":"public class Vertex : Element, IEquatable<Element>","content.vb":"Public Class Vertex\n    Inherits Element\n    Implements IEquatable(Of Element)"},"File":"obj/api/Gremlin.Net.Structure.Vertex.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Vertex.DefaultLabel","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"2\">The default label to use for a vertex.</p>\n","Type":"field","Syntax":{"content":"public const string DefaultLabel = \"vertex\"","return":{"type":"System.String"},"content.vb":"Public Const DefaultLabel As String = \"vertex\""},"File":"obj/api/Gremlin.Net.Structure.Vertex.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"2\">The default label to use for a vertex.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Vertex.#ctor(System.Object,System.String)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Vertex\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Vertex(object id, string label = \"vertex\")","parameters":[{"id":"id","type":"System.Object","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"1\">The id of the vertex.</p>\n"},{"id":"label","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"1\">The label of the vertex.</p>\n"}],"content.vb":"Public Sub New(id As Object, label As String = \"vertex\")"},"File":"obj/api/Gremlin.Net.Structure.Vertex.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Structure.Vertex.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Structure.Vertex\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.Vertex.ToString","Type":"method","Syntax":{"content":"public override string ToString()","return":{"type":"System.String"},"content.vb":"Public Overrides Function ToString As String"},"File":"obj/api/Gremlin.Net.Structure.Vertex.yml","Metadata":{"type":"method","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization.OrderLimitStrategy","Type":"class","Syntax":{"content":"public class OrderLimitStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class OrderLimitStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.OrderLimitStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Decoration.ConnectiveStrategy","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.ConnectiveStrategy.yml\" sourcestartlinenumber=\"2\">ConnectiveStrategy rewrites the binary conjunction form of <code>a.and().b</code> into an AndStep of\n<code>and(a, b)</code> (likewise for OrStep).</p>\n","Type":"class","Syntax":{"content":"public class ConnectiveStrategy : AbstractTraversalStrategy, ITraversalStrategy, IEquatable<AbstractTraversalStrategy>","content.vb":"Public Class ConnectiveStrategy\n    Inherits AbstractTraversalStrategy\n    Implements ITraversalStrategy, IEquatable(Of AbstractTraversalStrategy)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Decoration.ConnectiveStrategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml\" sourcestartlinenumber=\"2\">Configuration options to be passed to the <code>With()</code> modulator.</p>\n","Type":"class","Syntax":{"content":"public class WithOptions","content.vb":"Public Class WithOptions"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Tokens","Type":"field","Syntax":{"content":"public static readonly string Tokens","return":{"type":"System.String"},"content.vb":"Public Shared ReadOnly Tokens As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.None","Type":"field","Syntax":{"content":"public static readonly int None","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly None As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Ids","Type":"field","Syntax":{"content":"public static readonly int Ids","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly Ids As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Labels","Type":"field","Syntax":{"content":"public static readonly int Labels","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly Labels As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Keys","Type":"field","Syntax":{"content":"public static readonly int Keys","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly Keys As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Values","Type":"field","Syntax":{"content":"public static readonly int Values","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly Values As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.All","Type":"field","Syntax":{"content":"public static readonly int All","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly All As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Indexer","Type":"field","Syntax":{"content":"public static readonly string Indexer","return":{"type":"System.String"},"content.vb":"Public Shared ReadOnly Indexer As String"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.List","Type":"field","Syntax":{"content":"public static readonly int List","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly List As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Step.Util.WithOptions.Map","Type":"field","Syntax":{"content":"public static readonly int Map","return":{"type":"System.Int32"},"content.vb":"Public Shared ReadOnly Map As Integer"},"File":"obj/api/Gremlin.Net.Process.Traversal.Step.Util.WithOptions.yml","Metadata":{"type":"field","summary":null,"platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">A language agnostic representation of <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> mutations.</p>\n","Type":"class","Syntax":{"content":"public class Bytecode","content.vb":"Public Class Bytecode"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.#ctor","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Bytecode()","content.vb":"Public Sub New"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.#ctor(Gremlin.Net.Process.Traversal.Bytecode)","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","Type":"constructor","Syntax":{"content":"public Bytecode(Bytecode byteCode)","parameters":[{"id":"byteCode","type":"Gremlin.Net.Process.Traversal.Bytecode","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"1\">Already existing <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> that should be cloned.</p>\n"}],"content.vb":"Public Sub New(byteCode As Bytecode)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"constructor","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Initializes a new instance of the <xref href=\"Gremlin.Net.Process.Traversal.Bytecode\" data-throw-if-not-resolved=\"false\"></xref> class.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.SourceInstructions","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Gets the traversal source instructions.</p>\n","Type":"property","Syntax":{"content":"public List<Instruction> SourceInstructions { get; }","parameters":[],"return":{"type":"System.Collections.Generic.List{Gremlin.Net.Process.Traversal.Instruction}"},"content.vb":"Public ReadOnly Property SourceInstructions As List(Of Instruction)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Gets the traversal source instructions.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.StepInstructions","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> instructions.</p>\n","Type":"property","Syntax":{"content":"public List<Instruction> StepInstructions { get; }","parameters":[],"return":{"type":"System.Collections.Generic.List{Gremlin.Net.Process.Traversal.Instruction}"},"content.vb":"Public ReadOnly Property StepInstructions As List(Of Instruction)"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"property","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Gets the <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> instructions.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.AddSource(System.String,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Add a traversal source instruction to the bytecode.</p>\n","Type":"method","Syntax":{"content":"public void AddSource(string sourceName, params object[] args)","parameters":[{"id":"sourceName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"1\">The traversal source method name (e.g. withSack()).</p>\n"},{"id":"args","type":"System.Object[]","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"1\">The traversal source method arguments.</p>\n"}],"content.vb":"Public Sub AddSource(sourceName As String, ParamArray args As Object())"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Add a traversal source instruction to the bytecode.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Bytecode.AddStep(System.String,System.Object[])","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Adds a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> instruction to the bytecode.</p>\n","Type":"method","Syntax":{"content":"public void AddStep(string stepName, params object[] args)","parameters":[{"id":"stepName","type":"System.String","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"1\">The traversal method name (e.g. out()).</p>\n"},{"id":"args","type":"System.Object[]","description":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"1\">The traversal method arguments.</p>\n"}],"content.vb":"Public Sub AddStep(stepName As String, ParamArray args As Object())"},"File":"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml","Metadata":{"type":"method","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Process.Traversal.Bytecode.yml\" sourcestartlinenumber=\"2\">Adds a <xref href=\"Gremlin.Net.Process.Traversal.ITraversal\" data-throw-if-not-resolved=\"false\"></xref> instruction to the bytecode.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">Represents the various status codes that Gremlin Server returns.</p>\n","Type":"enum","Syntax":{"content":"public enum ResponseStatusCode","content.vb":"Public Enum ResponseStatusCode"},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.Success","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server successfully processed a request to completion - there are no messages remaining in this\nstream.</p>\n","Type":"field","Syntax":{"content":"Success = 200","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server successfully processed a request to completion - there are no messages remaining in this\nstream.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.NoContent","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server processed the request but there is no result to return (e.g. an Iterator with no elements)</p>\n<ul sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"3\">\n<li sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"3\">there are no messages remaining in this stream.</li>\n</ul>\n","Type":"field","Syntax":{"content":"NoContent = 204","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server processed the request but there is no result to return (e.g. an Iterator with no elements)</p>\n<ul sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"3\">\n<li sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"3\">there are no messages remaining in this stream.</li>\n</ul>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.PartialContent","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server successfully returned some content, but there is more in the stream to arrive - wait for a\nSUCCESS to signify the end of the stream.</p>\n","Type":"field","Syntax":{"content":"PartialContent = 206","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server successfully returned some content, but there is more in the stream to arrive - wait for a\nSUCCESS to signify the end of the stream.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.Unauthorized","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request attempted to access resources that the requesting user did not have access to.</p>\n","Type":"field","Syntax":{"content":"Unauthorized = 401","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request attempted to access resources that the requesting user did not have access to.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.Authenticate","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">A challenge from the server for the client to authenticate its request.</p>\n","Type":"field","Syntax":{"content":"Authenticate = 407","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">A challenge from the server for the client to authenticate its request.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.MalformedRequest","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request message was not properly formatted which means it could not be parsed at all or the &quot;op&quot; code\nwas not recognized such that Gremlin Server could properly route it for processing. Check the message format\nand retry the request.</p>\n","Type":"field","Syntax":{"content":"MalformedRequest = 498","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request message was not properly formatted which means it could not be parsed at all or the &quot;op&quot; code\nwas not recognized such that Gremlin Server could properly route it for processing. Check the message format\nand retry the request.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.InvalidRequestArguments","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request message was parseable, but the arguments supplied in the message were in conflict or incomplete.\nCheck the message format and retry the request.</p>\n","Type":"field","Syntax":{"content":"InvalidRequestArguments = 499","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The request message was parseable, but the arguments supplied in the message were in conflict or incomplete.\nCheck the message format and retry the request.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.ServerError","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">A general server error occurred that prevented the request from being processed.</p>\n","Type":"field","Syntax":{"content":"ServerError = 500","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">A general server error occurred that prevented the request from being processed.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.ScriptEvaluationError","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The script submitted for processing evaluated in the ScriptEngine with errors and could not be processed.\nCheck the script submitted for syntax errors or other problems and then resubmit.</p>\n","Type":"field","Syntax":{"content":"ScriptEvaluationError = 597","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The script submitted for processing evaluated in the ScriptEngine with errors and could not be processed.\nCheck the script submitted for syntax errors or other problems and then resubmit.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.ServerTimeout","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server exceeded one of the timeout settings for the request and could therefore only partially responded\nor did not respond at all.</p>\n","Type":"field","Syntax":{"content":"ServerTimeout = 598","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server exceeded one of the timeout settings for the request and could therefore only partially responded\nor did not respond at all.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Messages.ResponseStatusCode.ServerSerializationError","Summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server was not capable of serializing an object that was returned from the script supplied on the request.\nEither transform the object into something Gremlin Server can process within the script or install mapper\nserialization classes to Gremlin Server.</p>\n","Type":"field","Syntax":{"content":"ServerSerializationError = 599","return":{"type":"Gremlin.Net.Driver.Messages.ResponseStatusCode"}},"File":"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml","Metadata":{"type":"field","summary":"<p sourcefile=\"obj/api/Gremlin.Net.Driver.Messages.ResponseStatusCode.yml\" sourcestartlinenumber=\"2\">The server was not capable of serializing an object that was returned from the script supplied on the request.\nEither transform the object into something Gremlin Server can process within the script or install mapper\nserialization classes to Gremlin Server.</p>\n","platform":null},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Exceptions","Type":"namespace","File":"obj/api/Gremlin.Net.Driver.Exceptions.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure","Type":"namespace","File":"obj/api/Gremlin.Net.Structure.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Optimization","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Optimization.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Structure.IO.GraphSON","Type":"namespace","File":"obj/api/Gremlin.Net.Structure.IO.GraphSON.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Finalization","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Finalization.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Traversal.Strategy.Verification","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Traversal.Strategy.Verification.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Driver.Remote","Type":"namespace","File":"obj/api/Gremlin.Net.Driver.Remote.yml","Metadata":{},"IsExplicitInterfaceImplementation":false},{"Uid":"Gremlin.Net.Process.Remote","Type":"namespace","File":"obj/api/Gremlin.Net.Process.Remote.yml","Metadata":{},"IsExplicitInterfaceImplementation":false}]