/*
 * $Id: PatternRecognizer.java 795343 2009-07-18 11:26:09Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tiles.definition.pattern;

/**
 * Checks if a pattern (or a candidate one) is recognized as a pattern.
 *
 * @version $Rev: 795343 $ $Date: 2009-07-18 07:26:09 -0400 (Sat, 18 Jul 2009) $
 * @since 2.2.0
 */
public interface PatternRecognizer {

    /**
     * Checks if a pattern is recognized as a pattern.
     *
     * @param candidatePattern The pattern to check.
     * @return <code>true</code> if the pattern has been recognized.
     * @since 2.2.0
     */
    boolean isPatternRecognized(String candidatePattern);
}
