/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.startup;

import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.startup.TilesInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTilesInitializer
implements TilesInitializer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String CONTAINER_KEY_INIT_PARAMETER = "org.apache.tiles.startup.AbstractTilesInitializer.CONTAINER_KEY";
    private TilesApplicationContext applicationContext;
    private TilesContainer container;

    public void initialize(TilesApplicationContext applicationContext) {
        this.applicationContext = this.createTilesApplicationContext(applicationContext);
        String key = this.getContainerKey(this.applicationContext);
        this.container = this.createContainer(this.applicationContext);
        TilesAccess.setContainer((TilesApplicationContext)this.applicationContext, (TilesContainer)this.container, (String)key);
    }

    public void destroy() {
        try {
            TilesAccess.setContainer((TilesApplicationContext)this.applicationContext, null, (String)this.getContainerKey(this.applicationContext));
        }
        catch (TilesException e) {
            this.log.warn("Unable to remove tiles container from service.", (Throwable)e);
        }
    }

    protected TilesApplicationContext createTilesApplicationContext(TilesApplicationContext preliminaryContext) {
        return preliminaryContext;
    }

    protected String getContainerKey(TilesApplicationContext applicationContext) {
        return null;
    }

    protected TilesContainer createContainer(TilesApplicationContext context) {
        AbstractTilesContainerFactory factory = this.createContainerFactory(context);
        return factory.createContainer(context);
    }

    protected abstract AbstractTilesContainerFactory createContainerFactory(TilesApplicationContext var1);
}

