/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PatternUtil;
import org.apache.tiles.util.WildcardHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardPatternDefinitionResolver<T>
implements PatternDefinitionResolver<T> {
    private Map<T, List<WildcardMapping>> localePatternPaths = new HashMap<T, List<WildcardMapping>>();
    private WildcardHelper wildcardHelper = new WildcardHelper();

    @Override
    public Definition resolveDefinition(String name, T customizationKey) {
        Definition retValue = null;
        if (this.localePatternPaths.containsKey(customizationKey)) {
            retValue = this.resolveWildcardDefinition(this.localePatternPaths.get(customizationKey), name);
        }
        return retValue;
    }

    @Override
    public Map<String, Definition> storeDefinitionPatterns(Map<String, Definition> localeDefsMap, T customizationKey) {
        List<WildcardMapping> lpaths = this.localePatternPaths.get(customizationKey);
        if (lpaths == null) {
            lpaths = new ArrayList<WildcardMapping>();
            this.localePatternPaths.put(customizationKey, lpaths);
        }
        return this.addWildcardPaths(lpaths, localeDefsMap);
    }

    private Map<String, Definition> addWildcardPaths(List<WildcardMapping> paths, Map<String, Definition> defsMap) {
        LinkedHashSet<String> excludedKeys = new LinkedHashSet<String>();
        for (Map.Entry<String, Definition> de : defsMap.entrySet()) {
            String key = de.getKey();
            if (key.indexOf(42) != -1) {
                paths.add(new WildcardMapping(key, new Definition(de.getValue())));
                continue;
            }
            excludedKeys.add(key);
        }
        return PatternUtil.createExtractedMap(defsMap, excludedKeys);
    }

    private Definition resolveWildcardDefinition(List<WildcardMapping> paths, String name) {
        Definition d = null;
        for (WildcardMapping wm : paths) {
            List<String> vars = this.wildcardHelper.match(name, wm.getPattern());
            if (vars == null) continue;
            d = PatternUtil.replacePlaceholders(wm.getDefinition(), name, vars.toArray());
            break;
        }
        return d;
    }

    private class WildcardMapping {
        private int[] pattern;
        private Definition definition;

        public WildcardMapping(String pattern, Definition definition) {
            this.pattern = WildcardPatternDefinitionResolver.this.wildcardHelper.compilePattern(pattern);
            this.definition = definition;
        }

        public Definition getDefinition() {
            return this.definition;
        }

        public int[] getPattern() {
            return this.pattern;
        }
    }
}

