/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.Definition;
import org.apache.tiles.Initializable;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.RefreshMonitor;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.definition.dao.URLReader;
import org.apache.tiles.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.reflect.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseLocaleUrlDefinitionDAO
implements DefinitionDAO<Locale>,
Initializable,
TilesApplicationContextAware,
RefreshMonitor,
URLReader {
    private final Logger log = LoggerFactory.getLogger(BaseLocaleUrlDefinitionDAO.class);
    private static final String LEGACY_DEFINITIONS_CONFIG = "definitions-config";
    protected List<URL> sourceURLs = new ArrayList<URL>();
    protected Map<String, Long> lastModifiedDates = new HashMap<String, Long>();
    protected TilesApplicationContext applicationContext;
    protected DefinitionsReader reader;

    @Override
    public void setSourceURLs(List<URL> sourceURLs) {
        this.sourceURLs = sourceURLs;
    }

    @Override
    public void setReader(DefinitionsReader reader) {
        this.reader = reader;
    }

    @Override
    public void addSourceURL(URL sourceURL) {
        if (this.sourceURLs == null) {
            this.sourceURLs = new ArrayList<URL>();
        }
        this.sourceURLs.add(sourceURL);
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void init(Map<String, String> params) {
        this.identifySources(params);
        String readerClassName = params.get("org.apache.tiles.definition.DefinitionsReader");
        this.reader = readerClassName != null ? (DefinitionsReader)ClassUtil.instantiate((String)readerClassName) : new DigesterDefinitionsReader();
        this.reader.init(params);
    }

    @Override
    public boolean refreshRequired() {
        boolean status = false;
        Set<String> urls = this.lastModifiedDates.keySet();
        try {
            for (String urlPath : urls) {
                Long lastModifiedDate = this.lastModifiedDates.get(urlPath);
                URL url = new URL(urlPath);
                URLConnection connection = url.openConnection();
                connection.connect();
                long newModDate = connection.getLastModified();
                if (newModDate == lastModifiedDate) continue;
                status = true;
                break;
            }
        }
        catch (Exception e) {
            this.log.warn("Exception while monitoring update times.", (Throwable)e);
            return true;
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void identifySources(Map<String, String> initParameters) {
        if (this.applicationContext == null) {
            throw new IllegalStateException("The TilesApplicationContext cannot be null");
        }
        String resourceString = this.getResourceString(initParameters);
        String[] resources = this.getResourceNames(resourceString);
        try {
            for (int i = 0; i < resources.length; ++i) {
                Iterator i$;
                Set urls = this.applicationContext.getResources(resources[i]);
                if (urls != null && !urls.isEmpty()) {
                    i$ = urls.iterator();
                } else {
                    this.log.warn("Unable to find resources under the name '" + resources[i] + "'");
                    continue;
                }
                while (i$.hasNext()) {
                    URL resourceUrl = (URL)i$.next();
                    if (resourceUrl != null) {
                        String externalForm;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Adding resource '" + resourceUrl + "' to definitions factory.");
                        }
                        if ((externalForm = resourceUrl.toExternalForm()).indexOf(95, externalForm.lastIndexOf("/")) < 0) {
                            this.sourceURLs.add(resourceUrl);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Not adding resource '" + resourceUrl + "' to definitions factory because it is " + "supposed to be an internationalization.");
                        continue;
                    }
                    this.log.warn("Unable to find configured definition '" + resources[i] + "'");
                }
            }
            return;
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Unable to parse definitions from " + resourceString, e);
        }
    }

    protected String getResourceString(Map<String, String> parms) {
        String resourceStr = parms.get("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG");
        if (resourceStr == null) {
            resourceStr = parms.get("org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG");
        }
        if (resourceStr == null) {
            resourceStr = parms.get(LEGACY_DEFINITIONS_CONFIG);
        }
        if (resourceStr == null) {
            resourceStr = "/WEB-INF/tiles.xml";
        }
        return resourceStr;
    }

    protected String[] getResourceNames(String resourceString) {
        return resourceString.split(",");
    }

    protected Map<String, Definition> loadDefinitionsFromURL(URL url) {
        Map<String, Definition> defsMap = null;
        try {
            URLConnection connection = url.openConnection();
            connection.connect();
            this.lastModifiedDates.put(url.toExternalForm(), connection.getLastModified());
            defsMap = this.reader.read(connection.getInputStream());
        }
        catch (FileNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("File " + null + " not found, continue");
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("I/O error processing configuration.", e);
        }
        return defsMap;
    }
}

