/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import org.springframework.web.context.support.RequestHandledEvent;

public class PortletRequestHandledEvent
extends RequestHandledEvent {
    private final String portletName;
    private final String portletMode;
    private final String requestType;

    public PortletRequestHandledEvent(Object source, String portletName, String portletMode, String requestType, String sessionId, String userName, long processingTimeMillis) {
        super(source, sessionId, userName, processingTimeMillis);
        this.portletName = portletName;
        this.portletMode = portletMode;
        this.requestType = requestType;
    }

    public PortletRequestHandledEvent(Object source, String portletName, String portletMode, String requestType, String sessionId, String userName, long processingTimeMillis, Throwable failureCause) {
        super(source, sessionId, userName, processingTimeMillis, failureCause);
        this.portletName = portletName;
        this.portletMode = portletMode;
        this.requestType = requestType;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("portlet=[").append(this.portletName).append("]; ");
        sb.append(super.getShortDescription());
        return sb.toString();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("portlet=[").append(this.portletName).append("]; ");
        sb.append("mode=[").append(this.portletMode).append("]; ");
        sb.append("type=[").append(this.requestType).append("]; ");
        sb.append(super.getDescription());
        return sb.toString();
    }

    public String toString() {
        return "PortletRequestHandledEvent: " + this.getDescription();
    }
}

