/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.portlet.wildcard;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.portlet.PortletContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.portlet.PortletApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.portlet.context.PortletContextResourcePatternResolver;

public class WildcardPortletApplicationContext
extends PortletApplicationContext {
    protected ResourcePatternResolver resolver;

    public WildcardPortletApplicationContext(PortletContext portletContext) {
        super(portletContext);
    }

    public void initialize(PortletContext context) {
        super.initialize(context);
        this.resolver = new PortletContextResourcePatternResolver(context);
    }

    public ApplicationResource getResource(String localePath) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> resourceSet = this.getResources(localePath);
        if (resourceSet != null && !resourceSet.isEmpty()) {
            retValue = resourceSet.iterator().next();
        }
        return retValue;
    }

    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> resourceSet = this.getResources(base.getLocalePath(locale));
        if (resourceSet != null && !resourceSet.isEmpty()) {
            retValue = resourceSet.iterator().next();
        }
        return retValue;
    }

    public Collection<ApplicationResource> getResources(String path) {
        Resource[] resources;
        try {
            resources = this.resolver.getResources(path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>();
        if (resources != null && resources.length > 0) {
            for (int i = 0; i < resources.length; ++i) {
                try {
                    URL url = resources[i].getURL();
                    resourceList.add((ApplicationResource)new URLApplicationResource(url.toExternalForm(), url));
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("no URL for " + resources[i].toString(), e);
                }
            }
        }
        return resourceList;
    }
}

