/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.eval.util.ContentTags;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.ccil.cowan.tagsoup.jaxp.SAXParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentTagParser {
    private static final ParseContext EMPTY_PARSE_CONTEXT = new ParseContext();

    public static ContentTags parseXML(String html, Set<String> uppercaseTagsOfInterest) throws TikaException, IOException, SAXException {
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        XHTMLContentTagHandler xhtmlContentTagHandler = new XHTMLContentTagHandler(uppercaseTagsOfInterest, tags);
        XMLReaderUtils.parseSAX(new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8)), xhtmlContentTagHandler, EMPTY_PARSE_CONTEXT);
        return new ContentTags(xhtmlContentTagHandler.toString(), tags);
    }

    public static ContentTags parseHTML(String html, Set<String> uppercaseTagsOfInterest) throws SAXException, IOException {
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        XHTMLContentTagHandler xhtmlContentTagHandler = new XHTMLContentTagHandler(uppercaseTagsOfInterest, tags);
        SAXParserImpl.newInstance(null).parse(new InputSource(new StringReader(html)), (DefaultHandler)xhtmlContentTagHandler);
        return new ContentTags(xhtmlContentTagHandler.toString(), tags);
    }

    private static class XHTMLContentTagHandler
    extends ToTextContentHandler {
        private final Map<String, Integer> tags;
        private final Set<String> uppercaseTagsOfInterest;

        public XHTMLContentTagHandler(Set<String> uppercaseTagsOfInterest, Map<String, Integer> tags) {
            this.uppercaseTagsOfInterest = uppercaseTagsOfInterest;
            this.tags = tags;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String uc;
            super.startElement(uri, localName, qName, atts);
            String string = uc = qName == null ? "" : qName.toUpperCase(Locale.ENGLISH);
            if (this.uppercaseTagsOfInterest.contains(uc)) {
                Integer i = this.tags.get(uc);
                if (i == null) {
                    i = 1;
                } else {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                this.tags.put(uc, i);
            }
        }
    }
}

