/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.io;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.eval.db.ColInfo;
import org.apache.tika.eval.db.Cols;
import org.apache.tika.eval.db.JDBCUtil;
import org.apache.tika.eval.db.MimeBuffer;
import org.apache.tika.eval.db.TableInfo;
import org.apache.tika.eval.io.IDBWriter;
import org.apache.tika.io.IOExceptionWithCause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBWriter
implements IDBWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DBWriter.class);
    private static final AtomicInteger WRITER_ID = new AtomicInteger();
    private final Long commitEveryXRows = 10000L;
    private final Connection conn;
    private final JDBCUtil dbUtil;
    private final MimeBuffer mimeBuffer;
    private final int myId = WRITER_ID.getAndIncrement();
    private final Map<String, PreparedStatement> inserts = new HashMap<String, PreparedStatement>();
    private final Map<String, LastInsert> lastInsertMap = new HashMap<String, LastInsert>();

    public DBWriter(Connection connection, List<TableInfo> tableInfos, JDBCUtil dbUtil, MimeBuffer mimeBuffer) throws IOException, SQLException {
        this.conn = connection;
        this.mimeBuffer = mimeBuffer;
        this.dbUtil = dbUtil;
        for (TableInfo tableInfo : tableInfos) {
            try {
                PreparedStatement st = this.createPreparedInsert(tableInfo);
                this.inserts.put(tableInfo.getName(), st);
                this.lastInsertMap.put(tableInfo.getName(), new LastInsert());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int getMimeId(String mimeString) {
        return this.mimeBuffer.getId(mimeString);
    }

    private PreparedStatement createPreparedInsert(TableInfo tableInfo) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableInfo.getName());
        sb.append("(");
        int i = 0;
        for (ColInfo c : tableInfo.getColInfos()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append((Object)c.getName());
        }
        sb.append(") ");
        sb.append("VALUES");
        sb.append("(");
        for (int j = 0; j < i; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(")");
        return this.conn.prepareStatement(sb.toString());
    }

    @Override
    public void writeRow(TableInfo table, Map<Cols, String> data) throws IOException {
        try {
            PreparedStatement p = this.inserts.get(table.getName());
            if (p == null) {
                throw new RuntimeException("Failed to create prepared statement for: " + table.getName());
            }
            JDBCUtil.batchInsert(p, table, data);
            LastInsert lastInsert = this.lastInsertMap.get(table.getName());
            lastInsert.rowCount++;
            long elapsed = System.currentTimeMillis() - lastInsert.lastInsert;
            if (lastInsert.rowCount % this.commitEveryXRows == 0L) {
                LOG.info("writer ({}) on table ({}) is committing after {} rows and {} ms", this.myId, table.getName(), lastInsert.rowCount, elapsed);
                p.executeBatch();
                this.conn.commit();
                lastInsert.lastInsert = System.currentTimeMillis();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        for (PreparedStatement p : this.inserts.values()) {
            try {
                p.executeBatch();
            }
            catch (SQLException e) {
                throw new IOExceptionWithCause(e);
            }
        }
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new IOExceptionWithCause(e);
        }
    }

    private class LastInsert {
        private long lastInsert = System.currentTimeMillis();
        private long rowCount = 0L;

        private LastInsert() {
        }
    }
}

