/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.tika.eval.db.AbstractDBBuffer;

public class DBBuffer
extends AbstractDBBuffer {
    private final PreparedStatement st;

    public DBBuffer(Connection connection, String tableName, String idColumnName, String valueColumnName) throws SQLException {
        this.st = connection.prepareStatement("insert into " + tableName + "( " + idColumnName + ", " + valueColumnName + ") values (?,?);");
    }

    @Override
    public void write(int id, String value) throws RuntimeException {
        try {
            this.st.clearParameters();
            this.st.setInt(1, id);
            this.st.setString(2, value);
            this.st.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        this.st.close();
    }
}

