/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.Tika;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.detect.FileCommandDetector;
import org.apache.tika.eval.AbstractProfiler;
import org.apache.tika.eval.db.ColInfo;
import org.apache.tika.eval.db.Cols;
import org.apache.tika.eval.db.TableInfo;
import org.apache.tika.eval.io.IDBWriter;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProfiler
extends AbstractProfiler {
    private static final boolean HAS_FILE = FileCommandDetector.checkHasFile();
    private static final Logger LOG = LoggerFactory.getLogger(FileProfiler.class);
    static Options OPTIONS;
    public static TableInfo FILE_PROFILES;
    public static TableInfo FILE_MIME_TABLE;
    public static final String DETECT_EXCEPTION = "detect-exception";
    private static final Tika TIKA;
    private static final FileCommandDetector FILE_COMMAND_DETECTOR;
    private final Path inputDir;

    public static void USAGE() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(80, "java -jar tika-eval-x.y.jar FileProfiler -inputDir docs -db mydb [-inputDir input]", "Tool: Profile", OPTIONS, "Note: for the default h2 db, do not include the .mv.db at the end of the db name.");
    }

    public FileProfiler(ArrayBlockingQueue<FileResource> fileQueue, Path inputDir, IDBWriter dbWriter) {
        super(fileQueue, dbWriter);
        this.inputDir = inputDir;
    }

    @Override
    public boolean processFileResource(FileResource fileResource) {
        String relPath = fileResource.getMetadata().get(FSProperties.FS_REL_PATH);
        try (InputStream is = fileResource.openInputStream();
             TikaInputStream tis = TikaInputStream.get(is);){
            Path path = tis.getPath();
            HashMap<Cols, String> data = new HashMap<Cols, String>();
            int tikaMimeId = this.writer.getMimeId(this.detectTika(tis));
            String fileName = "";
            String extension = "";
            long length = -1L;
            try {
                fileName = FilenameUtils.getName(relPath);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("bad file name: " + relPath, e);
            }
            try {
                extension = FilenameUtils.getExtension(relPath);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("bad extension: " + relPath, e);
            }
            try {
                length = Files.size(path);
            }
            catch (IOException e) {
                LOG.warn("problem getting size: " + relPath, e);
            }
            data.put(Cols.FILE_PATH, relPath);
            data.put(Cols.FILE_NAME, fileName);
            data.put(Cols.FILE_EXTENSION, extension);
            data.put(Cols.LENGTH, Long.toString(length));
            data.put(Cols.TIKA_MIME_ID, Integer.toString(tikaMimeId));
            data.put(Cols.SHA256, DigestUtils.sha256Hex(tis));
            if (HAS_FILE) {
                int fileMimeId = this.writer.getMimeId(this.detectFile(tis));
                data.put(Cols.FILE_MIME_ID, Integer.toString(fileMimeId));
            }
            this.writer.writeRow(FILE_PROFILES, data);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private String detectFile(TikaInputStream tis) {
        try {
            return FILE_COMMAND_DETECTOR.detect(tis, new Metadata()).toString();
        }
        catch (IOException e) {
            return DETECT_EXCEPTION;
        }
    }

    private String detectTika(TikaInputStream tis) {
        try {
            return TIKA.detect(tis);
        }
        catch (IOException e) {
            return DETECT_EXCEPTION;
        }
    }

    static {
        Option inputDir = new Option("inputDir", true, "optional: directory for original binary input documents. If not specified, -extracts is crawled as is.");
        OPTIONS = new Options().addOption(inputDir).addOption("bc", "optional: tika-batch config file").addOption("numConsumers", true, "optional: number of consumer threads").addOption("db", true, "db file to which to write results").addOption("jdbc", true, "EXPERT: full jdbc connection string. Must specify this or -db <h2db>").addOption("jdbcDriver", true, "EXPERT: jdbc driver, or specify via -Djdbc.driver").addOption("tablePrefix", true, "EXPERT: optional prefix for table names").addOption("drop", false, "drop tables if they exist").addOption("maxFilesToAdd", true, "maximum number of files to add to the crawler");
        FILE_PROFILES = HAS_FILE ? new TableInfo("file_profiles", new ColInfo(Cols.FILE_PATH, 12, 2048, "PRIMARY KEY"), new ColInfo(Cols.FILE_NAME, 12, 2048), new ColInfo(Cols.FILE_EXTENSION, 12, 24), new ColInfo(Cols.LENGTH, -5), new ColInfo(Cols.SHA256, 12, 64), new ColInfo(Cols.TIKA_MIME_ID, 4), new ColInfo(Cols.FILE_MIME_ID, 4)) : new TableInfo("file_profiles", new ColInfo(Cols.FILE_PATH, 12, 2048, "PRIMARY KEY"), new ColInfo(Cols.FILE_NAME, 12, 2048), new ColInfo(Cols.FILE_EXTENSION, 12, 24), new ColInfo(Cols.LENGTH, -5), new ColInfo(Cols.SHA256, 12, 64), new ColInfo(Cols.TIKA_MIME_ID, 4));
        FILE_MIME_TABLE = new TableInfo("file_mimes", new ColInfo(Cols.MIME_ID, 4, "PRIMARY KEY"), new ColInfo(Cols.MIME_STRING, 12, 256), new ColInfo(Cols.FILE_EXTENSION, 12, 12));
        TIKA = new Tika();
        FILE_COMMAND_DETECTOR = new FileCommandDetector();
    }
}

