/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.textstats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.tika.eval.langid.Language;
import org.apache.tika.eval.langid.LanguageIDWrapper;
import org.apache.tika.eval.textstats.LanguageAwareTokenCountStats;
import org.apache.tika.eval.textstats.StringStatsCalculator;
import org.apache.tika.eval.textstats.TextStatsCalculator;
import org.apache.tika.eval.textstats.TokenCountStatsCalculator;
import org.apache.tika.eval.tokens.AnalyzerManager;
import org.apache.tika.eval.tokens.TokenCounts;

public class CompositeTextStatsCalculator {
    private static final String FIELD = "f";
    private static final int DEFAULT_MAX_TOKENS = 10000000;
    private final Analyzer analyzer;
    private final LanguageIDWrapper languageIDWrapper;
    private final List<LanguageAwareTokenCountStats> languageAwareTokenCountStats = new ArrayList<LanguageAwareTokenCountStats>();
    private final List<TokenCountStatsCalculator> tokenCountStatCalculators = new ArrayList<TokenCountStatsCalculator>();
    private final List<StringStatsCalculator> stringStatCalculators = new ArrayList<StringStatsCalculator>();

    public CompositeTextStatsCalculator(List<TextStatsCalculator> calculators) {
        this(calculators, AnalyzerManager.newInstance(10000000).getGeneralAnalyzer(), new LanguageIDWrapper());
    }

    public CompositeTextStatsCalculator(List<TextStatsCalculator> calculators, Analyzer analyzer, LanguageIDWrapper languageIDWrapper) {
        this.analyzer = analyzer;
        this.languageIDWrapper = languageIDWrapper;
        for (TextStatsCalculator t : calculators) {
            if (t instanceof StringStatsCalculator) {
                this.stringStatCalculators.add((StringStatsCalculator)t);
                continue;
            }
            if (t instanceof LanguageAwareTokenCountStats) {
                this.languageAwareTokenCountStats.add((LanguageAwareTokenCountStats)t);
                if (languageIDWrapper != null) continue;
                throw new IllegalArgumentException("Must specify a LanguageIdWrapper if you want to calculate languageAware stats: " + t.getClass());
            }
            if (t instanceof TokenCountStatsCalculator) {
                this.tokenCountStatCalculators.add((TokenCountStatsCalculator)t);
                if (analyzer != null) continue;
                throw new IllegalArgumentException("Analyzer must not be null if you are using a TokenCountStats: " + t.getClass());
            }
            throw new IllegalArgumentException("I regret I don't yet handle: " + t.getClass());
        }
    }

    public Map<Class, Object> calculate(String txt) {
        HashMap<Class, Object> results = new HashMap<Class, Object>();
        for (StringStatsCalculator calc : this.stringStatCalculators) {
            results.put(calc.getClass(), calc.calculate(txt));
        }
        TokenCounts tokenCounts = null;
        if (this.tokenCountStatCalculators.size() > 0 || this.languageAwareTokenCountStats.size() > 0) {
            try {
                tokenCounts = this.tokenize(txt);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.languageAwareTokenCountStats.size() > 0) {
            Object langs = results.containsKey(LanguageIDWrapper.class) ? (List)results.get(LanguageIDWrapper.class) : this.languageIDWrapper.calculate(txt);
            results.put(LanguageIDWrapper.class, langs);
            for (LanguageAwareTokenCountStats calc : this.languageAwareTokenCountStats) {
                results.put(calc.getClass(), calc.calculate((List<Language>)langs, tokenCounts));
            }
        }
        for (TokenCountStatsCalculator calc : this.tokenCountStatCalculators) {
            results.put(calc.getClass(), calc.calculate(tokenCounts));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenCounts tokenize(String txt) throws IOException {
        TokenCounts counts = new TokenCounts();
        TokenStream ts = this.analyzer.tokenStream(FIELD, txt);
        try {
            CharTermAttribute termAtt = ts.getAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                String token = termAtt.toString();
                counts.increment(token);
            }
        }
        finally {
            ts.close();
            ts.end();
        }
        return counts;
    }
}

