/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public abstract class QueryVisitor {
    public static final QueryVisitor EMPTY_VISITOR = new QueryVisitor(){};

    public void consumeTerms(Query query, Term ... terms) {
    }

    public void visitLeaf(Query query) {
    }

    public boolean acceptField(String field) {
        return true;
    }

    public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return EMPTY_VISITOR;
        }
        return this;
    }

    public static QueryVisitor termCollector(final Set<Term> termSet) {
        return new QueryVisitor(){

            @Override
            public void consumeTerms(Query query, Term ... terms) {
                termSet.addAll(Arrays.asList(terms));
            }
        };
    }
}

