/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tika.eval.tokens.AlphaIdeographFilterFactory;
import org.apache.tika.eval.tokens.CommonTokenResult;
import org.apache.tika.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTokenCountManager {
    private static final Logger LOG = LoggerFactory.getLogger(CommonTokenCountManager.class);
    private static final Charset COMMON_TOKENS_CHARSET = StandardCharsets.UTF_8;
    private final Path commonTokensDir;
    Map<String, Set<String>> commonTokenMap = new ConcurrentHashMap<String, Set<String>>();
    Set<String> alreadyTriedToLoad = new HashSet<String>();
    private final String defaultLangCode;

    public CommonTokenCountManager(Path commonTokensDir, String defaultLangCode) throws IOException {
        if (defaultLangCode == null) {
            defaultLangCode = "";
        }
        this.defaultLangCode = defaultLangCode;
        this.commonTokensDir = commonTokensDir;
        if (!"".equals(defaultLangCode)) {
            this.tryToLoad(defaultLangCode);
            Set<String> set = this.commonTokenMap.get(defaultLangCode);
            if (set == null) {
                LOG.warn("No common tokens for default language: '" + defaultLangCode + "'");
                this.commonTokenMap.put(defaultLangCode, Collections.EMPTY_SET);
            }
        } else {
            this.commonTokenMap.put(defaultLangCode, Collections.EMPTY_SET);
        }
    }

    public CommonTokenResult countTokenOverlaps(String langCode, Map<String, MutableInt> tokens) throws IOException {
        String actualLangCode = this.getActualLangCode(langCode);
        int numUniqueCommonTokens = 0;
        int numCommonTokens = 0;
        int numUniqueAlphabeticTokens = 0;
        int numAlphabeticTokens = 0;
        Set<String> commonTokens = this.commonTokenMap.get(actualLangCode);
        for (Map.Entry<String, MutableInt> e : tokens.entrySet()) {
            String token = e.getKey();
            int count = e.getValue().intValue();
            if (AlphaIdeographFilterFactory.isAlphabetic(token.toCharArray(), token.length())) {
                numAlphabeticTokens += count;
                ++numUniqueAlphabeticTokens;
            }
            if (!commonTokens.contains(token)) continue;
            numCommonTokens += count;
            ++numUniqueCommonTokens;
        }
        return new CommonTokenResult(actualLangCode, numUniqueCommonTokens, numCommonTokens, numUniqueAlphabeticTokens, numAlphabeticTokens);
    }

    public Set<String> getTokens(String lang) {
        return Collections.unmodifiableSet(new HashSet(this.commonTokenMap.get(this.getActualLangCode(lang))));
    }

    private String getActualLangCode(String langCode) {
        if (langCode == null || "".equals(langCode)) {
            return this.defaultLangCode;
        }
        if (this.commonTokenMap.containsKey(langCode)) {
            return langCode;
        }
        this.tryToLoad(langCode);
        Set<String> set = this.commonTokenMap.get(langCode);
        if (set == null) {
            return this.defaultLangCode;
        }
        return langCode;
    }

    public void close() throws IOException {
        this.commonTokenMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void tryToLoad(String langCode) {
        InputStream is;
        block24: {
            if (this.alreadyTriedToLoad.contains(langCode)) {
                return;
            }
            if (this.commonTokenMap.get(langCode) != null) {
                return;
            }
            is = null;
            Path p = null;
            if (this.commonTokensDir != null) {
                p = this.commonTokensDir.resolve(langCode);
            }
            is = p == null || !Files.isRegularFile(p, new LinkOption[0]) ? this.getClass().getResourceAsStream("/common_tokens/" + langCode) : Files.newInputStream(p, new OpenOption[0]);
            if (is != null) break block24;
            String path = p == null ? "resource on class path: /common_tokens/" + langCode : p.toAbsolutePath().toString();
            LOG.warn("Couldn't find common tokens file for: '" + langCode + "' tried here: " + path);
            this.alreadyTriedToLoad.add(langCode);
            IOUtils.closeQuietly(is);
            return;
        }
        try {
            Set<String> set = this.commonTokenMap.get(langCode);
            if (set == null) {
                set = new HashSet<String>();
                this.commonTokenMap.put(langCode, set);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, COMMON_TOKENS_CHARSET));){
                this.alreadyTriedToLoad.add(langCode);
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("#")) {
                        line = reader.readLine();
                        continue;
                    }
                    String[] cols = line.split("\t");
                    String t = cols[0].trim();
                    if (t.length() > 0) {
                        set.add(t);
                    }
                    line = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            try {
                LOG.warn("IOException trying to read: '" + langCode + "'");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
        }
        IOUtils.closeQuietly(is);
    }
}

