/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Level;
import org.apache.tika.eval.AbstractProfiler;
import org.apache.tika.eval.ExtractComparer;
import org.apache.tika.eval.ExtractProfiler;
import org.apache.tika.eval.db.Cols;
import org.apache.tika.eval.db.H2Util;
import org.apache.tika.eval.db.TableInfo;
import org.apache.tika.eval.io.XMLLogMsgHandler;
import org.apache.tika.eval.io.XMLLogReader;
import org.apache.tika.eval.reports.ResultsReporter;
import org.apache.tika.io.IOExceptionWithCause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLErrorLogUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ResultsReporter.class);
    private Statement statement;

    public static void main(String[] args) throws Exception {
        XMLErrorLogUpdater writer = new XMLErrorLogUpdater();
        Path xmlLogFileA = Paths.get(args[0], new String[0]);
        Path xmlLogFileB = Paths.get(args[1], new String[0]);
        Path db = Paths.get(args[2], new String[0]);
        H2Util dbUtil = new H2Util(db);
        Connection connection = dbUtil.getConnection();
        writer.update(connection, ExtractComparer.EXTRACT_EXCEPTION_TABLE_A, xmlLogFileA);
        writer.update(connection, ExtractComparer.EXTRACT_EXCEPTION_TABLE_B, xmlLogFileB);
        connection.commit();
        connection.close();
    }

    public void update(Connection connection, TableInfo tableInfo, Path xmlLogFile) throws Exception {
        this.statement = connection.createStatement();
        XMLLogReader reader = new XMLLogReader();
        try (InputStream is = Files.newInputStream(xmlLogFile, new OpenOption[0]);){
            reader.read(is, new ErrorMsgUpdater(tableInfo.getName()));
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading: " + xmlLogFile.toAbsolutePath().toString());
        }
        finally {
            try {
                connection.commit();
                this.statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to close db connection!", e);
            }
        }
    }

    private class ErrorMsgUpdater
    implements XMLLogMsgHandler {
        private final String errorTablename;

        private ErrorMsgUpdater(String errorTablename) {
            this.errorTablename = errorTablename;
        }

        @Override
        public void handleMsg(Level level, String xml) throws SQLException, IOException {
            if (!level.equals(Level.ERROR)) {
                return;
            }
            XMLStreamReader reader = null;
            try {
                reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
            }
            catch (XMLStreamException e) {
                throw new IOExceptionWithCause(e);
            }
            Object type = null;
            String resourceId = null;
            try {
                while (reader.hasNext() && type == null && resourceId == null) {
                    reader.next();
                    switch (reader.getEventType()) {
                        case 1: {
                            if ("timed_out".equals(reader.getLocalName())) {
                                resourceId = reader.getAttributeValue("", "resourceId");
                                this.update(this.errorTablename, resourceId, AbstractProfiler.PARSE_ERROR_TYPE.TIMEOUT);
                                break;
                            }
                            if (!"oom".equals(reader.getLocalName())) break;
                            resourceId = reader.getAttributeValue("", "resourceId");
                            this.update(this.errorTablename, resourceId, AbstractProfiler.PARSE_ERROR_TYPE.OOM);
                        }
                    }
                }
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOExceptionWithCause(e);
            }
        }

        private void update(String errorTableName, String filePath, AbstractProfiler.PARSE_ERROR_TYPE type) throws SQLException {
            int containerId = this.getContainerId(filePath);
            String sql = "SELECT count(1) from " + errorTableName + " where " + (Object)((Object)Cols.CONTAINER_ID) + " = " + containerId + " or " + (Object)((Object)Cols.FILE_PATH) + "='" + filePath + "'";
            ResultSet rs = XMLErrorLogUpdater.this.statement.executeQuery(sql);
            int hitCount = 0;
            while (rs.next()) {
                hitCount = rs.getInt(1);
            }
            sql = hitCount > 0 ? "UPDATE " + errorTableName + " SET " + (Object)((Object)Cols.PARSE_ERROR_ID) + " = " + type.ordinal() + "," + (Object)((Object)Cols.FILE_PATH) + "='" + filePath + "' where " + (Object)((Object)Cols.CONTAINER_ID) + "=" + containerId + " or " + (Object)((Object)Cols.FILE_PATH) + "='" + filePath + "'" : (containerId > -1 ? "INSERT INTO " + errorTableName + " (" + (Object)((Object)Cols.CONTAINER_ID) + "," + (Object)((Object)Cols.FILE_PATH) + "," + (Object)((Object)Cols.PARSE_ERROR_ID) + ") values (" + containerId + ", '" + filePath + "'," + type.ordinal() + ");" : "INSERT INTO " + errorTableName + " (" + Cols.FILE_PATH.name() + "," + (Object)((Object)Cols.PARSE_ERROR_ID) + ")values ('" + filePath + "'," + type.ordinal() + ");");
            int updated = XMLErrorLogUpdater.this.statement.executeUpdate(sql);
            if (updated == 0) {
                LOG.warn("made no updates in xmlerrorlogupdater!");
            } else if (updated > 1) {
                LOG.warn("made too many updates");
            }
        }

        private int getContainerId(String resourceId) throws SQLException {
            int containerId = -1;
            String sql = "SELECT " + Cols.CONTAINER_ID.name() + " from " + ExtractProfiler.CONTAINER_TABLE.getName() + " where " + (Object)((Object)Cols.FILE_PATH) + " ='" + resourceId + "'";
            ResultSet rs = XMLErrorLogUpdater.this.statement.executeQuery(sql);
            int resultCount = 0;
            while (rs.next()) {
                containerId = rs.getInt(1);
                ++resultCount;
            }
            rs.close();
            if (resultCount == 0) {
                LOG.warn("Should have found a container for: {}", (Object)resourceId);
            } else if (resultCount > 1) {
                LOG.error("Records ids should be unique: {}", (Object)resourceId);
            }
            return containerId;
        }
    }
}

