/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.image.ImageHeaderWMF;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.Units;

public final class WMF
extends Metafile {
    @Override
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16 * this.getUIDInstanceCount());
            long len = ((InputStream)is).skip((long)header.getSize() + 16L * (long)this.getUIDInstanceCount());
            assert (len == (long)(header.getSize() + 16 * this.getUIDInstanceCount()));
            ImageHeaderWMF aldus = new ImageHeaderWMF(header.getBounds());
            aldus.write(out);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    public void setData(byte[] data) throws IOException {
        int pos = 0;
        ImageHeaderWMF nHeader = new ImageHeaderWMF(data, pos);
        byte[] compressed = WMF.compress(data, pos += nHeader.getLength(), data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.setWmfSize(data.length - nHeader.getLength());
        header.setBounds(nHeader.getBounds());
        Dimension nDim = nHeader.getSize();
        header.setDimension(new Dimension(Units.toEMU(nDim.getWidth()), Units.toEMU(nDim.getHeight())));
        header.setZipSize(compressed.length);
        byte[] checksum = WMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        if (this.getUIDInstanceCount() == 2) {
            out.write(checksum);
        }
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public PictureData.PictureType getType() {
        return PictureData.PictureType.WMF;
    }

    @Override
    public int getSignature() {
        return this.getUIDInstanceCount() == 1 ? 8544 : 8560;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 8544: {
                this.setUIDInstanceCount(1);
                break;
            }
            case 8560: {
                this.setUIDInstanceCount(2);
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for WMF");
            }
        }
    }
}

