/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ICUNormalizer2FilterFactory
extends TokenFilterFactory {
    private final Normalizer2 normalizer;

    public ICUNormalizer2FilterFactory(Map<String, String> args) {
        super(args);
        UnicodeSet set;
        String name = this.get(args, "name", "nfkc_cf");
        String mode = this.get(args, "mode", Arrays.asList("compose", "decompose"), "compose");
        Normalizer2 normalizer = Normalizer2.getInstance(null, name, "compose".equals(mode) ? Normalizer2.Mode.COMPOSE : Normalizer2.Mode.DECOMPOSE);
        String filter = this.get(args, "filter");
        if (filter != null && !(set = new UnicodeSet(filter)).isEmpty()) {
            set.freeze();
            normalizer = new FilteredNormalizer2(normalizer, set);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
        this.normalizer = normalizer;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ICUNormalizer2Filter(input, this.normalizer);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

