/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.tika.eval.tokens.TokenCountPriorityQueue;
import org.apache.tika.eval.tokens.TokenIntPair;
import org.apache.tika.eval.tokens.TokenStatistics;

public class TokenCounter {
    Map<String, Map<String, MutableInt>> map = new HashMap<String, Map<String, MutableInt>>();
    Map<String, TokenStatistics> tokenStatistics = new HashMap<String, TokenStatistics>();
    private final TokenStatistics NULL_TOKEN_STAT = new TokenStatistics(0, 0, new TokenIntPair[0], 0.0, new SummaryStatistics());
    private final Analyzer generalAnalyzer;
    private int topN = 10;

    public TokenCounter(Analyzer generalAnalyzer) throws IOException {
        this.generalAnalyzer = generalAnalyzer;
    }

    public void add(String field, String content) throws IOException {
        this._add(field, this.generalAnalyzer, content);
    }

    private void _add(String field, Analyzer analyzer, String content) throws IOException {
        int totalTokens = 0;
        TokenStream ts = analyzer.tokenStream(field, content);
        CharTermAttribute termAtt = ts.getAttribute(CharTermAttribute.class);
        ts.reset();
        Map<String, MutableInt> tokenMap = this.map.get(field);
        if (tokenMap == null) {
            tokenMap = new HashMap<String, MutableInt>();
            this.map.put(field, tokenMap);
        }
        while (ts.incrementToken()) {
            String token = termAtt.toString();
            MutableInt cnt = tokenMap.get(token);
            if (cnt == null) {
                cnt = new MutableInt(1);
                tokenMap.put(token, cnt);
            } else {
                cnt.increment();
            }
            ++totalTokens;
        }
        ts.close();
        ts.end();
        int totalUniqueTokens = tokenMap.size();
        double ent = 0.0;
        double p = 0.0;
        double base = 2.0;
        TokenCountPriorityQueue queue = new TokenCountPriorityQueue(this.topN);
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        for (Map.Entry<String, MutableInt> e : tokenMap.entrySet()) {
            String token = e.getKey();
            int termFreq = e.getValue().intValue();
            p = (double)termFreq / (double)totalTokens;
            ent += p * FastMath.log(base, p);
            int len = token.codePointCount(0, token.length());
            for (int i = 0; i < e.getValue().intValue(); ++i) {
                summaryStatistics.addValue(len);
            }
            if (queue.top() != null && queue.size() >= this.topN && (long)termFreq < ((TokenIntPair)queue.top()).getValue()) continue;
            queue.insertWithOverflow(new TokenIntPair(token, termFreq));
        }
        if (totalTokens > 0) {
            ent = -1.0 / (double)totalTokens * ent;
        }
        this.tokenStatistics.put(field, new TokenStatistics(totalUniqueTokens, totalTokens, queue.getArray(), ent, summaryStatistics));
    }

    public TokenStatistics getTokenStatistics(String field) {
        TokenStatistics tokenStat = this.tokenStatistics.get(field);
        if (tokenStat == null) {
            return this.NULL_TOKEN_STAT;
        }
        return tokenStat;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    public void clear(String field) {
        Map<String, MutableInt> tokenMap = this.map.get(field);
        if (tokenMap != null) {
            tokenMap.clear();
        }
        this.tokenStatistics.put(field, this.NULL_TOKEN_STAT);
    }

    public Map<String, MutableInt> getTokens(String field) {
        Map<String, MutableInt> ret = this.map.get(field);
        if (ret == null) {
            return Collections.emptyMap();
        }
        return ret;
    }
}

