/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.tokens;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class AlphaIdeographFilterFactory
extends TokenFilterFactory {
    public AlphaIdeographFilterFactory(Map<String, String> args) {
        super(args);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new AlphaFilter(tokenStream);
    }

    public static boolean isAlphabetic(char[] token) {
        for (int i = 0; i < token.length; ++i) {
            int cp = token[i];
            if (Character.isHighSurrogate(token[i]) && i < token.length - 1) {
                cp = Character.toCodePoint(token[i], token[i + 1]);
                ++i;
            }
            if (!Character.isAlphabetic(cp) && !Character.isIdeographic(cp)) continue;
            return true;
        }
        return false;
    }

    private class AlphaFilter
    extends FilteringTokenFilter {
        private final CharTermAttribute termAtt;

        public AlphaFilter(TokenStream in) {
            super(in);
            this.termAtt = this.addAttribute(CharTermAttribute.class);
        }

        @Override
        protected boolean accept() throws IOException {
            return AlphaIdeographFilterFactory.isAlphabetic(this.termAtt.buffer());
        }
    }
}

